/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.mindspore.ide.toolkit.search.entity.LinkInfo;
import com.mindspore.ide.toolkit.ui.search.BrowserWindowManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JTable;

public class ApiMappingUiUtil {
    private static final String NEW_LINE = "\n";
    private static final String API = "\u53ef\u4ee5\u8f6c\u6362\u4e3aMindSpore API\u7684PyTorch API";
    private static final String API_NULL = "\u6682\u672a\u63d0\u4f9b\u76f4\u63a5\u6620\u5c04\u5173\u7cfb\u7684PyTorch API";
    private static final String PAPI = "\u53ef\u80fd\u662ftorch.Tensor API\u7684\u7ed3\u679c";

    public static void buttonListener(JButton export, ActionListener actionListener) {
        export.addActionListener(actionListener);
    }

    public static StringBuilder initData(Object[][] api, Object[][] apiNull, Object[][] papi) {
        StringBuilder str = new StringBuilder();
        if (api.length > 0) {
            str.append(API).append(",").append(NEW_LINE);
            ApiMappingUiUtil.append(str, api);
        }
        if (papi.length > 0) {
            str.append(",").append(NEW_LINE).append(PAPI).append(",").append(NEW_LINE);
            ApiMappingUiUtil.append(str, papi);
        }
        if (apiNull.length > 0) {
            str.append(",").append(NEW_LINE).append(API_NULL).append(",").append(NEW_LINE);
            ApiMappingUiUtil.append(str, apiNull);
        }
        return str;
    }

    public static void append(StringBuilder builder, Object[][] table) {
        if (table == null) {
            return;
        }
        Object[][] objectArray = table;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] objects;
            for (Object object : objects = objectArray[i]) {
                if (object instanceof LinkInfo) {
                    LinkInfo linkInfo = (LinkInfo)object;
                    String text = String.format("\"=HYPERLINK(\"\"%s\"\",\"\"%s\"\")\"", linkInfo.getUrl(), linkInfo.getText() + linkInfo.getVersionString());
                    builder.append(text.trim()).append(",");
                    continue;
                }
                builder.append(object == null ? "" : object.toString().trim()).append(",");
            }
            builder.setLength(builder.length() - 1);
            builder.append(NEW_LINE);
        }
    }

    public static MouseAdapter createListener(final Object[][] data, final JTable table, final Project project) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column;
                if (e.getButton() != 1 || e.getClickCount() != 1) {
                    return;
                }
                int row = table.rowAtPoint(e.getPoint());
                Object o = data[row][column = table.columnAtPoint(e.getPoint())];
                if (o instanceof LinkInfo) {
                    LinkInfo linkModel = (LinkInfo)o;
                    BrowserWindowManager.getBrowserWindow(project).loadUrl(linkModel.getUrl());
                    ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                    ToolWindow toolWindow = toolWindowManager.getToolWindow("MindSpore");
                    toolWindow.show();
                }
            }
        };
    }
}

