/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.search;

import com.intellij.notification.NotificationType;
import com.mindspore.ide.toolkit.common.utils.NotificationUtils;
import com.mindspore.ide.toolkit.search.MdDataGet;
import com.mindspore.ide.toolkit.search.MsVersionDataConfig;
import com.mindspore.ide.toolkit.search.OperatorMapDataHub;
import com.mindspore.ide.toolkit.search.SearchEveryWhereDataHub;
import com.mindspore.ide.toolkit.search.entity.OperatorRecord;
import com.mindspore.ide.toolkit.search.structure.TrieNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum OperatorSearchService {
    INSTANCE;

    private TrieNode root = new TrieNode();
    private final Map<String, SearchEveryWhereDataHub<String, OperatorRecord>> mdFile2Map = new ConcurrentHashMap<String, SearchEveryWhereDataHub<String, OperatorRecord>>();
    private SearchEveryWhereDataHub<String, OperatorRecord> recentHub;

    public boolean changeSearchDataHub(String version) {
        return this.changeSearchDataHub(version, false);
    }

    public boolean changeSearchDataHub(String version, boolean isInit) {
        OperatorMapDataHub tempHub;
        MsVersionDataConfig.MsVersionData msVersionData = MsVersionDataConfig.newVersionData(version);
        if (this.mdFile2Map.containsKey(msVersionData.getMdVersion())) {
            tempHub = this.mdFile2Map.get(msVersionData.getMdVersion());
        } else {
            MdDataGet mdDataGet = new MdDataGet(msVersionData);
            if (!isInit && mdDataGet.pytorchMdStr.isEmpty()) {
                NotificationUtils.notify(NotificationUtils.NotifyGroup.SEARCH, NotificationType.ERROR, "Unable to get api-mapping about mindspore " + version);
                return false;
            }
            tempHub = new OperatorMapDataHub(mdDataGet);
        }
        this.recentHub = tempHub;
        this.root = new TrieNode();
        this.recentHub.searchable().forEach(this.root::addWord);
        this.mdFile2Map.putIfAbsent(msVersionData.getMdVersion(), tempHub);
        return true;
    }

    public List<OperatorRecord> search(String inputString) {
        return this.search(inputString, Integer.MAX_VALUE);
    }

    public List<OperatorRecord> search(String inputString, int count) {
        if (inputString == null || inputString.isEmpty()) {
            return new ArrayList<OperatorRecord>();
        }
        List<String> topSearch = this.root.search(inputString, count);
        return this.recentHub.assemble(topSearch, inputString, count);
    }

    public List<OperatorRecord> searchFullMatch(String inputString) {
        return this.recentHub.fetchAllMatch(inputString);
    }

    public boolean isInit() {
        return this.recentHub != null;
    }
}

