/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning.utils;

import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.mindspore.ide.toolkit.common.utils.RegularUtils;
import com.mindspore.ide.toolkit.search.OperatorSearchService;
import com.mindspore.ide.toolkit.search.entity.LinkInfo;
import com.mindspore.ide.toolkit.search.entity.OperatorRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileScanAgent {
    private static final Logger log = LoggerFactory.getLogger(FileScanAgent.class);
    private Map<String, String> importMap = new HashMap<String, String>();
    private Map<String, String> fromMap = new HashMap<String, String>();
    private Map<String, String> fromAsMap = new HashMap<String, String>();
    private Set<String> apiNameList = new LinkedHashSet<String>();
    private Set<String> sortedApiList = new LinkedHashSet<String>();
    private List<Object[]> apiNameNullList;
    private List<Object[]> straightApiMappingList;
    private List<Object[]> blurredApiMappingList;
    private static final String NO_PACKAGE_PLACEHOLDER = "<no package>";
    private static final List<String> TORCH_TENSOR = Arrays.asList("new_tensor", "new_full", "new_empty", "new_ones", "new_zeros", "is_cuda", "is_quantized", "is_meta", "device", "grad", "ndim", "T", "real", "imag", "abs", "abs_", "absolute", "absolute_", "acos", "acos_", "arccos", "arccos_", "add", "add_", "addbmm", "addbmm_", "addcdiv", "addcdiv_", "addcmul", "addcmul_", "addmm", "addmm_", "sspaddmm", "addmv", "addmv_", "addr", "addr_", "allclose", "amax", "amin", "angle", "apply_", "argmax", "argmin", "argsort", "asin", "asin_", "arcsin", "arcsin_", "as_strided", "atan", "atan_", "arctan", "arctan_", "atan2", "atan2_", "all", "any", "backward", "baddbmm", "baddbmm_", "bernoulli", "bernoulli_", "bfloat16", "bincount", "bitwise_not", "bitwise_not_", "bitwise_and", "bitwise_and_", "bitwise_or", "bitwise_or_", "bitwise_xor", "bitwise_xor_", "bmm", "bool", "byte", "broadcast_to", "cauchy_", "ceil", "ceil_", "char", "cholesky", "cholesky_inverse", "cholesky_solve", "chunk", "clamp", "clamp_", "clip", "clip_", "clone", "contiguous", "copy_", "conj", "copysign", "copysign_", "cos", "cos_", "cosh", "cosh_", "count_nonzero", "acosh", "acosh_", "arccosh", "arccosh_", "cpu", "cross", "cuda", "logcumsumexp", "cummax", "cummin", "cumprod", "cumprod_", "cumsum", "cumsum_", "data_ptr", "deg2rad", "dequantize", "det", "dense_dim", "detach", "detach_", "diag", "diag_embed", "diagflat", "diagonal", "fill_diagonal_", "fmax", "fmin", "diff", "digamma", "digamma_", "dim", "dist", "div", "div_", "divide", "divide_", "dot", "double", "eig", "element_size", "eq", "eq_", "equal", "erf", "erf_", "erfc", "erfc_", "erfinv", "erfinv_", "exp", "exp_", "expm1", "expm1_", "expand", "expand_as", "exponential_", "fix", "fix_", "fill_", "flatten", "flip", "fliplr", "flipud", "float", "float_power", "float_power_", "floor", "floor_", "floor_divide", "floor_divide_", "fmod", "fmod_", "frac", "frac_", "gather", "gcd", "gcd_", "ge", "ge_", "greater_equal", "greater_equal_", "geometric_", "geqrf", "ger", "get_device", "gt", "gt_", "greater", "greater_", "half", "hardshrink", "heaviside", "histc", "hypot", "hypot_", "i0", "i0_", "igamma", "igamma_", "igammac", "igammac_", "index_add_", "index_add", "index_copy_", "index_copy", "index_fill_", "index_fill", "index_put_", "index_put", "index_select", "indices", "inner", "int", "int_repr", "inverse", "isclose", "isfinite", "isinf", "isposinf", "isneginf", "isnan", "is_contiguous", "is_complex", "is_floating_point", "is_leaf", "is_pinned", "is_set_to", "is_shared", "is_signed", "is_sparse", "istft", "isreal", "item", "kthvalue", "lcm", "lcm_", "ldexp", "ldexp_", "le", "le_", "less_equal", "less_equal_", "lerp", "lerp_", "lgamma", "lgamma_", "log", "log_", "logdet", "log10", "log10_", "log1p", "log1p_", "log2", "log2_", "log_normal_", "logaddexp", "logaddexp2", "logsumexp", "logical_and", "logical_and_", "logical_not", "logical_not_", "logical_or", "logical_or_", "logical_xor", "logical_xor_", "logit", "logit_", "long", "lstsq", "lt", "lt_", "less", "less_", "lu", "lu_solve", "as_subclass", "map_", "masked_scatter_", "masked_scatter", "masked_fill_", "masked_fill", "masked_select", "matmul", "matrix_power", "matrix_exp", "max", "maximum", "mean", "median", "nanmedian", "min", "minimum", "mm", "smm", "mode", "movedim", "moveaxis", "msort", "mul", "mul_", "multiply", "multiply_", "multinomial", "mv", "mvlgamma", "mvlgamma_", "nansum", "narrow", "narrow_copy", "ndimension", "nan_to_num", "nan_to_num_", "ne", "ne_", "not_equal", "not_equal_", "neg", "neg_", "negative", "negative_", "nelement", "nextafter", "nextafter_", "nonzero", "norm", "normal_", "numel", "numpy", "orgqr", "ormqr", "outer", "permute", "pin_memory", "pinverse", "polygamma", "polygamma_", "pow", "pow_", "prod", "put_", "qr", "qscheme", "quantile", "nanquantile", "q_scale", "q_zero_point", "q_per_channel_scales", "q_per_channel_zero_points", "q_per_channel_axis", "rad2deg", "random_", "ravel", "reciprocal", "reciprocal_", "record_stream", "register_hook", "remainder", "remainder_", "renorm", "renorm_", "repeat", "repeat_interleave", "requires_grad", "requires_grad_", "reshape", "reshape_as", "resize_", "resize_as_", "retain_grad", "roll", "rot90", "round", "round_", "rsqrt", "rsqrt_", "scatter", "scatter_", "scatter_add_", "scatter_add", "select", "set_", "share_memory_", "short", "sigmoid", "sigmoid_", "sign", "sign_", "signbit", "sgn", "sgn_", "sin", "sin_", "sinc", "sinc_", "sinh", "sinh_", "asinh", "asinh_", "arcsinh", "arcsinh_", "size", "slogdet", "solve", "sort", "split", "sparse_mask", "sparse_dim", "sqrt", "sqrt_", "square", "square_", "squeeze", "squeeze_", "std", "stft", "storage", "storage_offset", "storage_type", "stride", "sub", "sub_", "subtract", "subtract_", "sum", "sum_to_size", "svd", "swapaxes", "swapdims", "symeig", "t", "t_", "tensor_split", "tile", "to", "to_mkldnn", "take", "tan", "tan_", "tanh", "tanh_", "atanh", "atanh_", "arctanh", "arctanh_", "tolist", "topk", "to_sparse", "trace", "transpose", "transpose_", "triangular_solve", "tril", "tril_", "triu", "triu_", "true_divide", "true_divide_", "trunc", "trunc_", "type", "type_as", "unbind", "unfold", "uniform_", "unique", "unique_consecutive", "unsqueeze", "unsqueeze_", "values", "var", "vdot", "view", "view_as", "where", "xlogy", "xlogy_", "zero_");

    public FileScanAgent() {
    }

    public FileScanAgent(PsiFile psiFile) {
        this();
        this.scan(psiFile);
        this.assembleResultAndSearch();
    }

    public void scan(PsiFile psiFile) {
        this.importMap = new HashMap<String, String>();
        this.fromMap = new HashMap<String, String>();
        this.fromAsMap = new HashMap<String, String>();
        this.translateImport((PsiElement)psiFile, this.importMap, this.fromMap, this.fromAsMap);
        this.translateCallExpression((PsiElement)psiFile);
        this.sortedApiList.addAll(this.sortList());
    }

    public void assembleResultAndSearch() {
        this.straightApiMappingList = new ArrayList<Object[]>();
        this.blurredApiMappingList = new ArrayList<Object[]>();
        this.apiNameNullList = new ArrayList<Object[]>();
        this.searchData(this.sortedApiList);
    }

    public void translateCallExpression(PsiElement psiElement) {
        ArrayList<String[]> formerFunction = new ArrayList<String[]>();
        for (PsiElement element : psiElement.getChildren()) {
            if (element instanceof PyCallExpression) {
                String apiName;
                String prefix;
                PyCallExpression pyCallExpression = (PyCallExpression)element;
                String apiString = pyCallExpression.getCallee().getText().replace("\\", "");
                String[] attrList = apiString.split("\\.");
                ArrayList<String> resultList = new ArrayList<String>();
                for (String single : attrList) {
                    if (single.contains("(")) {
                        resultList = new ArrayList();
                        resultList.add(attrList[attrList.length - 1]);
                        break;
                    }
                    resultList.add(single);
                }
                if (resultList.size() > 1) {
                    prefix = String.join((CharSequence)".", resultList.subList(0, resultList.size() - 1));
                    apiName = (String)resultList.get(resultList.size() - 1);
                } else {
                    prefix = NO_PACKAGE_PLACEHOLDER;
                    apiName = (String)resultList.get(0);
                }
                formerFunction.add(new String[]{prefix, apiName.strip()});
                this.translateCallExpressionInPyCallExpression(element, formerFunction);
                continue;
            }
            this.translateCallExpression(element);
        }
    }

    public void translateImport(PsiElement psiElement, Map<String, String> importMap, Map<String, String> fromMap, Map<String, String> fromAsMap) {
        for (PsiElement element : psiElement.getChildren()) {
            try {
                if (element instanceof PyImportStatementBase) {
                    PyImportStatementBase importStatementBase = (PyImportStatementBase)element;
                    if (element instanceof PyImportStatement) {
                        PyImportElement importElement = importStatementBase.getImportElements()[0];
                        importMap.put(importElement.getImportedQName().toString(), importElement.getAsName());
                        continue;
                    }
                    if (element instanceof PyFromImportStatement) {
                        PyFromImportStatement pyFromImportStatement = (PyFromImportStatement)element;
                        if (pyFromImportStatement.getImportElements().length < 1) continue;
                        if (pyFromImportStatement.getImportElements()[0].getAsName() == null) {
                            for (PyImportElement pyImportElement : importStatementBase.getImportElements()) {
                                fromMap.put(pyFromImportStatement.getImportSourceQName().toString() + "." + pyImportElement.getText(), pyImportElement.getText());
                            }
                            continue;
                        }
                        fromAsMap.put((String)importStatementBase.getFullyQualifiedObjectNames().get(0), importStatementBase.getImportElements()[0].getAsName());
                        continue;
                    }
                    log.info("psiFile exceptions");
                    continue;
                }
                this.translateImport(element, importMap, fromMap, fromAsMap);
            }
            catch (Throwable ex) {
                log.debug("import analyse error", ex);
            }
        }
    }

    public Set<String> filteringData(Set<String> apiNameList) {
        LinkedHashSet<String> apiString = new LinkedHashSet<String>();
        Iterator<String> it = apiNameList.iterator();
        while (it.hasNext()) {
            String str = it.next();
            if (str.startsWith("torch")) {
                apiString.add(str);
                it.remove();
                continue;
            }
            String[] split = str.split("\\.");
            if (!TORCH_TENSOR.contains(str = split[split.length - 1])) continue;
            apiString.add(str);
            it.remove();
        }
        return apiString;
    }

    public Set<String> filteringDataReverse(Set<String> apiNameList) {
        LinkedHashSet<String> apiString = new LinkedHashSet<String>();
        Iterator<String> it = apiNameList.iterator();
        while (it.hasNext()) {
            String[] apiNew;
            String str = it.next();
            String[] api = str.split("\\.");
            if (api.length > 0 && "tensorflow".equals(api[0])) {
                str = str.replaceFirst("tensorflow", "tf");
            }
            if ("tf".equals((apiNew = str.split("\\."))[0]) || "torch".equals(apiNew[0]) || "torchtext".equals(apiNew[0]) || "torchvision".equals(apiNew[0])) continue;
            apiString.add(str);
            it.remove();
        }
        return apiString;
    }

    /*
     * WARNING - void declaration
     */
    public void searchData(Set<String> apiStringSet) {
        LinkedList<Object[]> nonMatchApiList = new LinkedList<Object[]>();
        for (String string : apiStringSet) {
            void var4_4;
            boolean isTensor = false;
            if (TORCH_TENSOR.contains(string)) {
                isTensor = true;
                String string2 = "torch.Tensor." + string;
            }
            if (!var4_4.startsWith("torch")) continue;
            List<OperatorRecord> records = OperatorSearchService.INSTANCE.searchFullMatch((String)var4_4);
            for (OperatorRecord record : records) {
                Object[] cells = new Object[]{Strings.isEmpty((String)record.getOriginalLink()) ? record.getOriginalLink() : new LinkInfo(record.getOriginalOperator(), record.getOriginalLink()), record.getVersionText(), Strings.isEmpty((String)record.getMindSporeLink()) ? record.getMindSporeOperator() : new LinkInfo(record.getMindSporeOperator(), record.getMindSporeLink()), record.getPlatform(), Strings.isEmpty((String)record.getDescriptionLink()) ? record.getDescription() + (record.isInWhiteList() ? "" : "\uff08\u4ec5\u652f\u63012.0\u53ca\u4ee5\u4e0a\u7248\u672cMindSpore\uff09") : new LinkInfo(record.getDescription(), record.getDescriptionLink(), !record.isInWhiteList())};
                if (!isTensor) {
                    this.straightApiMappingList.add(cells);
                    continue;
                }
                this.blurredApiMappingList.add(cells);
            }
            if (!records.isEmpty()) continue;
            nonMatchApiList.add(new Object[]{var4_4, isTensor ? "\u53ef\u80fd\u662ftorch.Tensor\u7684API" : "", new LinkInfo("\u7f3a\u5931API\u5904\u7406\u7b56\u7565", "https://www.mindspore.cn/docs/zh-CN/master/migration_guide/analysis_and_preparation.html#%E7%BC%BA%E5%A4%B1api%E5%A4%84%E7%90%86%E7%AD%96%E7%95%A5")});
        }
        this.sortMarkdownList(this.straightApiMappingList);
        this.sortMarkdownList(this.blurredApiMappingList);
        this.sortMarkdownList(nonMatchApiList);
        Objects.requireNonNullElse(this.apiNameNullList, this.straightApiMappingList).addAll(nonMatchApiList);
    }

    private void sortMarkdownList(List<Object[]> list) {
        list.sort(Comparator.comparing(this::getApiName));
    }

    private String getApiName(Object[] obj) {
        if (obj == null || obj.length < 0) {
            return "";
        }
        if (obj[0] instanceof LinkInfo) {
            return ((LinkInfo)obj[0]).getText();
        }
        if (obj[0] instanceof String) {
            return (String)obj[0];
        }
        return "";
    }

    public void translateCallExpressionInPyCallExpression(PsiElement psiElement, List<String[]> formerFunction) {
        for (PsiElement element : psiElement.getChildren()) {
            if (element instanceof PyCallExpression) {
                String apiName;
                String prefix;
                PyCallExpression pyCallExpression = (PyCallExpression)element;
                String apiString = pyCallExpression.getCallee().getText().replace("\\", "");
                int lastDot = apiString.lastIndexOf(46);
                if (lastDot > 0 && apiString.length() > lastDot) {
                    prefix = apiString.substring(0, lastDot);
                    apiName = apiString.substring(lastDot + 1);
                } else {
                    prefix = NO_PACKAGE_PLACEHOLDER;
                    apiName = apiString;
                }
                formerFunction.add(new String[]{prefix, apiName.strip()});
                this.translateCallExpressionInPyCallExpression(element, formerFunction);
                continue;
            }
            if (element instanceof PyReferenceExpression && element.getChildren().length > 0 && !element.getText().toLowerCase().equals(element.getText())) {
                this.apiNameList.add(element.getText());
                this.translateCallExpressionInPyCallExpression(element, formerFunction);
                continue;
            }
            this.translateCallExpressionInPyCallExpression(element, formerFunction);
        }
        if (formerFunction.size() <= 0) {
            log.info("The length of the formerFunction is 0");
        } else {
            int last = formerFunction.size() - 1;
            String prefix = formerFunction.get(last)[0];
            formerFunction.forEach(record -> {
                if (NO_PACKAGE_PLACEHOLDER.equals(record[0])) {
                    this.apiNameList.add(record[1]);
                } else {
                    this.apiNameList.add(prefix + "." + record[1]);
                }
            });
        }
        formerFunction.clear();
    }

    public Set<String> sortList() {
        this.apiNameList = this.filteringApi(this.apiNameList);
        Set<String> apiString = this.filteringData(this.apiNameList);
        block0: for (String str : this.apiNameList) {
            String[] split;
            String key;
            String value;
            for (Map.Entry<String, String> entry : this.importMap.entrySet()) {
                value = entry.getValue();
                key = entry.getKey();
                if (value == null) {
                    split = str.split("\\.");
                    if (split.length > 0) {
                        if (!split[0].equals(key)) continue;
                        apiString.add(str);
                        continue block0;
                    }
                    if (!str.equals(key)) continue;
                    apiString.add(str);
                    continue block0;
                }
                split = str.split("\\.");
                if (split.length > 0) {
                    if (!split[0].equals(value)) continue;
                    apiString.add(str.replaceFirst(value, key));
                    continue block0;
                }
                if (!str.equals(value)) continue;
                apiString.add(str.replaceFirst(value, key));
                continue block0;
            }
            for (Map.Entry<String, String> entry : this.fromMap.entrySet()) {
                value = entry.getValue();
                key = entry.getKey();
                if (value == null) {
                    apiString.add(key + "." + str);
                    continue block0;
                }
                split = str.split("\\.");
                if (split.length > 0) {
                    if (!split[0].equals(value)) continue;
                    apiString.add(key + str.replaceFirst(split[0], ""));
                    continue block0;
                }
                if (!str.equals(value)) continue;
                apiString.add(key);
                continue block0;
            }
            for (Map.Entry<String, String> entry : this.fromAsMap.entrySet()) {
                value = entry.getValue();
                key = entry.getKey();
                split = str.split("\\.");
                if (split.length > 0) {
                    if (!split[0].equals(value)) continue;
                    apiString.add(key + str.replaceFirst(split[0], ""));
                    continue block0;
                }
                if (!str.equals(value)) continue;
                apiString.add(key);
                continue block0;
            }
        }
        return apiString;
    }

    private Set<String> blurSort(Set<String> apiString, Set<String> apiNameList) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        apiString.forEach(value -> {
            String[] split = value.split("\\.");
            String last = split[split.length - 1];
            result.add(last);
        });
        return result;
    }

    public Set<String> filteringApi(Set<String> apiNameList) {
        LinkedHashSet<String> stringSet = new LinkedHashSet<String>();
        apiNameList.forEach(s -> {
            if (RegularUtils.isApi(s)) {
                stringSet.add((String)s);
            }
        });
        return stringSet;
    }

    public Object[][] apiArray() {
        return this.trans(this.straightApiMappingList);
    }

    public Object[][] papiArray() {
        return this.trans(this.blurredApiMappingList);
    }

    public Object[][] apiNullArray() {
        return this.trans(this.apiNameNullList);
    }

    public Object[][] trans(List<Object[]> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new Object[0][];
        }
        Object[][] objects = new Object[data.size()][data.get(0).length];
        for (int i = 0; i < data.size(); ++i) {
            objects[i] = data.get(i);
        }
        return objects;
    }
}

