/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning.handler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.mindspore.ide.toolkit.apiscanning.ApiMappingProjectUI;
import com.mindspore.ide.toolkit.apiscanning.VirtualFileNode;
import com.mindspore.ide.toolkit.apiscanning.utils.FileScanAgent;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ApiMappingHandler {
    private static final Logger log = Logger.getInstance(ApiMappingHandler.class);
    private static Map<Content, ApiMappingProjectUI> projectContentMap = new HashMap<Content, ApiMappingProjectUI>();
    private Project myProject;
    public static Map<Project, VirtualFile[]> excludedFilesMap = new HashMap<Project, VirtualFile[]>();
    private VirtualFile root;
    private ToolWindow toolWindow;
    private ContentManager contentManager;
    private final Set<VirtualFile> virtualFileSet = new LinkedHashSet<VirtualFile>();
    private final VirtualFileFilter virtualFileFilter = new VirtualFileFilter(){

        public boolean accept(@NotNull VirtualFile file) {
            VirtualFile[] excludedFiles;
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((excludedFiles = excludedFilesMap.get(ApiMappingHandler.this.myProject)) != null && excludedFiles.length != 0) {
                return !Arrays.asList(excludedFiles).contains(file);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/mindspore/ide/toolkit/apiscanning/handler/ApiMappingHandler$1", "accept"));
        }
    };
    private final ContentIterator contentIterator = fileOrDir -> {
        try {
            this.virtualFileSet.add(fileOrDir);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    };

    public ApiMappingHandler(Project project) {
        this.myProject = project;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        this.toolWindow = toolWindowManager.getToolWindow("MindSporeApiMapping");
        this.contentManager = this.toolWindow.getContentManager();
        this.contentManager.addContentManagerListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                projectContentMap.remove(event.getContent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/mindspore/ide/toolkit/apiscanning/handler/ApiMappingHandler$2", "contentRemoved"));
            }
        });
    }

    public void iterateVfsTreeNode(VirtualFile virtualFileRoot) {
        this.root = virtualFileRoot;
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)this.root, (VirtualFileFilter)this.virtualFileFilter, (ContentIterator)this.contentIterator);
    }

    public void handleProjectApiMapping(List<PsiFile> psiFiles) {
        ApiMappingProjectUI.project = this.myProject;
        ApiMappingProjectUI.chosenFile = this.root;
        ApiMappingProjectUI projectMap = new ApiMappingProjectUI(this.myProject, this.root);
        JBScrollPane jbScrollPane = new JBScrollPane((Component)projectMap.splitPane);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)jbScrollPane, this.myProject.getName(), true);
        this.contentManager.addContent(content);
        projectContentMap.put(content, projectMap);
        this.contentManager.setSelectedContent(content, false, false);
        this.toolWindow.show();
        projectMap.initLoad();
    }

    public void handleTreeNodeSelection(@NotNull VirtualFileNode virtualFileNode) throws Exception {
        if (virtualFileNode == null) {
            ApiMappingHandler.$$$reportNull$$$0(0);
        }
        final VirtualFile chosenFile = virtualFileNode.getVirtualFile();
        long startTime = System.currentTimeMillis();
        FileScanAgent fileScanAgent = (FileScanAgent)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<FileScanAgent, Exception>(this.myProject, "Scanning", false){

            public FileScanAgent compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                FileScanAgent fileScanAgentInner = new FileScanAgent();
                ApplicationManager.getApplication().runReadAction(() -> {
                    VfsUtilCore.iterateChildrenRecursively((VirtualFile)chosenFile, (VirtualFileFilter)ApiMappingHandler.this.virtualFileFilter, (ContentIterator)ApiMappingHandler.this.contentIterator);
                    List psiFiles = PsiUtilCore.toPsiFiles((PsiManager)PsiManager.getInstance((Project)this.myProject), ApiMappingHandler.this.virtualFileSet);
                    psiFiles.stream().filter(psiFile -> psiFile.getName().contains(".py")).forEach(fileScanAgentInner::scan);
                });
                return fileScanAgentInner;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/mindspore/ide/toolkit/apiscanning/handler/ApiMappingHandler$3", "compute"));
            }
        });
        if (fileScanAgent == null) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("MindSporeApiMapping");
        ApiMappingProjectUI projectMap = projectContentMap.get(this.contentManager.getSelectedContent());
        String name = chosenFile.getName();
        projectMap.reload(fileScanAgent, name);
        ContentManager contentManagerLocal = toolWindow.getContentManager();
        contentManagerLocal.removeContent(contentManagerLocal.getSelectedContent(), true);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)new JBScrollPane((Component)projectMap.splitPane), name, true);
        contentManagerLocal.addContent(content);
        projectContentMap.put(content, projectMap);
        contentManagerLocal.setSelectedContent(content, true, true);
        toolWindow.show();
        log.info("api mapping for project const" + (System.currentTimeMillis() - startTime) + " ms");
    }

    public Set<VirtualFile> getVirtualFileSet() {
        return this.virtualFileSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFileNode", "com/mindspore/ide/toolkit/apiscanning/handler/ApiMappingHandler", "handleTreeNodeSelection"));
    }
}

