/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.mindspore.ide.toolkit.apiscanning.ExportDialog;
import com.mindspore.ide.toolkit.apiscanning.MsCellRender;
import com.mindspore.ide.toolkit.apiscanning.MsTableModel;
import com.mindspore.ide.toolkit.apiscanning.utils.ApiMappingUiUtil;
import com.mindspore.ide.toolkit.search.entity.LinkInfo;
import com.mindspore.ide.toolkit.ui.search.BrowserWindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ApiMappingUI {
    private static final String[] API_COLUMNS = new String[]{"Original Api", "Original Api Version", "MindSpore Api", "Platform", "Description"};
    private static final String[] API_NULL_COLUMNS = new String[]{"Original Api", "Description"};
    private static final String[] PAPI_COLUMNS = new String[]{"Original Api", "Original Api Version", "MindSpore Api", "Platform", "Description"};
    private static final String NEW_LINE = "\n";
    private static final String API = "\u53ef\u4ee5\u8f6c\u6362\u4e3aMindSpore API\u7684PyTorch/TensorFlow API";
    private static final String API_NULL = "\u6682\u672a\u63d0\u4f9b\u76f4\u63a5\u6620\u5c04\u5173\u7cfb\u7684PyTorch API";
    private static final String PAPI = "\u53ef\u80fd\u662ftorch.Tensor API\u7684\u7ed3\u679c";
    private Project project;
    private Object[][] api;
    private Object[][] papi;
    private Object[][] apiNull;
    private JPanel main;
    private JButton export;
    private JPanel apiJPanel;
    private JTable apiJTable;
    private JTable apiNullJTable;
    private JLabel apiNullJLabel;
    private JPanel apiNullJPanel;
    private JPanel papiJPanel;
    private JLabel papiJLabel;
    private JLabel apiJLabel;
    private JTable papiJTable;
    private String fileName;
    private ActionListener actionListener;

    public ApiMappingUI() {
        this.$$$setupUI$$$();
    }

    private void init(Object[][] api, Object[][] papi, Object[][] apiNull, Project project, String name) {
        this.project = project;
        this.api = api;
        this.papi = papi;
        this.apiNull = apiNull;
        this.fileName = name;
        this.addApiPanel();
        this.addApiNullPanel();
        this.addPapiPanel();
        this.buttonListener();
    }

    public static JComponent build(Object[][] api, Object[][] papi, Object[][] apiNull, Project project, String name) {
        return new JScrollPane(ApiMappingUI.buildSelf((Object[][])api, (Object[][])papi, (Object[][])apiNull, (Project)project, (String)name).main);
    }

    public static ApiMappingUI buildSelf(Object[][] api, Object[][] papi, Object[][] apiNull, Project project, String name) {
        ApiMappingUI apiMappingUI = new ApiMappingUI();
        apiMappingUI.init(api, papi, apiNull, project, name);
        return apiMappingUI;
    }

    public void reload(Object[][] api, Object[][] papi, Object[][] apiNull, String fileName) {
        this.api = api;
        this.papi = papi;
        this.apiNull = apiNull;
        this.apiJPanel.removeAll();
        this.apiNullJPanel.removeAll();
        this.papiJPanel.removeAll();
        this.addApiPanel();
        this.addApiNullPanel();
        this.addPapiPanel();
        this.export.removeActionListener(this.actionListener);
        this.actionListener = e -> {
            ExportDialog exportListDialog = new ExportDialog(ApiMappingUiUtil.initData(api, apiNull, papi).toString(), fileName);
            exportListDialog.setVisible(true);
        };
        ApiMappingUiUtil.buttonListener(this.export, this.actionListener);
    }

    public void addApiPanel() {
        this.apiJTable = new JTable(new MsTableModel(this.api, API_COLUMNS));
        this.apiJTable.setDefaultRenderer(Object.class, new MsCellRender());
        this.apiJTable.addMouseListener(this.createListener(this.api, this.apiJTable));
        if (this.api.length > 0) {
            this.apiJPanel.add((Component)this.apiJTable.getTableHeader(), "North");
            this.apiJPanel.add((Component)this.apiJTable, "South");
            this.apiJLabel.setVisible(true);
        } else {
            this.apiJLabel.setVisible(false);
        }
    }

    public void addApiNullPanel() {
        this.apiNullJTable = new JTable(new MsTableModel(this.apiNull, API_NULL_COLUMNS));
        this.apiNullJTable.setDefaultRenderer(Object.class, new MsCellRender());
        this.apiNullJTable.addMouseListener(this.createListener(this.apiNull, this.apiNullJTable));
        if (this.apiNull.length > 0) {
            this.apiNullJPanel.add((Component)this.apiNullJTable.getTableHeader(), "North");
            this.apiNullJPanel.add((Component)this.apiNullJTable, "South");
            this.apiNullJLabel.setVisible(true);
        } else {
            this.apiNullJLabel.setVisible(false);
        }
    }

    public void addPapiPanel() {
        this.papiJTable = new JTable(new MsTableModel(this.papi, PAPI_COLUMNS));
        this.papiJTable.setDefaultRenderer(Object.class, new MsCellRender());
        this.papiJTable.addMouseListener(this.createListener(this.papi, this.papiJTable));
        if (this.papi.length > 0) {
            this.papiJPanel.add((Component)this.papiJTable.getTableHeader(), "North");
            this.papiJPanel.add((Component)this.papiJTable, "South");
            this.papiJLabel.setVisible(true);
        } else {
            this.papiJLabel.setVisible(false);
        }
    }

    public void buttonListener() {
        this.actionListener = e -> {
            ExportDialog exportListDialog = new ExportDialog(this.initData().toString(), this.fileName);
            exportListDialog.setVisible(true);
        };
        this.export.addActionListener(this.actionListener);
    }

    public StringBuilder initData() {
        StringBuilder str = new StringBuilder();
        str.append(API).append(",").append(NEW_LINE);
        this.append(str, this.api);
        if (this.apiNull.length > 0) {
            str.append(",").append(NEW_LINE).append(API_NULL).append(",").append(NEW_LINE);
            this.append(str, this.apiNull);
        }
        if (this.papi.length > 0) {
            str.append(",").append(NEW_LINE).append(PAPI).append(",").append(NEW_LINE);
            this.append(str, this.papi);
        }
        return str;
    }

    public void append(StringBuilder builder, Object[][] table) {
        if (table == null) {
            return;
        }
        Object[][] objectArray = table;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] objects;
            for (Object object : objects = objectArray[i]) {
                if (object instanceof LinkInfo) {
                    LinkInfo linkInfo = (LinkInfo)object;
                    String text = String.format("\"=HYPERLINK(\"\"%s\"\",\"\"%s\"\")\"", linkInfo.getUrl(), linkInfo.getText() + linkInfo.getVersionString());
                    builder.append(text.trim()).append(",");
                    continue;
                }
                builder.append(object == null ? "" : object.toString().trim()).append(",");
            }
            builder.setLength(builder.length() - 1);
            builder.append(NEW_LINE);
        }
    }

    public MouseAdapter createListener(final Object[][] data, final JTable table) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column;
                if (e.getButton() != 1 || e.getClickCount() != 1) {
                    return;
                }
                int row = table.rowAtPoint(e.getPoint());
                Object o = data[row][column = table.columnAtPoint(e.getPoint())];
                if (o instanceof LinkInfo) {
                    LinkInfo linkModel = (LinkInfo)o;
                    BrowserWindowManager.getBrowserWindow(ApiMappingUI.this.project).loadUrl(linkModel.getUrl());
                    ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)ApiMappingUI.this.project);
                    ToolWindow toolWindow = toolWindowManager.getToolWindow("MindSpore");
                    toolWindow.show();
                }
            }
        };
    }

    public void setVisible(boolean visible) {
        this.main.setVisible(visible);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel2;
        JButton jButton;
        JPanel jPanel3;
        JLabel jLabel3;
        JPanel jPanel4;
        this.main = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.apiJLabel = jLabel3 = new JLabel();
        jLabel3.setText("\u53ef\u4ee5\u8f6c\u6362\u4e3aMindSpore API\u7684PyTorch API");
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 0, 1, 2, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.apiJPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.export = jButton = new JButton();
        jButton.setText("\u5bfc\u51fa");
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        this.apiNullJPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.apiNullJLabel = jLabel2 = new JLabel();
        jLabel2.setText(API_NULL);
        jPanel4.add((Component)jLabel2, new GridConstraints(5, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.papiJLabel = jLabel = new JLabel();
        jLabel.setText(PAPI);
        jPanel4.add((Component)jLabel, new GridConstraints(3, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.papiJPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.main;
    }
}

