/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.search;

import com.mindspore.ide.toolkit.common.utils.HttpUtils;
import com.mindspore.ide.toolkit.search.MsVersionDataConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdDataGet {
    private static final String NEW_LINE = "\n";
    public static String pytorchMdStr = "";
    public static String tensorflowMdStr = "";
    private static final Logger LOG = LoggerFactory.getLogger(MdDataGet.class);
    private static String mdVersion = "";

    private MdDataGet() {
    }

    public static MdDataGet getInstance() {
        return SingleMdDataGet.INSTANCE;
    }

    public void getMdStr(MsVersionDataConfig.MsVersionData msVersionData) {
        mdVersion = msVersionData.getMdVersion();
        pytorchMdStr = this.getPytorchMdStr(msVersionData.getPytorchMdUrl());
        tensorflowMdStr = this.getTensorflowMdStr(msVersionData.getTensorflowMdUrl());
    }

    public String getPytorchMdStr(String url) {
        return this.getMdData(url, 3000);
    }

    public String getTensorflowMdStr(String url) {
        return this.getMdData(url, 3000);
    }

    private String getMdData(String url, int timeout) {
        String mdData;
        try (CloseableHttpResponse response = HttpUtils.doGet(url, new HashMap<String, String>(), timeout);){
            mdData = response == null ? "" : (response.getStatusLine().getStatusCode() == 200 ? new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining(NEW_LINE)) : "");
        }
        catch (IOException ioException) {
            mdData = "";
            LOG.warn("get md data failed: {}", (Object)ioException.toString());
        }
        return mdData;
    }

    private static class SingleMdDataGet {
        private static final MdDataGet INSTANCE = new MdDataGet();

        private SingleMdDataGet() {
        }
    }
}

