/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.mindspore.ide.toolkit.apiscanning.handler.ApiMappingHandler;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class TransProjectApiAction
extends AnAction {
    private static final Logger log = Logger.getInstance(TransProjectApiAction.class);

    public void actionPerformed(final @NotNull AnActionEvent e) {
        if (e == null) {
            TransProjectApiAction.$$$reportNull$$$0(0);
        }
        long startTime = System.currentTimeMillis();
        final Optional<Project> projectOp = Optional.ofNullable((Project)e.getData(PlatformDataKeys.PROJECT));
        if (projectOp.isPresent()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(projectOp.get(), "API Scan project-level"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Optional<String> projectUrlOp = Optional.ofNullable(((Project)projectOp.get()).getPresentableUrl());
                    ApiMappingHandler apiMappingHandler = new ApiMappingHandler((Project)projectOp.get());
                    Optional<VirtualFile> virtualFileOP = Optional.ofNullable(StandardFileSystems.local().findFileByPath(projectUrlOp.get()));
                    List psiFiles = (List)ApplicationManager.getApplication().runReadAction(() -> {
                        virtualFileOP.ifPresent(virtualFileRoot -> {
                            ModifiableRootModel modifiableModel;
                            ContentEntry contentEntry;
                            Module moduleForFile;
                            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                            if (editor != null && (moduleForFile = ProjectRootManager.getInstance((Project)((Project)projectOp.get())).getFileIndex().getModuleForFile(PsiDocumentManager.getInstance((Project)((Project)projectOp.get())).getPsiFile(editor.getDocument()).getVirtualFile())) != null && (contentEntry = MarkRootActionBase.findContentEntry((ModuleRootModel)(modifiableModel = ModuleRootManager.getInstance((Module)moduleForFile).getModifiableModel()), (VirtualFile)virtualFileRoot)) != null) {
                                ApiMappingHandler.excludedFilesMap.put((Project)projectOp.get(), contentEntry.getExcludeFolderFiles());
                            }
                        });
                        virtualFileOP.ifPresent(apiMappingHandler::iterateVfsTreeNode);
                        return PsiUtilCore.toPsiFiles((PsiManager)PsiManager.getInstance((Project)((Project)projectOp.get())), apiMappingHandler.getVirtualFileSet());
                    });
                    ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runReadAction(() -> apiMappingHandler.handleProjectApiMapping(psiFiles)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/mindspore/ide/toolkit/apiscanning/TransProjectApiAction$1", "run"));
                }
            });
        } else {
            log.warn("get project failed, can't execute api mapping");
        }
        log.info("api mapping for project cost " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/mindspore/ide/toolkit/apiscanning/TransProjectApiAction", "actionPerformed"));
    }
}

