/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.mindspore.ide.toolkit.apiscanning.ExportDialog;
import com.mindspore.ide.toolkit.apiscanning.MsCellRender;
import com.mindspore.ide.toolkit.apiscanning.MsTableModel;
import com.mindspore.ide.toolkit.apiscanning.VirtualFileNode;
import com.mindspore.ide.toolkit.apiscanning.VirtualFileTreeModel;
import com.mindspore.ide.toolkit.apiscanning.VirtualFileTreeSelectionListener;
import com.mindspore.ide.toolkit.apiscanning.utils.ApiMappingUiUtil;
import com.mindspore.ide.toolkit.apiscanning.utils.VirtualFileTreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ApiMappingProjectUI {
    public JSplitPane splitPane;
    private static final String[] API_COLUMNS = new String[]{"Original Api", "Original Api Version", "MindSpore Api", "Description"};
    private static final String[] API_NULL_COLUMNS = new String[]{"Original Api", "Original Api Version", "MindSpore Api", "Description"};
    private static final String[] PAPI_COLUMNS = new String[]{"Original Api", "Original Api Version", "MindSpore Api", "Description"};
    private Project project;
    private Object[][] api;
    private Object[][] papi;
    private Object[][] apiNull;
    private VirtualFile root;
    private VirtualFile chosenFile;
    private JTable apiJTable;
    private JTable apiNullJTable;
    private JLabel emptyJLabel;
    private JPanel apiJPanel;
    private JLabel papiJLabel;
    private JButton export;
    private JLabel apiNullJLabel;
    private JPanel apiNullJPanel;
    private JPanel papiJPanel;
    private JTree tree1;
    private JPanel main;
    private JLabel apiJLabel;
    private JTable papiJTable;
    private ActionListener actionListener;

    public ApiMappingProjectUI(Object[][] api, Object[][] papi, Object[][] apiNull, Project project, VirtualFile root, VirtualFile choseFile) {
        this.project = project;
        this.api = api;
        this.papi = papi;
        this.apiNull = apiNull;
        this.root = root;
        this.chosenFile = choseFile;
        this.$$$setupUI$$$();
        this.emptyJLabel.setVisible(false);
        this.addApiPanel();
        this.addApiNullPanel();
        this.addPapiPanel();
        this.setEmptyPanel();
        this.actionListener = e -> {
            ExportDialog exportListDialog = new ExportDialog(ApiMappingUiUtil.initData(api, apiNull, papi).toString(), root.getName());
            exportListDialog.setVisible(true);
        };
        ApiMappingUiUtil.buttonListener(this.export, this.actionListener);
    }

    public void reload(Object[][] api, Object[][] papi, Object[][] apiNull, String fileName) {
        this.api = api;
        this.papi = papi;
        this.apiNull = apiNull;
        this.apiJPanel.removeAll();
        this.apiNullJPanel.removeAll();
        this.papiJPanel.removeAll();
        this.emptyJLabel.setVisible(false);
        this.addApiPanel();
        this.addApiNullPanel();
        this.addPapiPanel();
        this.setEmptyPanel();
        this.export.removeActionListener(this.actionListener);
        this.actionListener = e -> {
            ExportDialog exportListDialog = new ExportDialog(ApiMappingUiUtil.initData(api, apiNull, papi).toString(), fileName);
            exportListDialog.setVisible(true);
        };
        ApiMappingUiUtil.buttonListener(this.export, this.actionListener);
    }

    private void setEmptyPanel() {
        if (!(this.apiJLabel.isVisible() || this.apiNullJLabel.isVisible() || this.papiJLabel.isVisible())) {
            this.emptyJLabel.setVisible(true);
        }
    }

    private void addApiPanel() {
        if (this.api == null || this.api.length == 0) {
            this.apiJLabel.setVisible(false);
            return;
        }
        this.apiJTable = new JTable(new MsTableModel(this.api, API_COLUMNS));
        this.apiJTable.setDefaultRenderer(Object.class, new MsCellRender());
        this.apiJTable.addMouseListener(ApiMappingUiUtil.createListener(this.api, this.apiJTable, this.project));
        this.apiJPanel.add((Component)this.apiJTable.getTableHeader(), "North");
        this.apiJPanel.add((Component)this.apiJTable, "Center");
        this.apiJLabel.setVisible(true);
    }

    private void addApiNullPanel() {
        if (this.apiNull == null || this.apiNull.length == 0) {
            this.apiNullJLabel.setVisible(false);
            return;
        }
        this.apiNullJTable = new JTable(new MsTableModel(this.apiNull, API_NULL_COLUMNS));
        this.apiNullJTable.setDefaultRenderer(Object.class, new MsCellRender());
        this.apiNullJTable.addMouseListener(ApiMappingUiUtil.createListener(this.apiNull, this.apiNullJTable, this.project));
        this.apiNullJPanel.add((Component)this.apiNullJTable.getTableHeader(), "North");
        this.apiNullJPanel.add((Component)this.apiNullJTable, "Center");
        this.apiNullJLabel.setVisible(true);
    }

    private void addPapiPanel() {
        if (this.papi == null || this.papi.length == 0) {
            this.papiJLabel.setVisible(false);
            return;
        }
        this.papiJTable = new JTable(new MsTableModel(this.papi, PAPI_COLUMNS));
        this.papiJTable.setDefaultRenderer(Object.class, new MsCellRender());
        this.papiJTable.addMouseListener(ApiMappingUiUtil.createListener(this.papi, this.papiJTable, this.project));
        this.papiJPanel.add((Component)this.papiJTable.getTableHeader(), "North");
        this.papiJPanel.add((Component)this.papiJTable, "Center");
        this.papiJLabel.setVisible(true);
    }

    private void createUIComponents() {
        VirtualFileNode root = VirtualFileTreeUtil.initVirtualFileNode(new VirtualFileNode(this.chosenFile), this.project);
        VirtualFileTreeUtil.clearUnmarkedPyDic(root);
        this.tree1 = new JTree(new VirtualFileTreeModel(root));
        this.tree1.setVisible(true);
        this.tree1.addTreeSelectionListener(new VirtualFileTreeSelectionListener(this.project));
        Icon leafIconFolder = IconLoader.getIcon((String)"/icons/folder.svg", ApiMappingProjectUI.class);
        Icon leafIconPythonFile = IconLoader.getIcon((String)"/icons/pythonFile.svg", ApiMappingProjectUI.class);
        if (leafIconFolder != null && leafIconPythonFile != null) {
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            renderer.setLeafIcon(leafIconPythonFile);
            renderer.setOpenIcon(leafIconFolder);
            renderer.setClosedIcon(leafIconFolder);
            renderer.setDisabledIcon(leafIconFolder);
            this.tree1.setCellRenderer(renderer);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JButton jButton;
        JPanel jPanel2;
        JLabel jLabel3;
        JPanel jPanel3;
        JLabel jLabel4;
        JSplitPane jSplitPane;
        JPanel jPanel4;
        this.createUIComponents();
        this.main = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.splitPane = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(250);
        jSplitPane.setDividerSize(1);
        jSplitPane.setOrientation(0);
        jPanel4.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JScrollPane jScrollPane = new JScrollPane();
        jSplitPane.setLeftComponent(jScrollPane);
        JTree jTree = this.tree1;
        jScrollPane.setViewportView(jTree);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel5);
        this.apiJLabel = jLabel4 = new JLabel();
        jLabel4.setText("\u53ef\u4ee5\u8f6c\u6362\u4e3aMindSpore API\u7684PyTorch/TensorFlow API");
        jPanel5.add((Component)jLabel4, new GridConstraints(2, 0, 1, 3, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.apiJPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.papiJLabel = jLabel3 = new JLabel();
        jLabel3.setText("\u53ef\u80fd\u662fPyTorch/TensorFlow API\u7684\u60c5\u51b5");
        jPanel5.add((Component)jLabel3, new GridConstraints(6, 0, 1, 3, 0, 0, 0, 0, null, null, null));
        this.papiJPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.export = jButton = new JButton();
        jButton.setText("\u5bfc\u51fa");
        jPanel5.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        this.apiNullJPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.apiNullJLabel = jLabel2 = new JLabel();
        jLabel2.setText("\u6682\u65f6\u4e0d\u80fd\u8f6c\u6362\u7684API");
        jPanel5.add((Component)jLabel2, new GridConstraints(4, 1, 1, 2, 0, 0, 0, 0, null, null, null));
        this.emptyJLabel = jLabel = new JLabel();
        jLabel.setText("\u65e0\u76f8\u5173API");
        jPanel5.add((Component)jLabel, new GridConstraints(1, 0, 1, 3, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.main;
    }
}

