/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.statusbar.service;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.EmptyIcon;
import com.mindspore.ide.toolkit.search.OperatorSearchService;
import com.mindspore.ide.toolkit.statusbar.MindSporeStatusBarWidget;
import com.mindspore.ide.toolkit.statusbar.service.MindSporeStatusBarService;
import com.mindspore.ide.toolkit.statusbar.utils.MindSporeVersionUtils;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MindSporeStatusBarServiceImpl
implements MindSporeStatusBarService {
    private static final Logger log = LoggerFactory.getLogger(MindSporeStatusBarServiceImpl.class);
    private String selectedVersion;

    public MindSporeStatusBarServiceImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(MindSporeStatusBarService.TOPIC, (Object)this);
    }

    public static void notifyApp(String version) {
        ((MindSporeStatusBarService)ApplicationManager.getApplication().getMessageBus().syncPublisher(MindSporeStatusBarService.TOPIC)).mindSporeVersionChanged(version);
    }

    public static String getCurrentSelectedVersion() {
        return ((MindSporeStatusBarServiceImpl)ApplicationManager.getApplication().getService(MindSporeStatusBarServiceImpl.class)).getVersion();
    }

    public static void setCurrentSelectedVersion(String version) {
        ((MindSporeStatusBarServiceImpl)ApplicationManager.getApplication().getService(MindSporeStatusBarServiceImpl.class)).setVersion(version);
    }

    private String getVersion() {
        return this.selectedVersion;
    }

    private void setVersion(String version) {
        this.selectedVersion = version;
    }

    @Override
    public void mindSporeVersionChanged(String version) {
        if (StringUtils.isEmpty((String)version)) {
            return;
        }
        boolean shouldNotify = !version.equals(this.selectedVersion);
        this.selectedVersion = version;
        if (shouldNotify) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                if (project.isDisposed()) continue;
                MindSporeStatusBarWidget.update(project);
            }
        }
    }

    public static DefaultActionGroup createVersionActionsGroup() {
        String selectedVersion = MindSporeStatusBarServiceImpl.getCurrentSelectedVersion();
        ArrayList<String> versions = new ArrayList<String>(MindSporeVersionUtils.VERSION_LIST);
        Collections.sort(versions);
        versions.remove(selectedVersion);
        DefaultActionGroup group = new DefaultActionGroup();
        for (final String version : versions) {
            VersionAction action = new VersionAction("MindSpore " + version, EmptyIcon.ICON_16){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    log.debug("choose version:{} to mapping", (Object)version);
                    Task.Backgroundable task = new Task.Backgroundable(e.getProject(), "API Mapping data Changing to MindSpore " + version, false){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            indicator.isRunning();
                            boolean checkResult = OperatorSearchService.INSTANCE.changeSearchDataHub(version);
                            if (checkResult) {
                                MindSporeStatusBarServiceImpl.notifyApp(version);
                            }
                            indicator.stop();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/mindspore/ide/toolkit/statusbar/service/MindSporeStatusBarServiceImpl$1$1", "run"));
                        }
                    };
                    ProgressManager.getInstance().run((Task)task);
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabledAndVisible(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/mindspore/ide/toolkit/statusbar/service/MindSporeStatusBarServiceImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            group.add((AnAction)action);
        }
        return group;
    }

    private static abstract class VersionAction
    extends DumbAwareAction
    implements LightEditCompatible {
        VersionAction(@NlsSafe String name, Icon icon) {
            super(name, null, icon);
        }
    }
}

