# TensorFlow与MindSpore API映射表

[![查看源文件](https://mindspore-website.obs.cn-north-4.myhuaweicloud.com/website-images/r2.1/resource/_static/logo_source.png)](https://gitee.com/mindspore/docs/blob/r2.1/docs/mindspore/source_zh_cn/note/api_mapping/tensorflow_api_mapping.md)

由社区提供的TensorFlow APIs和MindSpore APIs之间的映射，可能在参数、输入、输出、逻辑功能和特定场景等方面存在差异，可详见各API描述或已提供的差异对比。

也欢迎更多的MindSpore开发者参与完善映射内容。

## TensorFlow 2.6

### tf

| TensorFlow 2.6 APIs                                          | MindSpore APIs                                               | 说明                                                         |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| [tf.bitwise.invert](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/bitwise/invert) | [mindspore.ops.invert](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.invert.html) | 一致  |
| [tf.clip_by_value](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/clip_by_value) | [mindspore.ops.clip_by_value](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.clip_by_value.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/clip_by_value.html) |
| [tf.expand_dims](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/expand_dims) | [mindspore.ops.expand_dims](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.expand_dims.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/expand_dims.html) |
| [tf.eye](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/eye) | [mindspore.ops.eye](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.eye.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/eye.html) |
| [tf.fill](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/fill) | [mindspore.ops.fill](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.fill.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/fill.html) |
| [tf.range](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/range) | [mindspore.ops.range](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.range.html) | 功能一致，参数名不同 |
| [tf.random.uniform_candidate_sampler](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/random/uniform_candidate_sampler) | [mindspore.ops.uniform_candidate_sampler](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.uniform_candidate_sampler.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/uniform_candidate_sampler.html)   |
| [tf.raw_ops.ApplyGradientDescent](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/ApplyGradientDescent) | [mindspore.ops.ApplyGradientDescent](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.ApplyGradientDescent.html) |  一致   |
| [tf.raw_ops.ApproximateEqual](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/ApproximateEqual) | [mindspore.ops.approximate_equal](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.approximate_equal.html) | 一致 |
| [tf.raw_ops.DataFormatDimMap](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/DataFormatDimMap) | [mindspore.ops.DataFormatDimMap](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.DataFormatDimMap.html) |       功能一致，参数名不同  |
| [tf.raw_ops.InplaceUpdate](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/InplaceUpdate) | [mindspore.ops.inplace_update](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.inplace_update.html) | 功能一致，参数名不同 |
| [tf.raw_ops.Inv](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/Inv) | [mindspore.ops.inv](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.inv.html) |  一致   |
| [tf.raw_ops.LRN](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/LRN) | [mindspore.ops.LRN](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.LRN.html) |   [差异对比](https://www.mindspore.cn/docs/en/r2.1/note/api_mapping/tensorflow_diff/LRN.html)      |
| [tf.raw_ops.MatrixDiagPartV3](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/MatrixDiagPartV3) | [mindspore.ops.matrix_diag_part](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.matrix_diag_part.html) |  功能一致，参数名不同   |
| [tf.raw_ops.MatrixDiagV3](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/MatrixDiagV3) | [mindspore.ops.matrix_diag](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.matrix_diag.html) |   功能一致，参数名不同 |
| [tf.raw_ops.MatrixSetDiagV3](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/MatrixSetDiagV3) | [mindspore.ops.matrix_set_diag](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.matrix_set_diag.html) |  功能一致，参数名不同   |
| [tf.raw_ops.MatrixSolve](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/MatrixSolve) | [mindspore.ops.matrix_solve](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.matrix_solve.html) |   一致   |
| [tf.raw_ops.RandomGamma](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/RandomGamma) | [mindspore.ops.random_gamma](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.random_gamma.html) |  一致   |
| [tf.raw_ops.ScatterNdMax](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/ScatterNdMax) | [mindspore.ops.scatter_nd_max](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.scatter_nd_max.html) |  功能一致，参数名不同   |
| [tf.raw_ops.ScatterNdMin](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/ScatterNdMin) | [mindspore.ops.scatter_nd_min](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.scatter_nd_min.html) |   功能一致，参数名不同   |
| [tf.raw_ops.Select](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/Select) | [mindspore.ops.select](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.select.html) |   功能一致，参数名不同   |
| [tf.raw_ops.SparseApplyAdagradV2](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/SparseApplyAdagradV2) | [mindspore.ops.SparseApplyAdagradV2](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.SparseApplyAdagradV2.html) |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/SparseApplyAdagradV2.html)  |
| [tf.raw_ops.SparseToDense](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/SparseToDense) |[mindspore.ops.SparseToDense](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.SparseToDense.html)| [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/SparseToDense.html) |
| [tf.raw_ops.TensorScatterAdd](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/TensorScatterAdd) | [mindspore.ops.tensor_scatter_add](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.tensor_scatter_add.html) |  功能一致，参数名不同   |
| [tf.raw_ops.TensorScatterSub](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/raw_ops/TensorScatterSub) | [mindspore.ops.tensor_scatter_sub](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.tensor_scatter_sub.html) |  功能一致，参数名不同   |
| [tf.reverse_sequence](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/reverse_sequence) | [mindspore.ops.reverse_sequence](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.reverse_sequence.html) | 功能一致，参数名不同 |
| [tf.scatter_nd](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/scatter_nd) | [mindspore.ops.scatter_nd](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.scatter_nd.html) | 一致  |
| [tf.space_to_batch_nd](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/space_to_batch_nd) | [mindspore.ops.space_to_batch_nd](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.space_to_batch_nd.html) | 功能一致，参数名不同  |
| [tf.unstack](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/unstack) | [mindspore.ops.unstack](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.unstack.html) |   功能一致，参数名不同   |

### tf.compat.v1

| TensorFlow  2.6 APIs                                                                                                              | MindSpore APIs  | 说明    |
| ---------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------- |
| [tf.compat.v1.assign_sub](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/assign_sub) | [mindspore.ops.assign_sub](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.assign_sub.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/assign_sub.html)     |
| [tf.compat.v1.layers.Dense](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/layers/Dense) | [mindspore.nn.Dense](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Dense.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/Dense.html)     |
| [tf.compat.v1.random_poisson](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/random_poisson) | [mindspore.ops.random_poisson](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.random_poisson.html) |   功能一致，参数名不同  |
| [tf.compat.v1.scatter_div](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/scatter_div) | [mindspore.ops.scatter_div](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.scatter_div.html) |  功能一致，参数名不同  |
| [tf.compat.v1.scatter_max](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/scatter_max) | [mindspore.ops.scatter_max](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.scatter_max.html) |  功能一致，参数名不同  |
| [tf.compat.v1.scatter_min](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/scatter_min) | [mindspore.ops.scatter_min](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.scatter_min.html) |  功能一致，参数名不同  |
| [tf.compat.v1.scatter_mul](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/scatter_mul)| [mindspore.ops.scatter_mul](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.scatter_mul.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/scatter_mul.html)    |
| [tf.compat.v1.scatter_nd_add](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/scatter_nd_add) | [mindspore.ops.scatter_nd_add](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.scatter_nd_add.html) |  功能一致，参数名不同  |
| [tf.compat.v1.scatter_nd_sub](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/scatter_nd_sub) | [mindspore.ops.scatter_nd_sub](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.scatter_nd_sub.html) |  功能一致，参数名不同  |
| [tf.compat.v1.scatter_update](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/scatter_update) | [mindspore.ops.scatter_update](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.scatter_update.html) |  功能一致，参数名不同  |
| [tf.compat.v1.sparse_segment_mean](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/sparse_segment_mean) | [mindspore.ops.sparse_segment_mean](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.sparse_segment_mean.html) |  功能一致，参数名不同    |
| [tf.compat.v1.train.MomentumOptimizer](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/train/MomentumOptimizer)               | [mindspore.nn.Momentum](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Momentum.html)                                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/Momentum.html)        |
| [tf.compat.v1.train.ProximalAdagradOptimizer](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/train/ProximalAdagradOptimizer) | [mindspore.nn.ProximalAdagrad](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.ProximalAdagrad.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/ProximalAdagrad.html) |
| [tf.compat.v1.train.RMSPropOptimizer](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/train/RMSPropOptimizer) | [mindspore.nn.RMSProp](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.RMSProp.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/RMSProp.html) |
| [tf.compat.v1.train.exponential_decay](https://www.tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/train/exponential_decay)               | [mindspore.nn.exponential_decay_lr](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.exponential_decay_lr.html)                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/exponential_decay_lr.html)                                                                                                                      |
| [tf.compat.v1.train.cosine_decay](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/compat/v1/train/cosine_decay)           | [mindspore.nn.CosineDecayLR](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.CosineDecayLR.html)                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/CosineDecayLR.html)   |
| [tf.concat](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/concat) | [mindspore.ops.concat](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.concat.html) |  功能一致，参数名不同  |

### tf.data

MindSpore中的许多数据处理方法为各数据集类共有，下面以 `GeneratorDataset` 为例进行API差异对比，其他数据集类也是同理。

| TensorFlow  2.6 APIs                                                                                                                                      | MindSpore APIs                                                                                                                                                                                                               | 说明                                                                                                                              |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------- |
| [tf.data.Dataset.apply](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#apply)                                                   | [mindspore.dataset.GeneratorDataset.apply](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/operation/mindspore.dataset.Dataset.apply.html#mindspore.dataset.Dataset.apply)                                   |                                                                                                                                   |
| [tf.data.Dataset.batch](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#batch)                                                   | [mindspore.dataset.GeneratorDataset.batch](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/batch/mindspore.dataset.Dataset.batch.html#mindspore.dataset.Dataset.batch)                                   |                                                                                                                                   |
| [tf.data.Dataset.concatenate](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#concatenate)                                       | [mindspore.dataset.GeneratorDataset.concat](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/operation/mindspore.dataset.Dataset.concat.html#mindspore.dataset.Dataset.concat)                                 |                                                                                                                                   |
| [tf.data.Dataset.filter](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#filter)                                                 | [mindspore.dataset.GeneratorDataset.filter](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/operation/mindspore.dataset.Dataset.filter.html#mindspore.dataset.Dataset.filter)                                 |                                                                                                                                   |
| [tf.data.Dataset.flat_map](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#flat_map)                                             | [mindspore.dataset.GeneratorDataset.flat_map](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/operation/mindspore.dataset.Dataset.flat_map.html#mindspore.dataset.Dataset.flat_map)                             |                                                                                                                                   |
| [tf.data.Dataset.from_generator](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#from_generator)                                 | [mindspore.dataset.GeneratorDataset](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset)                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/from_generator.html)            |
| [tf.data.Dataset.from_tensor_slices](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#from_tensor_slices)                         | [mindspore.dataset.NumpySlicesDataset](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.NumpySlicesDataset.html#mindspore.dataset.NumpySlicesDataset)                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/from_tensor_slices.html)        |
| [tf.data.Dataset.map](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#map)                                                       | [mindspore.dataset.GeneratorDataset.map](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/operation/mindspore.dataset.Dataset.map.html#mindspore.dataset.Dataset.map)                                       |                                                                                                                                   |
| [tf.data.Dataset.prefetch](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#prefetch)                                             | [mindspore.dataset.config.set_prefetch_size](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.config.set_prefetch_size.html#mindspore.dataset.config.set_prefetch_size)                                                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/prefetch.html)                  |
| [tf.data.Dataset.repeat](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#repeat)                                                 | [mindspore.dataset.GeneratorDataset.repeat](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/operation/mindspore.dataset.Dataset.repeat.html#mindspore.dataset.Dataset.repeat)                                 |                                                                                                                                   |
| [tf.data.Dataset.shuffle](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#shuffle)                                               | [mindspore.dataset.GeneratorDataset.shuffle](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/operation/mindspore.dataset.Dataset.shuffle.html#mindspore.dataset.Dataset.shuffle)                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/shuffle.html)                   |
| [tf.data.Dataset.skip](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#skip)                                                     | [mindspore.dataset.GeneratorDataset.skip](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/operation/mindspore.dataset.Dataset.skip.html#mindspore.dataset.Dataset.skip)                                     |                                                                                                                                   |
| [tf.data.Dataset.take](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#take)                                                     | [mindspore.dataset.GeneratorDataset.take](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/operation/mindspore.dataset.Dataset.take.html#mindspore.dataset.Dataset.take)                                     |                                                                                                                                   |
| [tf.data.Dataset.zip](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/Dataset#zip)                                                       | [mindspore.dataset.GeneratorDataset.zip](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/operation/mindspore.dataset.Dataset.zip.html#mindspore.dataset.Dataset.zip)                                       |                                                                                                                                   |
| [tf.data.TextLineDataset](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/TextLineDataset)                                               | [mindspore.dataset.TextFileDataset](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.TextFileDataset.html#mindspore.dataset.TextFileDataset)                                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/TextLineDataset.html)           |
| [tf.data.TFRecordDataset](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/TFRecordDataset)                                               | [mindspore.dataset.TFRecordDataset](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.TFRecordDataset.html#mindspore.dataset.TFRecordDataset)                                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/TFRecordDataset.html)           |
| [tf.data.experimental.bucket_by_sequence_length](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/experimental/bucket_by_sequence_length) | [mindspore.dataset.GeneratorDataset.bucket_batch_by_length](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/dataset_method/batch/mindspore.dataset.Dataset.bucket_batch_by_length.html#mindspore.dataset.Dataset.bucket_batch_by_length) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/bucket_by_sequence_length.html) |
| [tf.data.experimental.CsvDataset](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/data/experimental/CsvDataset)                               | [mindspore.dataset.CSVDataset](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.CSVDataset.html#mindspore.dataset.CSVDataset)                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/CsvDataset.html)                |

### tf.math

| TensorFlow 2.6 APIs                                                                                        | MindSpore APIs                                                                                                                           | 说明                                                                                                                 |
| ------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [tf.math.argmax](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/math/argmax?hl=zh-cn) | [mindspore.ops.argmax](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.argmax.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/argmax.html) |
| [tf.math.argmin](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/math/argmin?hl=zh-cn) | [mindspore.ops.argmin](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.argmin.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/argmin.html) |
| [tf.math.add](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/math/add?hl=zh-cn%3B)                         | [mindspore.ops.add](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.add.html)                                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/add.html)                                                                                                                     |
| [tf.math.bessel_i0](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/bessel_i0)                                                     | [mindspore.ops.bessel_i0](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_i0.html)   |  一致  |
| [tf.math.bessel_i0e](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/bessel_i0e)                                                     | [mindspore.ops.bessel_i0e](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_i0e.html) |  一致  |
| [tf.math.bessel_i1](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/bessel_i1)                                                     | [mindspore.ops.bessel_i1](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_i1.html) |  一致  |
| [tf.math.bessel_i1e](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/bessel_i1e)                                                     | [mindspore.ops.bessel_i1e](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_i1e.html)   |  一致  |
| [tf.math.cumsum](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/cumsum)                   | [mindspore.ops.cumsum](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.cumsum.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/cumsum.html) |
| [tf.math.divide](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/divide)                  | [mindspore.ops.div](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.div.html)                                    |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/div.html)                                                                                                                   |
| [tf.math.erf](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/erf)                         | [mindspore.ops.erf](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.erf.html)                                    |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/erf.html)                                                                                                                    |
| [tf.math.in_top_k](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/in_top_k)                                                     | [mindspore.ops.intopk](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.intopk.html)   |  功能一致，参数名不同  |
| [tf.math.special.bessel_j0](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/special/bessel_j0)                                                     | [mindspore.ops.bessel_j0](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_j0.html)   |  一致  |
| [tf.math.special.bessel_j1](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/special/bessel_j1)                                                     | [mindspore.ops.bessel_j1](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_j1.html)   |  一致  |
| [tf.math.special.bessel_k0](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/special/bessel_k0)                                                     | [mindspore.ops.bessel_k0](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_k0.html)   |  一致  |
| [tf.math.special.bessel_k0e](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/special/bessel_k0e)                                                     | [mindspore.ops.bessel_k0e](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_k0e.html)   |  一致  |
| [tf.math.special.bessel_k1](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/special/bessel_k1)                                                     | [mindspore.ops.bessel_k1](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_k1.html)   |  一致  |
| [tf.math.special.bessel_k1e](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/special/bessel_k1e)                                                     | [mindspore.ops.bessel_k1e](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_k1e.html)   |  一致  |
| [tf.math.special.bessel_y0](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/special/bessel_y0)                                                     | [mindspore.ops.bessel_y0](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_y0.html)   |  一致  |
| [tf.math.special.bessel_y1](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/special/bessel_y1)                                                     | [mindspore.ops.bessel_y1](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bessel_y1.html)   |  一致  |
| [tf.math.unsorted_segment_max](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/unsorted_segment_max)       | [mindspore.ops.unsorted_segment_max](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.unsorted_segment_max.html)                 |  功能一致，参数名不同   |
| [tf.math.unsorted_segment_min](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/unsorted_segment_min)       | [mindspore.ops.unsorted_segment_min](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.unsorted_segment_min.html)                 |  功能一致，参数名不同   |
| [tf.math.unsorted_segment_prod](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/unsorted_segment_prod)       | [mindspore.ops.unsorted_segment_prod](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.unsorted_segment_prod.html)                 |  功能一致，参数名不同   |
| [tf.math.unsorted_segment_sum](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/unsorted_segment_sum)      | [mindspore.ops.unsorted_segment_sum](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.unsorted_segment_sum.html)                |   功能一致，参数名不同   |
| [tf.math.xdivy](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/math/xdivy)                 | [mindspore.ops.xdivy](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.xdivy.html)                               |    一致    |

### tf.image

| TensorFlow  2.6 APIs                                                                                                              | MindSpore APIs                                                                                                                                                                                                                                                | 说明                                                                                                                              |
| ---------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------- |
| [tf.image.central_crop](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/central_crop)                           | [mindspore.dataset.vision.CenterCrop](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.CenterCrop.html#mindspore.dataset.vision.CenterCrop)                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/central_crop.html)              |
| [tf.image.convert_image_dtype](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/convert_image_dtype)             | [mindspore.dataset.transforms.TypeCast](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_transforms/mindspore.dataset.transforms.TypeCast.html#mindspore.dataset.transforms.TypeCast)                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/convert_image_dtype.html)       |
| [tf.image.crop_to_bounding_box](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/crop_to_bounding_box)           | [mindspore.dataset.vision.Crop](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.Crop.html#mindspore.dataset.vision.Crop)                                                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/crop_to_bounding_box.html)      |
| [tf.image.flip_left_right](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/flip_left_right)                     | [mindspore.dataset.vision.HorizontalFlip](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.HorizontalFlip.html#mindspore.dataset.vision.HorizontalFlip)                   |                                                                                                                                   |
| [tf.image.flip_up_down](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/flip_up_down)                           | [mindspore.dataset.vision.VerticalFlip](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.VerticalFlip.html#mindspore.dataset.vision.VerticalFlip)                         |                                                                                                                                   |
| [tf.image.grayscale_to_rgb](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/grayscale_to_rgb)                   | [mindspore.dataset.vision.ConvertColor](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.ConvertColor.html#mindspore.dataset.vision.ConvertColor)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/grayscale_to_rgb.html)          |
| [tf.image.hsv_to_rgb](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/hsv_to_rgb)                               | [mindspore.dataset.vision.HsvToRgb](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.HsvToRgb.html#mindspore.dataset.vision.HsvToRgb)                                  |                                                                                                                                   |
| [tf.image.pad_to_bounding_box](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/pad_to_bounding_box)             | [mindspore.dataset.vision.Pad](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.Pad.html#mindspore.dataset.vision.Pad)                                                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/pad_to_bounding_box.html)       |
| [tf.image.per_image_standardization](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/per_image_standardization) | [mindspore.dataset.vision.Normalize](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.Normalize.html#mindspore.dataset.vision.Normalize)                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/per_image_standardization.html) |
| [tf.image.random_crop](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/random_crop)                             | [mindspore.dataset.vision.RandomCrop](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.RandomCrop.html#mindspore.dataset.vision.RandomCrop)                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/random_crop.html)               |
| [tf.image.random_flip_left_right](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/random_flip_left_right)       | [mindspore.dataset.vision.RandomHorizontalFlip](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.RandomHorizontalFlip.html#mindspore.dataset.vision.RandomHorizontalFlip) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/random_flip_left_right.html)    |
| [tf.image.random_flip_up_down](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/random_flip_up_down)             | [mindspore.dataset.vision.RandomVerticalFlip](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.RandomVerticalFlip.html#mindspore.dataset.vision.RandomVerticalFlip)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/random_flip_up_down.html)       |
| [tf.image.ResizeMethod](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/ResizeMethod)                           | [mindspore.dataset.vision.Inter](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.Inter.html#mindspore.dataset.vision.Inter)                                                                                     |                                                                                                                                   |
| [tf.image.resize](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/resize)                         | [mindspore.dataset.vision.Resize](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.Resize.html#mindspore.dataset.vision.Resize)                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/resize.html)             |
| [tf.image.rgb_to_grayscale](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/rgb_to_grayscale)                   | [mindspore.dataset.vision.ConvertColor](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.ConvertColor.html#mindspore.dataset.vision.ConvertColor)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/rgb_to_grayscale.html)          |
| [tf.image.rot90](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/image/rot90)                                         | [mindspore.dataset.vision.Rotate](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.Rotate.html#mindspore.dataset.vision.Rotate)                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/rot90.html)                     |

### tf.keras

| TensorFlow  2.6 APIs                                                                                                                        | MindSpore APIs                                                                                                                                            | 说明                                                                                                                                  |
| -------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- |
| [tf.keras.layers.BatchNormalization](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/keras/layers/BatchNormalization)   | [mindspore.nn.BatchNorm2d](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.BatchNorm2d.html)      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/BatchNorm2d.html)              |
| [tf.keras.layers.LayerNormalization](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/keras/layers/LayerNormalization)    | [mindspore.nn.LayerNorm](https://mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.LayerNorm.html)    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/LayerNorm.html)  |
| [tf.keras.layers.LSTM](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/keras/layers/LSTM)    | [mindspore.nn.LSTM](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.LSTM.html)    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/LSTM.html)              |
| [tf.keras.layers.PReLU](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/keras/layers/PReLU)   | [mindspore.nn.PReLU](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.PReLU.html)     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/PReLU.html) |
| [tf.keras.optimizers.Adagrad](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/keras/optimizers/Adagrad)     | [mindspore.nn.Adagrad](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Adagrad.html)  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/Adagrad.html)           |
| [tf.keras.optimizers.Adam](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/keras/optimizers/Adam)  | [mindspore.nn.Adam](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Adam.html)     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/Adam.html)              |
| [tf.keras.optimizers.Ftrl](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/keras/optimizers/Ftrl)   | [mindspore.nn.FTRL](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.FTRL.html)     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/FTRL.html)              |
| [tf.keras.optimizers.SGD](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/keras/optimizers/SGD)     | [mindspore.nn.SGD](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.SGD.html)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/SGD.html)               |
| [tf.one_hot](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/one_hot) | [mindspore.ops.one_hot](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.one_hot.html) |    一致    |

### tf.nn

| TensorFlow  2.6 APIs                                         | MindSpore APIs                                               | 说明                                                         |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| [tf.nn.avg_pool2d](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/nn/avg_pool2d) | [mindspore.nn.AvgPool2d](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.AvgPool2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/AvgPool2d.html) |
| [tf.nn.bias_add](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/nn/bias_add?hl=zh-cn%3B) | [mindspore.ops.bias_add](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.bias_add.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/bias_add.html) |
| [tf.nn.conv2d](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/nn/conv2d) | [mindspore.nn.Conv2d](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Conv2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/Conv2d.html) |
| [tf.nn.conv2d_transpose](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/nn/conv2d_transpose) | [mindspore.nn.Conv2dTranspose](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Conv2dTranspose.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/Conv2dTranspose.html) |
| [tf.nn.ctc_loss](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/nn/ctc_loss) | [mindspore.ops.CTCLoss](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.CTCLoss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/CTCLoss.html) |
| [tf.nn.ctc_greedy_decoder](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/nn/ctc_greedy_decoder) | [mindspore.ops.ctc_greedy_decoder](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.ctc_greedy_decoder.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/ctc_greedy_decoder.html) |
| [tf.nn.dropout](https://www.tensorflow.org/versions/r2.6/api_docs/python/tf/nn/dropout) | [mindspore.ops.dropout](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.dropout.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/dropout.html) |
| [tf.nn.elu](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/nn/elu) | [mindspore.ops.elu](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.elu.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/elu.html) |
| [tf.nn.leaky_relu](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/nn/leaky_relu) | [mindspore.nn.LeakyReLU](https://mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.LeakyReLU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/LeakyReLU.html) |
| [tf.nn.max_pool2d](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/nn/max_pool2d) | [mindspore.nn.MaxPool2d](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.MaxPool2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/MaxPool2d.html) |
| [tf.nn.relu](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/nn/relu) | [mindspore.nn.ReLU](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.ReLU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/ReLU.html) |
| [tf.nn.softmax](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/nn/softmax) | [mindspore.nn.Softmax](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Softmax.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/Softmax.html) |
| [tf.nn.softmax_cross_entropy_with_logits](https://tensorflow.google.cn/versions/r2.6/api_docs/python/tf/nn/softmax_cross_entropy_with_logits) | [mindspore.nn.SoftmaxCrossEntropyWithLogits](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.SoftmaxCrossEntropyWithLogits.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/SoftmaxCrossEntropyWithLogits.html) |

## TensorFlow 1.15

### tf

| TensorFlow 1.15 APIs                                        | MindSpore APIs                                               | 说明                                                         |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| [tf.gather](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/gather) | [mindspore.ops.Gather](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Gather.html) |                                                              |
| [tf.gradients](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/gradients) | [mindspore.grad](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/mindspore.grad.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/grad.html) |
| [tf.ones_like](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/ones_like) | [mindspore.ops.OnesLike](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.OnesLike.html) |                                                              |
| [tf.pad](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/pad) | [mindspore.nn.Pad](https://mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Pad.html) |                                                              |
| [tf.print](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/print) | [mindspore.ops.Print](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Print.html) |                                                              |
| [tf.repeat](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/repeat) | [mindspore.Tensor.repeat](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/Tensor/mindspore.Tensor.repeat.html#mindspore.Tensor.repeat) |                                                              |
| [tf.reshape](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/reshape) | [mindspore.ops.Reshape](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Reshape.html) |                                                              |
| [tf.reshape](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/reshape) | [mindspore.Tensor.reshape](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/Tensor/mindspore.Tensor.reshape.html#mindspore.Tensor.reshape) |                                                              |
| [tf.shape](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/shape) | [mindspore.ops.Shape](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Shape.html) |                                                              |
| [tf.size](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/size) | [mindspore.ops.Size](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Size.html) |                                                              |
| [tf.slice](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/slice) | [mindspore.ops.Slice](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Slice.html) |                                                              |
| [tf.squeeze](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/squeeze) | [mindspore.Tensor.squeeze](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/Tensor/mindspore.Tensor.squeeze.html#mindspore.Tensor.squeeze) |                                                              |
| [tf.stop_gradient](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/stop_gradient) | [mindspore.ops.stop_gradient](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.stop_gradient.html) |                                                              |
| [tf.Tensor](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/Tensor) | [mindspore.Tensor](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/mindspore.Tensor.html) |                                                              |
| [tf.tile](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/tile) | [mindspore.ops.Tile](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Tile.html) |                                                              |
| [tf.transpose](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/transpose) | [mindspore.ops.Transpose](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Transpose.html) |                                                              |
| [tf.zeros_like](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/zeros_like) | [mindspore.ops.ZerosLike](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.ZerosLike.html) |                                                              |
| [tf.arg_max](https://tensorflow.google.cn/versions/r1.15/api_docs/python/tf/arg_max) | [mindspore.Tensor.argmax](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/Tensor/mindspore.Tensor.argmax.html#mindspore.Tensor.argmax) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/TensorArgmax.html)  |
| [tf.arg_min](https://tensorflow.google.cn/versions/r1.15/api_docs/python/tf/arg_min) | [mindspore.Tensor.argmin](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/Tensor/mindspore.Tensor.argmin.html#mindspore.Tensor.argmin) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/TensorArgmin.html)  |
| [tf.clip_by_value](https://tensorflow.google.cn/versions/r1.15/api_docs/python/tf/clip_by_value) | [mindspore.Tensor.clip](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/Tensor/mindspore.Tensor.clip.html#mindspore.Tensor.clip) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/TensorClip.html)  |

### tf.io

| TensorFlow  1.15 APIs                                                                              | MindSpore APIs                                                                                                                                                                                                      | 说明                                                                                                                 |
| -------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [tf.io.decode_image](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/io/decode_image) | [mindspore.dataset.vision.Decode](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.Decode.html#mindspore.dataset.vision.Decode) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/decode_image.html) |

### tf.keras

| TensorFlow  1.15 APIs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | MindSpore APIs                                                                                                                                                                                                                              | 说明                                                                                                                      |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------- |
| [tf.keras.Model](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model)                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [mindspore.train.Model](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.Model.html#mindspore.train.Model)                                                                                                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/Model.html)             |
| [tf.keras.Model.fit](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#fit) <br> [tf.keras.Model.fit_generator]( https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#fit_generator)                                                                                                                                                                                                                                                                                                                         | [mindspore.train.Model.train](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.Model.html#mindspore.train.Model.train)                                                                                                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/ModelTrain.html)        |
| [tf.keras.Model.predict]( https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#predict) <br> [tf.keras.Model.predict_generator]( https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#predict_generator)                                                                                                                                                                                                                                                                                                        | [mindspore.train.Model.eval](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.Model.html#mindspore.train.Model.eval)                                                                                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/ModelEval.html)         |
| [tf.keras.backend.batch_dot](https://keras.io/zh/backend/#batch_dot) | [mindspore.ops.batch_dot](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.batch_dot.html)   |        [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/batch_dot.html) |
| [tf.keras.backend.dot](https://keras.io/zh/backend/#dot) | [mindspore.ops.dot](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.dot.html)  |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/dot.html) |
| [tf.keras.datasets.cifar10](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/datasets/cifar10)                                                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.dataset.Cifar10Dataset](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.Cifar10Dataset.html#mindspore.dataset.Cifar10Dataset)                                                                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/cifar10.html)           |
| [tf.keras.datasets.cifar100](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/datasets/cifar100)                                                                                                                                                                                                                                                                                                                                                                                                                                      | [mindspore.dataset.Cifar100Dataset](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.Cifar100Dataset.html#mindspore.dataset.Cifar100Dataset)                                                                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/cifar100.html)          |
| [tf.keras.datasets.fashion_mnist](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/datasets/fashion_mnist)                                                                                                                                                                                                                                                                                                                                                                                                                            | [mindspore.dataset.FashionMnistDataset](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.FashionMnistDataset.html#mindspore.dataset.FashionMnistDataset)                                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/fashion_mnist.html)     |
| [tf.keras.datasets.imdb](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/datasets/imdb)                                                                                                                                                                                                                                                                                                                                                                                                                                              | [mindspore.dataset.IMDBDataset](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.IMDBDataset.html#mindspore.dataset.IMDBDataset)                                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/imdb.html)              |
| [tf.keras.datasets.mnist](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/datasets/mnist)                                                                                                                                                                                                                                                                                                                                                                                                                                            | [mindspore.dataset.MnistDataset](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset/mindspore.dataset.MnistDataset.html#mindspore.dataset.MnistDataset)                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/mnist.html)             |
| [tf.keras.initializers.Constant](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/Constant)                                                                                                                                                                                                                                                                                                                                                                                                                                             | [mindspore.common.initializer.Constant](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Constant)                                                                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/initConst.html)         |
| [tf.keras.initializers.Ones](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/Ones)                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [mindspore.common.initializer.One](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore.common.initializer.html#mindspore.common.initializer.One)                                                                                |                                                                                                                           |
| [tf.keras.initializers.RandomNormal](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/RandomNormal)                                                                                                                                                                                                                                                                                                                                                                                                                                     | [mindspore.common.initializer.Normal](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Normal)                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/initNormal.html)        |
| [tf.keras.initializers.RandomUniform](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/RandomUniform)                                                                                                                                                                                                                                                                                                                                                                                                                                   | [mindspore.common.initializer.Uniform](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Uniform)                                                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/initUniform.html)       |
| [tf.keras.initializers.TruncatedNormal](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/TruncatedNormal)                                                                                                                                                                                                                                                                                                                                                                                                                               | [mindspore.common.initializer.TruncatedNormal](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore.common.initializer.html#mindspore.common.initializer.TruncatedNormal)                                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/initTruncNormal.html)   |
| [tf.keras.initializers.VarianceScaling](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/VarianceScaling)                                                                                                                                                                                                                                                                                                                                                                                                                               | [mindspore.common.initializer.XavierUniform](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore.common.initializer.html#mindspore.common.initializer.XavierUniform)                                                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/initXavierUniform.html) |
| [tf.keras.initializers.Zeros](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/Zeros)                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [mindspore.common.initializer.Zero](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Zero)                                                                              |                                                                                                                           |
| [tf.keras.layers.Embedding](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/Embedding)                                                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.nn.Embedding](https://mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Embedding.html)                                                                                                                              |                                                                                                                           |
| [tf.keras.layers.Flatten](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/Flatten)                                                                                                                                                                                                                                                                                                                                                                                                                                            | [mindspore.nn.Flatten](https://mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Flatten.html)                                                                                                                                  |                                                                                                                           |
| [tf.keras.layers.RNN](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/RNN)                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [mindspore.ops.DynamicRNN](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.DynamicRNN.html)                                                                                                                         |                                                                                                                           |
| [tf.keras.metrics.Accuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Accuracy)  <br> [tf.keras.metrics.BinaryAccuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/BinaryAccuracy) <br> [tf.keras.metrics.CategoricalAccuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/CategoricalAccuracy) <br> [tf.keras.metrics.SparseCategoricalAccuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/SparseCategoricalAccuracy) | [mindspore.train.Accuracy](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.Accuracy.html#mindspore.train.Accuracy)                                                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/metricAcc.html)         |
| [tf.keras.metrics.AUC](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/AUC)                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [mindspore.train.auc](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.auc.html)                                                                                                                                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/metricAUC.html)         |
| [tf.keras.metrics.CosineSimilarity](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/CosineSimilarity)                                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.train.CosineSimilarity](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.CosineSimilarity.html#mindspore.train.CosineSimilarity)                                                                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/metricCosineSim.html)   |
| [tf.keras.metrics.Mean](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Mean)                                                                                                                                                                                                                                                                                                                                                                                                                                                | [mindspore.train.Loss](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.Loss.html#mindspore.train.Loss)                                                                                                                      |                                                                                                                           |
| [tf.keras.metrics.MeanAbsoluteError](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/MeanAbsoluteError)                                                                                                                                                                                                                                                                                                                                                                                                                      | [mindspore.train.MAE](https://mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.MAE.html#mindspore.train.MAE)                                                                                                                         |                                                                                                                           |
| [tf.keras.metrics.MeanSquaredError](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/MeanSquaredError)                                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.train.MSE](https://mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.MSE.html#mindspore.train.MSE)                                                                                                                         |                                                                                                                           |
| [tf.keras.metrics.Precision](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Precision)                                                                                                                                                                                                                                                                                                                                                                                                                                      | [mindspore.train.Precision](https://mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.Precision.html#mindspore.train.Precision)                                                                                                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/metricPrecision.html)   |
| [tf.keras.metrics.Recall](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Recall)                                                                                                                                                                                                                                                                                                                                                                                                                                            | [mindspore.train.Recall](https://mindspore.cn/docs/zh-CN/r2.1/api_python/train/mindspore.train.Recall.html#mindspore.train.Recall)                                                                                                                | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/metricRecall.html)      |
| [tf.keras.preprocessing.image.random_rotation](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/preprocessing/image/random_rotation)                                                                                                                                                                                                                                                                                                                                                                                                  | [mindspore.dataset.vision.RandomRotation](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.RandomRotation.html#mindspore.dataset.vision.RandomRotation) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/random_rotation.html)   |
| [tf.keras.preprocessing.image.random_shear](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/preprocessing/image/random_shear)                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.dataset.vision.RandomAffine](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.RandomAffine.html#mindspore.dataset.vision.RandomAffine)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/random_shear.html)      |
| [tf.keras.preprocessing.image.random_shift](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/preprocessing/image/random_shift)                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.dataset.vision.RandomAffine](https://mindspore.cn/docs/zh-CN/r2.1/api_python/dataset_vision/mindspore.dataset.vision.RandomAffine.html#mindspore.dataset.vision.RandomAffine)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/random_shift.html)      |

### tf.linalg

| TensorFlow  1.15 APIs                                                                          | MindSpore APIs                                                                                           | 说明 |
| ---------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ---- |
| [tf.linalg.matmul](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/linalg/matmul) | [mindspore.ops.MatMul](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.MatMul.html) |      |

### tf.math

| TensorFlow  1.15 APIs                                                                                        | MindSpore APIs                                                                                                                           | 说明                                                                                                                 |
| ------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [tf.math.greater](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/greater)                 | [mindspore.ops.Greater](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Greater.html)                            |                                                                                                                      |
| [tf.math.less_equal](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/less_equal)           | [mindspore.ops.LessEqual](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.LessEqual.html)                        |                                                                                                                      |
| [tf.math.log](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/log)                         | [mindspore.ops.Log](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Log.html)                                    |                                                                                                                      |
| [tf.math.multiply](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/multiply)               | [mindspore.ops.Mul](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Mul.html)                                    |                                                                                                                      |
| [tf.math.pow](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/pow)                         | [mindspore.ops.Pow](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Pow.html)                                    |                                                                                                                      |
| [tf.math.reduce_std](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/reduce_std)           | [mindspore.Tensor.std](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/Tensor/mindspore.Tensor.std.html#mindspore.Tensor.std)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/TensorStd.html)    |
| [tf.math.reduce_sum](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/reduce_sum)           | [mindspore.Tensor.sum](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/Tensor/mindspore.Tensor.sum.html#mindspore.Tensor.sum)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/TensorSum.html)    |
| [tf.math.reduce_variance](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/reduce_variance) | [mindspore.Tensor.var](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/Tensor/mindspore.Tensor.var.html#mindspore.Tensor.var)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_diff/TensorVar.html)    |
| [tf.math.sigmoid](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/sigmoid)                 | [mindspore.nn.Sigmoid](https://mindspore.cn/docs/zh-CN/r2.1/api_python/nn/mindspore.nn.Sigmoid.html)                               |                                                                                                                      |
| [tf.math.subtract](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/subtract)               | [mindspore.ops.Sub](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Sub.html)                                    |                                                                                                                      |

### tf.metrics

| TensorFlow  1.15 APIs                                                                                | MindSpore APIs                                                                                        | 说明 |
| ---------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------- | ---- |
| [tf.metrics.mean_iou](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/metrics/mean_iou) | [mindspore.ops.IOU](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.IOU.html) |      |

### tf.nn

| TensorFlow  1.15 APIs                                                                                                                        | MindSpore APIs                                                                                                                                            | 说明                                                                                                                                  |
| -------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- |
| [tf.nn.batch_normalization](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/batch_normalization)                             | [mindspore.ops.BatchNorm](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.BatchNorm.html)                                         |                                                                                                                                       |
| [tf.nn.l2_loss](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/l2_loss)                                                     | [mindspore.ops.L2Loss](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.L2Loss.html)                                               |                                                                                                                                       |
| [tf.nn.l2_normalize](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/l2_normalize)                                           | [mindspore.ops.L2Normalize](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.L2Normalize.html)                                     |                                                                                                                                       |
| [tf.nn.max_pool_with_argmax](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/max_pool_with_argmax)                           | [mindspore.ops.MaxPoolWithArgmax](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.MaxPoolWithArgmax.html)                         |                                                                                                                                       |
| [tf.nn.selu](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/selu)                                                           | [mindspore.ops.SeLU](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.SeLU.html)                                                   |                                                                                                                                       |
| [tf.nn.sigmoid_cross_entropy_with_logits](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/sigmoid_cross_entropy_with_logits) | [mindspore.ops.SigmoidCrossEntropyWithLogits](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.SigmoidCrossEntropyWithLogits.html) |                                                                                                                                       |

### tf.random

| TensorFlow  1.15 APIs                                                                            | MindSpore APIs                                                                                                | 说明 |
| ------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------- | ---- |
| [tf.random.gamma](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/random/gamma)     | [mindspore.ops.Gamma](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.Gamma.html)     |      |
| [tf.random.uniform](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/random/uniform) | [mindspore.ops.uniform](https://mindspore.cn/docs/zh-CN/r2.1/api_python/ops/mindspore.ops.uniform.html) |      |

### tf.sparse

| TensorFlow  1.15 APIs                                                                                      | MindSpore APIs                                                                                                        | 说明 |
| ---------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------- | ---- |
| [tf.sparse.SparseTensor](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/sparse/SparseTensor) | [mindspore.SparseTensor](https://mindspore.cn/docs/zh-CN/r2.1/api_python/mindspore/mindspore.SparseTensor.html) |      |

## tfp

| TensorFlow Probability 0.14.1 APIs                                                                      | MindSpore APIs                                                                                                                                                         | 说明                                                                                                                                 |
| ------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------ |
| [tfp.bijectors.Softplus](https://www.tensorflow.org/probability/api_docs/python/tfp/bijectors/Softplus) | [mindspore.nn.probability.bijector.Softplus](https://www.mindspore.cn/docs/zh-CN/r2.1/api_python/nn_probability/mindspore.nn.probability.bijector.Softplus.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.1/note/api_mapping/tensorflow_probability_diff/BijectorSoftplus.html) |
