# PyTorch与MindSpore API映射表

[![查看源文件](https://mindspore-website.obs.cn-north-4.myhuaweicloud.com/website-images/r2.2/resource/_static/logo_source.svg)](https://gitee.com/mindspore/docs/blob/r2.2/docs/mindspore/source_zh_cn/note/api_mapping/pytorch_api_mapping.md)

由社区提供的PyTorch APIs和MindSpore APIs之间的映射，可能在参数、输入、输出、逻辑功能和特定场景等方面存在差异，可详见各API描述或已提供的差异对比。

也欢迎更多的MindSpore开发者参与完善映射内容。关于PyTorch与MindSpore关于框架机制差异，请参考：[优化器对比](https://www.mindspore.cn/docs/zh-CN/r2.2/migration_guide/typical_api_comparision.html#优化器对比)，[随机数策略对比](https://www.mindspore.cn/docs/zh-CN/r2.2/migration_guide/typical_api_comparision.html#随机数策略对比)，[参数初始化对比](https://www.mindspore.cn/docs/zh-CN/r2.2/migration_guide/typical_api_comparision.html#参数初始化对比)。

## API映射一致标准及例外场景

API映射一致标准：API功能一致，参数个数或顺序一致，参数数据类型一致，参数默认值一致，参数名一致。同时满足所有一致条件被认为是API映射一致。

以下例外场景也被认为是API映射一致，

**例外场景1**：相较于API映射一致标准，仅API参数的输入数据类型支持范围不一样，包含以下3种子场景：

（1）MindSpore的API支持传入int，float，bool等类型的参数，但不支持传入int8或float64等小位宽数据类型的参数。

（2）MindSpore的API不支持传入复数类型的参数。

（3）MindSpore的API不支持传入8D及以上的参数。

**例外场景2**：相较于MindSpore的API，PyTorch的API多出的参数是[通用差异参数](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#通用差异参数表)。通用差异参数存在的原因是PyTorch有部分参数是为性能优化等非功能性而增加的参数，MindSpore的性能优化机制与PyTorch不同。

**例外场景3**：如果能保证MindSpore的API在使用默认配置（或用户不配置）的情况下，能够实现与PyTorch对应API完全一致的功能，则MindSpore的API多于PyTorch的API的参数，功能不被认为是差异。

**例外场景4**：MindSpore将API中与PyTorch重载机制相关参数的默认值设置为None，PyTorch对应API的相应参数无默认值。

下面是例外场景4的举例，
在PyTorch 1.8.1中，torch.argmax具有两种API重载形式，分别是torch.argmax(input)和torch.argmax(input, dim, keepdim=False)，其中torch.argmax(input)返回输入Tensor中的最大值元素的索引，torch.argmax(input, dim, keepdim=False)返回输入Tensor在指定轴上最大值的索引。

mindspore.ops.argmax只有一种API形式，即mindspore.ops.argmax(input, dim=None, keepdim=False)，但mindspore.ops.argmax(input)与torch.argmax(input)功能相同，mindspore.ops.argmax(input, dim, keepdim)与torch.argmax(input, dim, keepdim)功能相同。相较于torch.argmax，mindspore.ops.argmax参数dim的默认值被设置为None，仅是为了适配torch.argmax的两种API重载形式，因此例外场景4也被认为是API映射一致。

## 通用差异参数表

因为框架机制原因，MindSpore不提供PyTorch的以下参数：

|      参数名      |                        功能                        |                              说明                              |
|:-------------:| :------------------------------------------------: |:------------------------------------------------------------:|
|      out      |                  表示输出的Tensor                  |                把运算结果赋值给out参数，MindSpore目前无此机制                 |
|    layout     |                  表示内存分布策略                  | PyTorch支持torch.strided和torch.sparse_coo两种模式, MindSpore目前无此机制 |
|    device     |                 表示Tensor存放位置                 |            包含设备类型及可选设备号，MindSpore目前支持算子或网络级别的设备调度            |
| requires_grad |                  表示是否更新梯度                  |           MindSpore中可以通过`Parameter.requires_grad`控制           |
|   generator   |                 表示伪随机数生成器                 |                MindSpore中通过随机数API的seed参数进行控制                 |
|  pin_memeory  |                表示是否使用锁页内存                |                       MindSpore目前无此机制                        |
| memory_format |                表示Tensor的内存格式                |                       MindSpore目前无此机制                        |
|    stable     |                  表示是否稳定排序                  |                一般用在排序算法的API中，MindSpore目前无此功能                 |
|    inplace    | 表示在不更改变量内存地址的情况下，直接修改变量的值 |           MindSpore目前提供少量inplace的API，例如`assign_add`等           |
|  sparse_grad  |                表示是否对梯度稀疏化                |                       MindSpore目前无此机制                        |
| size_average  |                  PyTorch废弃参数                   |                MindSpore中可以使用`reduction`参数替代                 |
|    reduce     |                  PyTorch废弃参数                   |                MindSpore中可以使用`reduction`参数替代                 |

## PyTorch 1.8.1

### torch

| PyTorch 1.8.1 APIs                                                                           | MindSpore APIs                                                                                                                                                          | 说明                                                                                                                     |
| -------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------ |
| [torch.abs](https://pytorch.org/docs/1.8.1/generated/torch.abs.html)                             | [mindspore.ops.abs](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.abs.html)                                                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)        |
| [torch.absolute](https://pytorch.org/docs/1.8.1/generated/torch.absolute.html)                             | [mindspore.ops.absolute](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.absolute.html)                                                 |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)             |
| [torch.acos](https://pytorch.org/docs/1.8.1/generated/torch.acos.html)                           | [mindspore.ops.acos](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.acos.html)                                              | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.acosh](https://pytorch.org/docs/1.8.1/generated/torch.acosh.html)| [mindspore.ops.acosh](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.acosh.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.add](https://pytorch.org/docs/1.8.1/generated/torch.add.html)| [mindspore.ops.add](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.add.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.addbmm](https://pytorch.org/docs/1.8.1/generated/torch.addbmm.html)                       | [mindspore.ops.addbmm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.addbmm.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.addcdiv](https://pytorch.org/docs/1.8.1/generated/torch.addcdiv.html)| [mindspore.ops.addcdiv](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.addcdiv.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.addcmul](https://pytorch.org/docs/1.8.1/generated/torch.addcmul.html)| [mindspore.ops.addcmul](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.addcmul.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.addmm](https://pytorch.org/docs/1.8.1/generated/torch.addmm.html)                         | [mindspore.ops.addmm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.addmm.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.addmv](https://pytorch.org/docs/1.8.1/generated/torch.addmv.html)                         | [mindspore.ops.addmv](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.addmv.html) |[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.addr](https://pytorch.org/docs/1.8.1/generated/torch.addr.html)                         | [mindspore.ops.addr](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.addr.html) |   功能一致，参数名不同|
| [torch.all](https://pytorch.org/docs/1.8.1/generated/torch.all.html#torch.all) | [mindspore.ops.all](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.all.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/all.html) |
| [torch.amax](https://pytorch.org/docs/1.8.1/generated/torch.amax.html#torch.amax) | [mindspore.ops.amax](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.amax.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/amax.html) |
| [torch.amin](https://pytorch.org/docs/1.8.1/generated/torch.amin.html#torch.amin) | [mindspore.ops.amin](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.amin.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/amin.html) |
| [torch.angle](https://pytorch.org/docs/1.8.1/generated/torch.angle.html)                         | [mindspore.ops.angle](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.angle.html) |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.any](https://pytorch.org/docs/1.8.1/generated/torch.any.html#torch.any) | [mindspore.ops.any](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.any.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/any.html) |
| [torch.arange](https://pytorch.org/docs/1.8.1/generated/torch.arange.html)| [mindspore.ops.arange](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.arange.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.arccos](https://pytorch.org/docs/1.8.1/generated/torch.arccos.html)                           | [mindspore.ops.arccos](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.arccos.html)                                              |     [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                    |
| [torch.arccosh](https://pytorch.org/docs/1.8.1/generated/torch.arccosh.html)                     | [mindspore.ops.arccosh](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.arccosh.html)                                              | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.arcsin](https://pytorch.org/docs/1.8.1/generated/torch.arcsin.html)                       | [mindspore.ops.arcsin](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.arcsin.html)                                              |   功能一致，参数名不同|
| [torch.arcsinh](https://pytorch.org/docs/1.8.1/generated/torch.arcsinh.html)                       | [mindspore.ops.arcsinh](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.arcsinh.html)                                              |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.arctan](https://pytorch.org/docs/1.8.1/generated/torch.arctan.html)                       | [mindspore.ops.arctan](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.arctan.html)                                              |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.arctanh](https://pytorch.org/docs/1.8.1/generated/torch.arctanh.html)                       | [mindspore.ops.arctanh](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.arctanh.html)                                              |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.argmax](https://pytorch.org/docs/1.8.1/generated/torch.argmax.html) | [mindspore.ops.argmax](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.argmax.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.argmin](https://pytorch.org/docs/1.8.1/generated/torch.argmin.html) | [mindspore.ops.argmin](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.argmin.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/argmin.html) |
| [torch.argsort](https://pytorch.org/docs/1.8.1/generated/torch.argsort.html)                         | [mindspore.ops.argsort](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.argsort.html) |功能一致，参数名不同|
| [torch.asin](https://pytorch.org/docs/1.8.1/generated/torch.asin.html)                           | [mindspore.ops.asin](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.asin.html)                                              |    [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                      |
| [torch.asinh](https://pytorch.org/docs/1.8.1/generated/torch.asinh.html)| [mindspore.ops.asinh](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.asinh.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.atan](https://pytorch.org/docs/1.8.1/generated/torch.atan.html)                           | [mindspore.ops.atan](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.atan.html)                                              |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.atan2](https://pytorch.org/docs/1.8.1/generated/torch.atan2.html)                         | [mindspore.ops.atan2](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.atan2.html)                                           |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.atanh](https://pytorch.org/docs/1.8.1/generated/torch.atanh.html)| [mindspore.ops.atanh](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.atanh.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.atleast_1d](https://pytorch.org/docs/1.8.1/generated/torch.atleast_1d.html)                     | [mindspore.ops.atleast_1d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.atleast_1d.html)                                         |  功能一致，参数名不同 |
| [torch.atleast_2d](https://pytorch.org/docs/1.8.1/generated/torch.atleast_2d.html)                     | [mindspore.ops.atleast_2d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.atleast_2d.html)                                         |  功能一致，参数名不同 |
| [torch.atleast_3d](https://pytorch.org/docs/1.8.1/generated/torch.atleast_3d.html)                     | [mindspore.ops.atleast_3d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.atleast_3d.html)                                         |  功能一致，参数名不同 |
| [torch.baddbmm](https://pytorch.org/docs/1.8.1/generated/torch.baddbmm.html)                     | [mindspore.ops.baddbmm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.baddbmm.html)                                         | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.bartlett_window](https://pytorch.org/docs/1.8.1/generated/torch.bartlett_window.html)     | [mindspore.ops.bartlett_window](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.bartlett_window.html)                          | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.bernoulli](https://pytorch.org/docs/1.8.1/generated/torch.bernoulli.html) | [mindspore.ops.bernoulli](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.bernoulli.html) | [功能一致，参数个数或顺序不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/bernoulli.html) |
| [torch.bincount](https://pytorch.org/docs/1.8.1/generated/torch.bincount.html)             | [mindspore.ops.bincount](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.bincount.html)                            |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                                     |
| [torch.bitwise_and](https://pytorch.org/docs/1.8.1/generated/torch.bitwise_and.html)             | [mindspore.ops.bitwise_and](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.bitwise_and.html)                            |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.bitwise_or](https://pytorch.org/docs/1.8.1/generated/torch.bitwise_or.html)               | [mindspore.ops.bitwise_or](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.bitwise_or.html)                               |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.bitwise_xor](https://pytorch.org/docs/1.8.1/generated/torch.bitwise_xor.html)             | [mindspore.ops.bitwise_xor](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.bitwise_xor.html)                            |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.blackman_window](https://pytorch.org/docs/1.8.1/generated/torch.blackman_window.html)     | [mindspore.ops.blackman_window](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.blackman_window.html)                          | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.block_diag](https://pytorch.org/docs/1.8.1/generated/torch.block_diag.html)                     | [mindspore.ops.block_diag](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.block_diag.html)                                         |  功能一致，参数名不同 |
| [torch.bmm](https://pytorch.org/docs/1.8.1/generated/torch.bmm.html) | [mindspore.ops.bmm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.bmm.html) | 功能一致，参数名不同 |
| [torch.bucketize](https://pytorch.org/docs/1.8.1/generated/torch.bucketize.html) | [mindspore.ops.bucketize](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.bucketize.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/bucketize.html) |
| [torch.broadcast_to](https://pytorch.org/docs/1.8.1/generated/torch.broadcast_to.html) | [mindspore.ops.broadcast_to](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.broadcast_to.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/broadcast_to.html)        |
| [torch.cat](https://pytorch.org/docs/1.8.1/generated/torch.cat.html)                             | [mindspore.ops.cat](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cat.html)                                        | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/cat.html)           |
| [torch.cdist](https://pytorch.org/docs/1.8.1/generated/torch.cdist.html)                             | [mindspore.ops.cdist](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cdist.html)                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/cdist.html)           |
| [torch.ceil](https://pytorch.org/docs/1.8.1/generated/torch.ceil.html)                           | [mindspore.ops.ceil](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ceil.html)                                              |    [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.cholesky](https://pytorch.org/docs/1.8.1/generated/torch.cholesky.html)                           | [mindspore.ops.cholesky](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cholesky.html)                           | 功能一致，参数名不同 |
| [torch.cholesky_solve](https://pytorch.org/docs/1.8.1/generated/torch.cholesky_solve.html)                           | [mindspore.ops.cholesky_solve](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cholesky_solve.html)                           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.chunk](https://pytorch.org/docs/1.8.1/generated/torch.chunk.html)                           | [mindspore.ops.chunk](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.chunk.html)                           | 功能一致，参数名不同 |
| [torch.clamp](https://pytorch.org/docs/1.8.1/generated/torch.clamp.html) | [mindspore.ops.clamp](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.clamp.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.clip](https://pytorch.org/docs/1.8.1/generated/torch.clip.html) | [mindspore.ops.clip](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.clip.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.column_stack](https://pytorch.org/docs/1.8.1/generated/torch.column_stack.html) | [mindspore.ops.column_stack](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.column_stack.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.combinations](https://pytorch.org/docs/1.8.1/generated/torch.combinations.html)                     | [mindspore.ops.combinations](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.combinations.html)                                         |  功能一致，参数名不同 |
| [torch.conj](https://pytorch.org/docs/1.8.1/generated/torch.conj.html)                       | [mindspore.ops.conj](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.conj.html)                                              | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.copysign](https://pytorch.org/docs/1.8.1/generated/torch.copysign.html)                         | [mindspore.ops.copysign](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.copysign.html) |   功能一致，参数名不同|
| [torch.cos](https://pytorch.org/docs/1.8.1/generated/torch.cos.html)                             | [mindspore.ops.cos](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cos.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/cos.html) |
| [torch.cosh](https://pytorch.org/docs/1.8.1/generated/torch.cosh.html)                        | [mindspore.ops.cosh](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cosh.html)                                              |         [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)             |
| [torch.count_nonzero](https://pytorch.org/docs/1.8.1/generated/torch.count_nonzero.html)                         | [mindspore.ops.count_nonzero](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.count_nonzero.html) | 功能一致，参数名不同 |
| [torch.cross](https://pytorch.org/docs/1.8.1/generated/torch.cross.html)          | [mindspore.ops.cross](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cross.html)                                   | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)    |
| [torch.cummax](https://pytorch.org/docs/1.8.1/generated/torch.cummax.html) | [mindspore.ops.cummax](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cummax.html) |功能一致，参数名不同|
| [torch.cummin](https://pytorch.org/docs/1.8.1/generated/torch.cummin.html) | [mindspore.ops.cummin](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cummin.html) |功能一致，参数名不同|
| [torch.cumprod](https://pytorch.org/docs/1.8.1/generated/torch.cumprod.html) | [mindspore.ops.cumprod](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cumprod.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.cumsum](https://pytorch.org/docs/1.8.1/generated/torch.cumsum.html)                       |   [mindspore.ops.cumsum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cumsum.html) | 功能一致，参数名不同 |
| [torch.deg2rad](https://pytorch.org/docs/1.8.1/generated/torch.deg2rad.html)                         | [mindspore.ops.deg2rad](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.deg2rad.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/deg2rad.html) |
| [torch.diag](https://pytorch.org/docs/1.8.1/generated/torch.diag.html)                       |   [mindspore.ops.diag](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.diag.html)                                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/diag.html)                                                                                                                         |
| [torch.diag_embed](https://pytorch.org/docs/1.8.1/generated/torch.diag_embed.html)                         | [mindspore.ops.diag_embed](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.diag_embed.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.diagflat](https://pytorch.org/docs/1.8.1/generated/torch.diagflat.html)                       |   [mindspore.ops.diagflat](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.diagflat.html)                                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.diagonal](https://pytorch.org/docs/1.8.1/generated/torch.diagonal.html)                       |   [mindspore.ops.diagonal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.diagonal.html)                                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.diff](https://pytorch.org/docs/1.8.1/generated/torch.diff.html)                       |   [mindspore.ops.diff](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.diff.html)                                       | 功能一致，参数名不同 |
| [torch.digamma](https://pytorch.org/docs/1.8.1/generated/torch.digamma.html)                         | [mindspore.ops.digamma](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.digamma.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.dist](https://pytorch.org/docs/1.8.1/generated/torch.dist.html)                         | [mindspore.ops.dist](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.dist.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.div](https://pytorch.org/docs/1.8.1/generated/torch.div.html) |  [mindspore.ops.div](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.div.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.divide](https://pytorch.org/docs/1.8.1/generated/torch.divide.html)                            |  [mindspore.ops.divide](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.divide.html)                                                 |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.dot](https://pytorch.org/docs/1.8.1/generated/torch.dot.html) |  [mindspore.ops.tensor_dot](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tensor_dot.html) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/tensor_dot.html) |
| [torch.dstack](https://pytorch.org/docs/1.8.1/generated/torch.dstack.html)                     | [mindspore.ops.dstack](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.dstack.html)                                         |  功能一致，参数名不同 |
| [torch.einsum](https://pytorch.org/docs/1.8.1/generated/torch.einsum.html)               | [mindspore.ops.einsum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.einsum.html)                    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.eq](https://pytorch.org/docs/1.8.1/generated/torch.eq.html)                               |  [mindspore.ops.equal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.equal.html)                                           |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.erf](https://pytorch.org/docs/1.8.1/generated/torch.erf.html)                           | [mindspore.ops.erf](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.erf.html)                                              | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)   |
| [torch.erfc](https://pytorch.org/docs/1.8.1/generated/torch.erfc.html)                           | [mindspore.ops.erfc](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.erfc.html)                                              |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)   |
| [torch.erfinv](https://pytorch.org/docs/1.8.1/generated/torch.erfinv.html)                       | [mindspore.ops.erfinv](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.erfinv.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/erfinv.html) |
| [torch.exp](https://pytorch.org/docs/1.8.1/generated/torch.exp.html)                | [mindspore.ops.exp](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.exp.html)      |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)    |
| [torch.exp2](https://pytorch.org/docs/1.8.1/generated/torch.exp2.html)                         | [mindspore.ops.exp2](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.exp2.html) |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.expm1](https://pytorch.org/docs/1.8.1/generated/torch.expm1.html)                        | [mindspore.ops.expm1](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.expm1.html)                                           |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.eye](https://pytorch.org/docs/1.8.1/generated/torch.eye.html)                             | [mindspore.ops.eye](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.eye.html)                                                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.flatten](https://pytorch.org/docs/1.8.1/generated/torch.flatten.html) | [mindspore.ops.flatten](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.flatten.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/flatten.html) |
| [torch.float_power](https://pytorch.org/docs/1.8.1/generated/torch.float_power.html)             | [mindspore.ops.float_power](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.float_power.html)                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/float_power.html)                                                                                                                      |
| [torch.flip](https://pytorch.org/docs/1.8.1/generated/torch.flip.html)                           | [mindspore.ops.flip](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.flip.html)                           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.fliplr](https://pytorch.org/docs/1.8.1/generated/torch.fliplr.html)                       | [mindspore.ops.fliplr](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.fliplr.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.flipud](https://pytorch.org/docs/1.8.1/generated/torch.flipud.html)                       | [mindspore.ops.flipud](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.flipud.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.floor](https://pytorch.org/docs/1.8.1/generated/torch.floor.html) | [mindspore.ops.floor](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.floor.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/floor.html) |
| [torch.floor_divide](https://pytorch.org/docs/1.8.1/generated/torch.floor_divide.html) | [mindspore.ops.floor_divide](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.floor_divide.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.fmax](https://pytorch.org/docs/1.8.1/generated/torch.fmax.html)                         | [mindspore.ops.fmax](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.fmax.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.fmod](https://pytorch.org/docs/1.8.1/generated/torch.fmod.html)                       | [mindspore.ops.fmod](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.fmod.html)                                   | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.frac](https://pytorch.org/docs/1.8.1/generated/torch.frac.html)                       | [mindspore.ops.frac](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.frac.html)                                   | 功能一致，参数名不同 |
| [torch.full](https://pytorch.org/docs/1.8.1/generated/torch.full.html)                           | [mindspore.ops.full](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.full.html)                                      | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.full_like](https://pytorch.org/docs/1.8.1/generated/torch.full_like.html)                 | [mindspore.ops.full_like](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.full_like.html)                       |    [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)       |
| [torch.gather](https://pytorch.org/docs/1.8.1/generated/torch.gather.html) | [mindspore.ops.gather_elements](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.gather_elements.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.gcd](https://pytorch.org/docs/1.8.1/generated/torch.gcd.html)                 | [mindspore.ops.gcd](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.gcd.html)                       |    [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                |
| [torch.ge](https://pytorch.org/docs/1.8.1/generated/torch.ge.html)                 | [mindspore.ops.ge](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ge.html)                       |    功能一致，参数名不同                   |
| [torch.geqrf](https://pytorch.org/docs/1.8.1/generated/torch.geqrf.html)                 | [mindspore.ops.geqrf](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.geqrf.html)                       |    [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                |
| [torch.ger](https://pytorch.org/docs/1.8.1/generated/torch.ger.html) | [mindspore.ops.ger](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ger.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/ger.html) |
| [torch.greater](https://pytorch.org/docs/1.8.1/generated/torch.greater.html) | [mindspore.ops.greater](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.greater.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.greater_equal](https://pytorch.org/docs/1.8.1/generated/torch.greater_equal.html) | [mindspore.ops.greater_equal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.greater_equal.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.gt](https://pytorch.org/docs/1.8.1/generated/torch.gt.html)                 | [mindspore.ops.gt](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.gt.html)                       |    功能一致，参数名不同                   |
| [torch.hann_window](https://pytorch.org/docs/1.8.1/generated/torch.hann_window.html)                     | [mindspore.ops.hann_window](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.hann_window.html)                                         |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.heaviside](https://pytorch.org/docs/1.8.1/generated/torch.heaviside.html) | [mindspore.ops.heaviside](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.heaviside.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.hstack](https://pytorch.org/docs/1.8.1/generated/torch.hstack.html) | [mindspore.ops.hstack](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.hstack.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.histc](https://pytorch.org/docs/1.8.1/generated/torch.histc.html) | [mindspore.ops.histc](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.histc.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.hypot](https://pytorch.org/docs/1.8.1/generated/torch.hypot.html) | [mindspore.ops.hypot](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.hypot.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.hamming_window](https://pytorch.org/docs/1.8.1/generated/torch.hamming_window.html)             | [mindspore.ops.hamming_window](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.hamming_window.html)                             |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                              |
| [torch.i0](https://pytorch.org/docs/1.8.1/generated/torch.i0.html) | [mindspore.ops.i0](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.i0.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.igamma](https://pytorch.org/docs/1.8.1/generated/torch.igamma.html)| [mindspore.ops.igamma](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.igamma.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.igammac](https://pytorch.org/docs/1.8.1/generated/torch.igammac.html)| [mindspore.ops.igammac](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.igammac.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.imag](https://pytorch.org/docs/1.8.1/generated/torch.imag.html) | [mindspore.ops.imag](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.imag.html)  | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.index_select](https://pytorch.org/docs/1.8.1/generated/torch.index_select.html) | [mindspore.ops.index_select](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.index_select.html) | 功能一致，参数名不同 |
| [torch.inner](https://pytorch.org/docs/1.8.1/generated/torch.inner.html) | [mindspore.ops.inner](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.inner.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.inverse](https://pytorch.org/docs/1.8.1/generated/torch.inverse.html) | [mindspore.ops.inverse](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.inverse.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.isclose](https://pytorch.org/docs/1.8.1/generated/torch.isclose.html) | [mindspore.ops.isclose](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.isclose.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/isclose.html) |
| [torch.isfinite](https://pytorch.org/docs/1.8.1/generated/torch.isfinite.html) | [mindspore.ops.isfinite](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.isfinite.html) | 功能一致，参数名不同 |
| [torch.isinf](https://pytorch.org/docs/1.8.1/generated/torch.isinf.html) | [mindspore.ops.isinf](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.isinf.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.isnan](https://pytorch.org/docs/1.8.1/generated/torch.isnan.html) | [mindspore.ops.isnan](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.isnan.html) | 功能一致，参数名不同 |
| [torch.isneginf](https://pytorch.org/docs/1.8.1/generated/torch.isneginf.html) | [mindspore.ops.isneginf](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.isneginf.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.isposinf](https://pytorch.org/docs/1.8.1/generated/torch.isposinf.html) | [mindspore.ops.isposinf](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.isposinf.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.isreal](https://pytorch.org/docs/1.8.1/generated/torch.isreal.html) | [mindspore.ops.isreal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.isreal.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.is_complex](https://pytorch.org/docs/1.8.1/generated/torch.is_complex.html) | [mindspore.ops.is_complex](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.is_complex.html) | 功能一致，参数名不同|
| [torch.is_floating_point](https://pytorch.org/docs/1.8.1/generated/torch.is_floating_point.html) | [mindspore.ops.is_floating_point](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.is_floating_point.html) | 功能一致，参数名不同|
| [torch.is_nonzero](https://pytorch.org/docs/1.8.1/generated/torch.is_nonzero.html#torch.is_nonzero) | [mindspore.ops.is_nonzero](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.is_nonzero.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.is_tensor](https://pytorch.org/docs/1.8.1/generated/torch.is_tensor.html#torch.is_tensor) | [mindspore.ops.is_tensor](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.is_tensor.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.kaiser_window](https://pytorch.org/docs/1.8.1/generated/torch.kaiser_window.html)                     | [mindspore.ops.kaiser_window](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.kaiser_window.html)                                         | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.kron](https://pytorch.org/docs/1.8.1/generated/torch.kron.html)                         | [mindspore.ops.kron](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.kron.html) |[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.lcm](https://pytorch.org/docs/1.8.1/generated/torch.lcm.html) | [mindspore.ops.lcm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.lcm.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.ldexp](https://pytorch.org/docs/1.8.1/generated/torch.ldexp.html)                         | [mindspore.ops.ldexp](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ldexp.html) |   功能一致，参数名不同|
| [torch.le](https://pytorch.org/docs/1.8.1/generated/torch.le.html) | [mindspore.ops.le](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.le.html) | 功能一致，参数名不同 |
| [torch.lerp](https://pytorch.org/docs/1.8.1/generated/torch.lerp.html) | [mindspore.ops.lerp](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.lerp.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.less](https://pytorch.org/docs/1.8.1/generated/torch.less.html) | [mindspore.ops.less](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.less.html) | 功能一致，参数名不同 |
| [torch.less_equal](https://pytorch.org/docs/1.8.1/generated/torch.less_equal.html) | [mindspore.ops.less_equal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.less_equal.html) | 功能一致，参数名不同 |
| [torch.linalg.cond](https://pytorch.org/docs/1.8.1/linalg.html#torch.linalg.cond)                       | [mindspore.ops.cond](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cond.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.linalg.eigvals](https://pytorch.org/docs/stable/generated/torch.linalg.eigvals.html#torch.linalg.eigvals)               | [mindspore.ops.eigvals](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.eigvals.html)                    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.linalg.norm](https://pytorch.org/docs/1.8.1/linalg.html#torch.linalg.norm) | [mindspore.ops.norm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.norm.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.linspace](https://pytorch.org/docs/1.8.1/generated/torch.linspace.html) | [mindspore.ops.linspace](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.linspace.html) | [功能一致，参数个数或顺序不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/linspace.html) |
| [torch.log](https://pytorch.org/docs/1.8.1/generated/torch.log.html) | [mindspore.ops.log](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.log.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/log.html) |
| [torch.log2](https://pytorch.org/docs/1.8.1/generated/torch.log2.html)                         | [mindspore.ops.log2](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.log2.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/log2.html) |
| [torch.log10](https://pytorch.org/docs/1.8.1/generated/torch.log10.html)                         | [mindspore.ops.log10](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.log10.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/log10.html) |
| [torch.logaddexp](https://pytorch.org/docs/1.8.1/generated/torch.logaddexp.html)                         | [mindspore.ops.logaddexp](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logaddexp.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.logaddexp2](https://pytorch.org/docs/1.8.1/generated/torch.logaddexp2.html)                         | [mindspore.ops.logaddexp2](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logaddexp2.html) |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.logcumsumexp](https://pytorch.org/docs/1.8.1/generated/torch.logcumsumexp.html)                         | [mindspore.ops.logcumsumexp](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logcumsumexp.html) | 功能一致，参数名不同 |
| [torch.log1p](https://pytorch.org/docs/1.8.1/generated/torch.log1p.html#torch.log1p) | [mindspore.ops.log1p](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.log1p.html#mindspore.ops.log1p) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.logdet](https://pytorch.org/docs/1.8.1/generated/torch.logdet.html#torch.logdet) | [mindspore.ops.logdet](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logdet.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.logical_and](https://pytorch.org/docs/1.8.1/generated/torch.logical_and.html) | [mindspore.ops.logical_and](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logical_and.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.logical_not](https://pytorch.org/docs/1.8.1/generated/torch.logical_not.html) | [mindspore.ops.logical_not](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logical_not.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.logical_or](https://pytorch.org/docs/1.8.1/generated/torch.logical_or.html) | [mindspore.ops.logical_or](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logical_or.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.logical_xor](https://pytorch.org/docs/1.8.1/generated/torch.logical_xor.html) | [mindspore.ops.logical_xor](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logical_xor.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.logit](https://pytorch.org/docs/1.8.1/generated/torch.logit.html)| [mindspore.ops.logit](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logit.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.logspace](https://pytorch.org/docs/1.8.1/generated/torch.logspace.html) | [mindspore.ops.logspace](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logspace.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.logsumexp](https://pytorch.org/docs/1.8.1/generated/torch.logsumexp.html) | [mindspore.ops.logsumexp](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logsumexp.html) | 功能一致，参数名不同 |
| [torch.lt](https://pytorch.org/docs/1.8.1/generated/torch.lt.html) | [mindspore.ops.lt](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.lt.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.lu_solve](https://pytorch.org/docs/1.8.1/generated/torch.lu_solve.html) | [mindspore.ops.lu_solve](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.lu_solve.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.lu_unpack](https://pytorch.org/docs/1.8.1/generated/torch.lu_unpack.html) | [mindspore.ops.lu_unpack](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.lu_unpack.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.masked_select](https://pytorch.org/docs/1.8.1/generated/torch.masked_select.html) | [mindspore.ops.masked_select](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.masked_select.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.matmul](https://pytorch.org/docs/1.8.1/generated/torch.matmul.html#torch.matmul) | [mindspore.ops.matmul](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.matmul.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.max](https://pytorch.org/docs/1.8.1/generated/torch.max.html) | [mindspore.ops.max](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.max.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/max.html) |
| [torch.maximum](https://pytorch.org/docs/1.8.1/generated/torch.maximum.html) | [mindspore.ops.maximum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.maximum.html) | 功能一致，参数名不同 |
| [torch.mean](https://pytorch.org/docs/1.8.1/generated/torch.mean.html) | [mindspore.ops.mean](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.mean.html) | 功能一致，参数名不同 |
| [torch.median](https://pytorch.org/docs/1.8.1/generated/torch.median.html) | [mindspore.ops.median](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.median.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/median.html) |
| [torch.meshgrid](https://pytorch.org/docs/1.8.1/generated/torch.meshgrid.html#torch.meshgrid) | [mindspore.ops.meshgrid](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.meshgrid.html) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/meshgrid.html)                    |
| [torch.mm](https://pytorch.org/docs/1.8.1/generated/torch.mm.html)| [mindspore.ops.mm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.mm.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.mul](https://pytorch.org/docs/1.8.1/generated/torch.mul.html#torch.mul) | [mindspore.ops.mul](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.mul.html#mindspore.ops.mul)  | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.min](https://pytorch.org/docs/1.8.1/generated/torch.min.html) | [mindspore.ops.min](https://www.mindspore.cn/docs/zh-CN//r2.2/api_python/ops/mindspore.ops.min.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/min.html)|
| [torch.minimum](https://pytorch.org/docs/1.8.1/generated/torch.minimum.html) | [mindspore.ops.minimum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.minimum.html) | 功能一致，参数名不同 |
| [torch.msort](https://pytorch.org/docs/1.8.1/generated/torch.msort.html) | [mindspore.ops.msort](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.msort.html) |    [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.moveaxis](https://pytorch.org/docs/1.8.1/generated/torch.moveaxis.html) | [mindspore.ops.moveaxis](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.moveaxis.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.movedim](https://pytorch.org/docs/1.8.1/generated/torch.movedim.html) | [mindspore.ops.movedim](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.movedim.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.multinomial](https://pytorch.org/docs/1.8.1/generated/torch.multinomial.html) | [mindspore.ops.multinomial](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.multinomial.html) | [功能一致，参数默认值不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/multinomial.html) |
| [torch.multiply](https://pytorch.org/docs/1.8.1/generated/torch.multiply.html) | [mindspore.ops.multiply](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.multiply.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.mv](https://pytorch.org/docs/1.8.1/generated/torch.mv.html)                         | [mindspore.ops.mv](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.mv.html) |   功能一致，参数名不同|
| [torch.mvlgamma](https://pytorch.org/docs/1.8.1/generated/torch.mvlgamma.html)| [mindspore.ops.mvlgamma](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.mvlgamma.html)| [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/mvlgamma.html) |
| [torch.nan_to_num](https://pytorch.org/docs/1.8.1/generated/torch.nan_to_num.html) | [mindspore.ops.nan_to_num](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.nan_to_num.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nansum](https://pytorch.org/docs/1.8.1/generated/torch.nansum.html) | [mindspore.ops.nansum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.nansum.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.narrow](https://pytorch.org/docs/1.8.1/generated/torch.narrow.html) | [mindspore.ops.narrow](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.narrow.html) | 功能一致，参数名不同 |
| [torch.ne](https://pytorch.org/docs/1.8.1/generated/torch.ne.html)| [mindspore.ops.ne](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ne.html)| 功能一致，参数名不同 |
| [torch.neg](https://pytorch.org/docs/1.8.1/generated/torch.neg.html)| [mindspore.ops.neg](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.neg.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.negative](https://pytorch.org/docs/1.8.1/generated/torch.negative.html) | [mindspore.ops.negative](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.negative.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nextafter](https://pytorch.org/docs/1.8.1/generated/torch.nextafter.html) | [mindspore.ops.nextafter](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.nextafter.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nonzero](https://pytorch.org/docs/1.8.1/generated/torch.nonzero.html) | [mindspore.ops.nonzero](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.nonzero.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.normal](https://pytorch.org/docs/1.8.1/generated/torch.normal.html) | [mindspore.ops.normal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.normal.html) | [功能一致，参数个数或顺序不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/normal.html) |
| [torch.not_equal](https://pytorch.org/docs/1.8.1/generated/torch.not_equal.html) | [mindspore.ops.not_equal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.not_equal.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.numel](https://pytorch.org/docs/1.8.1/generated/torch.numel.html) | [mindspore.ops.numel](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.numel.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.ones](https://pytorch.org/docs/1.8.1/generated/torch.ones.html) | [mindspore.ops.ones](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ones.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/ones.html) |
| [torch.ones_like](https://pytorch.org/docs/1.8.1/torch.html#torch.ones_like) | [mindspore.ops.ones_like](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ones_like.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.orgqr](https://pytorch.org/docs/1.8.1/generated/torch.orgqr.html) | [mindspore.ops.orgqr](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.orgqr.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.ormqr](https://pytorch.org/docs/1.8.1/generated/torch.ormqr.html) | [mindspore.ops.ormqr](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ormqr.html) | 功能一致，参数名不同 |
| [torch.outer](https://pytorch.org/docs/1.8.1/generated/torch.outer.html)                         | [mindspore.ops.outer](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.outer.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.poisson](https://pytorch.org/docs/1.8.1/generated/torch.poisson.html) | [mindspore.ops.random_poisson](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.random_poisson.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/poisson.html) |
| [torch.polar](https://pytorch.org/docs/1.8.1/generated/torch.polar.html)                         | [mindspore.ops.polar](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.polar.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.polygamma](https://pytorch.org/docs/1.8.1/generated/torch.polygamma.html)                         | [mindspore.ops.polygamma](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.polygamma.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/polygamma.html) |
| [torch.pow](https://pytorch.org/docs/1.8.1/generated/torch.pow.html#torch.pow) | [mindspore.ops.pow](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.pow.html#mindspore.ops.pow) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.prod](https://pytorch.org/docs/1.8.1/generated/torch.prod.html#torch.prod) | [mindspore.ops.prod](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.prod.html#mindspore.ops.prod) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/prod.html) |
| [torch.rad2deg](https://pytorch.org/docs/1.8.1/generated/torch.rad2deg.html)                         | [mindspore.ops.rad2deg](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.rad2deg.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/rad2deg.html) |
| [torch.rand](https://pytorch.org/docs/1.8.1/generated/torch.rand.html) | [mindspore.ops.rand](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.rand.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.rand_like](https://pytorch.org/docs/1.8.1/generated/torch.rand_like.html) | [mindspore.ops.rand_like](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.rand_like.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.randn](https://pytorch.org/docs/1.8.1/generated/torch.randn.html) | [mindspore.ops.randn](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.randn.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.randn_like](https://pytorch.org/docs/1.8.1/generated/torch.randn_like.html) | [mindspore.ops.randn_like](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.randn_like.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.randint](https://pytorch.org/docs/1.8.1/generated/torch.randint.html) | [mindspore.ops.randint](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.randint.html) | [功能一致，默认值不同](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/randint.html) |
| [torch.randint_like](https://pytorch.org/docs/1.8.1/generated/torch.randint_like.html) | [mindspore.ops.randint_like](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.randint_like.html) | [功能一致，默认值不同](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/randint_like.html) |
| [torch.randperm](https://pytorch.org/docs/1.8.1/generated/torch.randperm.html)                         | [mindspore.ops.randperm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.randperm.html) |  功能一致，参数名不同 |
| [torch.range](https://pytorch.org/docs/1.8.1/generated/torch.range.html#torch.range) | [mindspore.ops.range](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.range.html) | [功能一致，参数个数或顺序不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/range.html) |
| [torch.ravel](https://pytorch.org/docs/1.8.1/generated/torch.ravel.html)                           | [mindspore.ops.ravel](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ravel.html)      |          [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)     |
| [torch.real](https://pytorch.org/docs/1.8.1/generated/torch.real.html)                           | [mindspore.ops.real](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.real.html)      |          [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                              |
| [torch.reciprocal](https://pytorch.org/docs/1.8.1/generated/torch.reciprocal.html) | [mindspore.ops.reciprocal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.reciprocal.html) |[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.remainder](https://pytorch.org/docs/1.8.1/generated/torch.remainder.html)                         | [mindspore.ops.remainder](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.remainder.html) |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.renorm](https://pytorch.org/docs/1.8.1/generated/torch.renorm.html) | [mindspore.ops.renorm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.renorm.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/renorm.html) |
| [torch.repeat_interleave](https://pytorch.org/docs/1.8.1/generated/torch.repeat_interleave.html) | [mindspore.ops.repeat_interleave](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.repeat_interleave.html) | 功能一致，参数名不同|
| [torch.reshape](https://pytorch.org/docs/1.8.1/generated/torch.reshape.html#torch.reshape) | [mindspore.ops.reshape](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.reshape.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.roll](https://pytorch.org/docs/1.8.1/generated/torch.roll.html)                         | [mindspore.ops.roll](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.roll.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.rot90](https://pytorch.org/docs/1.8.1/generated/torch.rot90.html)                         | [mindspore.ops.rot90](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.rot90.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.round](https://pytorch.org/docs/1.8.1/generated/torch.round.html)| [mindspore.ops.round](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.round.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.row_stack](https://pytorch.org/docs/1.8.1/generated/torch.row_stack.html)| [mindspore.ops.row_stack](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.row_stack.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.rsqrt](https://pytorch.org/docs/1.8.1/generated/torch.rsqrt.html)                           | [mindspore.ops.rsqrt](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.rsqrt.html)                           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.searchsorted](https://pytorch.org/docs/1.8.1/generated/torch.searchsorted.html)                         | [mindspore.ops.searchsorted](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.searchsorted.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.scatter](https://pytorch.org/docs/1.8.1/generated/torch.scatter.html) | [mindspore.ops.scatter](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.scatter.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/scatter.html) |
| [torch.scatter_add](https://pytorch.org/docs/1.8.1/generated/torch.scatter_add.html) | [mindspore.ops.tensor_scatter_elements](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tensor_scatter_elements.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/scatter_add.html) |
| [torch.sgn](https://pytorch.org/docs/1.8.1/generated/torch.sgn.html)                           | [mindspore.ops.sgn](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.sgn.html)                           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.sigmoid](https://pytorch.org/docs/1.8.1/generated/torch.sigmoid.html) | [mindspore.ops.sigmoid](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.sigmoid.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.sign](https://pytorch.org/docs/1.8.1/generated/torch.sign.html)                           | [mindspore.ops.sign](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.sign.html)                           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.signbit](https://pytorch.org/docs/1.8.1/generated/torch.signbit.html)                           | [mindspore.ops.signbit](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.signbit.html)                           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.sin](https://pytorch.org/docs/1.8.1/generated/torch.sin.html)| [mindspore.ops.sin](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.sin.html)| [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.sinc](https://pytorch.org/docs/1.8.1/generated/torch.sinc.html)| [mindspore.ops.sinc](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.sinc.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.sinh](https://pytorch.org/docs/1.8.1/generated/torch.sinh.html)| [mindspore.ops.sinh](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.sinh.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.slogdet](https://pytorch.org/docs/1.8.1/generated/torch.slogdet.html)                         | [mindspore.ops.slogdet](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.slogdet.html)                         | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.sort](https://pytorch.org/docs/1.8.1/generated/torch.sort.html)                     | [mindspore.ops.sort](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.sort.html)                                         |  功能一致，参数名不同 |
| [torch.split](https://pytorch.org/docs/1.8.1/generated/torch.split.html)                         | [mindspore.ops.split](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.split.html)                         | 功能一致，参数名不同 |
| [torch.stack](https://pytorch.org/docs/1.8.1/generated/torch.stack.html) | [mindspore.ops.stack](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.stack.html) | 功能一致，参数名不同 |
| [torch.squeeze](https://pytorch.org/docs/1.8.1/generated/torch.squeeze.html) | [mindspore.ops.squeeze](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.squeeze.html) | 功能一致，参数名不一致 |
| [torch.std](https://pytorch.org/docs/1.8.1/generated/torch.std.html#torch.std) | [mindspore.ops.std](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.std.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/std.html) |
| [torch.std_mean](https://pytorch.org/docs/1.8.1/generated/torch.std_mean.html#torch.std_mean) | [mindspore.ops.std_mean](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.std_mean.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/std_mean.html) |
| [torch.sqrt](https://pytorch.org/docs/1.8.1/generated/torch.sqrt.html) | [mindspore.ops.sqrt](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.sqrt.html) |  功能一致，参数名不同 |
| [torch.square](https://pytorch.org/docs/1.8.1/generated/torch.square.html)| [mindspore.ops.square](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.square.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.sub](https://pytorch.org/docs/1.8.1/generated/torch.sub.html#torch.sub)  | [mindspore.ops.subtract](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.subtract.html)  | 功能一致，参数名不同 |
| [torch.subtract](https://pytorch.org/docs/1.8.1/generated/torch.subtract.html#torch.subtract)  | [mindspore.ops.subtract](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.subtract.html)  | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.sum](https://pytorch.org/docs/1.8.1/generated/torch.sum.html)                             | [mindspore.ops.sum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.sum.html)                             | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.svd](https://pytorch.org/docs/1.8.1/generated/torch.svd.html) | [mindspore.ops.svd](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.svd.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/svd.html) |
| [torch.swapaxes](https://pytorch.org/docs/1.8.1/generated/torch.swapaxes.html) | [mindspore.ops.swapaxes](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.swapaxes.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.swapdims](https://pytorch.org/docs/1.8.1/generated/torch.swapdims.html) | [mindspore.ops.swapdims](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.swapdims.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.t](https://pytorch.org/docs/1.8.1/generated/torch.t.html)           | [mindspore.ops.t](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.t.html)           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.tan](https://pytorch.org/docs/1.8.1/generated/torch.tan.html)| [mindspore.ops.tan](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tan.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.tanh](https://pytorch.org/docs/1.8.1/generated/torch.tanh.html) | [mindspore.ops.tanh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tanh.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.tensor_split](https://pytorch.org/docs/1.8.1/generated/torch.tensor_split.html)           | [mindspore.ops.tensor_split](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tensor_split.html)           |功能一致，参数名不同|
| [torch.tile](https://pytorch.org/docs/1.8.1/generated/torch.tile.html)           | [mindspore.ops.tile](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tile.html)           | 功能一致，参数名不同|
| [torch.topk](https://pytorch.org/docs/1.8.1/generated/torch.topk.html#torch.topk) | [mindspore.ops.topk](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.topk.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.trace](https://pytorch.org/docs/1.8.1/generated/torch.trace.html) | [mindspore.ops.trace](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.trace.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.transpose](https://pytorch.org/docs/1.8.1/generated/torch.transpose.html) | [mindspore.ops.swapaxes](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.swapaxes.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.trapz](https://pytorch.org/docs/1.8.1/generated/torch.trapz.html)                         | [mindspore.ops.trapz](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.trapz.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.tril](https://pytorch.org/docs/1.8.1/generated/torch.tril.html)           | [mindspore.ops.tril](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tril.html)           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.tril_indices](https://pytorch.org/docs/1.8.1/generated/torch.tril_indices.html)                         | [mindspore.ops.tril_indices](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tril_indices.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.triu_indices](https://pytorch.org/docs/1.8.1/generated/torch.triu_indices.html)                         | [mindspore.ops.triu_indices](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.triu_indices.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.true_divide](https://pytorch.org/docs/1.8.1/generated/torch.true_divide.html#torch.true_divide) | [mindspore.ops.true_divide](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.true_divide.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.trunc](https://pytorch.org/docs/1.8.1/generated/torch.trunc.html)| [mindspore.ops.trunc](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.trunc.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.unbind](https://pytorch.org/docs/1.8.1/generated/torch.unbind.html)                           | [mindspore.ops.unbind](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.unbind.html)                            | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.unique](https://pytorch.org/docs/1.8.1/generated/torch.unique.html#torch.unique) | [mindspore.ops.unique](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.unique.html#mindspore.ops.unique) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/unique.html) |
| [torch.unique_consecutive](https://pytorch.org/docs/1.8.1/generated/torch.unique_consecutive.html#torch.unique_consecutive) | [mindspore.ops.unique_consecutive](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.unique_consecutive.html#mindspore.ops.unique_consecutive) | 功能一致，参数名不同 |
| [torch.unsqueeze](https://pytorch.org/docs/1.8.1/generated/torch.unsqueeze.html)| [mindspore.ops.unsqueeze](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.unsqueeze.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.vander](https://pytorch.org/docs/1.8.1/generated/torch.vander.html) | [mindspore.ops.vander](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.vander.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.var](https://pytorch.org/docs/1.8.1/generated/torch.var.html#torch.var) | [mindspore.ops.var](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.var.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/var.html) |
| [torch.var_mean](https://pytorch.org/docs/1.8.1/generated/torch.var_mean.html#torch.var_mean) | [mindspore.ops.var_mean](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.var_mean.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/var_mean.html) |
| [torch.view_as_real](https://pytorch.org/docs/1.8.1/generated/torch.view_as_real.html)                           | [mindspore.ops.view_as_real](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.view_as_real.html)                            | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.vstack](https://pytorch.org/docs/1.8.1/generated/torch.vstack.html)                     | [mindspore.ops.vstack](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.vstack.html)                                         |  功能一致，参数名不同 |
| [torch.where](https://pytorch.org/docs/1.8.1/generated/torch.where.html) | [mindspore.ops.where](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.where.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.xlogy](https://pytorch.org/docs/1.8.1/generated/torch.xlogy.html) | [mindspore.ops.xlogy](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.xlogy.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.zeros](https://pytorch.org/docs/1.8.1/generated/torch.zeros.html) | [mindspore.ops.zeros](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.zeros.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/zeros.html)|
| [torch.zeros_like](https://pytorch.org/docs/1.8.1/torch.html#torch.zeros_like) | [mindspore.ops.zeros_like](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.zeros_like.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |

### torch.distributions

| PyTorch 1.8.1 APIs                                                                                                   | MindSpore APIs                                                                                                                | 说明 |
| -------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------- | ---- |
| [torch.distributions.laplace.Laplace](https://pytorch.org/docs/1.8.1/distributions.html#torch.distributions.laplace.Laplace) | [mindspore.ops.standard_laplace](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.standard_laplace.html) |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/standard_laplace.html)   |

### torch.distributed

| PyTorch 1.8.1 APIs                                                                                                           | MindSpore APIs                                                                                                                                                  | 说明                                                                                                              |
| ---------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------- |
| [torch.distributed.all_gather](https://pytorch.org/docs/1.8.1/distributed.html#torch.distributed.all_gather)                 | [mindspore.ops.AllGather](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.AllGather.html#mindspore.ops.AllGather)                                                                                                                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/all_gather.html)        |
| [torch.distributed.all_reduce](https://pytorch.org/docs/1.8.1/distributed.html#torch.distributed.all_reduce)                 | [mindspore.ops.AllReduce](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.AllReduce.html#mindspore.ops.AllReduce)                                                                                                                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/all_reduce.html)        |
| [torch.distributed.get_rank](https://pytorch.org/docs/1.8.1/distributed.html#torch.distributed.get_rank)                     | [mindspore.communication.get_rank](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore.communication.html#mindspore.communication.get_rank)                                                                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/get_rank.html)          |
| [torch.distributed.init_process_group](https://pytorch.org/docs/1.8.1/distributed.html#torch.distributed.init_process_group) | [mindspore.communication.init](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore.communication.html#mindspore.communication.init)                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/init.html)         |
| [torch.distributed.new_group](https://pytorch.org/docs/1.8.1/distributed.html#torch.distributed.new_group)                   | [mindspore.communication.create_group](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore.communication.html#mindspore.communication.create_group) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/create_group.html) |

### torch.nn

| PyTorch 1.8.1 APIs                                           | MindSpore APIs                                               | 说明                                                         |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| [torch.nn.AdaptiveAvgPool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveAvgPool1d.html) | [mindspore.nn.AdaptiveAvgPool1d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AdaptiveAvgPool1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AdaptiveAvgPool1d.html) |
| [torch.nn.AdaptiveAvgPool2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveAvgPool2d.html) | [mindspore.nn.AdaptiveAvgPool2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AdaptiveAvgPool2d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.AdaptiveAvgPool3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveAvgPool3d.html) | [mindspore.nn.AdaptiveAvgPool3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AdaptiveAvgPool3d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.AdaptiveMaxPool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveMaxPool1d.html) | [mindspore.nn.AdaptiveMaxPool1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AdaptiveMaxPool1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AdaptiveMaxPool1d.html) |
| [torch.nn.AdaptiveMaxPool2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveMaxPool2d.html) | [mindspore.nn.AdaptiveMaxPool2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AdaptiveMaxPool2d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.AdaptiveMaxPool3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveMaxPool3d.html) | [mindspore.nn.AdaptiveMaxPool3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AdaptiveMaxPool3d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.AvgPool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AvgPool1d.html) | [mindspore.nn.AvgPool1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AvgPool1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AvgPool1d.html)                                                             |
| [torch.nn.AvgPool2d](https://PyTorch.org/docs/1.8.1/generated/torch.nn.AvgPool2d.html) | [mindspore.nn.AvgPool2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AvgPool2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AvgPool2d.html)                                                             |
| [torch.nn.AvgPool3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AvgPool3d.html)                 | [mindspore.nn.AvgPool3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AvgPool3d.html)                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AvgPool3d.html)|
| [torch.nn.BCELoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.BCELoss.html) | [mindspore.nn.BCELoss](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.BCELoss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.BCEWithLogitsLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.BCEWithLogitsLoss.html) | [mindspore.nn.BCEWithLogitsLoss](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.BCEWithLogitsLoss.html) |    [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/BCEWithLogitsLoss.html)                                                           |
| [torch.nn.BatchNorm1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.BatchNorm1d.html) | [mindspore.nn.BatchNorm1d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.BatchNorm1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/BatchNorm1d.html) |
| [torch.nn.BatchNorm2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.BatchNorm2d.html) | [mindspore.nn.BatchNorm2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.BatchNorm2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/BatchNorm2d.html) |
| [torch.nn.BatchNorm3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.BatchNorm3d.html) | [mindspore.nn.BatchNorm3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.BatchNorm3d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/BatchNorm3d.html) |
| [torch.nn.Bilinear](https://pytorch.org/docs/1.8.1/generated/torch.nn.Bilinear.html) | [mindspore.nn.BiDense](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.BiDense.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/BiDense.html) |
| [torch.nn.CeLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.CELU.html) | [mindspore.nn.CELU](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.CELU.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.ChannelShuffle](https://pytorch.org/docs/1.8.1/generated/torch.nn.ChannelShuffle.html) | [mindspore.nn.ChannelShuffle](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ChannelShuffle.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
|  [torch.nn.CTCLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.CTCLoss.html)  | [mindspore.nn.CTCLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.CTCLoss.html) |[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.ConstantPad1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConstantPad1d.html)  | [mindspore.nn.ConstantPad1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ConstantPad1d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.ConstantPad2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConstantPad2d.html)  | [mindspore.nn.ConstantPad2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ConstantPad2d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.ConstantPad3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConstantPad3d.html)  | [mindspore.nn.ConstantPad3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ConstantPad3d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.Conv1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Conv1d.html) | [mindspore.nn.Conv1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Conv1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Conv1d.html)                                                             |
| [torch.nn.Conv2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Conv2d.html) | [mindspore.nn.Conv2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Conv2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Conv2d.html) |
| [torch.nn.Conv3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Conv3d.html) | [mindspore.nn.Conv3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Conv3d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Conv3d.html)                                                             |
| [torch.nn.ConvTranspose1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConvTranspose1d.html) | [mindspore.nn.Conv1dTranspose](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Conv1dTranspose.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Conv1dTranspose.html)                                                             |
| [torch.nn.ConvTranspose2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConvTranspose2d.html) | [mindspore.nn.Conv2dTranspose](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Conv2dTranspose.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Conv2dTranspose.html)                                                             |
| [torch.nn.ConvTranspose3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConvTranspose3d.html) | [mindspore.nn.Conv3dTranspose](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Conv3dTranspose.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Conv3dTranspose.html)                                                             |
| [torch.nn.CosineEmbeddingLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.CosineEmbeddingLoss.html) | [mindspore.nn.CosineEmbeddingLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.CosineEmbeddingLoss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.CrossEntropyLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.CrossEntropyLoss.html) | [mindspore.nn.CrossEntropyLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.CrossEntropyLoss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/CrossEntropyLoss.html)                                                             |
|  [torch.nn.Dropout](https://pytorch.org/docs/1.8.1/generated/torch.nn.Dropout.html) | [mindspore.nn.Dropout](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Dropout.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Dropout.html) |
| [torch.nn.Dropout2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Dropout2d.html#torch.nn.Dropout2d) | [mindspore.nn.Dropout2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Dropout2d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.Dropout3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Dropout3d.html#torch.nn.Dropout3d) | [mindspore.nn.Dropout3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Dropout3d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.ELU](https://pytorch.org/docs/1.8.1/generated/torch.nn.ELU.html) | [mindspore.nn.ELU](https://www.mindspore.cn/docs/zh-CN/r2.2//api_python/nn/mindspore.nn.ELU.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.Flatten](https://pytorch.org/docs/1.8.1/generated/torch.nn.Flatten.html) | [mindspore.nn.Flatten](https://www.mindspore.cn/docs/zh-CN/r2.2//api_python/nn/mindspore.nn.Flatten.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.GaussianNLLLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.GaussianNLLLoss.html)     | [mindspore.nn.GaussianNLLLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.GaussianNLLLoss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/GaussianNLLLoss.html) |
| [torch.nn.GELU](https://pytorch.org/docs/1.8.1/generated/torch.nn.GELU.html) | [mindspore.nn.GELU](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.GELU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/GELU.html)                                                             |
| [torch.nn.GRU](https://pytorch.org/docs/1.8.1/generated/torch.nn.GRU.html#torch.nn.GRU) | [mindspore.nn.GRU](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.GRU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/GRU.html)                                                             |
| [torch.nn.GRUCell](https://pytorch.org/docs/1.8.1/generated/torch.nn.GRUCell.html) | [mindspore.nn.GRUCell](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.GRUCell.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/GRUCell.html)                                                             |
| [torch.nn.GroupNorm](https://pytorch.org/docs/1.8.1/generated/torch.nn.GroupNorm.html) | [mindspore.nn.GroupNorm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.GroupNorm.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/GroupNorm.html)                                                             |
| [torch.nn.Hardshrink](https://pytorch.org/docs/1.8.1/generated/torch.nn.Hardshrink.html#torch.nn.Hardshrink) | [mindspore.nn.HShrink](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.HShrink.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/HShrink.html)                                                             |
| [torch.nn.Hardsigmoid](https://pytorch.org/docs/1.8.1/generated/torch.nn.Hardsigmoid.html) | [mindspore.nn.Hsigmoid](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.HSigmoid.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.Hardswish](https://pytorch.org/docs/1.8.1/generated/torch.nn.Hardswish.html) | [mindspore.nn.Hswish](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.HSwish.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.Hardtanh](https://pytorch.org/docs/1.8.1/generated/torch.nn.Hardtanh.html) | [mindspore.nn.Hardtanh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Hardtanh.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.HingeEmbeddingLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.HingeEmbeddingLoss.html) | [mindspore.nn.HingeEmbeddingLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.HingeEmbeddingLoss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.HuberLoss](https://pytorch.org/docs/stable/generated/torch.nn.HuberLoss.html)                 | [mindspore.nn.HuberLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.HuberLoss.html)           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.Identity](https://pytorch.org/docs/1.8.1/generated/torch.nn.Identity.html) | [mindspore.nn.Identity](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Identity.html) | 功能一致，参数名不同|
| [torch.nn.init.uniform_](https://pytorch.org/docs/1.8.1/nn.init.html#torch.nn.init.uniform_)    | [mindspore.ops.uniform](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.uniform.html)                              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Uniform.html)           |
| [torch.nn.InstanceNorm1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.InstanceNorm1d.html) | [mindspore.nn.InstanceNorm1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.InstanceNorm1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/InstanceNorm1d.html)    |
| [torch.nn.InstanceNorm2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.InstanceNorm2d.html) | [mindspore.nn.InstanceNorm2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.InstanceNorm2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/InstanceNorm2d.html)|
| [torch.nn.InstanceNorm3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.InstanceNorm3d.html) | [mindspore.nn.InstanceNorm3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.InstanceNorm3d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/InstanceNorm3d.html)|
| [torch.nn.KLDivLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.KLDivLoss.html)                   | [mindspore.nn.KLDivLoss](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.KLDivLoss.html)                      | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.L1Loss](https://pytorch.org/docs/1.8.1/generated/torch.nn.L1Loss.html#torch.nn.L1Loss) | [mindspore.nn.L1Loss](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.L1Loss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.LayerNorm](https://pytorch.org/docs/1.8.1/generated/torch.nn.LayerNorm.html) | [mindspore.nn.LayerNorm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.LayerNorm.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/LayerNorm.html)      |
| [torch.nn.LeakyReLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.LeakyReLU.html)| [mindspore.nn.LeakyReLU](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.LeakyReLU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/LeakyReLU.html)     |
| [torch.nn.LPPool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.LPPool1d.html)                   | [mindspore.nn.LPPool1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.LPPool1d.html)                      | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.LPPool2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.LPPool2d.html)                   | [mindspore.nn.LPPool2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.LPPool2d.html)                      | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.LSTM](https://pytorch.org/docs/1.8.1/generated/torch.nn.LSTM.html) | [mindspore.nn.LSTM](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.LSTM.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/LSTM.html)                                                             |
| [torch.nn.LSTMCell](https://pytorch.org/docs/1.8.1/generated/torch.nn.LSTMCell.html?torch.nn.LSTMCell) | [mindspore.nn.LSTMCell](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.LSTMCell.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/LSTMCell.html)                                                             |
| [torch.nn.Linear](https://pytorch.org/docs/1.8.1/generated/torch.nn.Linear.html) | [mindspore.nn.Dense](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Dense.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Dense.html) |
| [torch.nn.LocalResponseNorm](https://pytorch.org/docs/1.8.1/generated/torch.nn.LocalResponseNorm.html) | [mindspore.nn.LRN](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.LRN.html) |[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/LRN.html) |
| [torch.nn.LogSigmoid](https://pytorch.org/docs/1.8.1/generated/torch.nn.LogSigmoid.html) | [mindspore.nn.LogSigmoid](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.LogSigmoid.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.LogSoftMax](https://pytorch.org/docs/1.8.1/generated/torch.nn.LogSoftmax.html) | [mindspore.nn.LogSoftMax](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.LogSoftmax.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.MSELoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.MSELoss.html) | [mindspore.nn.MSELoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MSELoss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.MarginRankingLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.MarginRankingLoss.html) | [mindspore.nn.MarginRankingLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MarginRankingLoss.html)    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                 |
| [torch.nn.MaxPool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxPool1d.html) | [mindspore.nn.MaxPool1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MaxPool1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/MaxPool1d.html) |
| [torch.nn.MaxPool2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxPool2d.html) | [mindspore.nn.MaxPool2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MaxPool2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/MaxPool2d.html) |
| [torch.nn.MaxPool3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxPool3d.html)                 | [mindspore.nn.MaxPool3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MaxPool3d.html)                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/MaxPool3d.html)|
| [torch.nn.MaxUnpool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxUnpool1d.html)                 | [mindspore.nn.MaxUnpool1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MaxUnpool1d.html)                    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.MaxUnpool2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxUnpool2d.html)                 | [mindspore.nn.MaxUnpool2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MaxUnpool2d.html)                    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.MaxUnpool3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxUnpool3d.html)                 | [mindspore.nn.MaxUnpool3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MaxUnpool3d.html)                    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.ModuleDict](https://pytorch.org/docs/1.8.1/nn.html#torch.nn.ModuleDict) | [mindspore.nn.CellDict](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.CellDict.html#mindspore.nn.CellDict) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/CellDict.html) |
| [torch.nn.ModuleList](https://pytorch.org/docs/1.8.1/nn.html#torch.nn.ModuleList) | [mindspore.nn.CellList](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.CellList.html#mindspore.nn.CellList) | 功能一致，参数名不同  |
| [torch.nn.MultiheadAttention](https://pytorch.org/docs/1.8.1/generated/torch.nn.MultiheadAttention.html)| [mindspore.nn.MultiheadAttention](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MultiheadAttention.html)|[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/MultiheadAttention.html)|
| [torch.nn.MultiLabelMarginLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.MultiLabelMarginLoss.html) | [mindspore.nn.MultiLabelMarginLoss](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MultilabelMarginLoss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.MultiLabelSoftMarginLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.MultiLabelSoftMarginLoss.html) | [mindspore.nn.MultiLabelSoftMarginLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MultiLabelSoftMarginLoss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.MultiMarginLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.MultiMarginLoss.html)| [mindspore.nn.MultiMarginLoss](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.MultiMarginLoss.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.NLLLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.NLLLoss.html)                 | [mindspore.nn.NLLLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.NLLLoss.html)                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/NLLLoss.html)  |
| [torch.nn.parameter.Parameter](https://pytorch.org/docs/1.8.1/generated/torch.nn.parameter.Parameter.html) | [mindspore.Parameter](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/mindspore.Parameter.html#mindspore.Parameter) |[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Parameter.html)|
| [torch.nn.PReLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.PReLU.html) | [mindspore.nn.PReLU](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.PReLU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/PReLU.html)                                                             |
| [torch.nn.PixelShuffle](https://pytorch.org/docs/1.8.1/generated/torch.nn.PixelShuffle.html)                 | [mindspore.nn.PixelShuffle](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.PixelShuffle.html)                    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.PixelUnshuffle](https://pytorch.org/docs/1.8.1/generated/torch.nn.PixelUnshuffle.html)                 | [mindspore.nn.PixelUnshuffle](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.PixelUnshuffle.html)                    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.PoissonNLLLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.PoissonNLLLoss.html) | [mindspore.nn.PoissonNLLLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.PoissonNLLLoss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.ReflectionPad1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReflectionPad1d.html) | [mindspore.nn.ReflectionPad1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ReflectionPad1d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.ReflectionPad2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReflectionPad2d.html) | [mindspore.nn.ReflectionPad2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ReflectionPad2d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.ReLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReLU.html) | [mindspore.nn.ReLU](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ReLU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/ReLU.html)                                                             |
| [torch.nn.ReLU6](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReLU6.html) | [mindspore.nn.ReLU6](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ReLU6.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.ReplicationPad1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReplicationPad1d.html) | [mindspore.nn.ReplicationPad1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ReplicationPad1d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.ReplicationPad2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReplicationPad2d.html) | [mindspore.nn.ReplicationPad2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ReplicationPad2d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.ReplicationPad3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReplicationPad3d.html) | [mindspore.nn.ReplicationPad3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ReplicationPad3d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.RNN](https://pytorch.org/docs/1.8.1/generated/torch.nn.RNN.html) | [mindspore.nn.RNN](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.RNN.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/RNN.html)                                                             |
| [torch.nn.RNNCell](https://pytorch.org/docs/1.8.1/generated/torch.nn.RNNCell.html) | [mindspore.nn.RNNCell](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.RNNCell.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/RNNCell.html)                                                             |
| [torch.nn.RReLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.RReLU.html) | [mindspore.nn.RReLU](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.RReLU.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.SeLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.SELU.html) | [mindspore.nn.SeLU](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.SeLU.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.Sequential](https://pytorch.org/docs/1.8.1/generated/torch.nn.Sequential.html) | [mindspore.nn.SequentialCell](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.SequentialCell.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SequentialCell.html)                                                             |
| [torch.nn.Sigmoid](https://pytorch.org/docs/1.8.1/generated/torch.nn.Sigmoid.html) | [mindspore.nn.Sigmoid](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Sigmoid.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Sigmoid.html)                                                             |
| [torch.nn.SiLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.SiLU.html) | [mindspore.nn.SiLU](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.SiLU.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.SmoothL1Loss](https://pytorch.org/docs/1.8.1/generated/torch.nn.SmoothL1Loss.html) | [mindspore.nn.SmoothL1Loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.SmoothL1Loss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SmoothL1Loss.html)                                                             |
| [torch.nn.SoftMarginLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.SoftMarginLoss.html) | [mindspore.nn.SoftMarginLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.SoftMarginLoss.html) |[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.nn.Softmax](https://pytorch.org/docs/1.8.1/generated/torch.nn.Softmax.html) | [mindspore.nn.Softmax]( https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Softmax.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/nn_Softmax.html)                                                             |
| [torch.nn.Softmin](https://pytorch.org/docs/1.8.1/generated/torch.nn.Softmin.html) | [mindspore.nn.Softmin](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Softmin.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/softmin.html) |
| [torch.nn.Softmax2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Softmax2d.html) | [mindspore.nn.Softmax2d]( https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Softmax2d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.Softshrink](https://pytorch.org/docs/1.8.1/generated/torch.nn.Softshrink.html) | [mindspore.nn.SoftShrink](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.SoftShrink.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SoftShrink.html)                                                             |
| [torch.nn.Softsign](https://pytorch.org/docs/1.8.1/generated/torch.nn.Softsign.html) | [mindspore.nn.Softsign](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Softsign.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.SyncBatchNorm](https://pytorch.org/docs/1.8.1/generated/torch.nn.SyncBatchNorm.html) | [mindspore.nn.SyncBatchNorm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.SyncBatchNorm.html) |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SyncBatchNorm.html)        |
| [torch.nn.Tanh](https://pytorch.org/docs/1.8.1/generated/torch.nn.Tanh.html) | [mindspore.nn.Tanh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Tanh.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Tanh.html)                                                             |
| [torch.nn.Tanhshrink](https://pytorch.org/docs/1.8.1/generated/torch.nn.Tanhshrink.html) | [mindspore.nn.Tanhshrink](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Tanhshrink.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.Threshold](https://pytorch.org/docs/1.8.1/generated/torch.nn.Threshold.html) | [mindspore.nn.Threshold](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Threshold.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.Transformer](https://pytorch.org/docs/1.8.1/generated/torch.nn.Transformer.html)| [mindspore.nn.Transformer](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Transformer.html)|[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Transformer.html)|
| [torch.nn.TransformerDecoder](https://pytorch.org/docs/1.8.1/generated/torch.nn.TransformerDecoder.html)| [mindspore.nn.TransformerDecoder](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.TransformerDecoder.html)|[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/TransformerDecoder.html)|
| [torch.nn.TransformerEncoder](https://pytorch.org/docs/1.8.1/generated/torch.nn.TransformerEncoder.html)| [mindspore.nn.TransformerEncoder](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.TransformerEncoder.html)|[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/TransformerEncoder.html)|
| [torch.nn.TransformerDecoderLayer](https://pytorch.org/docs/1.8.1/generated/torch.nn.TransformerDecoderLayer.html)| [mindspore.nn.TransformerDecoderLayer](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.TransformerDecoderLayer.html)|[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/TransformerDecoderLayer.html)|
| [torch.nn.TransformerEncoderLayer](https://pytorch.org/docs/1.8.1/generated/torch.nn.TransformerEncoderLayer.html)| [mindspore.nn.TransformerEncoderLayer](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.TransformerEncoderLayer.html)|[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/TransformerEncoderLayer.html)|
| [torch.nn.TripletMarginLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.TripletMarginLoss.html) | [mindspore.nn.TripletMarginLoss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.TripletMarginLoss.html) | [功能一致，参数个数或顺序不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/TripletMarginLoss.html) |
| [torch.nn.Unflatten](https://pytorch.org/docs/1.8.1/generated/torch.nn.Unflatten.html) | [mindspore.nn.Unflatten](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Unflatten.html) |功能一致，参数名不同|
| [torch.nn.Unfold](https://pytorch.org/docs/1.8.1/generated/torch.nn.Unfold.html) | [mindspore.nn.Unfold](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Unfold.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Unfold.html) |
| [torch.nn.Upsample](https://pytorch.org/docs/1.8.1/generated/torch.nn.Upsample.html#torch.nn.Upsample) | [mindspore.nn.Upsample](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Upsample.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/interpolate.html) |
| [torch.nn.ZeroPad2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ZeroPad2d.html) | [mindspore.nn.ZeroPad2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ZeroPad2d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |

### torch.nn.functional

| PyTorch 1.8.1 APIs                                                                                                                       | MindSpore APIs                                                                                                                                                                                    | 说明                                                                                                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- |
| [torch.nn.functional.adaptive_avg_pool1d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.adaptive_avg_pool1d)   | [mindspore.ops.adaptive_avg_pool1d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.adaptive_avg_pool1d.html)                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AdaptiveAvgPool1d.html) |
| [torch.nn.functional.adaptive_avg_pool2d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.adaptive_avg_pool2d)   | [mindspore.ops.adaptive_avg_pool2d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.adaptive_avg_pool2d.html)                             | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.adaptive_avg_pool3d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.adaptive_avg_pool3d)   | [mindspore.ops.adaptive_avg_pool3d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.adaptive_avg_pool3d.html)                             | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.adaptive_max_pool1d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.adaptive_max_pool1d)   | [mindspore.ops.adaptive_max_pool1d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.adaptive_max_pool1d.html)                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AdaptiveMaxPool1d.html) |
| [torch.nn.functional.adaptive_max_pool2d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.adaptive_max_pool2d)   | [mindspore.ops.adaptive_max_pool2d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.adaptive_max_pool2d.html)                             | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.affine_grid](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.affine_grid)   | [mindspore.ops.affine_grid](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.affine_grid.html)                             | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.avg_pool1d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.avg_pool1d)   | [mindspore.ops.avg_pool1d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.avg_pool1d.html)                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/avg_pool1d.html) |
| [torch.nn.functional.avg_pool2d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.avg_pool2d)   | [mindspore.ops.avg_pool2d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.avg_pool2d.html)                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/avg_pool1d.html) |
| [torch.nn.functional.avg_pool3d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.avg_pool3d)   | [mindspore.ops.avg_pool3d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.avg_pool3d.html)                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/avg_pool1d.html) |
| [torch.nn.functional.batch_norm](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.batch_norm)   | [mindspore.ops.batch_norm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.batch_norm.html)                             | 功能一致，参数名不同|
| [torch.nn.functional.bilinear](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.bilinear) | [mindspore.ops.bidense](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.bidense.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.binary_cross_entropy](https://pytorch.org/docs/1.8.1/nn.functional.html#binary-cross-entropy)   | [mindspore.ops.binary_cross_entropy](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.binary_cross_entropy.html)               | 功能一致，参数名不同|
| [torch.nn.functional.binary_cross_entropy_with_logits](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.binary_cross_entropy_with_logits)   | [mindspore.ops.binary_cross_entropy_with_logits](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.binary_cross_entropy_with_logits.html)                             | 功能一致，参数名不同  |
| [torch.nn.functional.celu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.celu)                 | [mindspore.ops.celu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.celu.html)                    | 功能一致，参数名不同|
| [torch.nn.functional.conv1d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.conv1d) | [mindspore.ops.conv1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.conv1d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.conv2d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.conv2d) | [mindspore.ops.conv2d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.conv2d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.conv3d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.conv3d) | [mindspore.ops.conv3d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.conv3d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.cosine_embedding_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.cosine_embedding_loss) | [mindspore.ops.cosine_embedding_loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cosine_embedding_loss.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.cosine_similarity](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.cosine_similarity)| [mindspore.ops.cosine_similarity](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cosine_similarity.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.functional.cross_entropy](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.cross_entropy)| [mindspore.ops.cross_entropy](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.cross_entropy.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.functional.ctc_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.ctc_loss)| [mindspore.ops.ctc_loss](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ctc_loss.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.functional.linear](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.linear) | [mindspore.ops.dense](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.dense.html#mindspore.ops.dense) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.dropout](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.dropout) | [mindspore.ops.dropout](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.dropout.html#mindspore.ops.dropout) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/drop_out.html) |
| [torch.nn.functional.dropout2d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.dropout2d) | [mindspore.ops.dropout2d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.dropout2d.html#mindspore.ops.dropout2d) | [功能一致，参数数据类型不同](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/dropout2d.html) |
| [torch.nn.functional.dropout3d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.dropout3d) | [mindspore.ops.dropout3d](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.dropout3d.html#mindspore.ops.dropout3d) | [功能一致，参数数据类型不同](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/dropout3d.html) |
| [torch.nn.functional.elu](https://pytorch.org/docs/1.8.1/nn.functional.html#elu)                                     | [mindspore.ops.elu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.elu.html)                                                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/elu.html)                                                                                                                       |
| [torch.nn.functional.fold](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.fold) | [mindspore.ops.fold](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.fold.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/mindspore.ops.fold.html) |
| [torch.nn.functional.gelu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.gelu) | [mindspore.ops.gelu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.gelu.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/mindspore.ops.gelu.html) |
| [torch.nn.functional.glu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.glu) | [mindspore.ops.glu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.glu.html) | 功能一致，参数名不同 |
| [torch.nn.functional.grid_sample](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.grid_sample) | [mindspore.ops.grid_sample](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.grid_sample.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/grid_sample.html) |
| [torch.nn.functional.gumbel_softmax](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.gumbel_softmax) | [mindspore.ops.gumbel_softmax](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.gumbel_softmax.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.nn.functional.hardshrink](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.hardshrink) | [mindspore.ops.hardshrink](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.hardshrink.html) | 功能一致，参数名不同 |
| [torch.nn.functional.hardsigmoid](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.hardsigmoid) | [mindspore.ops.hardsigmoid](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.hardsigmoid.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.hardswish](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.hardswish) | [mindspore.ops.hardswish](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.hardswish.html) | 功能一致，参数名不同 |
| [torch.nn.functional.hardtanh](https://pytorch.org/docs/1.8.1/nn.functional.html#hardtanh)   | [mindspore.ops.hardtanh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.hardtanh.html)     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.hinge_embedding_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#hinge-embedding-loss) | [mindspore.ops.hinge_embedding_loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.hinge_embedding_loss.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.interpolate](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.interpolate)                                     | [mindspore.ops.interpolate](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.interpolate.html)                                                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/interpolate.html)                                                                                                                       |
| [torch.nn.functional.kl_div](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.kl_div)                             | [mindspore.ops.kl_div](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.kl_div.html#mindspore.ops.kl_div)  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/kl_div.html) |
| [torch.nn.functional.l1_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#l1-loss)                             | [mindspore.ops.l1_loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.l1_loss.html#mindspore.ops.l1_loss)  | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.leaky_relu](https://pytorch.org/docs/1.8.1/nn.functional.html#leaky-relu)                             | [mindspore.ops.leaky_relu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.leaky_relu.html#mindspore.ops.leaky_relu)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/leaky_relu.html) |
| [torch.nn.functional.logsigmoid](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.logsigmoid) | [mindspore.ops.logsigmoid](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.logsigmoid.html) |  功能一致，参数名不同  |
| [torch.nn.functional.log_softmax](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.log_softmax) | [mindspore.ops.log_softmax](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.log_softmax.html) |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/log_softmax.html)                                                            |
| [torch.nn.functional.lp_pool1d](https://pytorch.org/docs/1.8.1/nn.functional.html#lp-pool1d)                     | [mindspore.ops.lp_pool1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.lp_pool1d.html)           | 功能一致，参数名不同|
| [torch.nn.functional.lp_pool2d](https://pytorch.org/docs/1.8.1/nn.functional.html#lp-pool2d)                     | [mindspore.ops.lp_pool2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.lp_pool2d.html)           | 功能一致，参数名不同|
| [torch.nn.functional.margin_ranking_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#margin-ranking-loss) | [mindspore.ops.margin_ranking_loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.margin_ranking_loss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.functional.max_pool3d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.max_pool3d) | [mindspore.ops.max_pool3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.max_pool3d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.functional.max_unpool1d](https://pytorch.org/docs/1.8.1/nn.functional.html#max-unpool1d) | [mindspore.ops.max_unpool1d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.max_unpool1d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.functional.max_unpool2d](https://pytorch.org/docs/1.8.1/nn.functional.html#max-unpool2d) | [mindspore.ops.max_unpool2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.max_unpool2d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.functional.max_unpool3d](https://pytorch.org/docs/1.8.1/nn.functional.html#max-unpool3d) | [mindspore.ops.max_unpool3d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.max_unpool3d.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.functional.mse_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#mse-loss)                           | [mindspore.ops.mse_loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.mse_loss.html)            | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.nn.functional.multi_margin_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.multi_margin_loss) | [mindspore.ops.multi_margin_loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.multi_margin_loss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.multilabel_margin_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.multilabel_margin_loss) | [mindspore.ops.multilabel_margin_loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.multilabel_margin_loss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.multilabel_soft_margin_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.multilabel_soft_margin_loss) | [mindspore.ops.multilabel_soft_margin_loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.multilabel_soft_margin_loss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.nll_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.nll_loss) | [mindspore.ops.nll_loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.nll_loss.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.pad](https://pytorch.org/docs/1.8.1/nn.functional.html#pad) | [mindspore.ops.pad](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.pad.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/pad.html) |
| [torch.nn.functional.pdist](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.pdist) | [mindspore.ops.pdist](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.pdist.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.nn.functional.pixel_shuffle](https://pytorch.org/docs/1.8.1/nn.functional.html#pixel-shuffle) | [mindspore.ops.pixel_shuffle](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.pixel_shuffle.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.pixel_unshuffle](https://pytorch.org/docs/1.8.1/nn.functional.html#pixel-unshuffle) | [mindspore.ops.pixel_unshuffle](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.pixel_unshuffle.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.prelu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.prelu) | [mindspore.ops.prelu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.prelu.html) | 功能一致，参数名不同 |
| [torch.nn.functional.relu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.relu) | [mindspore.ops.relu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.relu.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.nn.functional.relu6](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.relu6) | [mindspore.ops.relu6](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.relu6.html) | 功能一致，参数名不同 |
| [torch.nn.functional.rrelu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.rrelu) | [mindspore.ops.rrelu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.rrelu.html) |  功能一致，参数名不同  |
| [torch.nn.functional.selu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.selu) | [mindspore.ops.selu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.selu.html) | 功能一致，参数名不同 |
| [torch.nn.functional.sigmoid](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.sigmoid) | [mindspore.ops.sigmoid](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.sigmoid.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.silu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.silu) | [mindspore.ops.silu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.silu.html) |  功能一致，参数名不同  |
| [torch.nn.functional.softmax](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.softmax) | [mindspore.ops.softmax](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.softmax.html#mindspore.ops.softmax) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/softmax.html) |
| [torch.nn.functional.softmin](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.softmin) | [mindspore.ops.softmin](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.softmin.html#mindspore.ops.softmin) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/softmin.html) |
| [torch.nn.functional.softsign](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.softsign) | [mindspore.ops.softsign](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.softsign.html) | 功能一致，参数名不同 |
| [torch.nn.functional.smooth_l1_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.smooth_l1_loss)           | [mindspore.ops.smooth_l1_loss](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.smooth_l1_loss.html)                                              | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.nn.functional.soft_margin_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#soft-margin-loss)                           | [mindspore.ops.soft_margin_loss](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.soft_margin_loss.html)                           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.softshrink](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.softshrink) | [mindspore.ops.softshrink](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.softshrink.html) |  功能一致，参数名不同 |
| [torch.nn.functional.tanh](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.tanh) | [mindspore.ops.tanh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tanh.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.tanhshrink](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.tanhshrink) | [mindspore.ops.tanhshrink](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tanhshrink.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.nn.functional.threshold](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.threshold) | [mindspore.ops.threshold](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.threshold.html) | 功能一致，参数名不同 |
| [torch.nn.functional.triplet_margin_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.triplet_margin_loss) | [mindspore.ops.triplet_margin_loss](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.triplet_margin_loss.html) | [功能一致，参数个数或顺序不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/TripletMarginLoss.html) |
| [torch.nn.functional.unfold](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.unfold) | [mindspore.ops.unfold](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.unfold.html) | 一致 |
| [torch.nn.functional.upsample](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.upsample) | [mindspore.ops.upsample](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.upsample.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/interpolate.html) |

### torch.nn.Module

| PyTorch 1.8.1 APIs                                                                                                                       | MindSpore APIs                                                                                                                                                                                    | 说明                                                                                                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- |
| [torch.nn.Module.apply](https://pytorch.org/docs/1.8.1/generated/torch.nn.Module.html#torch.nn.Module.apply) | [mindspore.nn.Cell.apply](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell.apply) |         一致        |

### torch.nn.utils

| PyTorch 1.8.1 APIs                                                                                                                       | MindSpore APIs                                                                                                                                                                                    | 说明                                                                                                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- |
|[torch.nn.utils.clip_grad_value_](https://pytorch.org/docs/1.8.1/generated/torch.nn.utils.clip_grad_value_.html)                   |[mindspore.ops.clip_by_value](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.clip_by_value.html)                           |             [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/clip_by_value.html)        |
|[torch.nn.utils.clip_grad_norm_](https://pytorch.org/docs/1.8.1/generated/torch.nn.utils.clip_grad_norm_.html)                   |[mindspore.ops.clip_by_norm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.clip_by_norm.html)                           |             [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/clip_by_norm.html)        |

### torch.Tensor

| PyTorch 1.8.1 APIs                                                                                           | MindSpore APIs                                                                                                                                       | 说明                                         |
|--------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------|
| [torch.Tensor.abs](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.abs)                              | [mindspore.Tensor.abs](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.abs.html)                       |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.absolute](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.absolute)  | [mindspore.Tensor.absolute](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.absolute.html)  |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.acos](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.acos)| [mindspore.Tensor.acos](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.acos.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.acosh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.acosh)| [mindspore.Tensor.acosh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.acosh.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.add](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.add)| [mindspore.Tensor.add](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.add.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.addbmm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addbmm)                              | [mindspore.Tensor.addbmm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.addbmm.html)                       |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.addcdiv](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addcdiv)| [mindspore.Tensor.addcdiv](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.addcdiv.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.addcmul](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addcmul)| [mindspore.Tensor.addcmul](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.addcmul.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.addmm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addmm)                                | [mindspore.Tensor.addmm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.addmm.html)                         |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.addmv](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addmv)                                | [mindspore.Tensor.addmv](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.addmv.html)                         |   功能一致，参数名不同 |
| [torch.Tensor.addr](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addr) | [mindspore.Tensor.addr](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.addr.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.all](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.all)                                | [mindspore.Tensor.all](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.all.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/all.html) |
| [torch.Tensor.amax](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.amax)                                | [mindspore.Tensor.amax](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.amax.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/amax.html) |
| [torch.Tensor.amin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.amin)                                | [mindspore.Tensor.amin](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.amin.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/amin.html) |
| [torch.Tensor.any](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.any)                                | [mindspore.Tensor.any](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.any.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/any.html) |
| [torch.Tensor.arccos](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arccos)                     | [mindspore.Tensor.arccos](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.arccos.html)         | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                    |
| [torch.Tensor.arccosh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arccosh)                     | [mindspore.Tensor.arccosh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.arccosh.html)         | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                    |
| [torch.Tensor.argmax](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.argmax)                 | [mindspore.Tensor.argmax](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.argmax.html#mindspore.Tensor.argmax)                       |  功能一致，参数名不同  |
| [torch.Tensor.angle](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.angle)                     | [mindspore.Tensor.angle](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.angle.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.arcsin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arcsin)                     | [mindspore.Tensor.arcsin](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.arcsin.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.arcsinh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arcsinh)                     | [mindspore.Tensor.arcsinh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.arcsinh.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.arctan](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arctan)                     | [mindspore.Tensor.arctan](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.arctan.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.arctanh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arctanh)                     | [mindspore.Tensor.arctanh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.arctanh.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.argmin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.argmin)  | [mindspore.Tensor.argmin](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.argmin.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/argmin.html) |
| [torch.Tensor.argsort](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.argsort)                     | [mindspore.Tensor.argsort](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.argsort.html)                     |功能一致，参数名不同|
| [torch.Tensor.asin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.asin)| [mindspore.Tensor.asin](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.asin.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.asinh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.asinh)| [mindspore.Tensor.asinh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.asinh.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.atan](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.atan)| [mindspore.Tensor.atan](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.atan.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.atan2](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.atan2)                     | [mindspore.Tensor.atan2](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.atan2.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.atanh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.atanh)| [mindspore.Tensor.atanh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.atanh.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.baddbmm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.baddbmm)                     | [mindspore.Tensor.baddbmm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.baddbmm.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)   |
| [torch.Tensor.bernoulli](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bernoulli) | [mindspore.Tensor.bernoulli](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.bernoulli.html) | [功能一致，参数个数或顺序不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/bernoulli.html) |
| [torch.Tensor.bincount](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bincount)                     | [mindspore.Tensor.bincount](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.bincount.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.bitwise_and](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bitwise_and)| [mindspore.Tensor.bitwise_and](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.bitwise_and.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.bitwise_or](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bitwise_or)| [mindspore.Tensor.bitwise_or](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.bitwise_or.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.bitwise_xor](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bitwise_xor)| [mindspore.Tensor.bitwise_xor](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.bitwise_xor.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.bmm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bmm)| [mindspore.Tensor.bmm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.bmm.html)| 功能一致，参数名不同 |
| [torch.Tensor.bool](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bool)| [mindspore.Tensor.bool](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.bool.html)| 功能一致，参数名不同 |
| [torch.Tensor.broadcast_to](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.broadcast_to) | [mindspore.Tensor.broadcast_to](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.broadcast_to.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/broadcast_to.html)        |
| [torch.Tensor.cauchy_](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cauchy_)                     | [mindspore.Tensor.cauchy](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.cauchy.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.ceil](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ceil)                     | [mindspore.Tensor.ceil](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.ceil.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.chunk](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.chunk)                     | [mindspore.Tensor.chunk](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.chunk.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.cholesky](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cholesky) | [mindspore.Tensor.cholesky](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.cholesky.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.cholesky_solve](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cholesky_solve)                     | [mindspore.Tensor.cholesky_solve](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.cholesky_solve.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.clamp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.clamp)                         | [mindspore.Tensor.clamp](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.clamp.html)                         |    [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)    |
| [torch.Tensor.clip](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.clip) | [mindspore.Tensor.clip](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.clip.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.conj](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.conj)                   | [mindspore.Tensor.conj](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.conj.html)                   | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.copysign](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.copysign)                   | [mindspore.Tensor.copysign](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.copysign.html)                   | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.cos](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cos)                     | [mindspore.Tensor.cos](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.cos.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.cosh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cosh)                     | [mindspore.Tensor.cosh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.cosh.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.cross](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cross)                     | [mindspore.Tensor.cross](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.cross.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)      |
| [torch.Tensor.cummax](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cummax)                       | [mindspore.Tensor.cummax](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.cummax.html)                       | 功能一致，参数名不同                              |
| [torch.Tensor.cummin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cummin)                       | [mindspore.Tensor.cummin](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.cummin.html)                       | 功能一致，参数名不同      |
| [torch.Tensor.cumprod](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cumprod) | [mindspore.Tensor.cumprod](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.cumprod.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.cumsum](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cumsum) | [mindspore.Tensor.cumsum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.cumsum.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.deg2rad](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.deg2rad)                     | [mindspore.Tensor.deg2rad](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.deg2rad.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.diag](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.diag)                       |   [mindspore.Tensor.diag](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.diag.html)                                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/diag.html) |
| [torch.Tensor.diagflat](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.diagflat)                     | [mindspore.Tensor.diagflat](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.diagflat.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.diff](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.diff)                     | [mindspore.Tensor.diff](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.diff.html)                     | 功能一致，参数名不同 |
| [torch.Tensor.digamma](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.digamma)                     | [mindspore.Tensor.digamma](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.digamma.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.dim](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.dim) | [mindspore.Tensor.ndimension](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.ndimension.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.div](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.div) | [mindspore.Tensor.div](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.div.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)     |
| [torch.Tensor.divide](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.divide)                     | [mindspore.Tensor.divide](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.divide.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.eq](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.eq) | [mindspore.Tensor.equal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.equal.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.erf](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.erf)                              | [mindspore.Tensor.erf](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.erf.html)                       |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.erfc](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.erfc)                              | [mindspore.Tensor.erfc](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.erfc.html)                       |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.erfinv](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.erfinv)                              | [mindspore.Tensor.erfinv](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.erfinv.html)                       |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.exp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.exp)                              | [mindspore.Tensor.exp](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.exp.html)                       |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.expand](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.expand) | [mindspore.Tensor.broadcast_to](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.broadcast_to.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/expand.html) |
| [torch.Tensor.expand_as](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.expand_as)           | [mindspore.Tensor.expand_as](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.expand_as.html#mindspore.Tensor.expand_as) | 功能一致，参数名不同 |
| [torch.Tensor.expm1](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.expm1)                              | [mindspore.Tensor.expm1](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.expm1.html)                       |   [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.fill_diagonal_](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.fill_diagonal_)                           | [mindspore.Tensor.fill_diagonal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.fill_diagonal.html)                           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.flip](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.flip)                           | [mindspore.Tensor.flip](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.flip.html)                           |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/flip.html)                                       |
| [torch.Tensor.fliplr](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.fliplr)                       | [mindspore.Tensor.fliplr](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.fliplr.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.flipud](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.flipud)                       | [mindspore.Tensor.flipud](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.flipud.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.float](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.float) | [mindspore.Tensor.float](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.float.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.float_power](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.float_power)                       | [mindspore.Tensor.float_power](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.float_power.html)                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/float_power.html)                                       |
| [torch.Tensor.floor](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.floor)                       | [mindspore.Tensor.floor](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.floor.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.floor_divide](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.floor_divide)                       | [mindspore.Tensor.floor_divide](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.floor_divide.html)                       | 功能一致，参数名不同 |
| [torch.Tensor.fmax](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.fmax) | [mindspore.Tensor.fmax](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.fmax.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.fmod](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.fmod)                       | [mindspore.Tensor.fmod](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.fmod.html)                                   | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.frac](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.frac)                       | [mindspore.Tensor.frac](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.frac.html)                                   | 功能一致，参数名不同 |
| [torch.Tensor.gather](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.gather)                       | [mindspore.Tensor.gather_elements](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.gather_elements.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.ge](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ge)                       | [mindspore.Tensor.ge](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.ge.html) | 功能一致，参数名不同 |
| [torch.Tensor.geqrf](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.geqrf)                       | [mindspore.Tensor.geqrf](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.geqrf.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.ger](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ger) | [mindspore.Tensor.ger](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.ger.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/ger.html) |
| [torch.Tensor.greater](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.greater)                       | [mindspore.Tensor.greater](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.greater.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.greater_equal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.greater_equal) | [mindspore.Tensor.greater_equal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.greater_equal.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.gt](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.gt)                       | [mindspore.Tensor.gt](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.gt.html) | 功能一致，参数名不同 |
| [torch.Tensor.H](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.H)                       | [mindspore.Tensor.H](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.H.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.half](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.half) | [mindspore.Tensor.half](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.half.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.hardshrink](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.hardshrink) | [mindspore.Tensor.hardshrink](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.hardshrink.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.heaviside](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.heaviside)                       | [mindspore.Tensor.heaviside](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.heaviside.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.histc](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.histc)                       | [mindspore.Tensor.histc](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.histc.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.hypot](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.hypot)                       | [mindspore.Tensor.hypot](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.hypot.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.i0](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.i0) | [mindspore.Tensor.i0](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.i0.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.igamma](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.igamma)| [mindspore.Tensor.igamma](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.igamma.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.igammac](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.igammac)| [mindspore.Tensor.igammac](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.igammac.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.imag](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.imag)| [mindspore.Tensor.imag](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.imag.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.index_add](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.index_add)           | [mindspore.Tensor.index_add](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.index_add.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.index_fill](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.index_fill) | [mindspore.Tensor.index_fill](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.index_fill.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.index_put](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.index_put) | [mindspore.Tensor.index_put](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.index_put.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.index_select](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.index_select)           | [mindspore.Tensor.index_select](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.index_select.html) | 功能一致，参数名不同 |
| [torch.Tensor.inner](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.inner)      | [mindspore.Tensor.inner](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.inner.html)    | 功能一致，参数名不同 |
| [torch.Tensor.int](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.int) | [mindspore.Tensor.int](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.int.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.inverse](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.inverse)                 | [mindspore.Tensor.inverse](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.inverse.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.isclose](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isclose)      | [mindspore.Tensor.isclose](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.isclose.html)    | 功能一致，参数名不同 |
| [torch.Tensor.isfinite](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isfinite)      | [mindspore.Tensor.isfinite](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.isfinite.html)    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.isinf](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isinf)      | [mindspore.Tensor.isinf](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.isinf.html)    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.isnan](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isnan)      | [mindspore.Tensor.isnan](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.isnan.html)    | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.is_complex](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.is_complex) | [mindspore.Tensor.is_complex](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.is_complex.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.is_floating_point](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.is_floating_point) | [mindspore.Tensor.is_floating_point](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.is_floating_point.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.is_signed](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.is_signed)                 | [mindspore.Tensor.is_signed](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.is_signed.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.isneginf](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isneginf)                 | [mindspore.Tensor.isneginf](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.isneginf.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.isposinf](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isposinf)                 | [mindspore.Tensor.isposinf](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.isposinf.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.isreal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isreal)                 | [mindspore.Tensor.isreal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.isreal.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.item](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.item) | [mindspore.Tensor.item](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.item.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/item.html) |
| [torch.Tensor.lcm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.lcm)                             | [mindspore.Tensor.lcm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.lcm.html)      | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.ldexp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ldexp)                         | [mindspore.Tensor.ldexp](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.ldexp.html)      | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.le](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.le) | [mindspore.Tensor.le](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.le.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.lerp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.lerp)                         | [mindspore.Tensor.lerp](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.lerp.html)                         | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.less](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.less) | [mindspore.Tensor.less](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.less.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.less_equal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.less_equal) | [mindspore.Tensor.less_equal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.less_equal.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.log](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.log)                   | [mindspore.Tensor.log](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.log.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.log_normal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.log_normal)               | [mindspore.Tensor.log_normal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.log_normal.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.log10](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.log10)                   | [mindspore.Tensor.log10](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.log10.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.log1p](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.log1p)                   | [mindspore.Tensor.log1p](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.log1p.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.log2](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.log2)                   | [mindspore.Tensor.log2](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.log2.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.logaddexp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logaddexp)                   | [mindspore.Tensor.logaddexp](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.logaddexp.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.logaddexp2](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logaddexp2)                   | [mindspore.Tensor.logaddexp2](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.logaddexp2.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.logcumsumexp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logcumsumexp)                   | [mindspore.Tensor.logcumsumexp](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.logcumsumexp.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.logdet](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logdet) | [mindspore.Tensor.logdet](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.logdet.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.logical_and](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logical_and) | [mindspore.Tensor.logical_and](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.logical_and.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.logical_not](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logical_not) | [mindspore.Tensor.logical_not](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.logical_not.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.logical_or](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logical_or) | [mindspore.Tensor.logical_or](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.logical_or.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.logical_xor](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logical_xor) | [mindspore.Tensor.logical_xor](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.logical_xor.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.logit](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logit)| [mindspore.Tensor.logit](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.logit.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.logsumexp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logsumexp)                   | [mindspore.Tensor.logsumexp](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.logsumexp.html) | 功能一致，参数名不同 |
| [torch.Tensor.long](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.long) | [mindspore.Tensor.long](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.long.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.lt](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.lt)                   | [mindspore.Tensor.lt](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.lt.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.lu_solve](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.lu_solve)                   | [mindspore.Tensor.lu_solve](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.lu_solve.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.masked_fill](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.masked_fill) | [mindspore.Tensor.masked_fill](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.masked_fill.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.masked_scatter](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.masked_scatter) | [mindspore.Tensor.masked_scatter](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.masked_scatter.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/masked_scatter.html) |
| [torch.Tensor.masked_select](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.masked_select) | [mindspore.Tensor.masked_select](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.masked_select.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.matmul](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.matmul) | [mindspore.Tensor.matmul](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.matmul.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.max](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.max)                       | [mindspore.Tensor.max](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.max.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/tensor_max.html) |
| [torch.Tensor.maximum](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.maximum) | [mindspore.Tensor.maximum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.maximum.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.mean](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mean) | [mindspore.Tensor.mean](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.mean.html) | 功能一致，参数名不同 |
| [torch.Tensor.median](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.median) | [mindspore.Tensor.median](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.median.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/median.html) |
| [torch.Tensor.mH](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mH)| [mindspore.Tensor.mH](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.mH.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.min](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.min) | [mindspore.Tensor.min](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.min.html#mindspore.Tensor.min) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/tensor_min.html) |
| [torch.Tensor.minimum](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.minimum) | [mindspore.Tensor.minimum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.minimum.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.mm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mm)| [mindspore.Tensor.mm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.mm.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.moveaxis](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.moveaxis) | [mindspore.Tensor.moveaxis](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.moveaxis.html) | 功能一致 |
| [torch.Tensor.movedim](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.movedim) | [mindspore.Tensor.movedim](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.movedim.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.msort](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.msort) | [mindspore.Tensor.msort](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.msort.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)  |
| [torch.Tensor.mT](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mT)| [mindspore.Tensor.mT](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.mT.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.mul](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mul) | [mindspore.Tensor.mul](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.mul.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.multinomial](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.multinomial) | [mindspore.Tensor.multinomial](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.multinomial.html) | [功能一致，参数默认值不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/multinomial.html) |
| [torch.Tensor.multiply](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.multiply) | [mindspore.Tensor.multiply](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.multiply.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.mvlgamma](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mvlgamma) | [mindspore.Tensor.mvlgamma](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.mvlgamma.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.nan_to_num](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nan_to_num) | [mindspore.Tensor.nan_to_num](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.nan_to_num.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.nanmedian](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nanmedian) | [mindspore.Tensor.nanmedian](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.nanmedian.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.nansum](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nansum) | [mindspore.Tensor.nansum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.nansum.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.narrow](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.narrow) | [mindspore.Tensor.narrow](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.narrow.html) | 功能一致，参数名不同 |
| [torch.Tensor.ndim](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ndim) | [mindspore.Tensor.ndim](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.ndim.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.ndimension](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ndimension) | [mindspore.Tensor.ndimension](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.ndimension.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.ne](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ne) | [mindspore.Tensor.ne](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.ne.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.neg](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.neg)                   | [mindspore.Tensor.neg](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.neg.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.negative](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.negative)                   | [mindspore.Tensor.negative](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.negative.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.nelement](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nelement)                   | [mindspore.Tensor.nelement](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.nelement.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.new_ones](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.new_ones) | [mindspore.Tensor.new_ones](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.new_ones.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.new_zeros](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.new_zeros) | [mindspore.Tensor.new_zeros](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.new_zeros.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.nextafter](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nextafter) | [mindspore.Tensor.nextafter](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.nextafter.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.norm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.norm) | [mindspore.Tensor.norm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.norm.html) | torch.Tensor.norm即将弃用，mindspore.Tensor.norm对标torch.linalg.norm，功能完全一致 |
| [torch.Tensor.nonzero](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nonzero)                   | [mindspore.Tensor.nonzero](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.nonzero.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.not_equal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.not_equal)                   | [mindspore.Tensor.not_equal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.not_equal.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.numel](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.numel)                   | [mindspore.Tensor.numel](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.numel.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.numpy](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.numpy) | [mindspore.Tensor.asnumpy](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.asnumpy.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.orgqr](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.orgqr) | [mindspore.Tensor.orgqr](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.orgqr.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.ormqr](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ormqr) | [mindspore.Tensor.ormqr](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.ormqr.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.outer](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.outer) | [mindspore.Tensor.outer](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.outer.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.permute](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.permute)                   | [mindspore.Tensor.permute](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.permute.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.pow](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.pow)                       | [mindspore.Tensor.pow](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.pow.html)                                        | 功能一致，参数名不同|
| [torch.Tensor.prod](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.prod)                       | [mindspore.Tensor.prod](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.prod.html)                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/prod.html) |
| [torch.Tensor.ravel](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ravel) | [mindspore.Tensor.ravel](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.ravel.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.real](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.real) | [mindspore.Tensor.real](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.real.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.reciprocal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.reciprocal) | [mindspore.Tensor.reciprocal](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.reciprocal.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.remainder](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.remainder)                   | [mindspore.Tensor.remainder](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.remainder.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.renorm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.renorm) | [mindspore.Tensor.renorm](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.renorm.html) | [功能一致，参数数据类型不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/renorm.html) |
| [torch.Tensor.rad2deg](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.rad2deg)                     | [mindspore.Tensor.rad2deg](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.rad2deg.html)                     | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.repeat](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.repeat) | [mindspore.Tensor.tile](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.tile.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/tensor_repeat.html) |
| [torch.Tensor.repeat_interleave](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.repeat_interleave) | [mindspore.Tensor.repeat_interleave](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.repeat_interleave.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.reshape](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.reshape)               | [mindspore.Tensor.reshape](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.reshape.html)               | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.reshape_as](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.reshape_as)               | [mindspore.Tensor.reshape_as](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.reshape_as.html)               | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.round](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.round)| [mindspore.Tensor.round](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.round.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.roll](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.roll)                         | [mindspore.Tensor.roll](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.roll.html)                         | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.rot90](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.rot90)                         | [mindspore.Tensor.rot90](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.rot90.html)                         | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)                                       |
| [torch.Tensor.rsqrt](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.rsqrt)                           | [mindspore.Tensor.rsqrt](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.rsqrt.html)                           |[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.scatter_](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.scatter_)                        | [mindspore.ops.tensor_scatter_elements](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.tensor_scatter_elements.html)                    |[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/tensor_scatter_elements.html)   |
| [torch.Tensor.sum_to_size](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sum_to_size) | [mindspore.Tensor.sum_to_size](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.sum_to_size.html)                  | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.scatter](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.scatter) | [mindspore.Tensor.scatter](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.scatter.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/scatter.html) |
| [torch.Tensor.sgn](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sgn)                           | [mindspore.Tensor.sgn](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.sgn.html)                           |[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.short](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.short)                         | [mindspore.Tensor.short](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.short.html)                         | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.sigmoid](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sigmoid)               | [mindspore.Tensor.sigmoid](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.sigmoid.html)       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.sign](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sign)                           | [mindspore.Tensor.sign](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.sign.html)                           |[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.signbit](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.signbit)                           | [mindspore.Tensor.signbit](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.signbit.html)                           |[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.sin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sin)| [mindspore.Tensor.sin](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.sin.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.sinc](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sinc)| [mindspore.Tensor.sinc](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.sinc.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.sinh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sinh)| [mindspore.Tensor.sinh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.sinh.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.size](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.size)                     | [mindspore.Tensor.shape](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.shape.html#mindspore.Tensor.shape)                      | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.slogdet](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.slogdet)           | [mindspore.Tensor.slogdet](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.slogdet.html)           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.sort](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sort)           | [mindspore.Tensor.sort](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.sort.html)           | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.split](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.split)                         | [mindspore.Tensor.split](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.split.html)                         | 功能一致，参数名不同|
| [torch.Tensor.sqrt](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sqrt) | [mindspore.Tensor.sqrt](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.sqrt.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.square](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.square)| [mindspore.Tensor.square](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.square.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.squeeze](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.squeeze)               | [mindspore.Tensor.squeeze](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.squeeze.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.std](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.std) | [mindspore.Tensor.std](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.std.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/std.html) |
| [torch.Tensor.sub](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sub) | [mindspore.Tensor.subtract](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.subtract.html)                  | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.subtract](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.subtract) | [mindspore.Tensor.subtract](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.subtract.html)                  | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.sum](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sum) | [mindspore.Tensor.sum](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.sum.html#mindspore.Tensor.sum) | [功能一致，参数个数或顺序不一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/TensorSum.html) |  
| [torch.Tensor.svd](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.svd) | [mindspore.Tensor.svd](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.svd.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/svd.html) |
| [torch.Tensor.swapaxes](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.swapaxes) | [mindspore.Tensor.swapaxes](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.swapaxes.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.swapdims](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.swapdims) | [mindspore.Tensor.swapdims](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.swapdims.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.T](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.T)                           | [mindspore.Tensor.T](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.T.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.t](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.t)                           | [mindspore.Tensor.t](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.t.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.take](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.take)                           | [mindspore.Tensor.take](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.take.html)                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/take.html) |
| [torch.Tensor.tan](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.tan)| [mindspore.Tensor.tan](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.tan.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.tanh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.tanh) | [mindspore.Tensor.tanh](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.tanh.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.trace](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.trace) | [mindspore.Tensor.trace](https://mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.trace.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.transpose](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.transpose) | [mindspore.Tensor.swapaxes](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.swapaxes.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.tile](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.tile) | [mindspore.Tensor.tile](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.tile.html) | 功能一致，参数名不同 |
| [torch.Tensor.to](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.to)| [mindspore.Tensor.to](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.to.html)| [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/to.html) |
| [torch.Tensor.topk](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.topk)| [mindspore.Tensor.topk](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.topk.html)|[一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.triu](https://pytorch.org/docs/1.8.1/tensors.html?#torch.Tensor.triu)           | [mindspore.Tensor.triu](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.triu.html)           | 功能一致，参数名不同|
| [torch.Tensor.tril](https://pytorch.org/docs/1.8.1/tensors.html?highlight=tril#torch.Tensor.tril) | [mindspore.Tensor.tril](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.tril.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.tensor_split](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.tensor_split)           | [mindspore.Tensor.tensor_split](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.tensor_split.html)           |功能一致，参数名不同|
| [torch.Tensor.true_divide](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.true_divide) | [mindspore.Tensor.true_divide](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.true_divide.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.trunc](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.trunc) | [mindspore.Tensor.trunc](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.trunc.html) |  [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.unbind](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.unbind)                       | [mindspore.Tensor.unbind](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.unbind.html)                       | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.unique_consecutive](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.unique_consecutive)                       | [mindspore.Tensor.unique_consecutive](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.unique_consecutive.html)                       | 功能一致，参数名不同 |
| [torch.Tensor.unsqueeze](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.unsqueeze)                 | [mindspore.Tensor.unsqueeze](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.unsqueeze.html)                 | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景)|
| [torch.Tensor.var](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.var) | [mindspore.Tensor.var](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.var.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/var.html) |
| [torch.Tensor.view](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.view) | [mindspore.Tensor.view](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.view.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.view_as](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.view_as) | [mindspore.Tensor.view_as](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.view_as.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.where](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.where) | [mindspore.Tensor.where](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.where.html) | [一致](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_api_mapping.html#api映射一致标准及例外场景) |
| [torch.Tensor.xlogy](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.xlogy)                 | [mindspore.Tensor.xlogy](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/mindspore/Tensor/mindspore.Tensor.xlogy.html)                 | 功能一致，参数名不同|

### torch.optim

| PyTorch 1.8.1 APIs                                                                                                                                     | MindSpore APIs                                                                                                                                                            | 说明                                                                                                                     |
| ------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------ |
| [torch.optim.Adadelta](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.Adadelta) | [mindspore.nn.Adadelta](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Adadelta.html)  | 一致 |
| [torch.optim.Adagrad](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.Adagrad) | [mindspore.nn.Adagrad](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Adagrad.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Adagrad.html)  |
| [torch.optim.Adam](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.Adam) | [mindspore.nn.Adam](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Adam.html)  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Adam.html)  |
| [torch.optim.AdaMax](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.AdaMax) | [mindspore.nn.AdaMax](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AdaMax.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AdaMax.html)  |
| [torch.optim.AdamW](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.AdamW) | [mindspore.nn.AdamWeightDecay](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.AdamWeightDecay.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AdamWeightDecay.html)  |
| [torch.optim.ASGD](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.ASGD) | [mindspore.nn.ASGD](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.ASGD.html)  | 一致 |
| [torch.optim.Optimizer](https://pytorch.org/docs/1.8.0/optim.html#torch.optim.Optimizer)                                                               | [mindspore.nn.Optimizer](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Optimizer.html#mindspore.nn.Optimizer)                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Optimizer.html)           |
| [torch.optim.SparseAdam](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.SparseAdam) | [mindspore.nn.LazyAdam](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.LazyAdam.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SparseAdam.html)  |
| [torch.optim.RMSProp](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.RMSProp) | [mindspore.nn.RMSProp](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.RMSProp.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/RMSProp.html)  |
| [torch.optim.Rprop](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.Rprop) | [mindspore.nn.Rprop](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.Rprop.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Rprop.html)  |
| [torch.optim.SGD](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.SGD) | [mindspore.nn.SGD](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.SGD.html)  | 一致 |
| [torch.optim.lr_scheduler.CosineAnnealingLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.CosineAnnealingLR) | [mindspore.nn.cosine_decay_lr](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.cosine_decay_lr.html#mindspore.nn.cosine_decay_lr)                                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/CosineDecayLr.html)             |
| [torch.optim.lr_scheduler.ExponentialLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.ExponentialLR)                             | [mindspore.nn.exponential_decay_lr](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.exponential_decay_lr.html#mindspore.nn.exponential_decay_lr)    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/ExponentialDecayLR.html)  |
| [torch.optim.lr_scheduler.MultiStepLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.MultiStepLR)                                 | [mindspore.nn.piecewise_constant_lr](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.piecewise_constant_lr.html#mindspore.nn.piecewise_constant_lr) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/PiecewiseConstantLR.html) |
| [torch.optim.lr_scheduler.StepLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.StepLR)                                           | [mindspore.nn.piecewise_constant_lr](https://mindspore.cn/docs/zh-CN/r2.2/api_python/nn/mindspore.nn.piecewise_constant_lr.html#mindspore.nn.piecewise_constant_lr) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/PiecewiseConstantLR.html) |

### torch.optim

| PyTorch 1.8.1 APIs                                           | MindSpore APIs                                               | 说明                                                 |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| [torch.optim.Adam](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.Adam)                                                     | [mindspore.experimental.optim.Adam](https://mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.Adam.html)                                                     | 一致 |
| [torch.optim.AdamW](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.AdamW)                                                     | [mindspore.experimental.optim.AdamW](https://mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.AdamW.html)                                                     | 一致 |
| [torch.optim.SGD](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.SGD)                                                     | [mindspore.experimental.optim.SGD](https://mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.SGD.html)                                                     | 一致 |

### torch.optim.lr_scheduler

| PyTorch 1.8.1 APIs                                           | MindSpore APIs                                               | 说明                                                 |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| [torch.optim.lr_scheduler.LRScheduler](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.LRScheduler)      | [mindspore.experimental.optim.lr_scheduler.LRScheduler](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.LRScheduler.html#mindspore.experimental.optim.lr_scheduler.LRScheduler)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.ChainedScheduler](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.ChainedScheduler)      | [mindspore.experimental.optim.lr_scheduler.ChainedScheduler](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.ChainedScheduler.html#mindspore.experimental.optim.lr_scheduler.ChainedScheduler)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.ConstantLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.ConstantLR)      | [mindspore.experimental.optim.lr_scheduler.ConstantLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.ConstantLR.html#mindspore.experimental.optim.lr_scheduler.ConstantLR)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.CosineAnnealingLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.CosineAnnealingLR)      | [mindspore.experimental.optim.lr_scheduler.CosineAnnealingLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.CosineAnnealingLR.html#mindspore.experimental.optim.lr_scheduler.CosineAnnealingLR)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.CosineAnnealingWarmRestarts](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.CosineAnnealingWarmRestarts)      | [mindspore.experimental.optim.lr_scheduler.CosineAnnealingWarmRestarts](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.CosineAnnealingWarmRestarts.html#mindspore.experimental.optim.lr_scheduler.CosineAnnealingWarmRestarts)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.CyclicLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.CyclicLR)      | [mindspore.experimental.optim.lr_scheduler.CyclicLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.CyclicLR.html#mindspore.experimental.optim.lr_scheduler.CyclicLR)                                                     | 无 `verbose` 和 `momentum` 相关入参，其余功能一致 |
| [torch.optim.lr_scheduler.ExponentialLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.ExponentialLR)      | [mindspore.experimental.optim.lr_scheduler.ExponentialLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.ExponentialLR.html#mindspore.experimental.optim.lr_scheduler.ExponentialLR)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.LambdaLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.LambdaLR)      | [mindspore.experimental.optim.lr_scheduler.LambdaLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.LambdaLR.html#mindspore.experimental.optim.lr_scheduler.LambdaLR)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.LinearLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.LinearLR)      | [mindspore.experimental.optim.lr_scheduler.LinearLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.LinearLR.html#mindspore.experimental.optim.lr_scheduler.LinearLR)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.MultiplicativeLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.MultiplicativeLR)      | [mindspore.experimental.optim.lr_scheduler.MultiplicativeLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.MultiplicativeLR.html#mindspore.experimental.optim.lr_scheduler.MultiplicativeLR)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.MultiStepLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.MultiStepLR)      | [mindspore.experimental.optim.lr_scheduler.MultiStepLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.MultiStepLR.html#mindspore.experimental.optim.lr_scheduler.MultiStepLR)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.PolynomialLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.PolynomialLR)      | [mindspore.experimental.optim.lr_scheduler.PolynomialLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.PolynomialLR.html#mindspore.experimental.optim.lr_scheduler.PolynomialLR)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.ReduceLROnPlateau](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.ReduceLROnPlateau)      | [mindspore.experimental.optim.lr_scheduler.ReduceLROnPlateau](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.ReduceLROnPlateau.html#mindspore.experimental.optim.lr_scheduler.ReduceLROnPlateau)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.SequentialLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.SequentialLR)      | [mindspore.experimental.optim.lr_scheduler.SequentialLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.SequentialLR.html#mindspore.experimental.optim.lr_scheduler.SequentialLR)                                                     | 无 `verbose` 入参，其余功能一致 |
| [torch.optim.lr_scheduler.StepLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.StepLR)      | [mindspore.experimental.optim.lr_scheduler.StepLR](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/experimental/optim/mindspore.experimental.optim.lr_scheduler.StepLR.html#mindspore.experimental.optim.lr_scheduler.StepLR)                                                     | 无 `verbose` 入参，其余功能一致 |

### torch.utils

| PyTorch 1.8.1 APIs | MindSpore APIs  | 说明   |
| ------------------ | --------------- | ------ |
| [torch.utils.data.DataLoader](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.DataLoader) | [mindspore.dataset.GeneratorDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/DataLoader.html) |
| [torch.utils.data.distributed.DistributedSampler](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.distributed.DistributedSampler) | [mindspore.dataset.DistributedSampler](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.DistributedSampler.html#mindspore.dataset.DistributedSampler)  |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/DistributedSampler.html) |
| [torch.utils.data.RandomSampler](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.RandomSampler)  | [mindspore.dataset.RandomSampler](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.RandomSampler.html#mindspore.dataset.RandomSampler) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/RandomSampler.html)  |
| [torch.utils.data.SequentialSampler](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.SequentialSampler)     | [mindspore.dataset.SequentialSampler](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.SequentialSampler.html#mindspore.dataset.SequentialSampler)  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SequentialSampler.html)     |
| [torch.utils.data.SubsetRandomSampler](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.SubsetRandomSampler)    | [mindspore.dataset.SubsetRandomSampler](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.SubsetRandomSampler.html#mindspore.dataset.SubsetRandomSampler)    |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SubsetRandomSampler.html)  |
| [torch.utils.data.WeightedRandomSampler](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.WeightedRandomSampler)    | [mindspore.dataset.WeightedRandomSampler](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.WeightedRandomSampler.html#mindspore.dataset.WeightedRandomSampler) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/WeightedRandomSampler.html)   |

## torchaudio

| TorchAudio 0.8.1 APIs     | MindSpore APIs     | 说明        |
| ----------------------- | ------------------------- | ------------------ |
| [torchaudio.datasets.CMUARCTIC](https://pytorch.org/audio/0.8.0/datasets.html#cmuarctic)  | [mindspore.dataset.CMUArcticDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.CMUArcticDataset.html#mindspore.dataset.CMUArcticDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/CMUARCTIC.html)  |
| [torchaudio.datasets.GTZAN](https://pytorch.org/audio/0.8.0/datasets.html#gtzan)  | [mindspore.dataset.GTZANDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.GTZANDataset.html#mindspore.dataset.GTZANDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/GTZAN.html)  |
| [torchaudio.datasets.LIBRITTS](https://pytorch.org/audio/0.8.0/datasets.html#libritts)  | [mindspore.dataset.LibriTTSDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.LibriTTSDataset.html#mindspore.dataset.LibriTTSDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/LIBRITTS.html)  |
| [torchaudio.datasets.LJSPEECH](https://pytorch.org/audio/0.8.0/datasets.html#ljspeech)  | [mindspore.dataset.LJSpeechDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.LJSpeechDataset.html#mindspore.dataset.LJSpeechDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/LJSPEECH.html)  |
| [torchaudio.datasets.SPEECHCOMMANDS](https://pytorch.org/audio/0.8.0/datasets.html#speechcommands)  | [mindspore.dataset.SpeechCommandsDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.SpeechCommandsDataset.html#mindspore.dataset.SpeechCommandsDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SPEECHCOMMANDS.html)  |
| [torchaudio.datasets.TEDLIUM](https://pytorch.org/audio/0.8.0/datasets.html#tedlium)  | [mindspore.dataset.TedliumDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.TedliumDataset.html#mindspore.dataset.TedliumDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/TEDLIUM.html)  |
| [torchaudio.datasets.YESNO](https://pytorch.org/audio/0.8.0/datasets.html#yesno)  | [mindspore.dataset.YesNoDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.YesNoDataset.html#mindspore.dataset.YesNoDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/YESNO.html)  |
| [torchaudio.transforms.AmplitudeToDB](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.AmplitudeToDB.html)   | [mindspore.dataset.audio.AmplitudeToDB](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.AmplitudeToDB.html#mindspore.dataset.audio.AmplitudeToDB)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AmplitudeToDB.html)  |
| [torchaudio.transforms.ComplexNorm](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.ComplexNorm.html)   | [mindspore.dataset.audio.ComplexNorm](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.ComplexNorm.html#mindspore.dataset.audio.ComplexNorm)   | 一致  |
| [torchaudio.transforms.ComputeDeltas](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.ComputeDeltas.html)   | [mindspore.dataset.audio.ComputeDeltas](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.ComputeDeltas.html#mindspore.dataset.audio.ComputeDeltas)   | 功能一致，参数名不同  |
| [torchaudio.transforms.Fade](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.Fade.html)   | [mindspore.dataset.audio.Fade](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.Fade.html#mindspore.dataset.audio.Fade)   | 一致 |
| [torchaudio.transforms.FrequencyMasking](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.FrequencyMasking.html)   | [mindspore.dataset.audio.FrequencyMasking](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.FrequencyMasking.html#mindspore.dataset.audio.FrequencyMasking)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/FrequencyMasking.html)  |
| [torchaudio.transforms.GriffinLim](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.GriffinLim.html)   | [mindspore.dataset.audio.GriffinLim](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.GriffinLim.html#mindspore.dataset.audio.GriffinLim)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/GriffinLim.html)  |
| [torchaudio.transforms.InverseMelScale](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.InverseMelScale.html) | [mindspore.dataset.audio.InverseMelScale](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.InverseMelScale.html#mindspore.dataset.audio.InverseMelScale) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/InverseMelScale.html)  |
| [torchaudio.transforms.MelScale](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.MelScale.html)   | [mindspore.dataset.audio.MelScale](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.MelScale.html#mindspore.dataset.audio.MelScale)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/MelScale.html)  |
| [torchaudio.transforms.MelSpectrogram](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.MelSpectrogram.html)   | [mindspore.dataset.audio.MelSpectrogram](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.MelSpectrogram.html#mindspore.dataset.audio.MelSpectrogram)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/MelSpectrogram.html)  |
| [torchaudio.transforms.MFCC](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.MFCC.html)   | [mindspore.dataset.audio.MFCC](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.MFCC.html#mindspore.dataset.audio.MFCC)   | 一致  |
| [torchaudio.transforms.MuLawEncoding](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.MuLawEncoding.html)   | [mindspore.dataset.audio.MuLawEncoding](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.MuLawEncoding.html#mindspore.dataset.audio.MuLawEncoding)   | 一致  |
| [torchaudio.transforms.MuLawDecoding](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.MuLawDecoding.html)   | [mindspore.dataset.audio.MuLawDecoding](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.MuLawDecoding.html#mindspore.dataset.audio.MuLawDecoding)   | 一致  |
| [torchaudio.transforms.Resample](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.Resample.html)   | [mindspore.dataset.audio.Resample](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.Resample.html#mindspore.dataset.audio.Resample)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Resample.html)  |
| [torchaudio.transforms.SlidingWindowCmn](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.SlidingWindowCmn.html) | [mindspore.dataset.audio.SlidingWindowCmn](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.SlidingWindowCmn.html#mindspore.dataset.audio.SlidingWindowCmn) | 一致  |
| [torchaudio.transforms.SpectralCentroid](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.SpectralCentroid.html)   | [mindspore.dataset.audio.SpectralCentroid](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.SpectralCentroid.html#mindspore.dataset.audio.SpectralCentroid)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SpectralCentroid.html)  |
| [torchaudio.transforms.Spectrogram](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.Spectrogram.html)   | [mindspore.dataset.audio.Spectrogram](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.Spectrogram.html#mindspore.dataset.audio.Spectrogram)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Spectrogram.html)  |
| [torchaudio.transforms.TimeMasking](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.TimeMasking.html)   | [mindspore.dataset.audio.TimeMasking](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.TimeMasking.html#mindspore.dataset.audio.TimeMasking)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/TimeMasking.html)  |
| [torchaudio.transforms.TimeStretch](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.TimeStretch.html)   | [mindspore.dataset.audio.TimeStretch](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.TimeStretch.html#mindspore.dataset.audio.TimeStretch)    | 一致  |
| [torchaudio.transforms.Vad](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.Vad.html)   | [mindspore.dataset.audio.Vad](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.Vad.html#mindspore.dataset.audio.Vad)   | 一致  |
| [torchaudio.transforms.Vol](https://pytorch.org/audio/0.8.0/transforms.html#torchaudio.transforms.Vol.html)   | [mindspore.dataset.audio.Vol](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_audio/mindspore.dataset.audio.Vol.html#mindspore.dataset.audio.Vol)   | 一致  |

## torchtext

| TorchText 0.9.1 APIs    | MindSpore APIs            | 说明           |
| ---------------------- | ----------------------------- | ------------------------------ |
| [torchtext.data.functional.custom_replace](https://pytorch.org/text/0.9.0/data_functional.html#custom-replace)      | [mindspore.dataset.text.RegexReplace](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_text/mindspore.dataset.text.RegexReplace.html#mindspore.dataset.text.RegexReplace)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/RegexReplace.html)   |
| [torchtext.data.functional.load_sp_model](https://pytorch.org/text/0.9.0/data_functional.html#load-sp-model)  | [mindspore.dataset.text.SentencePieceTokenizer](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_text/mindspore.dataset.text.SentencePieceTokenizer.html#mindspore.dataset.text.SentencePieceTokenizer)  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/load_sp_model.html)       |
| [torchtext.data.functional.numericalize_tokens_from_iterator](https://pytorch.org/text/0.9.0/data_functional.html#numericalize-tokens-from-iterator) | [mindspore.dataset.text.Lookup](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_text/mindspore.dataset.text.Lookup.html#mindspore.dataset.text.Lookup)  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Lookup.html)                            |
| [torchtext.data.functional.sentencepiece_numericalizer](https://pytorch.org/text/0.9.0/data_functional.html#sentencepiece-numericalizer) | [mindspore.dataset.text.SentencePieceTokenizer](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_text/mindspore.dataset.text.SentencePieceTokenizer.html#mindspore.dataset.text.SentencePieceTokenizer) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SentencePieceTokenizer_Out_INT.html)    |
| [torchtext.data.functional.sentencepiece_tokenizer](https://pytorch.org/text/0.9.0/data_functional.html#sentencepiece-tokenizer)                     | [mindspore.dataset.text.SentencePieceTokenizer](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_text/mindspore.dataset.text.SentencePieceTokenizer.html#mindspore.dataset.text.SentencePieceTokenizer) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SentencePieceTokenizer_Out_STRING.html) |
| [torchtext.data.functional.simple_space_split](https://pytorch.org/text/0.9.0/data_functional.html#simple-space-split)                               | [mindspore.dataset.text.WhitespaceTokenizer](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_text/mindspore.dataset.text.WhitespaceTokenizer.html#mindspore.dataset.text.WhitespaceTokenizer)          |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/WhitespaceTokenizer.html)      |
| [torchtext.data.utils.ngrams_iterator](https://pytorch.org/text/0.9.0/data_functional.html#ngrams-iterator)      | [mindspore.dataset.text.Ngram](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_text/mindspore.dataset.text.Ngram.html#mindspore.dataset.text.Ngram)      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Ngram.html)    |
| [torchtext.datasets.AG_NEWS](https://pytorch.org/text/0.9.0/datasets.html#ag-news)  | [mindspore.dataset.AGNewsDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.AGNewsDataset.html#mindspore.dataset.AGNewsDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AGNEWS.html)  |
| [torchtext.datasets.AmazonReviewFull](https://pytorch.org/text/0.9.0/datasets.html#amazonreviewfull)  | [mindspore.dataset.AmazonReviewDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.AmazonReviewDataset.html#mindspore.dataset.AmazonReviewDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AmazonReviewFull.html)  |
| [torchtext.datasets.AmazonReviewPolarity](https://pytorch.org/text/0.9.0/datasets.html#amazonreviewpolarity)  | [mindspore.dataset.AmazonReviewDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.AmazonReviewDataset.html#mindspore.dataset.AmazonReviewDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/AmazonReviewPolarity.html)  |
| [torchtext.datasets.CoNLL2000Chunking](https://pytorch.org/text/0.9.0/datasets.html#conll2000chunking)  | [mindspore.dataset.CoNLL2000Dataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.CoNLL2000Dataset.html#mindspore.dataset.CoNLL2000Dataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/CoNLL2000Chunking.html)  |
| [torchtext.datasets.DBpedia](https://pytorch.org/text/0.9.0/datasets.html#dbpedia)  | [mindspore.dataset.DBpediaDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.DBpediaDataset.html#mindspore.dataset.DBpediaDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/DBpedia.html)  |
| [torchtext.datasets.IMDB](https://pytorch.org/text/0.9.0/datasets.html#imdb)  | [mindspore.dataset.IMDBDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.IMDBDataset.html#mindspore.dataset.IMDBDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/IMDB.html)  |
| [torchtext.datasets.IWSLT2016](https://pytorch.org/text/0.9.0/datasets.html#iwslt2016)  | [mindspore.dataset.IWSLT2016Dataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.IWSLT2016Dataset.html#mindspore.dataset.IWSLT2016Dataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/IWSLT2016.html)  |
| [torchtext.datasets.IWSLT2017](https://pytorch.org/text/0.9.0/datasets.html#iwslt2017)  | [mindspore.dataset.IWSLT2017Dataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.IWSLT2017Dataset.html#mindspore.dataset.IWSLT2017Dataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/IWSLT2017.html)  |
| [torchtext.datasets.PennTreebank](https://pytorch.org/text/0.9.0/datasets.html#penntreebank)  | [mindspore.dataset.PennTreebankDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.PennTreebankDataset.html#mindspore.dataset.PennTreebankDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/PennTreebank.html)  |
| [torchtext.datasets.SogouNews](https://pytorch.org/text/0.9.0/datasets.html#sogounews)  | [mindspore.dataset.SogouNewsDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.SogouNewsDataset.html#mindspore.dataset.SogouNewsDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SogouNews.html)  |
| [torchtext.datasets.SQuAD1](https://pytorch.org/text/0.9.0/datasets.html#torchtext.datasets.SQuAD1)  | [mindspore.dataset.SQuADDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.SQuADDataset.html#mindspore.dataset.SQuADDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SQuAD1.html)  |
| [torchtext.datasets.SQuAD2](https://pytorch.org/text/0.9.0/datasets.html#torchtext.datasets.SQuAD2)  | [mindspore.dataset.SQuADDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.SQuADDataset.html#mindspore.dataset.SQuADDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/SQuAD2.html)  |
| [torchtext.datasets.UDPOS](https://pytorch.org/text/0.9.0/datasets.html#udpos)  | [mindspore.dataset.UDPOSDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.UDPOSDataset.html#mindspore.dataset.UDPOSDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/UDPOS.html)  |
| [torchtext.datasets.WikiText103](https://pytorch.org/text/0.9.0/datasets.html#wikitext103)  | [mindspore.dataset.WikiTextDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.WikiTextDataset.html#mindspore.dataset.WikiTextDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/WikiText103.html)  |
| [torchtext.datasets.WikiText2](https://pytorch.org/text/0.9.0/datasets.html#wikitext-2)  | [mindspore.dataset.WikiTextDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.WikiTextDataset.html#mindspore.dataset.WikiTextDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/WikiText2.html)  |
| [torchtext.datasets.YahooAnswers](https://pytorch.org/text/0.9.0/datasets.html#yahooanswers)  | [mindspore.dataset.YahooAnswersDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.YahooAnswersDataset.html#mindspore.dataset.YahooAnswersDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/YahooAnswers.html)  |
| [torchtext.datasets.YelpReviewFull](https://pytorch.org/text/0.9.0/datasets.html#yelpreviewfull)  | [mindspore.dataset.YelpReviewDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.YelpReviewDataset.html#mindspore.dataset.YelpReviewDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/YelpReviewFull.html)  |
| [torchtext.datasets.YelpReviewPolarity](https://pytorch.org/text/0.9.0/datasets.html#yelpreviewpolarity)  | [mindspore.dataset.YelpReviewDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.YelpReviewDataset.html#mindspore.dataset.YelpReviewDataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/YelpReviewPolarity.html)  |

## torchvision

| TorchVision 0.9.1 APIs                                                                                                                    | MindSpore APIs                                                                                                                                                                                                                                                   | 说明                                                                                                                 |
| ------------------------------------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [torchvision.datasets.CelebA](https://pytorch.org/vision/0.9/datasets.html#torchvision.datasets.CelebA)  | [mindspore.dataset.CelebADataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.CelebADataset.html#mindspore.dataset.CelebADataset) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/CelebA.html)  |
| [torchvision.datasets.Cityscapes](https://pytorch.org/vision/0.9/datasets.html#cityscapes)     | [mindspore.dataset.CityscapesDataset](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.CityscapesDataset.html#mindspore.dataset.CityscapesDataset)    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Cityscapes.html) |
| [torchvision.datasets.CIFAR10](https://pytorch.org/vision/0.9/datasets.html#torchvision.datasets.CIFAR10) |   [mindspore.dataset.Cifar10Dataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.Cifar10Dataset.html#mindspore.dataset.Cifar10Dataset) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/CIFAR10.html) |
| [torchvision.datasets.CIFAR100](https://pytorch.org/vision/0.9/datasets.html#torchvision.datasets.CIFAR100)  | [mindspore.dataset.Cifar100Dataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.Cifar100Dataset.html#mindspore.dataset.Cifar100Dataset) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/CIFAR100.html) |
| [torchvision.datasets.CocoDetection](https://pytorch.org/vision/0.9/datasets.html#torchvision.datasets.CocoDetection)  | [mindspore.dataset.CocoDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.CocoDataset.html#mindspore.dataset.CocoDataset)  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/CocoDataset.html)     |
| [torchvision.datasets.ImageFolder](https://pytorch.org/vision/0.9/datasets.html#torchvision.datasets.ImageFolder)    | [mindspore.dataset.ImageFolderDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.ImageFolderDataset.html#mindspore.dataset.ImageFolderDataset)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/ImageFolder.html) |
| [torchvision.datasets.MNIST](https://pytorch.org/vision/0.9/datasets.html#torchvision.datasets.MNIST)     | [mindspore.dataset.MnistDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.MnistDataset.html#mindspore.dataset.MnistDataset)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/MNIST.html)   |
| [torchvision.datasets.VOCDetection](https://pytorch.org/vision/0.9/datasets.html#torchvision.datasets.VOCDetection)    | [mindspore.dataset.VOCDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.VOCDataset.html#mindspore.dataset.VOCDataset)  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/VOCDetection.html)    |
| [torchvision.datasets.VOCSegmentation](https://pytorch.org/vision/0.9/datasets.html#torchvision.datasets.VOCSegmentation)     | [mindspore.dataset.VOCDataset](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset/mindspore.dataset.VOCDataset.html#mindspore.dataset.VOCDataset)    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/VOCSegmentation.html) |
| [torchvision.ops.nms](https://pytorch.org/vision/0.9/ops.html#torchvision.ops.nms.html#torchvision.ops.nms)  | [mindspore.ops.NMSWithMask](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.NMSWithMask.html#mindspore.ops.NMSWithMask)       |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/nms.html)        |
| [torchvision.ops.roi_align](https://pytorch.org/vision/0.9/ops.html#torchvision.ops.roi_align.html#torchvision.ops.roi_align)    | [mindspore.ops.ROIAlign](https://mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.ROIAlign.html#mindspore.ops.ROIAlign)     |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/roi_align.html)   |
| [torchvision.transforms.CenterCrop](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.CenterCrop)   | [mindspore.dataset.vision.CenterCrop](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.CenterCrop.html#mindspore.dataset.vision.CenterCrop)    |  一致   |
| [torchvision.transforms.ColorJitter](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.ColorJitter) | [mindspore.dataset.vision.RandomColorAdjust](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.RandomColorAdjust.html#mindspore.dataset.vision.RandomColorAdjust)   | 一致  |
| [torchvision.transforms.Compose](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.Compose)      | [mindspore.dataset.transforms.Compose](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_transforms/mindspore.dataset.transforms.Compose.html#mindspore.dataset.transforms.Compose)   |  一致  |
| [torchvision.transforms.ConvertImageDtype](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.ConvertImageDtype)       | [mindspore.dataset.transforms.TypeCast](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_transforms/mindspore.dataset.transforms.TypeCast.html#mindspore.dataset.transforms.TypeCast)           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/TypeCast.html)          |
| [torchvision.transforms.FiveCrop](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.FiveCrop)                         | [mindspore.dataset.vision.FiveCrop](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.FiveCrop.html#mindspore.dataset.vision.FiveCrop)  |  一致 |
| [torchvision.transforms.GaussianBlur](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.GaussianBlur) | [mindspore.dataset.vision.GaussianBlur](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.GaussianBlur.html#mindspore.dataset.vision.GaussianBlur)  |  一致 |
| [torchvision.transforms.Grayscale](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.Grayscale)   | [mindspore.dataset.vision.Grayscale](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.Grayscale.html#mindspore.dataset.vision.Grayscale)    |  一致 |
| [torchvision.transforms.LinearTransformation](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.LinearTransformation) | [mindspore.dataset.vision.LinearTransformation](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.LinearTransformation.html#mindspore.dataset.vision.LinearTransformation) | 一致 |
| [torchvision.transforms.Normalize](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.Normalize)                       | [mindspore.dataset.vision.Normalize](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.Normalize.html#mindspore.dataset.vision.Normalize)    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/Normalize.html)  |
| [torchvision.transforms.Pad](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.Pad)  | [mindspore.dataset.vision.Pad](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.Pad.html#mindspore.dataset.vision.Pad)  | 功能一致，参数名不同 |
| [torchvision.transforms.RandomAffine](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomAffine)    | [mindspore.dataset.vision.RandomAffine](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.RandomAffine.html#mindspore.dataset.vision.RandomAffine)   |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/RandomAffine.html)    |
| [torchvision.transforms.RandomApply](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomApply)   | [mindspore.dataset.transforms.RandomApply](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_transforms/mindspore.dataset.transforms.RandomApply.html#mindspore.dataset.transforms.RandomApply)   | 功能一致，参数名不同 |
| [torchvision.transforms.RandomChoice](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomChoice)                 | [mindspore.dataset.transforms.RandomChoice](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_transforms/mindspore.dataset.transforms.RandomChoice.html#mindspore.dataset.transforms.RandomChoice)   | 一致 |
| [torchvision.transforms.RandomCrop](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomCrop)      | [mindspore.dataset.vision.RandomCrop](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.RandomCrop.html#mindspore.dataset.vision.RandomCrop)   | 功能一致，参数名不同 |
| [torchvision.transforms.RandomGrayscale](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomGrayscale)           | [mindspore.dataset.vision.RandomGrayscale](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.RandomGrayscale.html#mindspore.dataset.vision.RandomGrayscale)     | 功能一致，参数名不同 |
| [torchvision.transforms.RandomHorizontalFlip](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomHorizontalFlip) | [mindspore.dataset.vision.RandomHorizontalFlip](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.RandomHorizontalFlip.html#mindspore.dataset.vision.RandomHorizontalFlip)    | 功能一致，参数名不同 |
| [torchvision.transforms.RandomOrder](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomOrder)                   | [mindspore.dataset.transforms.RandomOrder](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_transforms/mindspore.dataset.transforms.RandomOrder.html#mindspore.dataset.transforms.RandomOrder)            |   一致 |
| [torchvision.transforms.RandomPerspective](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomPerspective)       | [mindspore.dataset.vision.RandomPerspective](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.RandomPerspective.html#mindspore.dataset.vision.RandomPerspective)     |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/RandomPerspective.html)  |
| [torchvision.transforms.RandomResizedCrop](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomResizedCrop)       | [mindspore.dataset.vision.RandomResizedCrop](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.RandomResizedCrop.html#mindspore.dataset.vision.RandomResizedCrop)   |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/RandomResizedCrop.html) |
| [torchvision.transforms.RandomRotation](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomRotation)             | [mindspore.dataset.vision.RandomRotation](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.RandomRotation.html#mindspore.dataset.vision.RandomRotation)      |    [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/RandomRotation.html)  |
| [torchvision.transforms.RandomVerticalFlip](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.RandomVerticalFlip)     | [mindspore.dataset.vision.RandomVerticalFlip](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.RandomVerticalFlip.html#mindspore.dataset.vision.RandomVerticalFlip)      |  功能一致，参数名不同  |
| [torchvision.transforms.Resize](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.Resize)                             | [mindspore.dataset.vision.Resize](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.Resize.html#mindspore.dataset.vision.Resize)    |  一致  |
| [torchvision.transforms.TenCrop](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.TenCrop)      | [mindspore.dataset.vision.TenCrop](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.TenCrop.html#mindspore.dataset.vision.TenCrop) |  功能一致，参数名不同  |
| [torchvision.transforms.ToPILImage](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.ToPILImage)  | [mindspore.dataset.vision.ToPIL](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.ToPIL.html#mindspore.dataset.vision.ToPIL)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/ToPIL.html)           |
| [torchvision.transforms.ToTensor](https://pytorch.org/vision/0.9/transforms.html#torchvision.transforms.ToTensor)   | [mindspore.dataset.vision.ToTensor](https://mindspore.cn/docs/zh-CN/r2.2/api_python/dataset_vision/mindspore.dataset.vision.ToTensor.html#mindspore.dataset.vision.ToTensor)  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/ToTensor.html)        |
| [torchvision.ops.deform_conv2d](https://pytorch.org/vision/main/generated/torchvision.ops.deform_conv2d.html#deform-conv2d) | [mindspore.ops.deformable_conv2d](https://www.mindspore.cn/docs/zh-CN/r2.2/api_python/ops/mindspore.ops.deformable_conv2d.html#mindspore-ops-deformable-conv2d) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.2/note/api_mapping/pytorch_diff/deform_conv2d.html)        |