/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.quesionnaire;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.mindspore.ide.toolkit.common.config.QuestionnaireConfig;
import com.mindspore.ide.toolkit.common.events.ProjectEvents;
import com.mindspore.ide.toolkit.ui.guide.QuestionnaireAction;
import net.engio.mbassy.listener.Handler;
import net.engio.mbassy.listener.Listener;
import net.engio.mbassy.listener.References;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Listener(references=References.Strong)
public class QuestionnaireListener {
    private static final Logger log = LoggerFactory.getLogger(QuestionnaireListener.class);
    private static final int QUESTION_PROP_MIN_VALUE = 3;
    private static final int QUESTION_PROP_MAX_VALUE = 6;
    private QuestionnaireConfig config = QuestionnaireConfig.get();

    @Handler
    public void showBalloon(ProjectEvents.ProjectOpen projectOpen) {
        int openPluginNum = PropertiesComponent.getInstance().getInt(this.config.getCacheFileName(), 0);
        if (openPluginNum <= 6) {
            PropertiesComponent.getInstance().setValue(this.config.getCacheFileName(), ++openPluginNum, 0);
        }
        if (3 < openPluginNum && openPluginNum <= 6) {
            Notification notification = new Notification("System Messages", "", this.config.getContent(), NotificationType.INFORMATION, NotificationListener.URL_OPENING_LISTENER);
            AnAction anAction = ActionManager.getInstance().getAction("mindsporeQuestionnaireAction");
            if (anAction instanceof QuestionnaireAction) {
                QuestionnaireAction questionnaireAction = (QuestionnaireAction)anAction;
                questionnaireAction.setUrl(this.config.getQuestionnaireUrl());
                notification.addAction((AnAction)questionnaireAction);
            }
            Notifications.Bus.notify((Notification)notification);
        }
    }
}

