/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.wizard;

import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.CustomStepProjectGenerator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.platform.DirectoryProjectGenerator;
import com.jetbrains.python.newProject.PyNewProjectSettings;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.sdk.PyLazySdk;
import com.mindspore.ide.toolkit.common.beans.NormalInfoConstants;
import com.mindspore.ide.toolkit.common.enums.EnumProperties;
import com.mindspore.ide.toolkit.common.events.CommonEvent;
import com.mindspore.ide.toolkit.common.events.EventCenter;
import com.mindspore.ide.toolkit.common.utils.VersionUtils;
import com.mindspore.ide.toolkit.ui.wizard.WizardMsSettingProjectPeer;
import com.mindspore.ide.toolkit.wizard.CustomMSProjectStep;
import com.mindspore.ide.toolkit.wizard.MindSporeService;
import com.mindspore.ide.toolkit.wizard.MsCondaEnvService;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MindSporeProjectGenerator
extends PythonProjectGenerator<PyNewProjectSettings>
implements CustomStepProjectGenerator<PyNewProjectSettings> {
    private static final Logger log = LoggerFactory.getLogger(MindSporeProjectGenerator.class);
    private static final String PROJECT_WIZARD_NAME = EnumProperties.MIND_SPORE_PROPERTIES.getProperty("project.wizard.name");
    private static final String PROJECT_WIZARD_DESCRIPTION = EnumProperties.MIND_SPORE_PROPERTIES.getProperty("project.wizard.description");
    private WizardMsSettingProjectPeer msSettingProjectPeer = new WizardMsSettingProjectPeer();

    public AbstractActionWithPanel createStep(DirectoryProjectGenerator projectGenerator, AbstractNewProjectStep.AbstractCallback callback) {
        this.msSettingProjectPeer.initCondaMap();
        this.msSettingProjectPeer.resetBrowserButton();
        return new CustomMSProjectStep((DirectoryProjectGenerator)this, callback, this.msSettingProjectPeer);
    }

    public String getDescription() {
        return PROJECT_WIZARD_DESCRIPTION;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getName() {
        String string = PROJECT_WIZARD_NAME;
        if (string == null) {
            MindSporeProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Icon getLogo() {
        return NormalInfoConstants.MS_ICON_16PX;
    }

    protected void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull PyNewProjectSettings settings, @NotNull Module module, @Nullable PyProjectSynchronizer synchronizer) {
        if (project == null) {
            MindSporeProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            MindSporeProjectGenerator.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            MindSporeProjectGenerator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            MindSporeProjectGenerator.$$$reportNull$$$0(4);
        }
        super.configureProject(project, baseDir, settings, module, synchronizer);
        CommonEvent createMindSporeProject = new CommonEvent();
        createMindSporeProject.setData("configureProject");
        EventCenter.INSTANCE.publish(createMindSporeProject);
        MindSporeService.createMindSporeTemplate(baseDir.getPresentableUrl(), this.msSettingProjectPeer.getTemplate());
        MindSporeService.createStructure(baseDir.getPresentableUrl());
        Sdk sdk = settings.getSdk();
        if (sdk instanceof PyLazySdk) {
            sdk = ((PyLazySdk)sdk).create();
        }
        log.info("generator configuration");
        log.info("sdk home path : {}", (Object)sdk.getHomePath());
        if (!MsCondaEnvService.isValid(sdk)) {
            return;
        }
        if (VersionUtils.getIdeBaselineVersion() >= 203) {
            PyCondaPackageService.onCondaEnvCreated((String)this.msSettingProjectPeer.getCondaPath());
        }
        Task.WithResult<Boolean, Exception> installMindSporeTask = MindSporeService.installMindSporeTask(project, this.msSettingProjectPeer.getHardwareValue(), sdk);
        boolean isMindSporeInstalled = (Boolean)ProgressManager.getInstance().run(installMindSporeTask);
        if (!isMindSporeInstalled) {
            log.info("MindSpore install failed, check by validate");
            CommonEvent createMindSporeProjectFailed = new CommonEvent();
            createMindSporeProjectFailed.setData("MindSpore install failed, check by validate");
            EventCenter.INSTANCE.publish(createMindSporeProjectFailed);
            return;
        }
        boolean isNewSdk = this.msSettingProjectPeer.isUsingNewCondaEnv();
        Task.WithResult<Long, Exception> setSdkTask = MsCondaEnvService.setSdkTask(project, module, sdk, isNewSdk);
        Long sessionId = (Long)ProgressManager.getInstance().run(setSdkTask);
        CommonEvent createMindSporeProjectSuccess = new CommonEvent();
        createMindSporeProjectSuccess.setData("create MindSpore project successful");
        EventCenter.INSTANCE.publish(createMindSporeProjectSuccess);
        log.info("session ID {}", (Object)sessionId);
    }

    @Nullable
    public String getNewProjectPrefix() {
        return "mindspore";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mindspore/ide/toolkit/wizard/MindSporeProjectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mindspore/ide/toolkit/wizard/MindSporeProjectGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

