/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.simple.xhtml;

import com.openhtmltopdf.simple.extend.URLUTF8Encoder;
import com.openhtmltopdf.simple.xhtml.FormControl;
import com.openhtmltopdf.simple.xhtml.FormListener;
import com.openhtmltopdf.simple.xhtml.controls.ButtonControl;
import com.openhtmltopdf.simple.xhtml.controls.CheckControl;
import com.openhtmltopdf.simple.xhtml.controls.HiddenControl;
import com.openhtmltopdf.simple.xhtml.controls.SelectControl;
import com.openhtmltopdf.simple.xhtml.controls.TextControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class XhtmlForm {
    protected String _action;
    protected String _method;
    protected List<FormControl> _controls = new ArrayList<FormControl>();
    private List<FormListener> _listeners = new ArrayList<FormListener>();

    public XhtmlForm(String action, String method) {
        this._action = action;
        this._method = method;
    }

    public void addFormListener(FormListener listener) {
        this._listeners.add(listener);
    }

    public void removeFormListener(FormListener listener) {
        this._listeners.remove(listener);
    }

    public FormControl getControl(String name) {
        for (FormControl control : this._controls) {
            if (!control.getName().equals(name)) continue;
            return control;
        }
        return null;
    }

    public List<FormControl> getAllControls(String name) {
        ArrayList<FormControl> result = new ArrayList<FormControl>();
        for (FormControl control : this._controls) {
            if (!control.getName().equals(name)) continue;
            result.add(control);
        }
        return result;
    }

    public Iterator<FormControl> getControls() {
        return this._controls.iterator();
    }

    public FormControl createControl(Element e) {
        return XhtmlForm.createControl(this, e);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FormControl createControl(XhtmlForm form, Element e) {
        void var2_12;
        if (e == null) {
            return null;
        }
        String name = e.getNodeName();
        if (name.equals("input")) {
            String type = e.getAttribute("type");
            if (type.equals("text") || type.equals("password")) {
                TextControl textControl = new TextControl(form, e);
            } else if (type.equals("hidden")) {
                HiddenControl hiddenControl = new HiddenControl(form, e);
            } else if (type.equals("button") || type.equals("submit") || type.equals("reset")) {
                ButtonControl buttonControl = new ButtonControl(form, e);
            } else {
                if (!type.equals("checkbox") && !type.equals("radio")) return null;
                CheckControl checkControl = new CheckControl(form, e);
            }
        } else if (name.equals("textarea")) {
            TextControl textControl = new TextControl(form, e);
        } else if (name.equals("button")) {
            ButtonControl buttonControl = new ButtonControl(form, e);
        } else {
            if (!name.equals("select")) return null;
            SelectControl selectControl = new SelectControl(form, e);
        }
        if (form == null) return var2_12;
        form._controls.add((FormControl)var2_12);
        return var2_12;
    }

    public void reset() {
        for (FormListener _listener : this._listeners) {
            _listener.resetted(this);
        }
    }

    public void submit() {
        StringBuilder data = new StringBuilder();
        Iterator<FormControl> iter = this.getControls();
        while (iter.hasNext()) {
            FormControl control = iter.next();
            if (!control.isSuccessful()) continue;
            if (control.isMultiple()) {
                String[] values;
                for (String value : values = control.getMultipleValues()) {
                    if (data.length() > 0) {
                        data.append('&');
                    }
                    data.append(URLUTF8Encoder.encode(control.getName()));
                    data.append('=');
                    data.append(URLUTF8Encoder.encode(value));
                }
                continue;
            }
            if (data.length() > 0) {
                data.append('&');
            }
            data.append(URLUTF8Encoder.encode(control.getName()));
            data.append('=');
            data.append(URLUTF8Encoder.encode(control.getValue()));
        }
        System.out.println("Form submitted!");
        System.out.println("Action: ".concat(this._action));
        System.out.println("Method: ".concat(this._method));
        System.out.println("Data: ".concat(data.toString()));
        for (FormListener _listener : this._listeners) {
            _listener.submitted(this);
        }
    }
}

