/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.hdc.msjtable;

import com.mindspore.ide.toolkit.hdc.msjtable.DefaultGridBagTableModel;
import com.mindspore.ide.toolkit.hdc.msjtable.GridBagModel;
import com.mindspore.ide.toolkit.hdc.msjtable.GridBagTableUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GridBagTable
extends JTable {
    GridBagModel gridBagModel;

    public GridBagTable(AbstractTableModel dm) {
        super(dm);
        this.getTableHeader().setReorderingAllowed(false);
        this.gridBagModel = new DefaultGridBagTableModel(dm);
        this.getColumnModel().setColumnSelectionAllowed(true);
    }

    public GridBagModel getGridBagModel() {
        return this.gridBagModel;
    }

    public void setGridBagModel(GridBagModel gridBagModel) {
        if (gridBagModel != null && gridBagModel != this.gridBagModel) {
            this.gridBagModel = gridBagModel;
        }
    }

    private void updateSubComponentUI(Object componentShell) {
        if (componentShell == null) {
            return;
        }
        Component component = null;
        if (componentShell instanceof Component) {
            component = (Component)componentShell;
        }
        if (componentShell instanceof DefaultCellEditor) {
            component = ((DefaultCellEditor)componentShell).getComponent();
        }
        if (component != null) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    @Override
    public void updateUI() {
        TableColumnModel cm = this.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            TableColumn aColumn = cm.getColumn(column);
            this.updateSubComponentUI(aColumn.getCellRenderer());
            this.updateSubComponentUI(aColumn.getCellEditor());
            this.updateSubComponentUI(aColumn.getHeaderRenderer());
        }
        Enumeration defaultRenderers = this.defaultRenderersByColumnClass.elements();
        while (defaultRenderers.hasMoreElements()) {
            this.updateSubComponentUI(defaultRenderers.nextElement());
        }
        Enumeration defaultEditors = this.defaultEditorsByColumnClass.elements();
        while (defaultEditors.hasMoreElements()) {
            this.updateSubComponentUI(defaultEditors.nextElement());
        }
        if (this.tableHeader != null && this.tableHeader.getParent() == null) {
            this.tableHeader.updateUI();
        }
        this.setUI(new GridBagTableUI());
    }

    public Rectangle getGridCellRect(int row, int column, boolean isIncludeSpacing) {
        return super.getCellRect(row, column, isIncludeSpacing);
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean isIncludeSpacing) {
        Rectangle cellRect = super.getCellRect(row, column, isIncludeSpacing);
        int cols = this.gridBagModel.getColumnGrid(row, column);
        TableColumnModel cm = this.getColumnModel();
        for (int n = 1; n < cols; ++n) {
            cellRect.width += cm.getColumn(column + n).getWidth();
        }
        int rows = this.gridBagModel.getRowGrid(row, column);
        for (int n = 1; n < rows; ++n) {
            cellRect.height += this.getRowHeight(row + n);
        }
        return cellRect;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
    }

    public boolean mergeCells(int startRow, int endRow, int startColumn, int endColumn) {
        if (this.gridBagModel.mergeCells(startRow, endRow, startColumn, endColumn)) {
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean mergeCells(int[] rows, int[] columns) {
        if (this.gridBagModel.mergeCells(rows, columns)) {
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean splitCellAt(int row, int column) {
        if (this.gridBagModel.spliteCellAt(row, column)) {
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    public void changeSelection(int inputRow, int inputColumn, boolean isToggle, boolean isExtend) {
        int inputRowNew = inputRow;
        int inputColumnNew = inputColumn;
        if (this.gridBagModel.getCellState(inputRowNew, inputColumnNew) != -1) {
            super.changeSelection(inputRowNew, inputColumnNew, isToggle, isExtend);
        }
        block0: for (int row = inputRowNew; row >= 0; --row) {
            for (int col = inputColumnNew; col >= 0; --col) {
                Point po = this.gridBagModel.getGrid(row, col);
                if (col + po.x <= inputColumnNew || row + po.y <= inputRowNew) continue;
                inputRowNew = row;
                inputColumnNew = col;
                continue block0;
            }
        }
        super.changeSelection(inputRowNew, inputColumnNew, isToggle, isExtend);
        this.repaint();
    }

    @Override
    public boolean editCellAt(int inputRow, int inputColumn, EventObject eventObject) {
        int inputRowNew = inputRow;
        int inputColumnNew = inputColumn;
        if (this.gridBagModel.getCellState(inputRowNew, inputColumnNew) != -1) {
            return super.editCellAt(inputRowNew, inputColumnNew, eventObject);
        }
        block0: for (int row = inputRowNew; row >= 0; --row) {
            for (int col = inputColumnNew; col >= 0; --col) {
                Point po = this.gridBagModel.getGrid(row, col);
                if (col + po.x <= inputColumnNew || row + po.y <= inputRowNew) continue;
                inputRowNew = row;
                inputColumnNew = col;
                continue block0;
            }
        }
        return super.editCellAt(inputRowNew, inputColumnNew, eventObject);
    }
}

