/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedUtils;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.ISegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.SegmentedSequenceStats;
import org.jetbrains.annotations.NotNull;

public final class SegmentedSequenceFull
extends SegmentedSequence {
    private final boolean nonBaseChars;
    private final int[] baseOffsets;
    private final int baseStartOffset;

    private SegmentedSequenceFull(BasedSequence baseSeq, int startOffset, int endOffset, int length, boolean nonBaseChars, int[] baseOffsets, int baseStartOffset) {
        super(baseSeq, startOffset, endOffset, length);
        this.nonBaseChars = nonBaseChars;
        this.baseOffsets = baseOffsets;
        this.baseStartOffset = baseStartOffset;
    }

    @Override
    public int getIndexOffset(int index) {
        SequenceUtils.validateIndexInclusiveEnd(index, this.length());
        int offset = this.baseOffsets[this.baseStartOffset + index];
        return offset < 0 ? -1 : offset;
    }

    @Override
    public void addSegments(@NotNull IBasedSegmentBuilder<?> builder) {
        BasedUtils.generateSegments(builder, this);
    }

    @Override
    public char charAt(int index) {
        SequenceUtils.validateIndex(index, this.length());
        int offset = this.baseOffsets[this.baseStartOffset + index];
        if (offset < 0) {
            return (char)(-offset - 1);
        }
        return this.baseSeq.charAt(offset);
    }

    @Override
    @NotNull
    public BasedSequence subSequence(int startIndex, int endIndex) {
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.length());
        if (startIndex == 0 && endIndex == this.length) {
            return this;
        }
        return this.subSequence(this.baseSeq, this.baseOffsets, this.baseStartOffset + startIndex, this.nonBaseChars, endIndex - startIndex);
    }

    public static SegmentedSequenceFull create(@NotNull BasedSequence baseSequence, ISegmentBuilder<?> builder) {
        SegmentedSequenceStats stats;
        boolean nonBaseChars;
        BasedSequence baseSeq = baseSequence.getBaseSequence();
        int length = builder.length();
        int baseStartOffset = 0;
        int[] baseOffsets = new int[length + 1];
        int index = 0;
        for (Object part : builder) {
            if (part instanceof Range) {
                if (((Range)part).isEmpty()) continue;
                int iMax = ((Range)part).getEnd();
                int i = ((Range)part).getStart();
                while (i < iMax) {
                    baseOffsets[index++] = i++;
                }
                continue;
            }
            if (part instanceof CharSequence) {
                CharSequence sequence = (CharSequence)part;
                int iMax = sequence.length();
                for (int i = 0; i < iMax; ++i) {
                    baseOffsets[index++] = -sequence.charAt(i) - '\u0001';
                }
                continue;
            }
            if (part == null) continue;
            throw new IllegalStateException("Invalid part type " + part.getClass());
        }
        int end = baseOffsets[length - 1];
        baseOffsets[length] = end < 0 ? end - 1 : end + 1;
        int startOffset = builder.getStartOffset();
        int endOffset = builder.getEndOffset();
        boolean bl = nonBaseChars = builder.getTextLength() > 0;
        if (baseSeq.anyOptions(F_COLLECT_SEGMENTED_STATS) && (stats = (SegmentedSequenceStats)baseSeq.getOption(SEGMENTED_STATS)) != null) {
            stats.addStats(builder.noAnchorsSize(), length, baseOffsets.length * 4);
        }
        return new SegmentedSequenceFull(baseSeq, startOffset, endOffset, length, nonBaseChars, baseOffsets, baseStartOffset);
    }

    private SegmentedSequenceFull subSequence(BasedSequence baseSeq, int[] baseOffsets, int baseStartOffset, boolean nonBaseChars, int length) {
        int iMax = baseOffsets.length - 1;
        assert (baseStartOffset + length <= iMax) : "Sub-sequence offsets list length < baseStartOffset + sub-sequence length";
        int startOffset = 0;
        int endOffset = 0;
        if (!nonBaseChars) {
            startOffset = baseStartOffset < iMax ? baseOffsets[baseStartOffset] : baseSeq.getEndOffset();
            if (length == 0) {
                endOffset = startOffset;
            } else {
                endOffset = baseOffsets[baseStartOffset + length - 1] + 1;
                assert (startOffset <= endOffset);
            }
        } else {
            boolean finished = false;
            for (int iS = baseStartOffset; iS < iMax; ++iS) {
                if (baseOffsets[iS] < 0) continue;
                startOffset = baseOffsets[iS];
                if (length != 0) {
                    int iE = baseStartOffset + length;
                    while (iE-- > iS) {
                        if (baseOffsets[iE] < 0) continue;
                        endOffset = baseOffsets[iE] + 1;
                        assert (startOffset <= endOffset);
                        finished = true;
                        break;
                    }
                }
                if (!finished) {
                    endOffset = startOffset;
                }
                finished = true;
                break;
            }
            if (!finished) {
                endOffset = startOffset = baseSeq.getEndOffset();
            }
        }
        return new SegmentedSequenceFull(baseSeq, startOffset, endOffset, length, nonBaseChars, baseOffsets, baseStartOffset);
    }

    @Deprecated
    public static BasedSequence of(BasedSequence basedSequence, @NotNull Iterable<? extends BasedSequence> segments) {
        return SegmentedSequence.create(basedSequence, segments);
    }

    @Deprecated
    public static BasedSequence of(BasedSequence ... segments) {
        return SegmentedSequence.create(segments);
    }
}

