/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.DynamicSslContextProvider;
import io.grpc.xds.internal.sds.SdsClient;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SdsSecretConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.Secret;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsCertificate;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

abstract class SdsSslContextProvider
extends DynamicSslContextProvider
implements SdsClient.SecretWatcher {
    private static final Logger logger = Logger.getLogger(SdsSslContextProvider.class.getName());
    @Nullable
    private final SdsClient certSdsClient;
    @Nullable
    private final SdsClient validationContextSdsClient;
    @Nullable
    private final SdsSecretConfig certSdsConfig;
    @Nullable
    private final SdsSecretConfig validationContextSdsConfig;
    @Nullable
    protected TlsCertificate tlsCertificate;
    @Nullable
    private CertificateValidationContext certificateValidationContext;

    protected SdsSslContextProvider(Node node, SdsSecretConfig certSdsConfig, SdsSecretConfig validationContextSdsConfig, CertificateValidationContext staticCertValidationContext, Executor watcherExecutor, Executor channelExecutor, EnvoyServerProtoData.BaseTlsContext tlsContext) {
        super(tlsContext, staticCertValidationContext);
        this.certSdsConfig = certSdsConfig;
        this.validationContextSdsConfig = validationContextSdsConfig;
        if (certSdsConfig != null && certSdsConfig.isInitialized()) {
            this.certSdsClient = SdsClient.Factory.createSdsClient(certSdsConfig, node, watcherExecutor, channelExecutor);
            this.certSdsClient.start();
            this.certSdsClient.watchSecret(this);
        } else {
            this.certSdsClient = null;
        }
        if (validationContextSdsConfig != null && validationContextSdsConfig.isInitialized()) {
            this.validationContextSdsClient = SdsClient.Factory.createSdsClient(validationContextSdsConfig, node, watcherExecutor, channelExecutor);
            this.validationContextSdsClient.start();
            this.validationContextSdsClient.watchSecret(this);
        } else {
            this.validationContextSdsClient = null;
        }
    }

    @Override
    public final synchronized void onSecretChanged(Secret secretUpdate) {
        Preconditions.checkNotNull((Object)secretUpdate);
        if (secretUpdate.hasTlsCertificate()) {
            Preconditions.checkState((boolean)secretUpdate.getName().equals(this.certSdsConfig.getName()), (Object)"tlsCert names don't match");
            logger.log(Level.FINEST, "onSecretChanged certSdsConfig.name={0}", this.certSdsConfig.getName());
            this.tlsCertificate = secretUpdate.getTlsCertificate();
            if (this.certificateValidationContext != null || this.validationContextSdsConfig == null) {
                this.updateSslContext();
            }
        } else if (secretUpdate.hasValidationContext()) {
            Preconditions.checkState((boolean)secretUpdate.getName().equals(this.validationContextSdsConfig.getName()), (Object)"validationContext names don't match");
            logger.log(Level.FINEST, "onSecretChanged validationContextSdsConfig.name={0}", this.validationContextSdsConfig.getName());
            this.certificateValidationContext = secretUpdate.getValidationContext();
            if (this.tlsCertificate != null || this.certSdsConfig == null) {
                this.updateSslContext();
            }
        } else {
            throw new UnsupportedOperationException("Unexpected secret type:" + (Object)((Object)secretUpdate.getTypeCase()));
        }
    }

    @Override
    protected final CertificateValidationContext generateCertificateValidationContext() {
        if (this.staticCertificateValidationContext == null) {
            return this.certificateValidationContext;
        }
        if (this.certificateValidationContext == null) {
            return this.staticCertificateValidationContext;
        }
        CertificateValidationContext.Builder localCertContextBuilder = this.certificateValidationContext.toBuilder();
        return localCertContextBuilder.mergeFrom(this.staticCertificateValidationContext).build();
    }

    @Override
    public final void close() {
        if (this.certSdsClient != null) {
            this.certSdsClient.cancelSecretWatch(this);
            this.certSdsClient.shutdown();
        }
        if (this.validationContextSdsClient != null) {
            this.validationContextSdsClient.cancelSecretWatch(this);
            this.validationContextSdsClient.shutdown();
        }
    }
}

