/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.hdc.msjtable;

import com.mindspore.ide.toolkit.hdc.msjtable.GridBagTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GridBagTableUI
extends BasicTableUI {
    int oldHeightPaintCells;
    JTableHeader headerPaintCells;
    TableColumn draggedColumnPaintCells;
    TableColumnModel cmPaintCells;
    int columnMarginPaintCells;
    Rectangle cellRectPaintCells;
    TableColumn aColumnPaintCells;
    int columnWidthPaintCells;

    @Override
    public Dimension getPreferredSize(JComponent jc) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createTableSize(width);
    }

    private Dimension createTableSize(long width) {
        long tmp;
        int height = 0;
        int rowCount = this.table.getRowCount();
        if (rowCount > 0 && this.table.getColumnCount() > 0) {
            Rectangle re = this.table.getCellRect(rowCount - 1, 0, true);
            height = re.y + re.height;
        }
        if ((tmp = Math.abs(width)) > Integer.MAX_VALUE) {
            tmp = Integer.MAX_VALUE;
        }
        return new Dimension((int)tmp, height);
    }

    @Override
    public void paint(Graphics gr, JComponent jc) {
        Rectangle clip = gr.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            this.paintDropLines(gr);
            return;
        }
        boolean isLtr = this.table.getComponentOrientation().isLeftToRight();
        Point upperLeft = clip.getLocation();
        if (!isLtr) {
            ++upperLeft.x;
        }
        Point lowerRight = new Point(clip.x + clip.width - (isLtr ? 1 : 0), clip.y + clip.height);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint(isLtr ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(isLtr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintCells(gr, rMin, rMax, cMin, cMax);
        this.paintDropLines(gr);
    }

    private void paintDropLines(Graphics gr) {
        JTable.DropLocation loc = this.table.getDropLocation();
        if (loc == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color shortColor = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && shortColor == null) {
            return;
        }
        Rectangle inputRect = this.getHDropLineRect(loc);
        if (inputRect != null) {
            int rx = inputRect.x;
            int rw = inputRect.width;
            if (color != null) {
                this.extendRect(inputRect, true);
                gr.setColor(color);
                gr.fillRect(inputRect.x, inputRect.y, inputRect.width, inputRect.height);
            }
            if (!loc.isInsertColumn() && shortColor != null) {
                gr.setColor(shortColor);
                gr.fillRect(rx, inputRect.y, rw, inputRect.height);
            }
        }
        if ((inputRect = this.getVDropLineRect(loc)) != null) {
            int ry = inputRect.y;
            int rh = inputRect.height;
            if (color != null) {
                this.extendRect(inputRect, false);
                gr.setColor(color);
                gr.fillRect(inputRect.x, inputRect.y, inputRect.width, inputRect.height);
            }
            if (!loc.isInsertRow() && shortColor != null) {
                gr.setColor(shortColor);
                gr.fillRect(inputRect.x, ry, inputRect.width, rh);
            }
        }
    }

    private void paintGrid(Graphics gr, int rMin, int rMax, int cMin, int cMax) {
        block6: {
            int dx;
            gr.setColor(this.table.getGridColor());
            Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
            Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            if (this.table.getShowHorizontalLines()) {
                int tableWidth = damagedArea.x + damagedArea.width;
                int dy = damagedArea.y;
                for (int row = rMin; row <= rMax; ++row) {
                    gr.drawLine(damagedArea.x, (dy += this.table.getRowHeight(row)) - 1, tableWidth - 1, dy - 1);
                }
            }
            if (!this.table.getShowVerticalLines()) break block6;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                dx = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int cmw = cm.getColumn(column).getWidth();
                    gr.drawLine((dx += cmw) - 1, 0, dx - 1, tableHeight - 1);
                }
            } else {
                dx = damagedArea.x;
                for (int column = cMax; column >= cMin; --column) {
                    int cmw = cm.getColumn(column).getWidth();
                    gr.drawLine((dx += cmw) - 1, 0, dx - 1, tableHeight - 1);
                }
            }
        }
    }

    private void paintCells(Graphics gr, int rMin, int rMax, int cMin, int cMax) {
        this.headerPaintCells = this.table.getTableHeader();
        this.draggedColumnPaintCells = this.headerPaintCells == null ? null : this.headerPaintCells.getDraggedColumn();
        this.cmPaintCells = this.table.getColumnModel();
        this.columnMarginPaintCells = this.cmPaintCells.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            this.ifPaintCells(gr, rMin, rMax, cMin, cMax);
        } else {
            this.elsePaintCells(gr, rMin, rMax, cMin, cMax);
        }
        if (this.draggedColumnPaintCells != null) {
            this.paintDraggedArea(gr, rMin, rMax, this.draggedColumnPaintCells, this.headerPaintCells.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void ifPaintCells(Graphics gr, int rMin, int rMax, int cMin, int cMax) {
        for (int row = rMin; row <= rMax; ++row) {
            this.cellRectPaintCells = this.table instanceof GridBagTable ? ((GridBagTable)this.table).getGridCellRect(row, cMin, false) : this.table.getCellRect(row, cMin, false);
            for (int column = cMin; column <= cMax; ++column) {
                this.aColumnPaintCells = this.cmPaintCells.getColumn(column);
                this.columnWidthPaintCells = this.aColumnPaintCells.getWidth();
                this.cellRectPaintCells.width = this.columnWidthPaintCells - this.columnMarginPaintCells;
                this.oldHeightPaintCells = this.cellRectPaintCells.height;
                this.ifPaintCellsTwo(row, column);
                if (this.aColumnPaintCells != this.draggedColumnPaintCells) {
                    this.paintCell(gr, this.cellRectPaintCells, row, column);
                }
                this.cellRectPaintCells.height = this.oldHeightPaintCells;
                this.cellRectPaintCells.x += this.columnWidthPaintCells;
            }
        }
    }

    private void ifPaintCellsTwo(int row, int column) {
        if (this.table instanceof GridBagTable) {
            GridBagTable gridBagTable = (GridBagTable)this.table;
            if (gridBagTable.getGridBagModel().getCellState(row, column) == -1) {
                this.cellRectPaintCells.width = 0;
                this.cellRectPaintCells.height = 0;
            } else {
                this.ifPaintCellsThree(row, column, gridBagTable);
            }
        }
    }

    private void ifPaintCellsThree(int row, int column, GridBagTable gridBagTable) {
        int vr;
        int th = gridBagTable.getGridBagModel().getColumnGrid(row, column);
        if (th > 1) {
            for (int n = 1; n < th; ++n) {
                this.cellRectPaintCells.width += this.cmPaintCells.getColumn(column + n).getWidth();
            }
        }
        if ((vr = gridBagTable.getGridBagModel().getRowGrid(row, column)) > 1) {
            for (int n = 1; n < vr; ++n) {
                this.cellRectPaintCells.height += this.table.getRowHeight(row + n);
            }
        }
    }

    private void elsePaintCells(Graphics gr, int rMin, int rMax, int cMin, int cMax) {
        for (int row = rMin; row <= rMax; ++row) {
            this.cellRectPaintCells = this.table.getCellRect(row, cMin, false);
            this.aColumnPaintCells = this.cmPaintCells.getColumn(cMin);
            if (this.aColumnPaintCells != this.draggedColumnPaintCells) {
                this.columnWidthPaintCells = this.aColumnPaintCells.getWidth();
                this.cellRectPaintCells.width = this.columnWidthPaintCells - this.columnMarginPaintCells;
                this.paintCell(gr, this.cellRectPaintCells, row, cMin);
            }
            for (int column = cMin + 1; column <= cMax; ++column) {
                this.aColumnPaintCells = this.cmPaintCells.getColumn(column);
                this.columnWidthPaintCells = this.aColumnPaintCells.getWidth();
                this.cellRectPaintCells.width = this.columnWidthPaintCells - this.columnMarginPaintCells;
                this.cellRectPaintCells.x -= this.columnWidthPaintCells;
                if (this.aColumnPaintCells == this.draggedColumnPaintCells) continue;
                this.paintCell(gr, this.cellRectPaintCells, row, column);
            }
        }
    }

    private void paintCell(Graphics gr, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(BorderFactory.createLineBorder(Color.gray));
            }
            this.rendererPane.paintComponent(gr, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return new Rectangle();
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        if (col >= this.table.getColumnCount()) {
            --col;
        }
        Rectangle rect = this.table.getCellRect(row, col, true);
        if (row >= this.table.getRowCount()) {
            Rectangle prevRect = this.table.getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    private void paintDraggedArea(Graphics gr, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        gr.setColor(this.table.getParent().getBackground());
        gr.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        gr.setColor(this.table.getBackground());
        gr.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            gr.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            gr.drawLine(x1 - 1, y1, x1 - 1, y2);
            gr.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle re = this.table.getCellRect(row, draggedColumnIndex, false);
            re.x += distance;
            this.paintCell(gr, re, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            gr.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            gr.drawLine(x1, y2, x2, y2);
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private Rectangle extendRect(Rectangle rect, boolean isHorizontal) {
        if (rect == null) {
            return rect;
        }
        if (isHorizontal) {
            rect.x = 0;
            rect.width = this.table.getWidth();
        } else {
            rect.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle lastRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rect.height = lastRect.y + lastRect.height;
            } else {
                rect.height = this.table.getHeight();
            }
        }
        return rect;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return new Rectangle();
        }
        boolean isLtr = this.table.getComponentOrientation().isLeftToRight();
        int col = loc.getColumn();
        Rectangle rect = this.table.getCellRect(loc.getRow(), col, true);
        if (col >= this.table.getColumnCount()) {
            rect = this.table.getCellRect(loc.getRow(), --col, true);
            if (isLtr) {
                rect.x += rect.width;
            }
        } else if (!isLtr) {
            rect.x += rect.width;
        } else {
            rect.getX();
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
        return rect;
    }
}

