/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static void writeFile(String filePath, InputStream input) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        FileUtils.createDirectories(path);
        try (FileChannel outChannel = new RandomAccessFile(filePath, "rw").getChannel();
             ReadableByteChannel inChannel = Channels.newChannel(input);){
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            while (inChannel.read(buffer) != -1) {
                buffer.flip();
                outChannel.write(buffer);
                buffer.clear();
            }
        }
    }

    public static boolean hideFile(File file) {
        try {
            Path path = file.toPath();
            Files.setAttribute(path, "dos:hidden", Boolean.TRUE, new LinkOption[0]);
        }
        catch (IOException exception) {
            log.info("hide file fail");
            return false;
        }
        return true;
    }

    public static File getFile(String filePath) {
        return new File(filePath);
    }

    public static File toFile(String resourceName) {
        URL url = FileUtils.class.getResource(resourceName);
        if (url == null) {
            return null;
        }
        return new File(url.getFile());
    }

    public static void writeDataToFile(Path path, String data) throws IOException {
        FileUtils.createDirectories(path);
        Files.write(path, data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static void createDirectories(Path path) throws IOException {
        Path parentPath = path.getParent();
        if (parentPath != null && !Files.exists(parentPath, new LinkOption[0])) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
    }

    public static Optional<String> loadDataFromFile(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            return Optional.of(new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
        }
        return Optional.empty();
    }

    public static boolean fileExist(String filePath) {
        return FileUtils.getFile(filePath).exists();
    }

    public static boolean fileLsExists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public static boolean isFile(String path) {
        if (path == null || path.equals("")) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static void createFile(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        Path parentPath = path.getParent();
        if (parentPath != null) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
        Files.createDirectories(path, new FileAttribute[0]);
    }

    public static boolean touchFile(String path) {
        if (FileUtils.fileLsExists(path)) {
            return true;
        }
        try {
            FileUtils.createFile(path);
            return true;
        }
        catch (IOException exception) {
            log.warn("create file failed with error{}", (Object)exception.getMessage());
            return false;
        }
    }

    public static boolean touchDir(String dirPath) {
        Path path = Paths.get(dirPath, new String[0]);
        if (Files.notExists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException exception) {
                log.warn("create directory failed with error{}", (Object)exception.getMessage());
                return false;
            }
        }
        return true;
    }

    public static Optional<String> readFileContent(String filePath) throws IOException {
        if (!FileUtils.fileLsExists(filePath)) {
            return Optional.empty();
        }
        Path path = Paths.get(filePath, new String[0]);
        return Optional.of(new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
    }

    public static void deleteDir(String path) throws IOException {
        Path directory = Paths.get(path, new String[0]);
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static Set<String> listAllDirectory(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptySet();
        }
        return Files.list(path).filter(item -> item != null && Files.isDirectory(item, new LinkOption[0]) && item.getFileName() != null).map(item -> item.getFileName().toString()).collect(Collectors.toSet());
    }

    public static Set<String> listAllFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptySet();
        }
        return Files.list(path).filter(item -> item != null && !Files.isDirectory(item, new LinkOption[0]) && item.getFileName() != null).map(item -> item.getFileName().toString()).collect(Collectors.toSet());
    }

    public static boolean deleteFile(File file) {
        File[] files;
        if (file == null) {
            return false;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            Arrays.stream(files).forEach(FileUtils::deleteFile);
        }
        return file.delete();
    }

    public static boolean isSame(@NotNull Path oldPath, @NotNull Path newPath) {
        if (oldPath == null) {
            FileUtils.$$$reportNull$$$0(0);
        }
        if (newPath == null) {
            FileUtils.$$$reportNull$$$0(1);
        }
        try {
            List<String> oldList = Files.readAllLines(oldPath);
            List<String> newList = Files.readAllLines(newPath);
            return Objects.equals(oldList, newList);
        }
        catch (IOException ioException) {
            log.warn("Read file failed.", (Throwable)ioException);
            return false;
        }
    }

    public static boolean rename(String oldFilePath, String newFilePath) {
        File oldFile = new File(oldFilePath);
        File newFile = new File(newFilePath);
        if (!newFile.exists()) {
            return false;
        }
        if (!oldFile.exists()) {
            return newFile.renameTo(oldFile);
        }
        if (oldFile.delete()) {
            return newFile.renameTo(oldFile);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "oldPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "newPath";
                break;
            }
        }
        objectArray[1] = "com/mindspore/ide/toolkit/common/utils/FileUtils";
        objectArray[2] = "isSame";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

