/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.wizard;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.mindspore.ide.toolkit.common.dialoginfo.DialogInfo;
import com.mindspore.ide.toolkit.common.dialoginfo.ExceptionDialogInfo;
import com.mindspore.ide.toolkit.common.exceptions.MsToolKitException;
import com.mindspore.ide.toolkit.common.utils.VersionUtils;
import com.mindspore.ide.toolkit.wizard.CondaCmdProcessor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsCondaEnvService {
    private static final Logger log = LoggerFactory.getLogger(MsCondaEnvService.class);

    public static Sdk newSdk(String condaExecutor, String condaEnvPath, String version) {
        String name = Paths.get(condaEnvPath, new String[0]).getFileName().toString();
        if (!Files.exists(Paths.get(condaEnvPath, new String[0]), new LinkOption[0])) {
            try {
                CondaCmdProcessor.executeCondaCmd(null, condaExecutor, Arrays.asList("env", "list", "-q"));
                DialogInfo dialogInfo = MsCondaEnvService.createCondaEnv(condaExecutor, condaEnvPath, version);
                dialogInfo.showDialog("Create conda environment");
            }
            catch (MsToolKitException msToolKitException) {
                ExceptionDialogInfo.parseException(msToolKitException, new Object[0]).showDialog("Create conda environment");
            }
        }
        ProjectJdkImpl sdk = new ProjectJdkImpl(name, (SdkTypeId)PythonSdkType.getInstance());
        sdk.setHomePath(PythonSdkUtil.getPythonExecutable((String)condaEnvPath));
        PythonSdkAdditionalData additionalData = new PythonSdkAdditionalData((PythonSdkFlavor)CondaEnvSdkFlavor.getInstance());
        sdk.setSdkAdditionalData((SdkAdditionalData)additionalData);
        return sdk;
    }

    public static PyLazySdk newLazySdk(String condaExecutor, String condaEnvPath, String version) {
        String name = Paths.get(condaEnvPath, new String[0]).getFileName().toString();
        return new PyLazySdk(name, () -> {
            Task.WithResult<Sdk, Exception> newSdkTask = MsCondaEnvService.newSdkTask(condaExecutor, condaEnvPath, version);
            return (Sdk)ProgressManager.getInstance().run(newSdkTask);
        });
    }

    public static Task.WithResult<Sdk, Exception> newSdkTask(final String condaExecutor, final String condaEnvPath, final String version) {
        return new Task.WithResult(null, "Createconda environment", true){

            protected Sdk compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return MsCondaEnvService.newSdk(condaExecutor, condaEnvPath, version);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/mindspore/ide/toolkit/wizard/MsCondaEnvService$1", "compute"));
            }
        };
    }

    public static Long setSdk(Project project, Module module, Sdk sdk, boolean isNewSdk) {
        if (VersionUtils.getIdeBaselineVersion() >= 203) {
            PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining((Sdk)sdk, (Project)project);
        }
        return VirtualFileManager.getInstance().asyncRefresh(() -> {
            PySdkUtil.activateVirtualEnv((Sdk)sdk);
            if (isNewSdk) {
                ProjectJdkTable.getInstance().addJdk(sdk);
            }
            ProjectRootManager.getInstance((Project)project).setProjectSdk(sdk);
            PySdkExtKt.setPythonSdk((Project)project, (Sdk)sdk);
            PySdkExtKt.setPythonSdk((Module)module, (Sdk)sdk);
        });
    }

    public static Task.WithResult<Long, Exception> setSdkTask(final Project project, final Module module, final Sdk sdk, final boolean isNewSdk) {
        return new Task.WithResult(project, "Refresh Sdk", true){

            protected Long compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return MsCondaEnvService.setSdk(project, module, sdk, isNewSdk);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/mindspore/ide/toolkit/wizard/MsCondaEnvService$2", "compute"));
            }
        };
    }

    public static boolean isValid(Sdk sdk) {
        return sdk != null && sdk.getHomePath() != null;
    }

    private static DialogInfo createCondaEnv(String condaExecutable, String condaEnvPath, String version) throws MsToolKitException {
        if (condaExecutable == null || condaEnvPath == null || version == null) {
            log.info("create conda environment failed. condaExecutable: {}, condaEnvPath: {}, version: {}", new Object[]{condaExecutable, condaEnvPath, version});
            return new ExceptionDialogInfo.Builder().isSuccessful(false).description("conda executable or env path or version is null").output("").build();
        }
        List<String> cmdList = Arrays.asList("create", "-p", condaEnvPath, "-y", "python=" + version);
        return CondaCmdProcessor.executeCondaCmd(null, condaExecutable, cmdList);
    }
}

