/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.common.dialoginfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.sdk.PythonSdkType;
import com.mindspore.ide.toolkit.common.dialoginfo.DialogInfo;
import com.mindspore.ide.toolkit.common.enums.EnumProperties;
import com.mindspore.ide.toolkit.common.exceptions.MsToolKitException;
import com.mindspore.ide.toolkit.ui.errordialog.ExceptionDialog;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionDialogInfo
extends DialogInfo {
    private static final Pattern ERROR_PATTERN = Pattern.compile(".*error:.*", 2);
    private String description;
    private String command;
    private String output;
    private String solution;

    private ExceptionDialogInfo(Builder builder) {
        this.setSuccessful(builder.isSuccessful);
        this.setTitle(builder.title);
        this.description = builder.description;
        this.command = builder.command;
        this.output = builder.output;
        this.solution = builder.solution;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    @Override
    public void showDialog() {
        if (this.isSuccessful()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> this.showDialogSync());
    }

    public static ExceptionDialogInfo parseException(@NotNull Exception exception, Object ... extraArgs) {
        if (exception == null) {
            ExceptionDialogInfo.$$$reportNull$$$0(0);
        }
        if (exception instanceof PyExecutionException) {
            return ExceptionDialogInfo.parsePyExecutionException(exception, extraArgs);
        }
        if (exception instanceof MsToolKitException) {
            MsToolKitException msToolKitException = (MsToolKitException)exception;
            String errMsg = msToolKitException.getErrMsg();
            if (errMsg != null) {
                return new Builder().description(errMsg).solution(msToolKitException.getSolution()).build();
            }
        } else {
            String errMessage = exception.getMessage();
            if (errMessage != null) {
                return new Builder().description(errMessage).build();
            }
        }
        return new Builder().description("Unknown exception").build();
    }

    private static ExceptionDialogInfo parsePyExecutionException(Exception exception, Object ... extraArgs) {
        Object obj;
        if (!(exception instanceof PyExecutionException)) {
            return new Builder().description("Unknown exception").build();
        }
        Sdk sdk = null;
        if (extraArgs != null && extraArgs.length == 1 && (obj = extraArgs[0]) instanceof Sdk) {
            sdk = (Sdk)obj;
        }
        PyExecutionException pyExecutionException = (PyExecutionException)exception;
        String stdoutReason = ExceptionDialogInfo.findErrorReason(pyExecutionException.getStdout());
        String stderrReason = ExceptionDialogInfo.findErrorReason(pyExecutionException.getStderr());
        String reason = stdoutReason == null ? stderrReason : stdoutReason;
        String message = reason == null ? pyExecutionException.getMessage() : reason;
        String command = pyExecutionException.getCommand() + " " + StringUtil.join((Collection)pyExecutionException.getArgs(), (String)" ");
        String solution = ExceptionDialogInfo.getPyExecutionErrorSolution(pyExecutionException, reason, sdk);
        String output = pyExecutionException.getStdout() + System.lineSeparator() + pyExecutionException.getStderr();
        return new Builder().description(message).command(command).output(output).solution(solution).build();
    }

    @Nullable
    private static String findErrorReason(@NotNull String errorStr) {
        Matcher matcher;
        if (errorStr == null) {
            ExceptionDialogInfo.$$$reportNull$$$0(1);
        }
        if ((matcher = ERROR_PATTERN.matcher(errorStr)).find()) {
            String result = matcher.group();
            return result == null ? null : result.trim();
        }
        return null;
    }

    @Nullable
    private static String getPyExecutionErrorSolution(@NotNull PyExecutionException pyExecutionException, @Nullable String reason, @Nullable Sdk sdk) {
        if (pyExecutionException == null) {
            ExceptionDialogInfo.$$$reportNull$$$0(2);
        }
        if (reason != null) {
            return ExceptionDialogInfo.getPyExecutionErrorSolutionFromReason(reason, sdk);
        }
        if (SystemInfo.isLinux && (ExceptionDialogInfo.containsInOutOrErr(pyExecutionException, "pyconfig.h") || ExceptionDialogInfo.containsInOutOrErr(pyExecutionException, "Python.h"))) {
            return EnumProperties.EXCEPTION_SOLUTION_PROPERTIES.getProperty("install.python.into.computer");
        }
        if ("pip".equals(pyExecutionException.getCommand())) {
            if (sdk == null) {
                return EnumProperties.EXCEPTION_SOLUTION_PROPERTIES.getProperty("has.pip.in.python.interpreter");
            }
            return EnumProperties.EXCEPTION_SOLUTION_PROPERTIES.getProperty("has.pip.in.python.interpreter.locate", sdk.getHomePath());
        }
        return null;
    }

    private static boolean containsInOutOrErr(@NotNull PyExecutionException pyExecutionException, @NotNull String what) {
        if (pyExecutionException == null) {
            ExceptionDialogInfo.$$$reportNull$$$0(3);
        }
        if (what == null) {
            ExceptionDialogInfo.$$$reportNull$$$0(4);
        }
        return StringUtil.containsIgnoreCase((String)pyExecutionException.getStdout(), (String)what) || StringUtil.containsIgnoreCase((String)pyExecutionException.getStderr(), (String)what);
    }

    @Nullable
    private static String getPyExecutionErrorSolutionFromReason(String reason, Sdk sdk) {
        if (StringUtil.containsIgnoreCase((String)reason, (String)"CondaHTTPError")) {
            return EnumProperties.EXCEPTION_SOLUTION_PROPERTIES.getProperty("check.network");
        }
        if (StringUtil.containsIgnoreCase((String)reason, (String)"proxy")) {
            return EnumProperties.EXCEPTION_SOLUTION_PROPERTIES.getProperty("check.conda.proxy");
        }
        if (StringUtil.containsIgnoreCase((String)reason, (String)"SyntaxError")) {
            if (sdk == null) {
                return EnumProperties.EXCEPTION_SOLUTION_PROPERTIES.getProperty("use.right.python");
            }
            return EnumProperties.EXCEPTION_SOLUTION_PROPERTIES.getProperty("use.right.python.version", PythonSdkType.getLanguageLevelForSdk((Sdk)sdk));
        }
        return null;
    }

    private void showDialogSync() {
        String defaultTitle = "Something wrong";
        String title = this.getTitle();
        StringBuilder messageSb = new StringBuilder();
        if (title == null || title.equals("")) {
            messageSb.append(defaultTitle);
            title = defaultTitle;
        } else {
            messageSb.append(title).append(" failed.");
        }
        if (this.solution != null && !this.solution.equals("")) {
            messageSb.append(System.lineSeparator()).append(this.solution);
        }
        messageSb.append(System.lineSeparator()).append(System.lineSeparator()).append("Do you want to check error message?");
        int choiceCode = Messages.showYesNoDialog((String)messageSb.toString(), (String)title, (Icon)Messages.getErrorIcon());
        if (choiceCode == 0) {
            new ExceptionDialog(this).show();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorStr";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyExecutionException";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
        }
        objectArray2[1] = "com/mindspore/ide/toolkit/common/dialoginfo/ExceptionDialogInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseException";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findErrorReason";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPyExecutionErrorSolution";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "containsInOutOrErr";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Builder {
        private boolean isSuccessful;
        private String title;
        private String description;
        private String command;
        private String output;
        private String solution;

        public ExceptionDialogInfo build() {
            return new ExceptionDialogInfo(this);
        }

        public Builder isSuccessful(boolean isSuccessful) {
            this.isSuccessful = isSuccessful;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder command(String command) {
            this.command = command;
            return this;
        }

        public Builder output(String output) {
            this.output = output;
            return this;
        }

        public Builder solution(String solution) {
            this.solution = solution;
            return this;
        }
    }
}

