/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.youtrack.converter;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.youtrack.converter.internal.YouTrackConverterNodeRenderer;
import org.jetbrains.annotations.NotNull;

public class YouTrackConverterExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension {
    private YouTrackConverterExtension() {
    }

    public static YouTrackConverterExtension create() {
        return new YouTrackConverterExtension();
    }

    public void extend(Parser.Builder parserBuilder) {
    }

    public void rendererOptions(@NotNull MutableDataHolder options) {
        String rendererType = (String)HtmlRenderer.TYPE.get((DataHolder)options);
        if (rendererType.equals("HTML")) {
            HtmlRenderer.addRenderTypeEquivalence((MutableDataHolder)options, (String)"YOUTRACK", (String)"JIRA");
            options.set(HtmlRenderer.TYPE, (Object)"YOUTRACK");
        } else if (!rendererType.equals("YOUTRACK")) {
            throw new IllegalStateException("Non HTML Renderer is already set to " + rendererType);
        }
    }

    public void parserOptions(MutableDataHolder options) {
    }

    public void extend(@NotNull HtmlRenderer.Builder htmlRendererBuilder, @NotNull String rendererType) {
        if (!htmlRendererBuilder.isRendererType("YOUTRACK")) {
            throw new IllegalStateException("YouTrack Converter Extension used with non YouTrack Renderer " + rendererType);
        }
        htmlRendererBuilder.nodeRendererFactory((NodeRendererFactory)new YouTrackConverterNodeRenderer.Factory());
    }
}

