/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.internal.sds.FileBasedPluginCredential;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.DiscoveryRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.DiscoveryResponse;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.ApiConfigSource;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.ConfigSource;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.GrpcService;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SdsSecretConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.Secret;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v2.SecretDiscoveryServiceGrpc;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class SdsClient {
    private static final Logger logger = Logger.getLogger(SdsClient.class.getName());
    private static final String SECRET_TYPE_URL = "type.googleapis.com/envoy.api.v2.auth.Secret";
    private static final EventLoopGroupResource eventLoopGroupResource = Epoll.isAvailable() ? new EventLoopGroupResource("SdsClient") : null;
    private SecretWatcher watcher;
    private final SdsSecretConfig sdsSecretConfig;
    private final Node clientNode;
    private final Executor watcherExecutor;
    private final CallCredentials callCredentials;
    private EventLoopGroup eventLoopGroup;
    private ManagedChannel channel;
    private SecretDiscoveryServiceGrpc.SecretDiscoveryServiceStub secretDiscoveryServiceStub;
    private ResponseObserver responseObserver;
    private StreamObserver<DiscoveryRequest> requestObserver;
    private DiscoveryResponse lastResponse;

    private SdsClient(SdsSecretConfig sdsSecretConfig, Node node, Executor watcherExecutor, ManagedChannel channel, EventLoopGroup eventLoopGroup, CallCredentials callCredentials) {
        Preconditions.checkNotNull((Object)sdsSecretConfig, (Object)"sdsSecretConfig");
        Preconditions.checkNotNull((Object)node, (Object)"node");
        this.sdsSecretConfig = sdsSecretConfig;
        this.clientNode = node;
        this.watcherExecutor = watcherExecutor;
        this.eventLoopGroup = eventLoopGroup;
        Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.channel = channel;
        this.callCredentials = callCredentials;
    }

    void start() {
        if (this.requestObserver == null) {
            this.secretDiscoveryServiceStub = SecretDiscoveryServiceGrpc.newStub((Channel)this.channel);
            if (this.callCredentials != null) {
                this.secretDiscoveryServiceStub = (SecretDiscoveryServiceGrpc.SecretDiscoveryServiceStub)this.secretDiscoveryServiceStub.withCallCredentials(this.callCredentials);
            }
            this.responseObserver = new ResponseObserver();
            this.requestObserver = this.secretDiscoveryServiceStub.streamSecrets(this.responseObserver);
            logger.log(Level.FINEST, "Stream created for {0}", this.sdsSecretConfig);
        }
    }

    void shutdown() {
        if (this.requestObserver != null) {
            this.requestObserver.onCompleted();
            this.requestObserver = null;
            this.channel.shutdownNow();
            if (this.eventLoopGroup != null) {
                this.eventLoopGroup = (EventLoopGroup)SharedResourceHolder.release((SharedResourceHolder.Resource)eventLoopGroupResource, (Object)this.eventLoopGroup);
            }
        }
    }

    private void processDiscoveryResponse(final DiscoveryResponse response) {
        this.watcherExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SdsClient.this.processSecretsFromDiscoveryResponse(response);
                }
                catch (Throwable exceptionSeen) {
                    SdsClient.this.sendNack(exceptionSeen);
                    return;
                }
                SdsClient.this.lastResponse = response;
                SdsClient.this.sendDiscoveryRequestOnStream();
            }
        });
    }

    private void sendNack(Throwable exceptionSeen) {
        String nonce = "";
        String versionInfo = "";
        if (this.lastResponse != null) {
            nonce = this.lastResponse.getNonce();
            versionInfo = this.lastResponse.getVersionInfo();
        }
        Status grpcStatus = Status.fromThrowable((Throwable)exceptionSeen);
        DiscoveryRequest.Builder builder = DiscoveryRequest.newBuilder().setTypeUrl(SECRET_TYPE_URL).setResponseNonce(nonce).setVersionInfo(versionInfo).addResourceNames(this.sdsSecretConfig.getName()).setErrorDetail(com.google.rpc.Status.newBuilder().setCode(grpcStatus.getCode().value()).setMessage(grpcStatus.getDescription() != null ? grpcStatus.getDescription() : "Secret not updated").build()).setNode(this.clientNode);
        DiscoveryRequest req = builder.build();
        logger.log(Level.FINEST, "Sending NACK req={0}", req);
        this.requestObserver.onNext((Object)req);
    }

    private void sendErrorToWatcher(final Throwable t) {
        final SecretWatcher localCopy = this.watcher;
        if (localCopy != null) {
            this.watcherExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        localCopy.onError(Status.fromThrowable((Throwable)t));
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.SEVERE, "exception from onError", throwable);
                    }
                }
            });
        }
    }

    private void processSecretsFromDiscoveryResponse(DiscoveryResponse response) throws InvalidProtocolBufferException {
        List<Any> resources = response.getResourcesList();
        Preconditions.checkState((resources.size() == 1 ? 1 : 0) != 0, (Object)"exactly one resource expected");
        Any any = resources.get(0);
        String typeUrl = any.getTypeUrl();
        Preconditions.checkState((boolean)SECRET_TYPE_URL.equals(typeUrl), (String)"wrong value for typeUrl %s", (Object)typeUrl);
        Secret secret = Secret.parseFrom(any.getValue());
        this.processSecret(secret);
    }

    private void processSecret(Secret secret) {
        Preconditions.checkState((boolean)this.sdsSecretConfig.getName().equals(secret.getName()), (String)"expected secret name %s", (Object)this.sdsSecretConfig.getName());
        SecretWatcher localCopy = this.watcher;
        if (localCopy != null) {
            localCopy.onSecretChanged(secret);
        }
    }

    void watchSecret(SecretWatcher secretWatcher) {
        Preconditions.checkNotNull((Object)secretWatcher, (Object)"secretWatcher");
        Preconditions.checkState((this.watcher == null ? 1 : 0) != 0, (Object)"watcher already set");
        this.watcher = secretWatcher;
        if (this.lastResponse == null) {
            this.sendDiscoveryRequestOnStream();
        } else {
            this.watcherExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        SdsClient.this.processSecretsFromDiscoveryResponse(SdsClient.this.lastResponse);
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.SEVERE, "from watcherExecutor.execute", throwable);
                    }
                }
            });
        }
    }

    void cancelSecretWatch(SecretWatcher secretWatcher) {
        Preconditions.checkNotNull((Object)secretWatcher, (Object)"secretWatcher");
        Preconditions.checkArgument((secretWatcher == this.watcher ? 1 : 0) != 0, (Object)"Incorrect secretWatcher to cancel");
        this.watcher = null;
    }

    private void sendDiscoveryRequestOnStream() {
        String nonce = "";
        String versionInfo = "";
        String requestType = "Sending initial req={0}";
        if (this.lastResponse != null) {
            nonce = this.lastResponse.getNonce();
            versionInfo = this.lastResponse.getVersionInfo();
            requestType = "Sending ACK req={0}";
        }
        DiscoveryRequest.Builder builder = DiscoveryRequest.newBuilder().setTypeUrl(SECRET_TYPE_URL).setResponseNonce(nonce).setVersionInfo(versionInfo).addResourceNames(this.sdsSecretConfig.getName()).setNode(this.clientNode);
        DiscoveryRequest req = builder.build();
        logger.log(Level.FINEST, requestType, req);
        this.requestObserver.onNext((Object)req);
    }

    private static final class EventLoopGroupResource
    implements SharedResourceHolder.Resource<EventLoopGroup> {
        private final String name;

        EventLoopGroupResource(String name) {
            this.name = name;
        }

        public EventLoopGroup create() {
            DefaultThreadFactory threadFactory = new DefaultThreadFactory(this.name, true);
            return new EpollEventLoopGroup(1, (ThreadFactory)threadFactory);
        }

        public void close(EventLoopGroup instance) {
            try {
                instance.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).sync();
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "from EventLoopGroup.shutdownGracefully", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    static interface SecretWatcher {
        public void onSecretChanged(Secret var1);

        public void onError(Status var1);
    }

    private final class ResponseObserver
    implements StreamObserver<DiscoveryResponse> {
        ResponseObserver() {
        }

        public void onNext(DiscoveryResponse discoveryResponse) {
            logger.log(Level.FINEST, "response={0}", discoveryResponse);
            SdsClient.this.processDiscoveryResponse(discoveryResponse);
        }

        public void onError(Throwable t) {
            SdsClient.this.sendErrorToWatcher(t);
        }

        public void onCompleted() {
            logger.warning("Stream unexpectedly completed.");
        }
    }

    @VisibleForTesting
    static final class ChannelInfo {
        @VisibleForTesting
        final String targetUri;
        @VisibleForTesting
        final String channelType;
        @VisibleForTesting
        final CallCredentials callCredentials;

        private ChannelInfo(String targetUri, String channelType, CallCredentials callCredentials) {
            this.targetUri = targetUri;
            this.channelType = channelType;
            this.callCredentials = callCredentials;
        }
    }

    static class Factory {
        Factory() {
        }

        static SdsClient createSdsClient(SdsSecretConfig sdsSecretConfig, Node node, Executor watcherExecutor, Executor channelExecutor) {
            NettyChannelBuilder builder;
            ChannelInfo channelInfo = Factory.extractChannelInfo(sdsSecretConfig.getSdsConfig());
            String targetUri = channelInfo.targetUri;
            String channelType = channelInfo.channelType;
            if (channelType != null && channelType.startsWith("inproc")) {
                ManagedChannel channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)targetUri).executor(channelExecutor)).build();
                return new SdsClient(sdsSecretConfig, node, watcherExecutor, channel, null, channelInfo.callCredentials);
            }
            EventLoopGroup eventLoopGroup = null;
            if (targetUri.startsWith("unix:")) {
                Preconditions.checkState((boolean)Epoll.isAvailable(), (Object)"Epoll is not available");
                eventLoopGroup = (EventLoopGroup)SharedResourceHolder.get((SharedResourceHolder.Resource)eventLoopGroupResource);
                builder = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(targetUri.substring(5))).eventLoopGroup(eventLoopGroup).channelType(EpollDomainSocketChannel.class);
            } else {
                builder = NettyChannelBuilder.forTarget((String)targetUri);
            }
            builder = builder.usePlaintext();
            if (channelExecutor != null) {
                builder = (NettyChannelBuilder)builder.executor(channelExecutor);
            }
            ManagedChannel channel = builder.build();
            return new SdsClient(sdsSecretConfig, node, watcherExecutor, channel, eventLoopGroup, channelInfo.callCredentials);
        }

        @VisibleForTesting
        static ChannelInfo extractChannelInfo(ConfigSource configSource) {
            Preconditions.checkNotNull((Object)configSource, (Object)"configSource");
            Preconditions.checkArgument((boolean)configSource.hasApiConfigSource(), (Object)"only configSource with ApiConfigSource supported");
            ApiConfigSource apiConfigSource = configSource.getApiConfigSource();
            Preconditions.checkArgument((boolean)ApiConfigSource.ApiType.GRPC.equals((Object)apiConfigSource.getApiType()), (Object)"only GRPC ApiConfigSource type supported");
            Preconditions.checkArgument((apiConfigSource.getGrpcServicesCount() == 1 ? 1 : 0) != 0, (Object)"expecting exactly 1 GrpcService in ApiConfigSource");
            GrpcService grpcService = apiConfigSource.getGrpcServices(0);
            Preconditions.checkArgument((grpcService.hasGoogleGrpc() && !grpcService.hasEnvoyGrpc() ? 1 : 0) != 0, (Object)"only GoogleGrpc expected in GrpcService");
            GrpcService.GoogleGrpc googleGrpc = grpcService.getGoogleGrpc();
            CallCredentials callCredentials = Factory.getVerifiedCredentials(googleGrpc);
            String targetUri = googleGrpc.getTargetUri();
            String channelType = null;
            if (googleGrpc.hasConfig()) {
                Struct struct = googleGrpc.getConfig();
                Value value = (Value)struct.getFieldsMap().get("channelType");
                channelType = value.getStringValue();
            }
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)targetUri) ? 1 : 0) != 0, (Object)"targetUri in GoogleGrpc is empty!");
            return new ChannelInfo(targetUri, channelType, callCredentials);
        }

        private static CallCredentials getVerifiedCredentials(GrpcService.GoogleGrpc googleGrpc) {
            String credentialsFactoryName = googleGrpc.getCredentialsFactoryName();
            if (credentialsFactoryName.isEmpty()) {
                Preconditions.checkArgument((!googleGrpc.hasChannelCredentials() && googleGrpc.getCallCredentialsCount() == 0 ? 1 : 0) != 0, (Object)"No credentials supported in GoogleGrpc");
                logger.warning("No CallCredentials specified.");
                return null;
            }
            Preconditions.checkArgument((boolean)credentialsFactoryName.equals("envoy.grpc_credentials.file_based_metadata"), (String)"factory name should be %s", (Object)"envoy.grpc_credentials.file_based_metadata");
            if (googleGrpc.hasChannelCredentials()) {
                Preconditions.checkArgument((boolean)googleGrpc.getChannelCredentials().hasLocalCredentials(), (Object)"only GoogleLocalCredentials supported");
            }
            if (googleGrpc.getCallCredentialsCount() > 0) {
                Preconditions.checkArgument((googleGrpc.getCallCredentialsCount() == 1 ? 1 : 0) != 0, (Object)"Exactly one CallCredential expected in GoogleGrpc");
                GrpcService.GoogleGrpc.CallCredentials callCreds = googleGrpc.getCallCredentials(0);
                Preconditions.checkArgument((boolean)callCreds.hasFromPlugin(), (Object)"only plugin credential supported");
                return new FileBasedPluginCredential(callCreds.getFromPlugin());
            }
            logger.warning("No CallCredentials specified.");
            return null;
        }
    }
}

