/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.smartcomplete.grpc;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;

public class PortUtil {
    private static final int INVALID_PORT = 0;
    private static final int MIN_VALID_PORT = 5001;
    private static final int MAX_VALID_PORT = 65535;

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortIdle(int port) {
        try (ServerSocket serverSocket = new ServerSocket(port);){
            DatagramSocket datagramSocket = new DatagramSocket(port);
            try {
                serverSocket.setReuseAddress(true);
                datagramSocket.setReuseAddress(true);
                boolean bl = true;
                datagramSocket.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    datagramSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioException) {
            return false;
        }
    }

    public static int findAnIdlePort(int port) {
        int validPort = port;
        if (port < 5001 || port > 65535) {
            validPort = 5001;
        }
        int tryNums = 10;
        for (int index = 0; index < tryNums; ++index) {
            if (validPort + 2 * index > 65535) {
                return 0;
            }
            if (!PortUtil.isPortIdle(validPort + 2 * index)) continue;
            return validPort + 2 * index;
        }
        return 0;
    }
}

