/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.smartcomplete;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.mindspore.ide.toolkit.common.events.SmartCompleteEvents;
import com.mindspore.ide.toolkit.protomessage.CompleteReply;
import com.mindspore.ide.toolkit.protomessage.ResultEntries;
import com.mindspore.ide.toolkit.protomessage.ResultEntry;
import com.mindspore.ide.toolkit.services.complete.MindSporeLookupElement;
import com.mindspore.ide.toolkit.smartcomplete.ModelManager;
import com.mindspore.ide.toolkit.smartcomplete.grpc.CompletionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CompleteService {
    COMPLETE;

    private static final Logger log;

    public void onPredicting(SmartCompleteEvents.CodeRecommendStart codeRecommendStart) {
        String formattedContent = this.getContentBeforeCursor(codeRecommendStart);
        log.info("Data send to model is: {}", (Object)formattedContent);
        List<String> backMsgList = this.getBackMsgFormModelToGrpc(formattedContent, codeRecommendStart.getPrefix());
        List<LookupElement> lookupElements = this.getListLookUpElement(backMsgList);
        codeRecommendStart.getPredictResult().complete(lookupElements);
    }

    private String getContentBeforeCursor(SmartCompleteEvents.CodeRecommendStart codeRecommendStart) {
        if (codeRecommendStart.getDoc() == null) {
            return "";
        }
        int maxContentLength = 500;
        int endIndex = codeRecommendStart.getMyOffset();
        int beginIndex = Integer.max(0, endIndex - 500);
        return codeRecommendStart.getDoc().getText(new TextRange(beginIndex, endIndex));
    }

    private List<String> getBackMsgFormModelToGrpc(String content, String prefix) {
        ArrayList<String> predictList = new ArrayList<String>();
        try {
            Optional<CompleteReply> completeReply = ModelManager.INSTANCE.communicateWithModel(content, prefix);
            if (completeReply.isPresent()) {
                String oldPrefix = completeReply.get().getOldPrefix();
                ResultEntries resultEntries = completeReply.get().getResults();
                log.info("Has data from model. Data count: {}", (Object)resultEntries.getResultEntryCount());
                for (int index = 0; index < resultEntries.getResultEntryCount(); ++index) {
                    ResultEntry entry = resultEntries.getResultEntry(index);
                    String newPrefix = entry.getNewPrefix().trim();
                    if (!Objects.equals(prefix, oldPrefix) && newPrefix.startsWith(oldPrefix)) {
                        newPrefix = newPrefix.replaceFirst(Pattern.quote(oldPrefix), prefix);
                    }
                    predictList.add(newPrefix);
                    log.info("  Data from model is: {}:{}", (Object)newPrefix, (Object)entry.getDetails());
                }
            } else {
                log.info("No data from model.");
            }
        }
        catch (CompletionException completionException) {
            log.warn("Get message from completion model failed.", (Throwable)completionException);
        }
        return predictList;
    }

    private List<LookupElement> getListLookUpElement(List<String> predictList) {
        int maxResult = 5;
        ArrayList<LookupElement> lookupElements = new ArrayList<LookupElement>(maxResult);
        for (String code : predictList) {
            lookupElements.add(new MindSporeLookupElement((LookupElement)LookupElementBuilder.create((String)code).withBoldness(true)));
        }
        return lookupElements;
    }

    static {
        log = LoggerFactory.getLogger(CompleteService.class);
    }
}

