/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.common.enums;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EnumProperties {
    MIND_SPORE_PROPERTIES("messages/mindspore.properties"),
    EXCEPTION_SOLUTION_PROPERTIES("messages/ExceptionSolution.properties"),
    MY_BUNDLE_PROPERTIES("messages/MyBundle.properties");

    private static final Logger log;
    private String resourceFilePath;
    private Properties prop;

    private EnumProperties(String resourceFilePath) {
        this.resourceFilePath = resourceFilePath;
        this.prop = new Properties();
        this.registerProperties();
    }

    private void registerProperties() {
        if (this.resourceFilePath == null) {
            log.warn("resourceFilePath is null.");
            return;
        }
        try (InputStream in = EnumProperties.class.getClassLoader().getResourceAsStream(this.resourceFilePath);){
            this.prop.load(in);
        }
        catch (IOException ioException) {
            log.warn("Register properties failed.", (Throwable)ioException);
        }
    }

    public String getProperty(String key) {
        return this.prop.getProperty(key);
    }

    public <T> String getProperty(String key, T ... args) {
        return String.format(this.prop.getProperty(key), args);
    }

    static {
        log = LoggerFactory.getLogger(EnumProperties.class);
    }
}

