/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.ExperimentalApi;
import io.grpc.Internal;
import io.grpc.ServerBuilder;
import io.grpc.ServerStreamTracer;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.internal.FixedObjectPool;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalServer;
import io.grpc.internal.KeepAliveManager;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerImplBuilder;
import io.grpc.internal.SharedResourcePool;
import io.grpc.internal.TransportTracer;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyServer;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiators;
import io.grpc.netty.shaded.io.grpc.netty.Utils;
import io.grpc.netty.shaded.io.netty.channel.ChannelFactory;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.ReflectiveChannelFactory;
import io.grpc.netty.shaded.io.netty.channel.ServerChannel;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1784")
@CanIgnoreReturnValue
public final class NettyServerBuilder
extends AbstractServerImplBuilder<NettyServerBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    static final long MAX_CONNECTION_IDLE_NANOS_DISABLED = Long.MAX_VALUE;
    static final long MAX_CONNECTION_AGE_NANOS_DISABLED = Long.MAX_VALUE;
    static final long MAX_CONNECTION_AGE_GRACE_NANOS_INFINITE = Long.MAX_VALUE;
    private static final long MIN_KEEPALIVE_TIME_NANO = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final long MIN_KEEPALIVE_TIMEOUT_NANO = TimeUnit.MICROSECONDS.toNanos(499L);
    private static final long MIN_MAX_CONNECTION_IDLE_NANO = TimeUnit.SECONDS.toNanos(1L);
    private static final long MIN_MAX_CONNECTION_AGE_NANO = TimeUnit.SECONDS.toNanos(1L);
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private static final ObjectPool<? extends EventLoopGroup> DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL = SharedResourcePool.forResource(Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP);
    private static final ObjectPool<? extends EventLoopGroup> DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL = SharedResourcePool.forResource(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP);
    private final ServerImplBuilder serverImplBuilder;
    private final List<SocketAddress> listenAddresses = new ArrayList<SocketAddress>();
    private TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    private ChannelFactory<? extends ServerChannel> channelFactory = Utils.DEFAULT_SERVER_CHANNEL_FACTORY;
    private final Map<ChannelOption<?>, Object> channelOptions = new HashMap();
    private final Map<ChannelOption<?>, Object> childChannelOptions = new HashMap();
    private ObjectPool<? extends EventLoopGroup> bossEventLoopGroupPool = DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL;
    private ObjectPool<? extends EventLoopGroup> workerEventLoopGroupPool = DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL;
    private boolean forceHeapBuffer;
    private SslContext sslContext;
    private ProtocolNegotiator protocolNegotiator;
    private int maxConcurrentCallsPerConnection = Integer.MAX_VALUE;
    private boolean autoFlowControl = true;
    private int flowControlWindow = 0x100000;
    private int maxMessageSize = 0x400000;
    private int maxHeaderListSize = 8192;
    private long keepAliveTimeInNanos = GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIME_NANOS;
    private long keepAliveTimeoutInNanos = GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIMEOUT_NANOS;
    private long maxConnectionIdleInNanos = Long.MAX_VALUE;
    private long maxConnectionAgeInNanos = Long.MAX_VALUE;
    private long maxConnectionAgeGraceInNanos = Long.MAX_VALUE;
    private boolean permitKeepAliveWithoutCalls;
    private long permitKeepAliveTimeInNanos = TimeUnit.MINUTES.toNanos(5L);

    @CheckReturnValue
    public static NettyServerBuilder forPort(int port) {
        return new NettyServerBuilder(port);
    }

    @CheckReturnValue
    public static NettyServerBuilder forAddress(SocketAddress address) {
        return new NettyServerBuilder(address);
    }

    @CheckReturnValue
    private NettyServerBuilder(int port) {
        this.serverImplBuilder = new ServerImplBuilder(new NettyClientTransportServersBuilder());
        this.listenAddresses.add(new InetSocketAddress(port));
    }

    @CheckReturnValue
    private NettyServerBuilder(SocketAddress address) {
        this.serverImplBuilder = new ServerImplBuilder(new NettyClientTransportServersBuilder());
        this.listenAddresses.add(address);
    }

    @Override
    @Internal
    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    public NettyServerBuilder addListenAddress(SocketAddress listenAddress) {
        this.listenAddresses.add((SocketAddress)Preconditions.checkNotNull((Object)listenAddress, (Object)"listenAddress"));
        return this;
    }

    public NettyServerBuilder channelType(Class<? extends ServerChannel> channelType) {
        Preconditions.checkNotNull(channelType, (Object)"channelType");
        return this.channelFactory(new ReflectiveChannelFactory<ServerChannel>(channelType));
    }

    public NettyServerBuilder channelFactory(ChannelFactory<? extends ServerChannel> channelFactory) {
        this.channelFactory = (ChannelFactory)Preconditions.checkNotNull(channelFactory, (Object)"channelFactory");
        return this;
    }

    public <T> NettyServerBuilder withOption(ChannelOption<T> option, T value) {
        this.channelOptions.put(option, value);
        return this;
    }

    public <T> NettyServerBuilder withChildOption(ChannelOption<T> option, T value) {
        this.childChannelOptions.put(option, value);
        return this;
    }

    public NettyServerBuilder bossEventLoopGroup(EventLoopGroup group) {
        if (group != null) {
            return this.bossEventLoopGroupPool(new FixedObjectPool<EventLoopGroup>(group));
        }
        return this.bossEventLoopGroupPool(DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL);
    }

    NettyServerBuilder bossEventLoopGroupPool(ObjectPool<? extends EventLoopGroup> bossEventLoopGroupPool) {
        this.bossEventLoopGroupPool = (ObjectPool)Preconditions.checkNotNull(bossEventLoopGroupPool, (Object)"bossEventLoopGroupPool");
        return this;
    }

    public NettyServerBuilder workerEventLoopGroup(EventLoopGroup group) {
        if (group != null) {
            return this.workerEventLoopGroupPool(new FixedObjectPool<EventLoopGroup>(group));
        }
        return this.workerEventLoopGroupPool(DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL);
    }

    NettyServerBuilder workerEventLoopGroupPool(ObjectPool<? extends EventLoopGroup> workerEventLoopGroupPool) {
        this.workerEventLoopGroupPool = (ObjectPool)Preconditions.checkNotNull(workerEventLoopGroupPool, (Object)"workerEventLoopGroupPool");
        return this;
    }

    void setForceHeapBuffer(boolean value) {
        this.forceHeapBuffer = value;
    }

    public NettyServerBuilder sslContext(SslContext sslContext) {
        if (sslContext != null) {
            Preconditions.checkArgument((boolean)sslContext.isServer(), (Object)"Client SSL context can not be used for server");
            GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        }
        this.sslContext = sslContext;
        return this;
    }

    @Internal
    public final NettyServerBuilder protocolNegotiator(@Nullable ProtocolNegotiator protocolNegotiator) {
        this.protocolNegotiator = protocolNegotiator;
        return this;
    }

    void setTracingEnabled(boolean value) {
        this.serverImplBuilder.setTracingEnabled(value);
    }

    void setStatsEnabled(boolean value) {
        this.serverImplBuilder.setStatsEnabled(value);
    }

    void setStatsRecordStartedRpcs(boolean value) {
        this.serverImplBuilder.setStatsRecordStartedRpcs(value);
    }

    void setStatsRecordRealTimeMetrics(boolean value) {
        this.serverImplBuilder.setStatsRecordRealTimeMetrics(value);
    }

    public NettyServerBuilder maxConcurrentCallsPerConnection(int maxCalls) {
        Preconditions.checkArgument((maxCalls > 0 ? 1 : 0) != 0, (String)"max must be positive: %s", (int)maxCalls);
        this.maxConcurrentCallsPerConnection = maxCalls;
        return this;
    }

    public NettyServerBuilder initialFlowControlWindow(int initialFlowControlWindow) {
        Preconditions.checkArgument((initialFlowControlWindow > 0 ? 1 : 0) != 0, (Object)"initialFlowControlWindow must be positive");
        this.flowControlWindow = initialFlowControlWindow;
        this.autoFlowControl = true;
        return this;
    }

    public NettyServerBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument((flowControlWindow > 0 ? 1 : 0) != 0, (String)"flowControlWindow must be positive: %s", (int)flowControlWindow);
        this.flowControlWindow = flowControlWindow;
        this.autoFlowControl = false;
        return this;
    }

    @Deprecated
    public NettyServerBuilder maxMessageSize(int maxMessageSize) {
        return this.maxInboundMessageSize(maxMessageSize);
    }

    @Override
    public NettyServerBuilder maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument((bytes >= 0 ? 1 : 0) != 0, (String)"bytes must be non-negative: %s", (int)bytes);
        this.maxMessageSize = bytes;
        return this;
    }

    @Deprecated
    public NettyServerBuilder maxHeaderListSize(int maxHeaderListSize) {
        return this.maxInboundMetadataSize(maxHeaderListSize);
    }

    @Override
    public NettyServerBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (String)"maxInboundMetadataSize must be positive: %s", (int)bytes);
        this.maxHeaderListSize = bytes;
        return this;
    }

    public NettyServerBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTime > 0L ? 1 : 0) != 0, (String)"keepalive time must be positive\uff1a%s", (long)keepAliveTime);
        this.keepAliveTimeInNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeInNanos = KeepAliveManager.clampKeepAliveTimeInNanos(this.keepAliveTimeInNanos);
        if (this.keepAliveTimeInNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeInNanos = Long.MAX_VALUE;
        }
        if (this.keepAliveTimeInNanos < MIN_KEEPALIVE_TIME_NANO) {
            this.keepAliveTimeInNanos = MIN_KEEPALIVE_TIME_NANO;
        }
        return this;
    }

    public NettyServerBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTimeout > 0L ? 1 : 0) != 0, (String)"keepalive timeout must be positive: %s", (long)keepAliveTimeout);
        this.keepAliveTimeoutInNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutInNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos(this.keepAliveTimeoutInNanos);
        if (this.keepAliveTimeoutInNanos < MIN_KEEPALIVE_TIMEOUT_NANO) {
            this.keepAliveTimeoutInNanos = MIN_KEEPALIVE_TIMEOUT_NANO;
        }
        return this;
    }

    public NettyServerBuilder maxConnectionIdle(long maxConnectionIdle, TimeUnit timeUnit) {
        Preconditions.checkArgument((maxConnectionIdle > 0L ? 1 : 0) != 0, (String)"max connection idle must be positive: %s", (long)maxConnectionIdle);
        this.maxConnectionIdleInNanos = timeUnit.toNanos(maxConnectionIdle);
        if (this.maxConnectionIdleInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionIdleInNanos = Long.MAX_VALUE;
        }
        if (this.maxConnectionIdleInNanos < MIN_MAX_CONNECTION_IDLE_NANO) {
            this.maxConnectionIdleInNanos = MIN_MAX_CONNECTION_IDLE_NANO;
        }
        return this;
    }

    public NettyServerBuilder maxConnectionAge(long maxConnectionAge, TimeUnit timeUnit) {
        Preconditions.checkArgument((maxConnectionAge > 0L ? 1 : 0) != 0, (String)"max connection age must be positive: %s", (long)maxConnectionAge);
        this.maxConnectionAgeInNanos = timeUnit.toNanos(maxConnectionAge);
        if (this.maxConnectionAgeInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionAgeInNanos = Long.MAX_VALUE;
        }
        if (this.maxConnectionAgeInNanos < MIN_MAX_CONNECTION_AGE_NANO) {
            this.maxConnectionAgeInNanos = MIN_MAX_CONNECTION_AGE_NANO;
        }
        return this;
    }

    public NettyServerBuilder maxConnectionAgeGrace(long maxConnectionAgeGrace, TimeUnit timeUnit) {
        Preconditions.checkArgument((maxConnectionAgeGrace >= 0L ? 1 : 0) != 0, (String)"max connection age grace must be non-negative: %s", (long)maxConnectionAgeGrace);
        this.maxConnectionAgeGraceInNanos = timeUnit.toNanos(maxConnectionAgeGrace);
        if (this.maxConnectionAgeGraceInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionAgeGraceInNanos = Long.MAX_VALUE;
        }
        return this;
    }

    public NettyServerBuilder permitKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTime >= 0L ? 1 : 0) != 0, (String)"permit keepalive time must be non-negative: %s", (long)keepAliveTime);
        this.permitKeepAliveTimeInNanos = timeUnit.toNanos(keepAliveTime);
        return this;
    }

    public NettyServerBuilder permitKeepAliveWithoutCalls(boolean permit) {
        this.permitKeepAliveWithoutCalls = permit;
        return this;
    }

    @CheckReturnValue
    List<NettyServer> buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        this.assertEventLoopsAndChannelType();
        ProtocolNegotiator negotiator = this.protocolNegotiator;
        if (negotiator == null) {
            negotiator = this.sslContext != null ? ProtocolNegotiators.serverTls(this.sslContext, this.serverImplBuilder.getExecutorPool()) : ProtocolNegotiators.serverPlaintext();
        }
        ArrayList<NettyServer> transportServers = new ArrayList<NettyServer>(this.listenAddresses.size());
        for (SocketAddress listenAddress : this.listenAddresses) {
            NettyServer transportServer = new NettyServer(listenAddress, this.channelFactory, this.channelOptions, this.childChannelOptions, this.bossEventLoopGroupPool, this.workerEventLoopGroupPool, this.forceHeapBuffer, negotiator, streamTracerFactories, this.transportTracerFactory, this.maxConcurrentCallsPerConnection, this.autoFlowControl, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, this.keepAliveTimeInNanos, this.keepAliveTimeoutInNanos, this.maxConnectionIdleInNanos, this.maxConnectionAgeInNanos, this.maxConnectionAgeGraceInNanos, this.permitKeepAliveWithoutCalls, this.permitKeepAliveTimeInNanos, this.serverImplBuilder.getChannelz());
            transportServers.add(transportServer);
        }
        return Collections.unmodifiableList(transportServers);
    }

    @VisibleForTesting
    void assertEventLoopsAndChannelType() {
        boolean allProvided = this.channelFactory != Utils.DEFAULT_SERVER_CHANNEL_FACTORY && this.bossEventLoopGroupPool != DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL && this.workerEventLoopGroupPool != DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL;
        boolean nonProvided = this.channelFactory == Utils.DEFAULT_SERVER_CHANNEL_FACTORY && this.bossEventLoopGroupPool == DEFAULT_BOSS_EVENT_LOOP_GROUP_POOL && this.workerEventLoopGroupPool == DEFAULT_WORKER_EVENT_LOOP_GROUP_POOL;
        Preconditions.checkState((allProvided || nonProvided ? 1 : 0) != 0, (Object)"All of BossEventLoopGroup, WorkerEventLoopGroup and ChannelType should be provided or neither should be");
    }

    NettyServerBuilder setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this;
    }

    @Override
    public NettyServerBuilder useTransportSecurity(File certChain, File privateKey) {
        try {
            this.sslContext = GrpcSslContexts.forServer(certChain, privateKey).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public NettyServerBuilder useTransportSecurity(InputStream certChain, InputStream privateKey) {
        try {
            this.sslContext = GrpcSslContexts.forServer(certChain, privateKey).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private final class NettyClientTransportServersBuilder
    implements ServerImplBuilder.ClientTransportServersBuilder {
        private NettyClientTransportServersBuilder() {
        }

        @Override
        public List<? extends InternalServer> buildClientTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
            return NettyServerBuilder.this.buildTransportServers(streamTracerFactories);
        }
    }
}

