/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.hdc;

import com.mindspore.ide.toolkit.hdc.ErrorDataInfo;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HdcStringUtils {
    public static final String ERROR_TITLE = "MindSpore FAR(Failure Analysis Report)";
    private static int lineNumber = -1;
    private static int iOne = 0;
    private static Map<Integer, String> mapOne;
    private static Map<Integer, String> mapTwo;
    private static StringBuilder stringBuilderTwo;
    private static List<int[]> intMerge;

    public static List<String> allListToErrorList(List<String> allList) {
        LinkedList<String> errorList = new LinkedList<String>();
        lineNumber = -1;
        for (int i = 0; i < allList.size(); ++i) {
            HdcStringUtils.typeErrorList(i, errorList, allList);
        }
        return errorList;
    }

    private static void typeErrorList(int in, List<String> errorList, List<String> allList) {
        if (allList.get(in).contains(ERROR_TITLE)) {
            errorList.add(allList.get(in - 1));
            errorList.add(allList.get(in));
            lineNumber = in;
        } else {
            HdcStringUtils.addErrorList(in, errorList, allList);
        }
    }

    private static void addErrorList(int in, List<String> errorList, List<String> allList) {
        if (lineNumber != -1 && in - lineNumber < 6) {
            errorList.add(allList.get(in));
        } else if (lineNumber != -1 && in - lineNumber >= 6) {
            if (allList.get(in).equals(errorList.get(0)) || allList.get(in).equals(errorList.get(2))) {
                errorList.add(allList.get(in));
                lineNumber = -1;
            } else {
                errorList.add(allList.get(in));
            }
        } else {
            errorList.size();
        }
    }

    public static ErrorDataInfo errorListToErrorDataInfo(List<String> errorList) {
        ErrorDataInfo errorDataInfo = new ErrorDataInfo();
        LinkedList<String[]> stringList = new LinkedList<String[]>();
        StringBuilder errorString = new StringBuilder();
        for (int i = 0; i < errorList.size(); ++i) {
            String str;
            errorString.append(errorList.get(i)).append(System.getProperty("line.separator"));
            if (i == 1) {
                errorDataInfo.setTitleString(errorList.get(i).replaceAll("\\|", "").trim());
                continue;
            }
            if (i == 3) {
                str = errorList.get(i);
                String[] strings = str.split("\\|");
                if (strings.length <= 2) continue;
                String str1 = strings[1];
                String str2 = strings[2];
                errorDataInfo.setProjectString(str1.trim());
                errorDataInfo.setDescriptionString(str2.trim());
                continue;
            }
            if (i > 4 && i < errorList.size() - 1) {
                str = errorList.get(i);
                int twoChar = HdcStringUtils.getIndexOf(str, "\\|", 2);
                String projectStr = str.substring(1, twoChar).trim();
                String descriptionStr = str.substring(twoChar + 1, str.length() - 1).trim().replaceAll("\\|", "");
                if (descriptionStr.contains("+---") && descriptionStr.contains("---+")) {
                    descriptionStr = "";
                }
                String[] strings = new String[]{projectStr, descriptionStr};
                stringList.add(strings);
                continue;
            }
            errorList.size();
        }
        errorDataInfo.setStrings(stringList);
        errorDataInfo.setErrorString(errorString.toString());
        errorDataInfo = HdcStringUtils.filterErrorDataInfo(errorDataInfo);
        return errorDataInfo;
    }

    public static ErrorDataInfo filterErrorDataInfo(ErrorDataInfo errorDataInfo) {
        mapOne = new LinkedHashMap<Integer, String>();
        mapTwo = new LinkedHashMap<Integer, String>();
        stringBuilderTwo = new StringBuilder();
        intMerge = new LinkedList<int[]>();
        for (int i = 0; i < errorDataInfo.getStrings().size(); ++i) {
            String[] strings = errorDataInfo.getStrings().get(i);
            mapOne.put(i, strings[0]);
            if (strings[0].equals("")) {
                HdcStringUtils.equalsEmpty(strings, i, errorDataInfo);
                continue;
            }
            HdcStringUtils.equalsNoEmpty(errorDataInfo, i, strings);
            iOne = 0;
        }
        LinkedList<String[]> listNew = new LinkedList<String[]>();
        HdcStringUtils.listFormat(listNew, mapOne, mapTwo);
        ErrorDataInfo errorDataInfoNew = new ErrorDataInfo();
        HdcStringUtils.errorDataInfoFormat(errorDataInfo, errorDataInfoNew, listNew, intMerge);
        return errorDataInfoNew;
    }

    private static void equalsEmpty(String[] strings, int inInt, ErrorDataInfo errorDataInfo) {
        if (stringBuilderTwo.length() > 0) {
            stringBuilderTwo.append(System.getProperty("line.separator")).append(strings[1]);
        } else {
            iOne = inInt - 1;
            stringBuilderTwo.append(errorDataInfo.getStrings().get(inInt - 1)[1]).append(System.getProperty("line.separator")).append(strings[1]);
        }
        if (inInt == errorDataInfo.getStrings().size() - 1) {
            HdcStringUtils.lastDataFormat(inInt, errorDataInfo, strings);
            iOne = 0;
        } else {
            mapTwo.put(inInt, "");
        }
    }

    private static void equalsNoEmpty(ErrorDataInfo errorDataInfo, int inInt, String[] strings) {
        if (stringBuilderTwo.length() > 0) {
            int[] stringsMergeOne = new int[]{iOne, inInt - 1, 0, 0};
            if (errorDataInfo.getStrings().get(iOne)[0].contains("\u4ee3\u7801")) {
                int[] stringsMergeTwo = new int[]{iOne, inInt - 1, 1, 1};
                intMerge.add(stringsMergeTwo);
                mapTwo.put(iOne, stringBuilderTwo.toString());
            } else {
                for (int in = iOne; in < inInt; ++in) {
                    mapTwo.put(in, errorDataInfo.getStrings().get(in)[1]);
                }
            }
            intMerge.add(stringsMergeOne);
            mapTwo.put(inInt, strings[1]);
            stringBuilderTwo.delete(0, stringBuilderTwo.length());
        } else {
            mapTwo.put(inInt, strings[1]);
        }
    }

    private static void lastDataFormat(int inInt, ErrorDataInfo errorDataInfo, String[] strings) {
        if (stringBuilderTwo.length() > 0) {
            if (errorDataInfo.getStrings().get(iOne)[0].contains("\u4ee3\u7801")) {
                int[] stringsMergeTwo = new int[]{iOne, inInt, 1, 1};
                intMerge.add(stringsMergeTwo);
                mapTwo.put(iOne, stringBuilderTwo.toString());
                mapTwo.put(inInt, "");
            } else {
                mapTwo.put(inInt, strings[1]);
                for (int in = iOne; in < inInt; ++in) {
                    mapTwo.put(in, errorDataInfo.getStrings().get(in)[1]);
                }
            }
            int[] stringsMergeOne = new int[]{iOne, inInt, 0, 0};
            intMerge.add(stringsMergeOne);
            stringBuilderTwo.delete(0, stringBuilderTwo.length());
        } else {
            mapTwo.put(inInt, strings[1]);
        }
    }

    private static void listFormat(List<String[]> listNew, Map<Integer, String> mapOne, Map<Integer, String> mapTwo) {
        if (mapOne.size() != mapTwo.size()) {
            return;
        }
        for (Map.Entry<Integer, String> oneResult : mapOne.entrySet()) {
            for (Map.Entry<Integer, String> twoResult : mapTwo.entrySet()) {
                if (!oneResult.getKey().equals(twoResult.getKey())) continue;
                String[] strings = new String[]{oneResult.getValue(), twoResult.getValue()};
                listNew.add(strings);
            }
        }
    }

    private static void errorDataInfoFormat(ErrorDataInfo errorDataInfo, ErrorDataInfo errorDataInfoNew, List<String[]> listNew, List<int[]> intMerge) {
        errorDataInfoNew.setTitleString(errorDataInfo.getTitleString());
        errorDataInfoNew.setDescriptionString(errorDataInfo.getDescriptionString());
        errorDataInfoNew.setProjectString(errorDataInfo.getProjectString());
        errorDataInfoNew.setErrorString(errorDataInfo.getErrorString());
        errorDataInfoNew.setStrings(listNew);
        errorDataInfoNew.setIntMerge(intMerge);
    }

    public static int getIndexOf(String data, String str, int num) {
        Pattern pattern = Pattern.compile(str);
        Matcher findMatcher = pattern.matcher(data);
        int indexNum = 0;
        while (findMatcher.find() && ++indexNum != num) {
        }
        return findMatcher.start();
    }
}

