/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.builder;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import com.vladsch.flexmark.util.misc.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BuilderBase<T extends BuilderBase<T>>
extends MutableDataSet {
    private final HashSet<Class<?>> loadedExtensions = new HashSet();
    private final HashMap<Class<?>, HashSet<Object>> extensionApiPoints = new HashMap();
    private Extension currentExtension;

    protected abstract void removeApiPoint(@NotNull Object var1);

    protected abstract void preloadExtension(@NotNull Extension var1);

    protected abstract boolean loadExtension(@NotNull Extension var1);

    @NotNull
    public final T extensions(@NotNull Collection<? extends Extension> extensions) {
        Extension extension;
        ArrayList<Extension> addedExtensions = new ArrayList<Extension>(((Collection)SharedDataKeys.EXTENSIONS.get((DataHolder)this)).size() + extensions.size());
        Iterator<? extends Extension> iterator = extensions.iterator();
        while (iterator.hasNext()) {
            this.currentExtension = extension = iterator.next();
            if (!this.loadedExtensions.contains(extension.getClass())) {
                this.preloadExtension(extension);
                addedExtensions.add(extension);
            }
            this.currentExtension = null;
        }
        iterator = extensions.iterator();
        while (iterator.hasNext()) {
            this.currentExtension = extension = iterator.next();
            Class<?> extensionClass = extension.getClass();
            if (!this.loadedExtensions.contains(extensionClass) && this.loadExtension(extension)) {
                this.loadedExtensions.add(extensionClass);
                addedExtensions.add(extension);
            }
            this.currentExtension = null;
        }
        if (!addedExtensions.isEmpty()) {
            addedExtensions.addAll(0, (Collection)SharedDataKeys.EXTENSIONS.get((DataHolder)this));
            this.set((DataKey<V>)SharedDataKeys.EXTENSIONS, (V)addedExtensions);
        }
        return (T)((Object)this);
    }

    @NotNull
    public abstract Object build();

    protected void addExtensionApiPoint(@NotNull Object apiPoint) {
        Extension extension = this.currentExtension;
        if (extension != null) {
            Class<?> extensionClass = extension.getClass();
            HashSet apiPoints = this.extensionApiPoints.computeIfAbsent(extensionClass, k -> new HashSet());
            apiPoints.add(apiPoint);
        }
    }

    @NotNull
    public <V> MutableDataSet set(@NotNull DataKey<V> key, @NotNull V value) {
        this.addExtensionApiPoint(key);
        return super.set(key, value);
    }

    @NotNull
    public <V> MutableDataSet set(@NotNull NullableDataKey<V> key, @Nullable V value) {
        this.addExtensionApiPoint(key);
        return super.set(key, value);
    }

    @Deprecated
    public <V> V get(@NotNull DataKey<V> key) {
        return (V)key.get((DataHolder)this);
    }

    protected BuilderBase(@Nullable DataHolder options) {
        super(options);
    }

    protected void loadExtensions() {
        if (this.contains((DataKeyBase)SharedDataKeys.EXTENSIONS)) {
            this.extensions((Collection)SharedDataKeys.EXTENSIONS.get((DataHolder)this));
        }
    }

    protected BuilderBase() {
    }

    public static DataHolder removeExtensions(@NotNull DataHolder options, @NotNull Collection<Class<? extends Extension>> excludeExtensions) {
        ArrayList<Extension> extensions;
        boolean removed;
        if (options.contains((DataKeyBase)SharedDataKeys.EXTENSIONS) && (removed = (extensions = new ArrayList<Extension>((Collection)SharedDataKeys.EXTENSIONS.get(options))).removeIf(it -> excludeExtensions.contains(it.getClass())))) {
            if (options instanceof MutableDataHolder) {
                return ((MutableDataHolder)options).set(SharedDataKeys.EXTENSIONS, extensions);
            }
            return options.toMutable().set(SharedDataKeys.EXTENSIONS, extensions).toImmutable();
        }
        return options;
    }
}

