/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.cipher;

import com.mindspore.flclient.Common;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.security.SecureRandom;
import java.util.logging.Logger;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.math.ec.rfc7748.X25519;

public class KEYAgreement {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(KEYAgreement.class.toString());
    private static final int PBKDF2_ITERATIONS = 10000;
    private static final int HASH_BIT_SIZE = 256;
    private SecureRandom random = Common.getSecureRandom();

    public byte[] generatePrivateKey() {
        byte[] privateKey = new byte[32];
        X25519.generatePrivateKey(this.random, privateKey);
        return privateKey;
    }

    public byte[] generatePublicKey(byte[] privateKey) {
        if (privateKey == null || privateKey.length == 0) {
            LOGGER.severe("privateKey is null");
            return new byte[0];
        }
        byte[] publicKey = new byte[32];
        X25519.generatePublicKey(privateKey, 0, publicKey, 0);
        return publicKey;
    }

    public byte[] keyAgreement(byte[] privateKey, byte[] publicKey) {
        if (privateKey == null || privateKey.length == 0) {
            LOGGER.severe("privateKey is null");
            return new byte[0];
        }
        if (publicKey == null || publicKey.length == 0) {
            LOGGER.severe("publicKey is null");
            return new byte[0];
        }
        byte[] secret = new byte[32];
        X25519.calculateAgreement(privateKey, 0, publicKey, 0, secret, 0);
        return secret;
    }

    public byte[] getEncryptedPassword(byte[] password, byte[] salt) {
        if (password == null || password.length == 0) {
            LOGGER.severe("password is null");
            return new byte[0];
        }
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator(new SHA256Digest());
        gen.init(password, salt, 10000);
        return ((KeyParameter)gen.generateDerivedParameters(256)).getKey();
    }
}

