/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient;

import com.google.flatbuffers.FlatBufferBuilder;
import com.mindspore.flclient.FLClientStatus;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.util.Date;
import java.util.logging.Logger;
import mindspore.fl.schema.RequestGetResult;
import mindspore.fl.schema.ResponseGetResult;

public class GetResult {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(GetResult.class.toString());
    private static volatile GetResult getResult;
    private int retCode = 400;

    private GetResult() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GetResult getInstance() {
        GetResult localRef = getResult;
        if (localRef != null) return localRef;
        Class<GetResult> clazz = GetResult.class;
        synchronized (GetResult.class) {
            localRef = getResult;
            if (localRef != null) return localRef;
            getResult = localRef = new GetResult();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localRef;
        }
    }

    public int getRetCode() {
        return this.retCode;
    }

    public byte[] getRequestGetResult(String name, int iteration) {
        if (name == null || name.isEmpty()) {
            LOGGER.severe("[GetResult] the input parameter of <name> is null or empty, please check!");
            throw new IllegalArgumentException();
        }
        RequestGetResultBuilder builder = new RequestGetResultBuilder();
        return builder.iteration(iteration).flName(name).time().build();
    }

    public FLClientStatus doResponse(ResponseGetResult responseDataBuf) {
        this.retCode = responseDataBuf.retcode();
        LOGGER.info("[getResult] ==========the response message of getResult is:================");
        LOGGER.info("[getResult] ==========retCode: " + this.retCode);
        LOGGER.info("[getResult] ==========reason: " + responseDataBuf.reason());
        LOGGER.info("[getResult] ==========iteration: " + responseDataBuf.iteration());
        LOGGER.info("[getResult] ==========time: " + responseDataBuf.timestamp());
        FLClientStatus status = FLClientStatus.SUCCESS;
        switch (responseDataBuf.retcode()) {
            case 200: {
                LOGGER.info("[getResult] SUCCESS");
                return status;
            }
            case 201: {
                LOGGER.info("[getResult] server is not ready now: need wait and request getResult again");
                return FLClientStatus.WAIT;
            }
            case 300: {
                LOGGER.info("[getResult] out of time: need wait and request startFLJob again");
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.warning("[getResult] catch RequestError or SystemError");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[getResult] the return <retCode> from server is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    static {
        System.loadLibrary("mindspore-lite-jni");
    }

    class RequestGetResultBuilder {
        private FlatBufferBuilder builder = new FlatBufferBuilder();
        private int nameOffset = 0;
        private int iteration = 0;
        private int timeStampOffset = 0;

        private RequestGetResultBuilder flName(String name) {
            if (name == null || name.isEmpty()) {
                LOGGER.severe("[GetResult] the input parameter of <name> is null or empty, please check!");
                throw new IllegalArgumentException();
            }
            this.nameOffset = this.builder.createString(name);
            return this;
        }

        private RequestGetResultBuilder time() {
            Date date = new Date();
            long time = date.getTime();
            this.timeStampOffset = this.builder.createString(String.valueOf(time));
            return this;
        }

        private RequestGetResultBuilder iteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        private byte[] build() {
            RequestGetResult.startRequestGetResult(this.builder);
            RequestGetResult.addFlName(this.builder, this.nameOffset);
            RequestGetResult.addIteration(this.builder, this.iteration);
            RequestGetResult.addTimestamp(this.builder, this.timeStampOffset);
            int root = RequestGetResult.endRequestGetResult(this.builder);
            this.builder.finish(root);
            return this.builder.sizedByteArray();
        }
    }
}

