/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.common;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MsgAnonymous {
    private ArrayList<Anonymous> anonymouses = new ArrayList();
    private boolean anonyed = false;
    private String result;

    MsgAnonymous() {
        this.anonymouses.add(new UrlAnonymous());
        this.anonymouses.add(new PathAnonymous());
        this.anonymouses.add(new PathArrayAnonymous());
        this.anonymouses.add(new HostAnonymous());
        this.anonymouses.add(new IPAnonymous());
    }

    public String doAnonymous(String msg) {
        this.result = msg;
        for (Anonymous anonymous : this.anonymouses) {
            if (anonymous.doAnonymous(msg).booleanValue()) break;
        }
        return this.result;
    }

    protected class HostAnonymous
    implements Anonymous {
        protected HostAnonymous() {
        }

        @Override
        public Boolean doAnonymous(String msg) {
            Pattern hosstPattern = Pattern.compile("(host[ :]+)([\"a-zA-Z0-9.]*)");
            Matcher hostMatcher = hosstPattern.matcher(msg);
            if (!hostMatcher.find()) {
                return false;
            }
            MsgAnonymous.this.result = hostMatcher.replaceAll("$1Anonymous");
            return true;
        }
    }

    protected class IPAnonymous
    implements Anonymous {
        protected IPAnonymous() {
        }

        @Override
        public Boolean doAnonymous(String msg) {
            Pattern IPPattern = Pattern.compile("([/ ]+)([0-9]+.[0-9]+.[0-9]+.[0-9]+)([: ]+)([0-9]*)");
            Matcher IPMatcher = IPPattern.matcher(msg);
            if (!IPMatcher.find()) {
                return false;
            }
            MsgAnonymous.this.result = IPMatcher.replaceAll("$1AnonymousIP");
            return true;
        }
    }

    protected class PathArrayAnonymous
    implements Anonymous {
        protected PathArrayAnonymous() {
        }

        @Override
        public Boolean doAnonymous(String msg) {
            Pattern pathArrayPattern = Pattern.compile("([Pp][Aa][Tt][Hh][ ]?:[ ]?)\\[(/[a-zA-Z0-9\\._-]+[, ]*)+\\]");
            Matcher pathArrayMatcher = pathArrayPattern.matcher(msg);
            if (!pathArrayMatcher.find()) {
                return false;
            }
            MsgAnonymous.this.result = pathArrayMatcher.replaceAll("$1/AnonymousPath$2");
            return true;
        }
    }

    protected class PathAnonymous
    implements Anonymous {
        protected PathAnonymous() {
        }

        @Override
        public Boolean doAnonymous(String msg) {
            Pattern pathPattern = Pattern.compile("([Pp][Aa][Tt][Hh][ ]?:[ ]?)(/[a-zA-Z0-9._-]*)+");
            Matcher pathMatcher = pathPattern.matcher(msg);
            if (!pathMatcher.find()) {
                return false;
            }
            MsgAnonymous.this.result = pathMatcher.replaceAll("$1/AnonymousPath$2");
            return true;
        }
    }

    protected class UrlAnonymous
    implements Anonymous {
        protected UrlAnonymous() {
        }

        @Override
        public Boolean doAnonymous(String msg) {
            Pattern urlPattern = Pattern.compile("(http[s]?://)([a-zA-Z0-9.:]*)");
            Matcher urlMatcher = urlPattern.matcher(msg);
            if (!urlMatcher.find()) {
                return false;
            }
            MsgAnonymous.this.result = urlMatcher.replaceAll("$1AnonymousDomain");
            return true;
        }
    }

    protected static interface Anonymous {
        public Boolean doAnonymous(String var1);
    }
}

