/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.cipher;

import com.google.flatbuffers.FlatBufferBuilder;
import com.mindspore.flclient.CipherClient;
import com.mindspore.flclient.Common;
import com.mindspore.flclient.FLClientStatus;
import com.mindspore.flclient.FLCommunication;
import com.mindspore.flclient.FLParameter;
import com.mindspore.flclient.LocalFLParameter;
import com.mindspore.flclient.cipher.AESEncrypt;
import com.mindspore.flclient.cipher.BaseUtil;
import com.mindspore.flclient.cipher.struct.DecryptShareSecrets;
import com.mindspore.flclient.cipher.struct.EncryptShare;
import com.mindspore.flclient.cipher.struct.NewArray;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import mindspore.fl.schema.GetClientList;
import mindspore.fl.schema.ReturnClientList;

public class ClientListReq {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(ClientListReq.class.toString());
    private FLCommunication flCommunication;
    private String nextRequestTime;
    private FLParameter flParameter = FLParameter.getInstance();
    private LocalFLParameter localFLParameter = LocalFLParameter.getInstance();
    private int retCode;

    public ClientListReq() {
        this.flCommunication = FLCommunication.getInstance();
    }

    public String getNextRequestTime() {
        return this.nextRequestTime;
    }

    public void setNextRequestTime(String nextRequestTime) {
        this.nextRequestTime = nextRequestTime;
    }

    public int getRetCode() {
        return this.retCode;
    }

    public FLClientStatus getClientList(int iteration, List<String> u3ClientList, List<DecryptShareSecrets> decryptSecretsList, List<EncryptShare> returnShareList, Map<String, byte[]> cuvKeys) {
        int clientListRoot;
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int id = builder.createString(this.localFLParameter.getFlID());
        Date date = new Date();
        long timestamp = date.getTime();
        String dateTime = String.valueOf(timestamp);
        int time = builder.createString(dateTime);
        byte[] signature = CipherClient.signTimeAndIter(dateTime, iteration);
        if (signature == null) {
            LOGGER.severe("[getClientList] get signature is null!");
            return FLClientStatus.FAILED;
        }
        if (signature.length > 0) {
            int signed = GetClientList.createSignatureVector(builder, signature);
            GetClientList.startGetClientList(builder);
            GetClientList.addFlId(builder, id);
            GetClientList.addIteration(builder, iteration);
            GetClientList.addTimestamp(builder, time);
            GetClientList.addSignature(builder, signed);
            clientListRoot = GetClientList.endGetClientList(builder);
        } else {
            GetClientList.startGetClientList(builder);
            GetClientList.addFlId(builder, id);
            GetClientList.addIteration(builder, iteration);
            GetClientList.addTimestamp(builder, time);
            GetClientList.addSignature(builder, 0);
            clientListRoot = GetClientList.endGetClientList(builder);
        }
        builder.finish(clientListRoot);
        byte[] msg = builder.sizedByteArray();
        String url = Common.generateUrl(this.flParameter.isUseElb(), this.flParameter.getServerNum(), this.flParameter.getDomainName());
        try {
            byte[] responseData = this.flCommunication.syncRequest(url + "/getClientList", msg);
            if (!Common.isSeverReady(responseData)) {
                LOGGER.info("[getClientList] the server is not ready now, need wait some time and request again");
                this.nextRequestTime = Common.getNextReqTime();
                this.retCode = 300;
                return FLClientStatus.RESTART;
            }
            if (Common.isSeverJobFinished(responseData)) {
                LOGGER.info("[getClientList] The server's training job is disabled or finished. will stop the task and exist.");
                this.retCode = 500;
                return FLClientStatus.FAILED;
            }
            ByteBuffer buffer = ByteBuffer.wrap(responseData);
            LOGGER.info("getClientList responseData size: " + responseData.length);
            ReturnClientList clientListRsp = ReturnClientList.getRootAsReturnClientList(buffer);
            return this.judgeGetClientList(clientListRsp, u3ClientList, decryptSecretsList, returnShareList, cuvKeys);
        }
        catch (IOException ex) {
            LOGGER.severe("[getClientList] unsolved error code in getClientList: catch IOException: " + ex.getMessage());
            this.retCode = 400;
            return FLClientStatus.FAILED;
        }
    }

    private FLClientStatus judgeGetClientList(ReturnClientList bufData, List<String> u3ClientList, List<DecryptShareSecrets> decryptSecretsList, List<EncryptShare> returnShareList, Map<String, byte[]> cuvKeys) {
        this.retCode = bufData.retcode();
        LOGGER.info("[PairWiseMask] ************** the response of GetClientList **************");
        LOGGER.info("[PairWiseMask] return code: " + this.retCode);
        LOGGER.info("[PairWiseMask] reason: " + bufData.reason());
        LOGGER.info("[PairWiseMask] current iteration in server: " + bufData.iteration());
        LOGGER.info("[PairWiseMask] next request time: " + bufData.nextReqTime());
        LOGGER.info("[PairWiseMask] the size of clients: " + bufData.clientsLength());
        switch (this.retCode) {
            case 200: {
                LOGGER.info("[PairWiseMask] GetClientList success");
                u3ClientList.clear();
                int clientSize = bufData.clientsLength();
                for (int i = 0; i < clientSize; ++i) {
                    String curFlId = bufData.clients(i);
                    u3ClientList.add(curFlId);
                }
                FLClientStatus status = this.decryptSecretShares(decryptSecretsList, returnShareList, cuvKeys);
                return status;
            }
            case 201: {
                LOGGER.info("[PairWiseMask] server is not ready now, need wait and request GetClientList again!");
                return FLClientStatus.WAIT;
            }
            case 300: {
                LOGGER.info("[PairWiseMask] GetClientList out of time: need wait and request startFLJob again");
                this.setNextRequestTime(bufData.nextReqTime());
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.info("[PairWiseMask] catch SucNotMatch or SystemError in GetClientList");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[PairWiseMask] the return <retCode> from server in ReturnClientList is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    private FLClientStatus decryptSecretShares(List<DecryptShareSecrets> decryptSecretsList, List<EncryptShare> returnShareList, Map<String, byte[]> cuvKeys) {
        decryptSecretsList.clear();
        int size = returnShareList.size();
        if (size <= 0) {
            LOGGER.severe("[PairWiseMask] the input argument <returnShareList> is null");
            return FLClientStatus.FAILED;
        }
        if (cuvKeys.isEmpty()) {
            LOGGER.severe("[PairWiseMask] the input argument <cuvKeys> is null");
            return FLClientStatus.FAILED;
        }
        for (int i = 0; i < size; ++i) {
            EncryptShare encryptShare = returnShareList.get(i);
            String vFlID = encryptShare.getFlID();
            byte[] share = encryptShare.getShare().getArray();
            if (!cuvKeys.containsKey(vFlID)) {
                LOGGER.severe("[PairWiseMask] the key <vFlID> is not in map <cuvKeys> ");
                return FLClientStatus.FAILED;
            }
            AESEncrypt aesEncrypt = new AESEncrypt(cuvKeys.get(vFlID), "CBC");
            byte[] decryptShare = aesEncrypt.decrypt(cuvKeys.get(vFlID), share);
            if (decryptShare == null || decryptShare.length == 0) {
                LOGGER.severe("[decryptSecretShares] the return byte[] is null, please check!");
                return FLClientStatus.FAILED;
            }
            if (decryptShare.length < 4) {
                LOGGER.severe("[decryptSecretShares] the returned decryptShare is not valid: length is not right, please check!");
                return FLClientStatus.FAILED;
            }
            byte sIndexLen = decryptShare[2];
            byte bIndexLen = decryptShare[3];
            byte sSize = decryptShare[0];
            byte bSize = decryptShare[1];
            if (decryptShare.length < 4 + sIndexLen + bIndexLen + sSize + bSize) {
                LOGGER.severe("[decryptSecretShares] the returned decryptShare is not valid: length is not right, please check!");
                return FLClientStatus.FAILED;
            }
            byte[] sSkUv = Arrays.copyOfRange(decryptShare, 4 + sIndexLen + bIndexLen, 4 + sIndexLen + bIndexLen + sSize);
            byte[] bUv = Arrays.copyOfRange(decryptShare, 4 + sIndexLen + bIndexLen + sSize, 4 + sIndexLen + bIndexLen + sSize + bSize);
            NewArray<byte[]> sSkVu = new NewArray<byte[]>();
            sSkVu.setSize(sSize);
            sSkVu.setArray(sSkUv);
            NewArray<byte[]> bVu = new NewArray<byte[]>();
            bVu.setSize(bSize);
            bVu.setArray(bUv);
            int sIndex = BaseUtil.byteArray2Integer(Arrays.copyOfRange(decryptShare, 4, 4 + sIndexLen));
            int bIndex = BaseUtil.byteArray2Integer(Arrays.copyOfRange(decryptShare, 4 + sIndexLen, 4 + sIndexLen + bIndexLen));
            DecryptShareSecrets decryptShareSecrets = new DecryptShareSecrets();
            decryptShareSecrets.setFlID(vFlID);
            decryptShareSecrets.setSSkVu(sSkVu);
            decryptShareSecrets.setBVu(bVu);
            decryptShareSecrets.setSIndex(sIndex);
            decryptShareSecrets.setIndexB(bIndex);
            decryptSecretsList.add(decryptShareSecrets);
        }
        return FLClientStatus.SUCCESS;
    }
}

