/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore;

import com.mindspore.MSTensor;
import com.mindspore.config.MindsporeLite;
import com.mindspore.config.RunnerConfig;
import java.util.ArrayList;
import java.util.List;

public class ModelParallelRunner {
    private long modelParallelRunnerPtr = 0L;

    public long getModelParallelRunnerPtr() {
        return this.modelParallelRunnerPtr;
    }

    public boolean init(String modelPath, RunnerConfig runnerConfig) {
        if (runnerConfig == null || modelPath == null) {
            return false;
        }
        this.modelParallelRunnerPtr = this.init(modelPath, runnerConfig.getRunnerConfigPtr());
        return this.modelParallelRunnerPtr != 0L;
    }

    public boolean init(String modelPath) {
        if (modelPath == null) {
            return false;
        }
        this.modelParallelRunnerPtr = this.init(modelPath, 0L);
        return this.modelParallelRunnerPtr != 0L;
    }

    public boolean predict(List<MSTensor> inputs, List<MSTensor> outputs) {
        if (inputs == null || outputs == null || inputs.size() == 0) {
            return false;
        }
        long[] inputsPtrArray = new long[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            inputsPtrArray[i] = inputs.get(i).getMSTensorPtr();
        }
        if (outputs.size() != 0) {
            long[] outputsPtrArray = new long[outputs.size()];
            for (int i = 0; i < outputs.size(); ++i) {
                if (outputs.get(i) == null) {
                    return false;
                }
                outputsPtrArray[i] = outputs.get(i).getMSTensorPtr();
            }
            boolean ret = this.predictWithOutput(this.modelParallelRunnerPtr, inputsPtrArray, outputsPtrArray);
            return ret;
        }
        List<Long> outputPtrs = this.predict(this.modelParallelRunnerPtr, inputsPtrArray);
        if (outputPtrs.isEmpty()) {
            return false;
        }
        for (int i = 0; i < outputPtrs.size(); ++i) {
            if (outputPtrs.get(i) == 0L) {
                return false;
            }
            MSTensor msTensor = new MSTensor(outputPtrs.get(i));
            outputs.add(msTensor);
        }
        return true;
    }

    public List<MSTensor> getInputs() {
        List<Long> ret = this.getInputs(this.modelParallelRunnerPtr);
        ArrayList<MSTensor> tensors = new ArrayList<MSTensor>();
        for (Long msTensorAddr : ret) {
            MSTensor msTensor = new MSTensor(msTensorAddr);
            tensors.add(msTensor);
        }
        return tensors;
    }

    public List<MSTensor> getOutputs() {
        List<Long> ret = this.getOutputs(this.modelParallelRunnerPtr);
        ArrayList<MSTensor> tensors = new ArrayList<MSTensor>();
        for (Long msTensorAddr : ret) {
            MSTensor msTensor = new MSTensor(msTensorAddr);
            tensors.add(msTensor);
        }
        return tensors;
    }

    public void free() {
        if (this.modelParallelRunnerPtr != 0L) {
            this.free(this.modelParallelRunnerPtr);
            this.modelParallelRunnerPtr = 0L;
        }
    }

    private native long init(String var1, long var2);

    private native List<Long> predict(long var1, long[] var3);

    private native boolean predictWithOutput(long var1, long[] var3, long[] var4);

    private native List<Long> getInputs(long var1);

    private native List<Long> getOutputs(long var1);

    private native void free(long var1);

    static {
        MindsporeLite.init();
    }
}

