/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.model;

import com.mindspore.MSTensor;
import com.mindspore.Model;
import com.mindspore.flclient.common.FLLoggerGenerater;
import com.mindspore.flclient.model.LossCallback;
import com.mindspore.flclient.model.Status;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public abstract class Callback {
    private static final Logger logger = FLLoggerGenerater.getModelLogger(LossCallback.class.toString());
    protected Model model;
    public int steps = 0;
    int epochs = 0;

    public Callback(Model model) {
        this.model = model;
    }

    @Deprecated
    protected Optional<MSTensor> searchOutputsForSize(int size) {
        if (this.model == null) {
            logger.severe("trainSession cannot be null");
            return Optional.empty();
        }
        List<MSTensor> outputs = this.model.getOutputs();
        for (MSTensor tensor : outputs) {
            if (tensor == null) {
                logger.severe("tensor cannot be null");
                return Optional.empty();
            }
            if (tensor.elementsNum() != size) continue;
            return Optional.of(tensor);
        }
        logger.severe("can not find output the tensor,element num is " + size);
        return Optional.empty();
    }

    protected Map<String, float[]> getOutputsBySize(int size) {
        if (this.model == null) {
            throw new RuntimeException("model cannot be null");
        }
        HashMap<String, float[]> mapOutputs = new HashMap<String, float[]>();
        List<MSTensor> outputs = this.model.getOutputs();
        for (MSTensor tensor : outputs) {
            if (tensor == null) {
                logger.severe("tensor cannot be null");
            }
            if (tensor.elementsNum() == size) {
                mapOutputs.put(tensor.tensorName(), tensor.getFloatData());
            }
            tensor.free();
        }
        return mapOutputs;
    }

    public abstract Status stepBegin();

    public abstract Status stepEnd();

    public abstract Status epochBegin();

    public abstract Status epochEnd();
}

