/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient;

import com.mindspore.flclient.FLParameter;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.prng.SP800SecureRandom;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;

public class Common {
    public static final String LOG_DEPRECATED = "This method will be deprecated in the next version, it is recommended to use the latest method according to the use cases in the official website tutorial";
    public static final List<String> SSL_PROTOCOL_TRUST_LIST = new ArrayList<String>(Arrays.asList("TLSv1.3", "TLSv1.2"));
    public static final String SAFE_MOD = "The cluster is in safemode.";
    public static final String NOT_READY = "The server's training job is not ready.";
    public static final String JOB_NOT_AVAILABLE = "The server's training job is disabled or finished.";
    private static final Object STOP_OBJECT = new Object();
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(Common.class.toString());
    private static List<String> envTrustList = new ArrayList<String>(Arrays.asList("x86", "android"));
    private static SecureRandom secureRandom;
    private static int iteration;
    private static boolean isHttps;

    public static String generateUrl(boolean ifUseElb, int serverNum, String domainName) {
        String url;
        if (serverNum <= 0) {
            LOGGER.severe("[generateUrl] the input argument <serverNum> is not valid: <= 0, it should be > 0, please check!");
            throw new IllegalArgumentException();
        }
        if (domainName == null || domainName.isEmpty() || domainName.split("//").length < 2) {
            LOGGER.severe("[generateUrl] the input argument <domainName> is null or not valid, it should be like as https://...... or http://......  , please check!");
            throw new IllegalArgumentException();
        }
        if (ifUseElb) {
            if (domainName.split("//")[1].split(":").length < 2) {
                LOGGER.severe("[generateUrl] the format of <domainName> is not valid, it should be like as https://127.0.0.1:6666 or http://127.0.0.1:6666 when set useElb to true, please check!");
                throw new IllegalArgumentException();
            }
            String ip = domainName.split("//")[1].split(":")[0];
            int port = Integer.parseInt(domainName.split("//")[1].split(":")[1]);
            if (!Common.checkIP(ip)) {
                LOGGER.severe("[generateUrl] the <ip> split from domainName is not valid, domainName should be like as https://127.0.0.1:6666 or http://127.0.0.1:6666 when set useElb to true, please check!");
                throw new IllegalArgumentException();
            }
            if (!Common.checkPort(port)) {
                LOGGER.severe("[generateUrl] the <port> split from domainName is not valid, domainName should be like as https://127.0.0.1:6666 or http://127.0.0.1:6666 when set useElb to true, please check!");
                throw new IllegalArgumentException();
            }
            String tag = domainName.split("//")[0] + "//";
            Common.setIsHttps(domainName.split("//")[0].split(":")[0]);
            Random rand = new Random();
            int randomNum = rand.nextInt(100000) % serverNum + port;
            url = tag + ip + ":" + String.valueOf(randomNum);
        } else {
            url = domainName;
        }
        return url;
    }

    public static boolean checkEnv(String env) {
        return envTrustList.contains(env);
    }

    public static boolean checkSSLProtocol(String sslProtocol) {
        return SSL_PROTOCOL_TRUST_LIST.contains(sslProtocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long millis) {
        if (millis <= 0L) {
            LOGGER.severe("[sleep] the millis is not valid(<= 0), will not do any thing, and stop the task");
            throw new IllegalArgumentException();
        }
        if (millis > 1800000L) {
            LOGGER.severe("[sleep] the sleep time: " + millis + " exceed MAX_SLEEP_TIME: " + 1800000 + "(unit: ms), will only sleep 30 minutes.");
            millis = 1800000L;
        }
        try {
            Object object = STOP_OBJECT;
            synchronized (object) {
                STOP_OBJECT.wait(millis);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.severe("[sleep] catch InterruptedException: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyObject() {
        Object object = STOP_OBJECT;
        synchronized (object) {
            STOP_OBJECT.notify();
        }
    }

    public static long getWaitTime(String nextRequestTime) {
        Date date = new Date();
        long currentTime = date.getTime();
        long waitTime = 0L;
        if (nextRequestTime != null && !nextRequestTime.isEmpty()) {
            waitTime = Long.valueOf(nextRequestTime) - currentTime;
        }
        if (waitTime <= 0L) {
            LOGGER.severe("[getWaitTime] waitTime: " + waitTime + " is not valid (should be > 0), the reasons " + "may be: the nextRequestTime <= currentTime, or the nextRequestTime is null, will stop the task");
            throw new IllegalArgumentException();
        }
        LOGGER.info("[getWaitTime] next request time stamp: " + nextRequestTime + " current time stamp: " + currentTime);
        LOGGER.info("[getWaitTime] waitTime: " + waitTime);
        return waitTime;
    }

    public static long startTime(String tag) {
        Date startDate = new Date();
        long startTime = startDate.getTime();
        LOGGER.info("[start time] <" + tag + "> start time: " + startTime);
        return startTime;
    }

    public static void endTime(long start, String tag) {
        Date endDate = new Date();
        long endTime = endDate.getTime();
        LOGGER.info("[end time] <" + tag + "> end time: " + endTime);
        LOGGER.info("[interval time] <" + tag + "> interval time(ms): " + (endTime - start));
    }

    public static boolean isSeverReady(byte[] message) {
        if (message == null) {
            LOGGER.severe("[isSeverReady] the input argument <message> is null, please check!");
            throw new IllegalArgumentException();
        }
        String messageStr = new String(message);
        if (messageStr.contains(SAFE_MOD)) {
            LOGGER.info("[isSeverReady] The cluster is in safemode., need wait some time and request again");
            if (messageStr.split(":").length == 2) {
                iteration = Integer.parseInt(messageStr.split(":")[1]);
            } else {
                LOGGER.info("[isSeverReady] the server does not return the current iteration.");
            }
            return false;
        }
        if (messageStr.contains(NOT_READY)) {
            LOGGER.info("[isSeverReady] The server's training job is not ready., need wait some time and request again");
            return false;
        }
        return true;
    }

    public static boolean isSeverJobFinished(byte[] message) {
        if (message == null) {
            LOGGER.severe("[isSeverJobFinished] the input argument <message> is null, please check!");
            throw new IllegalArgumentException();
        }
        String messageStr = new String(message);
        if (messageStr.contains(JOB_NOT_AVAILABLE)) {
            LOGGER.info("[isSeverJobFinished] The server's training job is disabled or finished., will stop the task and exist");
            if (messageStr.split(":").length == 2) {
                iteration = Integer.parseInt(messageStr.split(":")[1]);
            } else {
                LOGGER.info("[isSeverJobFinished] the server does not return the current iteration.");
            }
            return true;
        }
        return false;
    }

    public static String getRealPath(String path) {
        if (path == null) {
            LOGGER.severe("[getRealPath] the input argument <path> is null, please check!");
            throw new IllegalArgumentException();
        }
        LOGGER.info("[getRealPath] original path: " + path);
        String[] paths = path.split(",");
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] == null) {
                LOGGER.severe("[getRealPath] the paths[" + i + "] is null, please check");
                throw new IllegalArgumentException();
            }
            LOGGER.info("[getRealPath] original path: " + paths[i]);
            File file = new File(paths[i]);
            try {
                paths[i] = file.getCanonicalPath();
                continue;
            }
            catch (IOException e) {
                LOGGER.severe("[getRealPath] catch IOException in file.getCanonicalPath(): " + e.getMessage());
                throw new IllegalArgumentException();
            }
        }
        String realPath = String.join((CharSequence)",", Arrays.asList(paths));
        LOGGER.info("[getRealPath] real path: " + realPath);
        return realPath;
    }

    public static boolean checkPath(String path) {
        if (path == null) {
            LOGGER.severe("[checkPath] the input argument <path> is null, please check!");
            return false;
        }
        String[] paths = path.split(",");
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] == null) {
                LOGGER.severe("[checkPath] the paths[i] is null, please check");
                return false;
            }
            LOGGER.info("[check path] path: " + paths[i]);
            File file = new File(paths[i]);
            if (file.exists()) continue;
            LOGGER.severe("[checkPath] the path does not exist, please check");
            return false;
        }
        return true;
    }

    public static boolean checkIP(String ip) {
        if (ip == null) {
            LOGGER.severe("[checkIP] the input argument <ip> is null, please check!");
            throw new IllegalArgumentException();
        }
        String regex = "(25[0-4]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[1-9])[.](25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])[.](25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])[.](25[0-4]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[1-9])";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(ip);
        return matcher.matches();
    }

    public static boolean checkPort(int port) {
        return port > 0 && port <= 65535;
    }

    public static SecureRandom getSecureRandom() {
        if (secureRandom == null) {
            LOGGER.severe("[setSecureRandom] the parameter secureRandom is null, please set it before use");
            throw new IllegalArgumentException();
        }
        return secureRandom;
    }

    public static void setSecureRandom(SecureRandom secureRandom) {
        if (secureRandom == null) {
            LOGGER.severe("[setSecureRandom] the input parameter secureRandom is null, please check");
            throw new IllegalArgumentException();
        }
        Common.secureRandom = secureRandom;
    }

    public static SecureRandom getFastSecureRandom() {
        try {
            LOGGER.info("[getFastSecureRandom] start create fastSecureRandom");
            long start = System.currentTimeMillis();
            SecureRandom blockingRandom = SecureRandom.getInstanceStrong();
            boolean ifPredictionResistant = true;
            AESEngine cipher = new AESEngine();
            int cipherLen = 256;
            int entropyBitsRequired = 384;
            byte[] nonce = null;
            boolean ifForceReseed = false;
            SP800SecureRandom fastRandom = new SP800SecureRandomBuilder(blockingRandom, ifPredictionResistant).setEntropyBitsRequired(entropyBitsRequired).buildCTR(cipher, cipherLen, nonce, ifForceReseed);
            fastRandom.nextInt();
            LOGGER.info("[getFastSecureRandom] finish create fastSecureRandom");
            LOGGER.info("[getFastSecureRandom] cost time: " + (System.currentTimeMillis() - start));
            return fastRandom;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.severe("catch NoSuchAlgorithmException: " + e.getMessage());
            throw new IllegalArgumentException();
        }
    }

    public static int getIteration() {
        return iteration;
    }

    public static boolean isHttps() {
        return isHttps;
    }

    public static void setIsHttps(String tag) {
        if ("https".equals(tag)) {
            LOGGER.info("conducting https communication");
            isHttps = true;
        } else if ("http".equals(tag)) {
            LOGGER.info("conducting http communication");
            isHttps = false;
        } else {
            LOGGER.info("The domain header set by the user is incorrect, please check");
            throw new IllegalArgumentException();
        }
    }

    public static String getNextReqTime() {
        FLParameter flParameter = FLParameter.getInstance();
        long millis = flParameter.getSleepTime() != 0 ? (long)flParameter.getSleepTime() : 10000L;
        Date curDate = new Date();
        long currentTime = curDate.getTime();
        String nextRequestTime = Long.toString(currentTime + millis);
        return nextRequestTime;
    }
}

