/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient;

import com.mindspore.flclient.EarlyStopMod;
import com.mindspore.flclient.EncryptLevel;
import com.mindspore.flclient.ServerMod;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.util.Map;
import java.util.logging.Logger;

public class LocalFLParameter {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(LocalFLParameter.class.toString());
    public static final int SEED_SIZE = 32;
    public static final int I_VEC_LEN = 16;
    public static final int SALT_SIZE = 32;
    public static final int KEY_LEN = 32;
    public static final String ANDROID = "android";
    public static final String X86 = "x86";
    private static volatile LocalFLParameter localFLParameter;
    private String flID;
    private String encryptLevel = EncryptLevel.NOT_ENCRYPT.toString();
    private String earlyStopMod = EarlyStopMod.NOT_EARLY_STOP.toString();
    private String serverMod = ServerMod.HYBRID_TRAINING.toString();
    private boolean stopJobFlag = false;
    private boolean useSSL = true;
    private float lr = 0.1f;
    private Map<String, float[]> oldFeatureMap;
    private byte uploadCompressType = 0;
    private int seed = 0;
    private float uploadSparseRatio = 0.08f;
    private int deviceType = 0;
    private int threadNum = 2;
    private int cpuBindMode = 0;
    private boolean enableFp16 = false;

    private LocalFLParameter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalFLParameter getInstance() {
        LocalFLParameter localRef = localFLParameter;
        if (localRef != null) return localRef;
        Class<LocalFLParameter> clazz = LocalFLParameter.class;
        synchronized (LocalFLParameter.class) {
            localRef = localFLParameter;
            if (localRef != null) return localRef;
            localFLParameter = localRef = new LocalFLParameter();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localRef;
        }
    }

    public String getFlID() {
        if (this.flID == null || this.flID.isEmpty()) {
            LOGGER.severe("[localFLParameter] the parameter of <flID> is null, please set it before use");
            throw new IllegalArgumentException();
        }
        return this.flID;
    }

    public void setFlID(String flID) {
        if (flID == null || flID.isEmpty()) {
            LOGGER.severe("[localFLParameter] the parameter of <flID> is null, please check it before set");
            throw new IllegalArgumentException();
        }
        this.flID = flID;
    }

    public EncryptLevel getEncryptLevel() {
        return EncryptLevel.valueOf(this.encryptLevel);
    }

    public void setEncryptLevel(String encryptLevel) {
        if (encryptLevel == null || encryptLevel.isEmpty()) {
            LOGGER.severe("[localFLParameter] the parameter of <encryptLevel> is null, please check it before setting");
            throw new IllegalArgumentException();
        }
        if (!(EncryptLevel.DP_ENCRYPT.toString().equals(encryptLevel) || EncryptLevel.NOT_ENCRYPT.toString().equals(encryptLevel) || EncryptLevel.SIGNDS.toString().equals(encryptLevel) || EncryptLevel.PW_ENCRYPT.toString().equals(encryptLevel))) {
            LOGGER.severe("[localFLParameter] the parameter of <encryptLevel> is " + encryptLevel + " , it must be DP_ENCRYPT or NOT_ENCRYPT or PW_ENCRYPT or SIGNDS, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.encryptLevel = encryptLevel;
    }

    public EarlyStopMod getEarlyStopMod() {
        return EarlyStopMod.valueOf(this.earlyStopMod);
    }

    public void setEarlyStopMod(String earlyStopMod) {
        if (earlyStopMod == null || earlyStopMod.isEmpty()) {
            LOGGER.severe("[localFLParameter] the parameter of <earlyStopMod> is null, please check it before setting");
            throw new IllegalArgumentException();
        }
        if (!(EarlyStopMod.NOT_EARLY_STOP.toString().equals(earlyStopMod) || EarlyStopMod.LOSS_ABS.toString().equals(earlyStopMod) || EarlyStopMod.LOSS_DIFF.toString().equals(earlyStopMod) || EarlyStopMod.WEIGHT_DIFF.toString().equals(earlyStopMod))) {
            LOGGER.severe("[localFLParameter] the parameter of <earlyStopMod> is " + earlyStopMod + " , it must be NOT_EARLY_STOP or LOSS_ABS or LOSS_DIFF or WEIGHT_DIFF, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.earlyStopMod = earlyStopMod;
    }

    public String getServerMod() {
        return this.serverMod;
    }

    public void setServerMod(String serverMod) {
        if (serverMod == null || serverMod.isEmpty()) {
            LOGGER.severe("[localFLParameter] the parameter of <serverMod> is null, please check it before setting");
            throw new IllegalArgumentException();
        }
        if (!ServerMod.HYBRID_TRAINING.toString().equals(serverMod) && !ServerMod.FEDERATED_LEARNING.toString().equals(serverMod)) {
            LOGGER.severe("[localFLParameter] the parameter of <serverMod> is " + serverMod + " , it must be HYBRID_TRAINING or FEDERATED_LEARNING, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.serverMod = serverMod;
    }

    public boolean isStopJobFlag() {
        return this.stopJobFlag;
    }

    public void setStopJobFlag(boolean stopJobFlag) {
        this.stopJobFlag = stopJobFlag;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public int getCpuBindMode() {
        return this.cpuBindMode;
    }

    public boolean isEnableFp16() {
        return this.enableFp16;
    }

    public void setMsConfig(int deviceType, int threadNum, int cpuBindMode, boolean enableFp16) {
        this.deviceType = deviceType;
        this.threadNum = threadNum;
        this.cpuBindMode = cpuBindMode;
        this.enableFp16 = enableFp16;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public float getLr() {
        return this.lr;
    }

    public void setLr(float lr) {
        this.lr = lr;
    }

    public byte getUploadCompressType() {
        return this.uploadCompressType;
    }

    public void setUploadCompressType(byte uploadCompressType) {
        this.uploadCompressType = uploadCompressType;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public float getUploadSparseRatio() {
        return this.uploadSparseRatio;
    }

    public void setUploadSparseRatio(float uploadSparseRatio) {
        this.uploadSparseRatio = uploadSparseRatio;
    }
}

