/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.cipher;

import com.mindspore.flclient.Common;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncrypt {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(AESEncrypt.class.toString());
    private static final String ALGORITHM = "AES";
    private static final String CIPHER_MODE_CTR = "AES/CTR/NoPadding";
    private static final String CIPHER_MODE_CBC = "AES/CBC/PKCS5PADDING";
    private String cipherMod;

    public AESEncrypt(byte[] key, String mode) {
        if (key == null) {
            LOGGER.severe("Key is null");
            return;
        }
        if (key.length != 32) {
            LOGGER.severe("the length of key is not correct");
            return;
        }
        if (mode.contains("CBC")) {
            this.cipherMod = CIPHER_MODE_CBC;
        } else if (mode.contains("CTR")) {
            this.cipherMod = CIPHER_MODE_CTR;
        } else {
            return;
        }
    }

    public byte[] encrypt(byte[] key, byte[] data) {
        if (key == null) {
            LOGGER.severe("Key is null");
            return new byte[0];
        }
        if (data == null) {
            LOGGER.severe("data is null");
            return new byte[0];
        }
        try {
            byte[] iVec = new byte[16];
            SecureRandom secureRandom = Common.getSecureRandom();
            secureRandom.nextBytes(iVec);
            SecretKeySpec skeySpec = new SecretKeySpec(key, ALGORITHM);
            Cipher cipher = Cipher.getInstance(this.cipherMod);
            IvParameterSpec iv = new IvParameterSpec(iVec);
            cipher.init(1, (Key)skeySpec, iv);
            byte[] encrypted = cipher.doFinal(data);
            byte[] encryptedAddIv = new byte[encrypted.length + iVec.length];
            System.arraycopy(iVec, 0, encryptedAddIv, 0, iVec.length);
            System.arraycopy(encrypted, 0, encryptedAddIv, iVec.length, encrypted.length);
            return encryptedAddIv;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOGGER.severe("catch NoSuchAlgorithmException or NoSuchPaddingException or InvalidKeyException or InvalidAlgorithmParameterException or IllegalBlockSizeException or BadPaddingException: " + ex.getMessage());
            return new byte[0];
        }
    }

    public byte[] encryptCTR(byte[] key, byte[] data, byte[] iVec) {
        if (key == null) {
            LOGGER.severe("Key is null");
            return new byte[0];
        }
        if (data == null) {
            LOGGER.severe("data is null");
            return new byte[0];
        }
        if (iVec == null || iVec.length != 16) {
            LOGGER.severe("iVec is null or the length of iVec is not valid, it should be I_VEC_LEN");
            return new byte[0];
        }
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, ALGORITHM);
            Cipher cipher = Cipher.getInstance(this.cipherMod);
            IvParameterSpec iv = new IvParameterSpec(iVec);
            cipher.init(1, (Key)skeySpec, iv);
            return cipher.doFinal(data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOGGER.severe("[encryptCTR] catch NoSuchAlgorithmException or NoSuchPaddingException or InvalidKeyException or InvalidAlgorithmParameterException or IllegalBlockSizeException or BadPaddingException: " + ex.getMessage());
            return new byte[0];
        }
    }

    public byte[] decrypt(byte[] key, byte[] encryptDataAddIv) {
        if (key == null) {
            LOGGER.severe("Key is null");
            return new byte[0];
        }
        if (encryptDataAddIv == null) {
            LOGGER.severe("encryptDataAddIv is null");
            return new byte[0];
        }
        if (encryptDataAddIv.length <= 16) {
            LOGGER.severe("the length of encryptDataAddIv is not valid: " + encryptDataAddIv.length + ", it should be > 16");
            return new byte[0];
        }
        try {
            byte[] iVec = Arrays.copyOfRange(encryptDataAddIv, 0, 16);
            byte[] encryptData = Arrays.copyOfRange(encryptDataAddIv, 16, encryptDataAddIv.length);
            SecretKeySpec sKeySpec = new SecretKeySpec(key, ALGORITHM);
            Cipher cipher = Cipher.getInstance(this.cipherMod);
            IvParameterSpec iv = new IvParameterSpec(iVec);
            cipher.init(2, (Key)sKeySpec, iv);
            return cipher.doFinal(encryptData);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOGGER.severe("catch NoSuchAlgorithmException or NoSuchPaddingException or InvalidKeyException or InvalidAlgorithmParameterException or IllegalBlockSizeException or BadPaddingException: " + ex.getMessage());
            return new byte[0];
        }
    }
}

