/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient;

import com.mindspore.flclient.BindMode;
import com.mindspore.flclient.Common;
import com.mindspore.flclient.FLJobResultCallback;
import com.mindspore.flclient.IFLJobResultCallback;
import com.mindspore.flclient.ServerMod;
import com.mindspore.flclient.common.FLLoggerGenerater;
import com.mindspore.flclient.compression.CompressMode;
import com.mindspore.flclient.model.RunType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class FLParameter {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(FLParameter.class.toString());
    public static final int TIME_OUT = 30;
    public static final int SLEEP_TIME = 10000;
    public static final int MAX_SLEEP_TIME = 1800000;
    public static final int RESTART_TIME_PER_ITER = 1;
    public static final int MAX_WAIT_TRY_TIME = 18;
    private static volatile FLParameter flParameter;
    private String deployEnv;
    private String domainName;
    private String certPath;
    private SSLSocketFactory sslSocketFactory;
    private X509TrustManager x509TrustManager;
    private IFLJobResultCallback iflJobResultCallback = new FLJobResultCallback();
    private String trainDataset;
    private String vocabFile = "null";
    private String idsFile = "null";
    private String testDataset = "null";
    private boolean useSSL = false;
    private String flName;
    private String trainModelPath;
    private String inferModelPath;
    private String sslProtocol = "TLSv1.2";
    private String clientID;
    private int timeOut;
    private int sleepTime;
    private boolean ifUseElb = false;
    private int serverNum = 1;
    private boolean ifPkiVerify = false;
    private String equipCrlPath = "null";
    private long validIterInterval = 600000L;
    private int threadNum = 1;
    private BindMode cpuBindMode = BindMode.NOT_BINDING_CORE;
    private List<String> trainWeightName = new ArrayList<String>();
    private List<String> inferWeightName = new ArrayList<String>();
    private Map<RunType, List<String>> dataMap = new HashMap<RunType, List<String>>();
    private ServerMod serverMod;
    private int batchSize;
    private int[][] inputShape;

    private FLParameter() {
        this.clientID = UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FLParameter getInstance() {
        FLParameter localRef = flParameter;
        if (localRef != null) return localRef;
        Class<FLParameter> clazz = FLParameter.class;
        synchronized (FLParameter.class) {
            localRef = flParameter;
            if (localRef != null) return localRef;
            flParameter = localRef = new FLParameter();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localRef;
        }
    }

    public String getDeployEnv() {
        if (this.deployEnv == null || this.deployEnv.isEmpty()) {
            LOGGER.severe("[flParameter] the parameter of <env> is null, please set it before using");
            throw new IllegalArgumentException();
        }
        return this.deployEnv;
    }

    public void setDeployEnv(String env) {
        if (!Common.checkEnv(env)) {
            LOGGER.severe("[flParameter] the parameter of <env> is not in envTrustList: x86, android, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.deployEnv = env;
    }

    public String getDomainName() {
        if (this.domainName == null || this.domainName.isEmpty()) {
            LOGGER.severe("[flParameter] the parameter of <domainName> is null or empty, please set it before using");
            throw new IllegalArgumentException();
        }
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        if (domainName == null || domainName.isEmpty() || !"https".equals(domainName.split(":")[0]) && !"http".equals(domainName.split(":")[0])) {
            LOGGER.severe("[flParameter] the parameter of <domainName> is not valid, it should be like as https://...... or http://......, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.domainName = domainName;
        Common.setIsHttps(domainName.split("//")[0].split(":")[0]);
    }

    public String getClientID() {
        if (this.clientID == null || this.clientID.isEmpty()) {
            LOGGER.severe("[flParameter] the parameter of <clientID> is null or empty, please check");
            throw new IllegalArgumentException();
        }
        return this.clientID;
    }

    public void setClientID(String clientID) {
        if (clientID == null || clientID.isEmpty()) {
            LOGGER.severe("[flParameter] the parameter of <clientID> is null or empty, please check before setting");
            throw new IllegalArgumentException();
        }
        this.clientID = clientID;
    }

    public String getCertPath() {
        if (this.certPath == null || this.certPath.isEmpty()) {
            LOGGER.severe("[flParameter] the parameter of <certPath> is null or empty, the <certPath> must be set when conducting https communication, please set it by FLParameter.setCertPath()");
            throw new IllegalArgumentException();
        }
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        String realCertPath = Common.getRealPath(certPath);
        if (!Common.checkPath(realCertPath)) {
            LOGGER.severe("[flParameter] the parameter of <certPath> does not exist, it must be a valid path when conducting https communication, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.certPath = realCertPath;
    }

    public SSLSocketFactory getSslSocketFactory() {
        if (this.sslSocketFactory == null) {
            LOGGER.severe("[flParameter] the parameter of <sslSocketFactory> is null, the <sslSocketFactory> must be set when the deployEnv being \"android\", please set it by FLParameter.setSslSocketFactory()");
            throw new IllegalArgumentException();
        }
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public X509TrustManager getX509TrustManager() {
        if (this.x509TrustManager == null) {
            LOGGER.severe("[flParameter] the parameter of <x509TrustManager> is null, the <x509TrustManager> must be set when the deployEnv being \"android\", please set it by FLParameter.setX509TrustManager()");
            throw new IllegalArgumentException();
        }
        return this.x509TrustManager;
    }

    public void setX509TrustManager(X509TrustManager x509TrustManager) {
        this.x509TrustManager = x509TrustManager;
    }

    public IFLJobResultCallback getIflJobResultCallback() {
        if (this.iflJobResultCallback == null) {
            LOGGER.severe("[flParameter] the parameter of <iflJobResultCallback> is null, please set it before using");
            throw new IllegalArgumentException();
        }
        return this.iflJobResultCallback;
    }

    public void setIflJobResultCallback(IFLJobResultCallback iflJobResultCallback) {
        this.iflJobResultCallback = iflJobResultCallback;
    }

    public String getFlName() {
        if (this.flName == null || this.flName.isEmpty()) {
            LOGGER.severe("[flParameter] the parameter of <flName> is null or empty, please set it before using");
            throw new IllegalArgumentException();
        }
        return this.flName;
    }

    public void setFlName(String flName) {
        this.flName = flName;
    }

    public String getTrainModelPath() {
        return this.trainModelPath;
    }

    public void setTrainModelPath(String trainModelPath) {
        String realTrainModelPath = Common.getRealPath(trainModelPath);
        if (!Common.checkPath(realTrainModelPath)) {
            LOGGER.severe("[flParameter] the parameter of <trainModelPath> does not exist, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.trainModelPath = realTrainModelPath;
    }

    public String getInferModelPath() {
        return this.inferModelPath;
    }

    public void setInferModelPath(String inferModelPath) {
        String realInferModelPath = Common.getRealPath(inferModelPath);
        if (!Common.checkPath(realInferModelPath)) {
            LOGGER.severe("[flParameter] the parameter of <inferModelPath> does not exist, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.inferModelPath = realInferModelPath;
    }

    public String getSslProtocol() {
        if (this.sslProtocol == null || this.sslProtocol.isEmpty()) {
            LOGGER.severe("[flParameter] the parameter of <sslProtocol> is null or empty, please set it before using");
            throw new IllegalArgumentException();
        }
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        if (!Common.checkSSLProtocol(sslProtocol)) {
            LOGGER.severe("[flParameter] the parameter of <sslProtocol> is not in sslProtocolTrustList : " + Arrays.toString(Common.SSL_PROTOCOL_TRUST_LIST.toArray(new String[0])) + ", please check it before setting");
            throw new IllegalArgumentException();
        }
        this.sslProtocol = sslProtocol;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        if (timeOut <= 0 || timeOut > 100) {
            LOGGER.severe("[flParameter] the parameter of <timeOut: " + timeOut + " (unit: s)> is not valid, it should be > 0s and <= 100s, please set a valid value before using");
            throw new IllegalArgumentException();
        }
        this.timeOut = timeOut;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        if (sleepTime <= 0 || sleepTime > 100000) {
            LOGGER.severe("[flParameter] the parameter of <sleepTime: " + sleepTime + " (unit: ms)> is not valid, it should be > 0ms and <= 100000ms, please set a valid value before using");
            throw new IllegalArgumentException();
        }
        this.sleepTime = sleepTime;
    }

    public boolean isUseElb() {
        return this.ifUseElb;
    }

    public void setUseElb(boolean ifUseElb) {
        this.ifUseElb = ifUseElb;
    }

    public int getServerNum() {
        if (this.serverNum <= 0) {
            LOGGER.severe("[flParameter] the parameter of <serverNum> <= 0, it should be > 0, please set it before using");
            throw new IllegalArgumentException();
        }
        return this.serverNum;
    }

    public void setServerNum(int serverNum) {
        this.serverNum = serverNum;
    }

    public boolean isPkiVerify() {
        return this.ifPkiVerify;
    }

    public void setPkiVerify(boolean ifPkiVerify) {
        this.ifPkiVerify = ifPkiVerify;
    }

    public String getEquipCrlPath() {
        if (this.equipCrlPath == null || this.equipCrlPath.isEmpty()) {
            LOGGER.severe("[flParameter] the parameter of <equipCrlPath> is null or empty, please set it before using");
            throw new IllegalArgumentException();
        }
        return this.equipCrlPath;
    }

    public long getValidInterval() {
        if (this.validIterInterval <= 0L) {
            LOGGER.severe("[flParameter] the parameter of <validIterInterval> is not valid, please set it as larger than 0.");
            throw new IllegalArgumentException();
        }
        return this.validIterInterval;
    }

    public void setEquipCrlPath(String certPath) {
        String realCertPath = Common.getRealPath(certPath);
        if (!Common.checkPath(realCertPath)) {
            LOGGER.severe("[flParameter] the parameter of <equipCrlPath> does not exist, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.equipCrlPath = realCertPath;
    }

    public void setValidInterval(long validInterval) {
        if (validInterval <= 0L) {
            LOGGER.severe("[flParameter] the parameter of <validIterInterval> should be larger than 0, please set it again.");
            throw new IllegalArgumentException();
        }
        this.validIterInterval = validInterval;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        if (threadNum <= 0) {
            LOGGER.severe("[flParameter] the parameter of <threadNum> <= 0, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.threadNum = threadNum;
    }

    public int getCpuBindMode() {
        LOGGER.info("[flParameter] the parameter of <cpuBindMode> is: " + this.cpuBindMode.toString() + " , the NOT_BINDING_CORE means that not binding core, BIND_LARGE_CORE means binding the large core, BIND_MIDDLE_CORE means binding the middle core");
        return this.cpuBindMode.ordinal();
    }

    public void setCpuBindMode(BindMode cpuBindMode) {
        this.cpuBindMode = cpuBindMode;
    }

    public void setHybridWeightName(List<String> hybridWeightName, RunType runType) {
        if (RunType.TRAINMODE.equals((Object)runType)) {
            this.trainWeightName = hybridWeightName;
        } else if (RunType.INFERMODE.equals((Object)runType)) {
            this.inferWeightName = hybridWeightName;
        } else {
            LOGGER.severe("[flParameter] the variable <runType> can only be set to <RunType.TRAINMODE> or <RunType.INFERMODE>, please check it");
            throw new IllegalArgumentException();
        }
    }

    public List<String> getHybridWeightName(RunType runType) {
        if (RunType.TRAINMODE.equals((Object)runType)) {
            if (this.trainWeightName.isEmpty()) {
                LOGGER.severe("[flParameter] the parameter of <trainWeightName> is null, please set it before use");
                throw new IllegalArgumentException();
            }
            return this.trainWeightName;
        }
        if (RunType.INFERMODE.equals((Object)runType)) {
            if (this.inferWeightName.isEmpty()) {
                LOGGER.severe("[flParameter] the parameter of <inferWeightName> is null, please set it before use");
                throw new IllegalArgumentException();
            }
            return this.inferWeightName;
        }
        LOGGER.severe("[flParameter] the variable <runType> can only be set to <RunType.TRAINMODE> or <RunType.INFERMODE>, please check it");
        throw new IllegalArgumentException();
    }

    public Map<RunType, List<String>> getDataMap() {
        if (this.dataMap.isEmpty()) {
            LOGGER.severe("[flParameter] the parameter of <dataMaps> is null, please set it before use");
            throw new IllegalArgumentException();
        }
        return this.dataMap;
    }

    public void setDataMap(Map<RunType, List<String>> dataMap) {
        this.dataMap = dataMap;
    }

    public ServerMod getServerMod() {
        if (this.serverMod == null) {
            LOGGER.severe("[flParameter] the parameter of <serverMod> is null, please set it before use");
            throw new IllegalArgumentException();
        }
        return this.serverMod;
    }

    public void setServerMod(ServerMod serverMod) {
        this.serverMod = serverMod;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            LOGGER.severe("[flParameter] the parameter of <batchSize> <= 0, please check it before setting");
            throw new IllegalArgumentException();
        }
        this.batchSize = batchSize;
    }

    public byte[] getDownloadCompressTypes() {
        byte[] downloadCompressTypes = new byte[CompressMode.COMPRESS_TYPE_MAP.size()];
        int index = 0;
        Iterator<Byte> iterator = CompressMode.COMPRESS_TYPE_MAP.keySet().iterator();
        while (iterator.hasNext()) {
            byte downloadCompressType;
            downloadCompressTypes[index] = downloadCompressType = iterator.next().byteValue();
            ++index;
        }
        return downloadCompressTypes;
    }

    public int[][] getInputShape() {
        return this.inputShape;
    }

    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape;
    }
}

