/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient;

import com.google.flatbuffers.FlatBufferBuilder;
import com.mindspore.flclient.Common;
import com.mindspore.flclient.FLClientStatus;
import com.mindspore.flclient.FLCommunication;
import com.mindspore.flclient.FLParameter;
import com.mindspore.flclient.LocalFLParameter;
import com.mindspore.flclient.cipher.AESEncrypt;
import com.mindspore.flclient.cipher.BaseUtil;
import com.mindspore.flclient.cipher.CertVerify;
import com.mindspore.flclient.cipher.ClientListReq;
import com.mindspore.flclient.cipher.KEYAgreement;
import com.mindspore.flclient.cipher.Masking;
import com.mindspore.flclient.cipher.ReconstructSecretReq;
import com.mindspore.flclient.cipher.ShareSecrets;
import com.mindspore.flclient.cipher.SignAndVerify;
import com.mindspore.flclient.cipher.struct.ClientPublicKey;
import com.mindspore.flclient.cipher.struct.DecryptShareSecrets;
import com.mindspore.flclient.cipher.struct.EncryptShare;
import com.mindspore.flclient.cipher.struct.NewArray;
import com.mindspore.flclient.cipher.struct.ShareSecret;
import com.mindspore.flclient.common.FLLoggerGenerater;
import com.mindspore.flclient.pki.PkiUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import mindspore.fl.schema.ClientShare;
import mindspore.fl.schema.GetExchangeKeys;
import mindspore.fl.schema.GetShareSecrets;
import mindspore.fl.schema.RequestAllClientListSign;
import mindspore.fl.schema.RequestExchangeKeys;
import mindspore.fl.schema.RequestShareSecrets;
import mindspore.fl.schema.ResponseClientListSign;
import mindspore.fl.schema.ResponseExchangeKeys;
import mindspore.fl.schema.ResponseShareSecrets;
import mindspore.fl.schema.ReturnAllClientListSign;
import mindspore.fl.schema.ReturnExchangeKeys;
import mindspore.fl.schema.ReturnShareSecrets;
import mindspore.fl.schema.SendClientListSign;

public class CipherClient {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(CipherClient.class.toString());
    private FLCommunication flCommunication;
    private FLParameter flParameter = FLParameter.getInstance();
    private LocalFLParameter localFLParameter = LocalFLParameter.getInstance();
    private final int iteration;
    private int featureSize;
    private int minShareNum;
    private List<byte[]> cKey = new ArrayList<byte[]>();
    private List<byte[]> sKey = new ArrayList<byte[]>();
    private byte[] bu;
    private byte[] individualIv = new byte[16];
    private byte[] pwIVec = new byte[16];
    private byte[] pwSalt = new byte[32];
    private String nextRequestTime;
    private Map<String, ClientPublicKey> clientPublicKeyList = new HashMap<String, ClientPublicKey>();
    private Map<String, byte[]> sUVKeys = new HashMap<String, byte[]>();
    private Map<String, byte[]> cUVKeys = new HashMap<String, byte[]>();
    private List<EncryptShare> clientShareList = new ArrayList<EncryptShare>();
    private List<EncryptShare> returnShareList = new ArrayList<EncryptShare>();
    private List<String> u1ClientList = new ArrayList<String>();
    private List<String> u2UClientList = new ArrayList<String>();
    private List<String> u3ClientList = new ArrayList<String>();
    private List<DecryptShareSecrets> decryptShareSecretsList = new ArrayList<DecryptShareSecrets>();
    private byte[] prime;
    private KEYAgreement keyAgreement = new KEYAgreement();
    private Masking masking = new Masking();
    private ClientListReq clientListReq = new ClientListReq();
    private ReconstructSecretReq reconstructSecretReq = new ReconstructSecretReq();
    private int retCode;
    private Map<String, X509Certificate[]> certificateList = new HashMap<String, X509Certificate[]>();
    private int waitTryTime = 0;

    public CipherClient(int iter, int minSecretNum, byte[] prime, int featureSize) {
        this.flCommunication = FLCommunication.getInstance();
        this.iteration = iter;
        this.featureSize = featureSize;
        this.minShareNum = minSecretNum;
        this.prime = prime;
    }

    public void setNextRequestTime(String nextRequestTime) {
        this.nextRequestTime = nextRequestTime;
    }

    private void setClientShareList(List<EncryptShare> clientShareList) {
        this.clientShareList.clear();
        this.clientShareList = clientShareList;
    }

    public String getNextRequestTime() {
        return this.nextRequestTime;
    }

    public int getRetCode() {
        return this.retCode;
    }

    private FLClientStatus genDHKeyPairs() {
        byte[] csk = this.keyAgreement.generatePrivateKey();
        byte[] cpk = this.keyAgreement.generatePublicKey(csk);
        if (cpk == null || cpk.length == 0) {
            LOGGER.severe("[genDHKeyPairs] the return byte[] <cpk> is null, please check!");
            return FLClientStatus.FAILED;
        }
        byte[] ssk = this.keyAgreement.generatePrivateKey();
        byte[] spk = this.keyAgreement.generatePublicKey(ssk);
        if (spk == null || spk.length == 0) {
            LOGGER.severe("[genDHKeyPairs] the return byte[] <spk> is null, please check!");
            return FLClientStatus.FAILED;
        }
        this.cKey.clear();
        this.sKey.clear();
        this.cKey.add(cpk);
        this.cKey.add(csk);
        this.sKey.add(spk);
        this.sKey.add(ssk);
        return FLClientStatus.SUCCESS;
    }

    private FLClientStatus genIndividualSecret() {
        byte[] key = new byte[32];
        int tag = this.masking.getRandomBytes(key);
        if (tag == -1) {
            LOGGER.severe("[genIndividualSecret] the return value is -1, please check!");
            return FLClientStatus.FAILED;
        }
        this.bu = key;
        return FLClientStatus.SUCCESS;
    }

    private List<ShareSecret> genSecretShares(byte[] secret) {
        if (secret == null || secret.length == 0) {
            LOGGER.severe("[genSecretShares] the input argument <secret> is null");
            return new ArrayList<ShareSecret>();
        }
        int size = this.u1ClientList.size();
        if (size <= 1) {
            LOGGER.severe("[genSecretShares] the size of u1ClientList is not valid: <= 1, it should be > 1");
            return new ArrayList<ShareSecret>();
        }
        ShareSecrets shamir = new ShareSecrets(this.minShareNum, size - 1);
        ShareSecrets.SecretShares[] shares = shamir.split(secret, this.prime);
        if (shares == null || shares.length == 0) {
            LOGGER.severe("[genSecretShares] the return ShareSecrets.SecretShare[] is null, please check!");
            return new ArrayList<ShareSecret>();
        }
        int shareIndex = 0;
        ArrayList<ShareSecret> shareSecretList = new ArrayList<ShareSecret>();
        for (String vFlID : this.u1ClientList) {
            if (this.localFLParameter.getFlID().equals(vFlID)) continue;
            if (shareIndex >= shares.length) {
                LOGGER.severe("[genSecretShares] the shareIndex is out of range in array <shares>, please check!");
                return new ArrayList<ShareSecret>();
            }
            int index = shares[shareIndex].getNumber();
            BigInteger intShare = shares[shareIndex].getShares();
            byte[] share = BaseUtil.bigInteger2byteArray(intShare);
            NewArray<byte[]> array = new NewArray<byte[]>();
            array.setSize(share.length);
            array.setArray(share);
            ShareSecret shareSecret = new ShareSecret();
            shareSecret.setFlID(vFlID);
            shareSecret.setShare(array);
            shareSecret.setIndex(index);
            shareSecretList.add(shareSecret);
            ++shareIndex;
        }
        return shareSecretList;
    }

    private FLClientStatus genEncryptExchangedKeys() {
        this.cUVKeys.clear();
        for (String key : this.clientPublicKeyList.keySet()) {
            ClientPublicKey curPublicKey = this.clientPublicKeyList.get(key);
            String vFlID = curPublicKey.getFlID();
            if (this.localFLParameter.getFlID().equals(vFlID)) continue;
            if (this.cKey.size() < 2) {
                LOGGER.severe("[genEncryptExchangedKeys] the size of cKey is not valid: < 2, it should be >= 2, please check!");
                return FLClientStatus.FAILED;
            }
            byte[] secret1 = this.keyAgreement.keyAgreement(this.cKey.get(1), curPublicKey.getCPK().getArray());
            if (secret1 == null || secret1.length == 0) {
                LOGGER.severe("[genEncryptExchangedKeys] the returned secret1 is null, please check!");
                return FLClientStatus.FAILED;
            }
            byte[] salt = new byte[0];
            byte[] secret = this.keyAgreement.getEncryptedPassword(secret1, salt);
            if (secret == null || secret.length == 0) {
                LOGGER.severe("[genEncryptExchangedKeys] the returned secret is null, please check!");
                return FLClientStatus.FAILED;
            }
            this.cUVKeys.put(vFlID, secret);
        }
        return FLClientStatus.SUCCESS;
    }

    private FLClientStatus encryptShares() {
        LOGGER.info("[PairWiseMask] ************** generate encrypt share secrets for RequestShareSecrets **************");
        if (this.sKey.size() < 2) {
            LOGGER.severe("[encryptShares] the size of sKey is not valid: < 2, it should be >= 2, please check!");
            return FLClientStatus.FAILED;
        }
        List<ShareSecret> sSkUv = this.genSecretShares(this.sKey.get(1));
        if (sSkUv.isEmpty()) {
            LOGGER.severe("[encryptShares] the returned List<ShareSecret> sSkUv is empty, please check!");
            return FLClientStatus.FAILED;
        }
        List<ShareSecret> bUV = this.genSecretShares(this.bu);
        if (sSkUv.isEmpty()) {
            LOGGER.severe("[encryptShares] the returned List<ShareSecret> bUV is empty, please check!");
            return FLClientStatus.FAILED;
        }
        if (sSkUv.size() != bUV.size()) {
            LOGGER.severe("[encryptShares] the sSkUv.size() should be equal to bUV.size(), please check!");
            return FLClientStatus.FAILED;
        }
        ArrayList<EncryptShare> encryptShareList = new ArrayList<EncryptShare>();
        for (int i = 0; i < bUV.size(); ++i) {
            byte[] sShare = sSkUv.get(i).getShare().getArray();
            byte[] bShare = bUV.get(i).getShare().getArray();
            byte[] sIndex = BaseUtil.integer2byteArray(sSkUv.get(i).getIndex());
            byte[] bIndex = BaseUtil.integer2byteArray(bUV.get(i).getIndex());
            byte[] allSecret = new byte[sShare.length + bShare.length + sIndex.length + bIndex.length + 4];
            allSecret[0] = (byte)sShare.length;
            allSecret[1] = (byte)bShare.length;
            allSecret[2] = (byte)sIndex.length;
            allSecret[3] = (byte)bIndex.length;
            System.arraycopy(sIndex, 0, allSecret, 4, sIndex.length);
            System.arraycopy(bIndex, 0, allSecret, 4 + sIndex.length, bIndex.length);
            System.arraycopy(sShare, 0, allSecret, 4 + sIndex.length + bIndex.length, sShare.length);
            System.arraycopy(bShare, 0, allSecret, 4 + sIndex.length + bIndex.length + sShare.length, bShare.length);
            String vFlID = bUV.get(i).getFlID();
            if (!this.cUVKeys.containsKey(vFlID)) {
                LOGGER.severe("[encryptShares] the key " + vFlID + " is not in map cUVKeys, please check!");
                return FLClientStatus.FAILED;
            }
            AESEncrypt aesEncrypt = new AESEncrypt(this.cUVKeys.get(vFlID), "CBC");
            byte[] encryptData = aesEncrypt.encrypt(this.cUVKeys.get(vFlID), allSecret);
            if (encryptData == null || encryptData.length == 0) {
                LOGGER.severe("[encryptShares] the return byte[] is null, please check!");
                return FLClientStatus.FAILED;
            }
            NewArray<byte[]> array = new NewArray<byte[]>();
            array.setSize(encryptData.length);
            array.setArray(encryptData);
            EncryptShare encryptShare = new EncryptShare();
            encryptShare.setFlID(vFlID);
            encryptShare.setShare(array);
            encryptShareList.add(encryptShare);
        }
        this.setClientShareList(encryptShareList);
        return FLClientStatus.SUCCESS;
    }

    public float[] doubleMaskingWeight() {
        ArrayList<Float> noiseBu = new ArrayList<Float>();
        int tag = this.masking.getMasking(noiseBu, this.featureSize, this.bu, this.individualIv);
        if (tag == -1) {
            LOGGER.severe("[doubleMaskingWeight] the return value is -1, please check!");
            return new float[0];
        }
        float[] mask = new float[this.featureSize];
        for (String vFlID : this.u2UClientList) {
            byte[] iVec;
            byte[] salt;
            if (!this.clientPublicKeyList.containsKey(vFlID)) {
                LOGGER.severe("[doubleMaskingWeight] the key " + vFlID + " is not in map clientPublicKeyList, please check!");
                return new float[0];
            }
            ClientPublicKey curPublicKey = this.clientPublicKeyList.get(vFlID);
            if (this.localFLParameter.getFlID().equals(vFlID)) continue;
            if (vFlID.compareTo(this.localFLParameter.getFlID()) < 0) {
                salt = curPublicKey.getPwSalt().getArray();
                iVec = curPublicKey.getPwIv().getArray();
            } else {
                salt = this.pwSalt;
                iVec = this.pwIVec;
            }
            if (this.sKey.size() < 2) {
                LOGGER.severe("[doubleMaskingWeight] the size of sKey is not valid: < 2, it should be >= 2, please check!");
                return new float[0];
            }
            byte[] secret1 = this.keyAgreement.keyAgreement(this.sKey.get(1), curPublicKey.getSPK().getArray());
            if (secret1 == null || secret1.length == 0) {
                LOGGER.severe("[doubleMaskingWeight] the returned secret1 is null, please check!");
                return new float[0];
            }
            byte[] secret = this.keyAgreement.getEncryptedPassword(secret1, salt);
            if (secret == null || secret.length == 0) {
                LOGGER.severe("[doubleMaskingWeight] the returned secret is null, please check!");
                return new float[0];
            }
            this.sUVKeys.put(vFlID, secret);
            ArrayList<Float> noiseSuv = new ArrayList<Float>();
            tag = this.masking.getMasking(noiseSuv, this.featureSize, secret, iVec);
            if (tag == -1) {
                LOGGER.severe("[doubleMaskingWeight] the return value is -1, please check!");
                return new float[0];
            }
            int sign = this.localFLParameter.getFlID().compareTo(vFlID) > 0 ? 1 : -1;
            for (int maskIndex = 0; maskIndex < noiseSuv.size(); ++maskIndex) {
                mask[maskIndex] = mask[maskIndex] + (float)sign * ((Float)noiseSuv.get(maskIndex)).floatValue();
            }
        }
        for (int maskIndex = 0; maskIndex < noiseBu.size(); ++maskIndex) {
            mask[maskIndex] = mask[maskIndex] + ((Float)noiseBu.get(maskIndex)).floatValue();
        }
        return mask;
    }

    private NewArray<byte[]> byteToArray(ByteBuffer buf, int size) {
        NewArray<byte[]> newArray = new NewArray<byte[]>();
        newArray.setSize(size);
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            byte word;
            array[i] = word = buf.get();
        }
        newArray.setArray(array);
        return newArray;
    }

    private FLClientStatus requestExchangeKeys() {
        LOGGER.info("[PairWiseMask] ==============request flID: " + this.localFLParameter.getFlID() + "==============");
        FLClientStatus status = this.genDHKeyPairs();
        if (status == FLClientStatus.FAILED) {
            LOGGER.severe("[requestExchangeKeys] the return status is FAILED, please check!");
            return FLClientStatus.FAILED;
        }
        if (this.cKey.size() <= 0 || this.sKey.size() <= 0) {
            LOGGER.severe("[requestExchangeKeys] the size of cKey or sKey is not valid: <=0.");
            return FLClientStatus.FAILED;
        }
        if (this.cKey.size() < 2) {
            LOGGER.severe("[requestExchangeKeys] the size of cKey is not valid: < 2, it should be >= 2, please check!");
            return FLClientStatus.FAILED;
        }
        if (this.sKey.size() < 2) {
            LOGGER.severe("[requestExchangeKeys] the size of sKey is not valid: < 2, it should be >= 2, please check!");
            return FLClientStatus.FAILED;
        }
        byte[] indIv = new byte[16];
        byte[] pwIv = new byte[16];
        byte[] thisPwSalt = new byte[32];
        SecureRandom secureRandom = Common.getSecureRandom();
        secureRandom.nextBytes(indIv);
        secureRandom.nextBytes(pwIv);
        secureRandom.nextBytes(thisPwSalt);
        this.individualIv = indIv;
        this.pwIVec = pwIv;
        this.pwSalt = thisPwSalt;
        FlatBufferBuilder fbBuilder = new FlatBufferBuilder();
        int indIvFbs = RequestExchangeKeys.createIndIvVector(fbBuilder, indIv);
        int pwIvFbs = RequestExchangeKeys.createPwIvVector(fbBuilder, pwIv);
        int pwSaltFbs = RequestExchangeKeys.createPwSaltVector(fbBuilder, thisPwSalt);
        byte[] cPK = this.cKey.get(0);
        byte[] sPK = this.sKey.get(0);
        int cpk = RequestExchangeKeys.createCPkVector(fbBuilder, cPK);
        int spk = RequestExchangeKeys.createSPkVector(fbBuilder, sPK);
        int id = fbBuilder.createString((CharSequence)this.localFLParameter.getFlID());
        Date date = new Date();
        long timestamp = date.getTime();
        String dateTime = String.valueOf(timestamp);
        int time = fbBuilder.createString((CharSequence)dateTime);
        String clientID = this.flParameter.getClientID();
        int certificatesInt = 0;
        int signed = 0;
        if (this.flParameter.isPkiVerify()) {
            int waitTakeEffectTime = 5000;
            Common.sleep(waitTakeEffectTime);
            int nSize = 2;
            String[] pemCertificateChains = CipherClient.transformX509ArrayToPemArray(CertVerify.getX509CertificateChain(clientID));
            int[] pemList = new int[nSize];
            for (int i = 0; i < nSize; ++i) {
                pemList[i] = fbBuilder.createString((CharSequence)pemCertificateChains[i]);
            }
            certificatesInt = RequestExchangeKeys.createCertificateChainVector(fbBuilder, pemList);
            byte[] signature = this.signPkAndTime(clientID, cPK, sPK, dateTime, this.iteration);
            signed = RequestExchangeKeys.createSignatureVector(fbBuilder, signature);
        }
        RequestExchangeKeys.startRequestExchangeKeys(fbBuilder);
        RequestExchangeKeys.addFlId(fbBuilder, id);
        RequestExchangeKeys.addCPk(fbBuilder, cpk);
        RequestExchangeKeys.addSPk(fbBuilder, spk);
        RequestExchangeKeys.addIteration(fbBuilder, this.iteration);
        RequestExchangeKeys.addTimestamp(fbBuilder, time);
        RequestExchangeKeys.addIndIv(fbBuilder, indIvFbs);
        RequestExchangeKeys.addPwIv(fbBuilder, pwIvFbs);
        RequestExchangeKeys.addPwSalt(fbBuilder, pwSaltFbs);
        if (this.flParameter.isPkiVerify()) {
            RequestExchangeKeys.addSignature(fbBuilder, signed);
            RequestExchangeKeys.addCertificateChain(fbBuilder, certificatesInt);
        }
        int exchangeKeysRoot = RequestExchangeKeys.endRequestExchangeKeys(fbBuilder);
        fbBuilder.finish(exchangeKeysRoot);
        byte[] msg = fbBuilder.sizedByteArray();
        String url = Common.generateUrl(this.flParameter.isUseElb(), this.flParameter.getServerNum(), this.flParameter.getDomainName());
        try {
            byte[] responseData = this.flCommunication.syncRequest(url + "/exchangeKeys", msg);
            if (!Common.isSeverReady(responseData)) {
                return this.serverNotReady("requestExchangeKeys");
            }
            if (Common.isSeverJobFinished(responseData)) {
                return this.serverJobFinished("requestExchangeKeys");
            }
            ByteBuffer buffer = ByteBuffer.wrap(responseData);
            ResponseExchangeKeys responseExchangeKeys = ResponseExchangeKeys.getRootAsResponseExchangeKeys(buffer);
            return this.judgeRequestExchangeKeys(responseExchangeKeys);
        }
        catch (IOException ex) {
            LOGGER.severe("[requestExchangeKeys] catch IOException: " + ex.getMessage());
            return FLClientStatus.FAILED;
        }
    }

    private FLClientStatus judgeRequestExchangeKeys(ResponseExchangeKeys bufData) {
        this.retCode = bufData.retcode();
        LOGGER.info("[PairWiseMask] **************the response of RequestExchangeKeys**************");
        LOGGER.info("[PairWiseMask] return code: " + this.retCode);
        LOGGER.info("[PairWiseMask] reason: " + bufData.reason());
        LOGGER.info("[PairWiseMask] current iteration in server: " + bufData.iteration());
        LOGGER.info("[PairWiseMask] next request time: " + bufData.nextReqTime());
        switch (this.retCode) {
            case 200: {
                LOGGER.info("[PairWiseMask] RequestExchangeKeys success");
                return FLClientStatus.SUCCESS;
            }
            case 300: {
                LOGGER.info("[PairWiseMask] RequestExchangeKeys out of time: need wait and request startFLJob again");
                this.setNextRequestTime(bufData.nextReqTime());
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.info("[PairWiseMask] catch RequestError or SystemError in RequestExchangeKeys");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[PairWiseMask] the return <retCode> from server in ResponseExchangeKeys is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    private FLClientStatus getExchangeKeys() {
        int getExchangeKeysRoot;
        FlatBufferBuilder fbBuilder = new FlatBufferBuilder();
        int id = fbBuilder.createString((CharSequence)this.localFLParameter.getFlID());
        Date date = new Date();
        long timestamp = date.getTime();
        String dateTime = String.valueOf(timestamp);
        int time = fbBuilder.createString((CharSequence)dateTime);
        byte[] signature = CipherClient.signTimeAndIter(dateTime, this.iteration);
        if (signature == null) {
            LOGGER.severe("[getExchangeKeys] get signature is null!");
            return FLClientStatus.FAILED;
        }
        if (signature.length > 0) {
            int signed = GetExchangeKeys.createSignatureVector(fbBuilder, signature);
            GetExchangeKeys.startGetExchangeKeys(fbBuilder);
            GetExchangeKeys.addFlId(fbBuilder, id);
            GetExchangeKeys.addIteration(fbBuilder, this.iteration);
            GetExchangeKeys.addTimestamp(fbBuilder, time);
            GetExchangeKeys.addSignature(fbBuilder, signed);
            getExchangeKeysRoot = GetExchangeKeys.endGetExchangeKeys(fbBuilder);
        } else {
            GetExchangeKeys.startGetExchangeKeys(fbBuilder);
            GetExchangeKeys.addFlId(fbBuilder, id);
            GetExchangeKeys.addIteration(fbBuilder, this.iteration);
            GetExchangeKeys.addTimestamp(fbBuilder, time);
            getExchangeKeysRoot = GetExchangeKeys.endGetExchangeKeys(fbBuilder);
        }
        fbBuilder.finish(getExchangeKeysRoot);
        byte[] msg = fbBuilder.sizedByteArray();
        String url = Common.generateUrl(this.flParameter.isUseElb(), this.flParameter.getServerNum(), this.flParameter.getDomainName());
        try {
            byte[] responseData = this.flCommunication.syncRequest(url + "/getKeys", msg);
            if (!Common.isSeverReady(responseData)) {
                return this.serverNotReady("getExchangeKeys");
            }
            if (Common.isSeverJobFinished(responseData)) {
                return this.serverJobFinished("getExchangeKeys");
            }
            ByteBuffer buffer = ByteBuffer.wrap(responseData);
            ReturnExchangeKeys returnExchangeKeys = ReturnExchangeKeys.getRootAsReturnExchangeKeys(buffer);
            return this.judgeGetExchangeKeys(returnExchangeKeys);
        }
        catch (IOException ex) {
            LOGGER.severe("[getExchangeKeys] catch IOException: " + ex.getMessage());
            return FLClientStatus.FAILED;
        }
    }

    private FLClientStatus judgeGetExchangeKeys(ReturnExchangeKeys bufData) {
        this.retCode = bufData.retcode();
        LOGGER.info("[PairWiseMask] **************the response of GetExchangeKeys**************");
        LOGGER.info("[PairWiseMask] return code: " + this.retCode);
        LOGGER.info("[PairWiseMask] current iteration in server: " + bufData.iteration());
        LOGGER.info("[PairWiseMask] next request time: " + bufData.nextReqTime());
        switch (this.retCode) {
            case 200: {
                LOGGER.info("[PairWiseMask] GetExchangeKeys success");
                this.clientPublicKeyList.clear();
                this.u1ClientList.clear();
                int length = bufData.remotePublickeysLength();
                for (int i = 0; i < length; ++i) {
                    FLClientStatus checkResult;
                    ByteBuffer bufCpk = bufData.remotePublickeys(i).cPkAsByteBuffer();
                    ByteBuffer bufSpk = bufData.remotePublickeys(i).sPkAsByteBuffer();
                    int sizeCpk = bufData.remotePublickeys(i).cPkLength();
                    int sizeSpk = bufData.remotePublickeys(i).sPkLength();
                    byte[] bufCpkList = this.byteBufferToList(bufCpk, sizeCpk);
                    byte[] bufSpkList = this.byteBufferToList(bufSpk, sizeSpk);
                    byte[] cPkByte = (byte[])bufCpkList.clone();
                    byte[] sPkByte = (byte[])bufSpkList.clone();
                    boolean isPkiVerify = this.flParameter.isPkiVerify();
                    if (isPkiVerify && (checkResult = this.checkSignature(bufData, i, cPkByte, sPkByte)) == FLClientStatus.FAILED) {
                        return FLClientStatus.FAILED;
                    }
                    ClientPublicKey publicKey = new ClientPublicKey();
                    String srcFlId = bufData.remotePublickeys(i).flId();
                    publicKey.setFlID(srcFlId);
                    ByteBuffer bufPwIv = bufData.remotePublickeys(i).pwIvAsByteBuffer();
                    int sizePwIv = bufData.remotePublickeys(i).pwIvLength();
                    ByteBuffer bufPwSalt = bufData.remotePublickeys(i).pwSaltAsByteBuffer();
                    int sizePwSalt = bufData.remotePublickeys(i).pwSaltLength();
                    publicKey.setPwIv(this.byteToArray(bufPwIv, sizePwIv));
                    publicKey.setPwSalt(this.byteToArray(bufPwSalt, sizePwSalt));
                    NewArray<byte[]> bufCpkArray = new NewArray<byte[]>();
                    bufCpkArray.setSize(sizeCpk);
                    bufCpkArray.setArray(bufCpkList);
                    NewArray<byte[]> bufSpkArray = new NewArray<byte[]>();
                    bufSpkArray.setSize(sizeSpk);
                    bufSpkArray.setArray(bufSpkList);
                    publicKey.setCPK(bufCpkArray);
                    publicKey.setSPK(bufSpkArray);
                    this.clientPublicKeyList.put(srcFlId, publicKey);
                    this.u1ClientList.add(srcFlId);
                }
                return FLClientStatus.SUCCESS;
            }
            case 201: {
                LOGGER.info("[PairWiseMask] server is not ready now, need wait and request GetExchangeKeys again!");
                return FLClientStatus.WAIT;
            }
            case 300: {
                LOGGER.info("[PairWiseMask] GetExchangeKeys out of time: need wait and request startFLJob again");
                this.setNextRequestTime(bufData.nextReqTime());
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.info("[PairWiseMask] catch SucNotMatch or SystemError in GetExchangeKeys");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[PairWiseMask] the return <retCode> from server in ReturnExchangeKeys is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    private FLClientStatus checkSignature(ReturnExchangeKeys bufData, int dataIndex, byte[] cPkByte, byte[] sPkByte) {
        ByteBuffer signature = bufData.remotePublickeys(dataIndex).signatureAsByteBuffer();
        if (signature == null) {
            LOGGER.severe("[checkSignature] the signature get from server is null, please confirm that pki_verify mode is open at server.");
            return FLClientStatus.FAILED;
        }
        byte[] sigByte = new byte[signature.remaining()];
        signature.get(sigByte);
        int certifyNum = bufData.remotePublickeys(dataIndex).certificateChainLength();
        String[] pemCerts = new String[certifyNum];
        for (int certIndex = 0; certIndex < certifyNum; ++certIndex) {
            pemCerts[certIndex] = bufData.remotePublickeys(dataIndex).certificateChain(certIndex);
        }
        X509Certificate[] x509Certificates = CertVerify.transformPemArrayToX509Array(pemCerts);
        if (x509Certificates.length < 2) {
            LOGGER.severe("the length of x509Certificates is not valid, should be >= 2");
            return FLClientStatus.FAILED;
        }
        String certificateHash = PkiUtil.genHashFromCer(x509Certificates[1]);
        LOGGER.info("Get certificate hash success!");
        String srcFlId = bufData.remotePublickeys(dataIndex).flId();
        if (!certificateHash.equals(srcFlId)) {
            LOGGER.severe("Check flID failed!source flID: " + srcFlId + "Hash ID from certificate: " + certificateHash.equals(srcFlId));
            return FLClientStatus.FAILED;
        }
        LOGGER.info("Check flID success and source flID is:" + srcFlId);
        this.certificateList.put(srcFlId, x509Certificates);
        String timestamp = bufData.remotePublickeys(dataIndex).timestamp();
        String clientID = this.flParameter.getClientID();
        if (!CipherClient.verifySignature(clientID, x509Certificates, sigByte, cPkByte, sPkByte, timestamp, this.iteration)) {
            LOGGER.info("[PairWiseMask] FlID: " + srcFlId + ", signature authentication failed");
            return FLClientStatus.FAILED;
        }
        LOGGER.info("[PairWiseMask] Verify signature success!");
        int remoteIter = bufData.iteration();
        FLClientStatus iterTimeCheck = this.checkIterAndTimestamp(remoteIter, timestamp);
        if (iterTimeCheck == FLClientStatus.FAILED) {
            return FLClientStatus.FAILED;
        }
        return FLClientStatus.SUCCESS;
    }

    private FLClientStatus checkIterAndTimestamp(int remoteIter, String timestamp) {
        if (remoteIter != this.iteration) {
            LOGGER.severe("[PairWiseMask] iteration check failed. Remote iteration of client: is " + remoteIter + ", which is not consistent with current iteration:" + this.iteration);
            return FLClientStatus.FAILED;
        }
        Date date = new Date();
        long currentTimeStamp = date.getTime();
        if (timestamp == null) {
            LOGGER.severe("[PairWiseMask] Received timeStamp is null,please check it!");
            return FLClientStatus.FAILED;
        }
        long remoteTimeStamp = Long.parseLong(timestamp);
        long validIterInterval = this.flParameter.getValidInterval();
        if (Math.abs(currentTimeStamp - remoteTimeStamp) > validIterInterval) {
            LOGGER.severe("[PairWiseMask] timeStamp check failed! The difference between remote timestamp and current timestamp is beyond valid iteration interval!");
            return FLClientStatus.FAILED;
        }
        return FLClientStatus.SUCCESS;
    }

    private byte[] byteBufferToList(ByteBuffer buf, int size) {
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            byte word;
            array[i] = word = buf.get();
        }
        return array;
    }

    private FLClientStatus requestShareSecrets() {
        int requestShareSecretsRoot;
        FLClientStatus status = this.genIndividualSecret();
        if (status == FLClientStatus.FAILED) {
            LOGGER.severe("[requestShareSecrets] the returned status is FAILED from genIndividualSecret(), please check!");
            return FLClientStatus.FAILED;
        }
        status = this.genEncryptExchangedKeys();
        if (status == FLClientStatus.FAILED) {
            LOGGER.severe("[requestShareSecrets] the returned status is FAILED from genEncryptExchangedKeys(), please check!");
            return FLClientStatus.FAILED;
        }
        status = this.encryptShares();
        if (status == FLClientStatus.FAILED) {
            LOGGER.severe("[requestShareSecrets] the returned status is FAILED from encryptShares(), please check!");
            return FLClientStatus.FAILED;
        }
        FlatBufferBuilder fbBuilder = new FlatBufferBuilder();
        int id = fbBuilder.createString((CharSequence)this.localFLParameter.getFlID());
        Date date = new Date();
        long timestamp = date.getTime();
        String dateTime = String.valueOf(timestamp);
        int time = fbBuilder.createString((CharSequence)dateTime);
        int clientShareSize = this.clientShareList.size();
        if (clientShareSize <= 0) {
            LOGGER.warning("[PairWiseMask] encrypt shares is not ready now!");
            Common.sleep(10000L);
            return this.requestShareSecrets();
        }
        int[] add = new int[clientShareSize];
        for (int i = 0; i < clientShareSize; ++i) {
            int clientShareRoot;
            int flID = fbBuilder.createString((CharSequence)this.clientShareList.get(i).getFlID());
            int shareSecretFbs = ClientShare.createShareVector(fbBuilder, this.clientShareList.get(i).getShare().getArray());
            ClientShare.startClientShare(fbBuilder);
            ClientShare.addFlId(fbBuilder, flID);
            ClientShare.addShare(fbBuilder, shareSecretFbs);
            add[i] = clientShareRoot = ClientShare.endClientShare(fbBuilder);
        }
        int encryptedSharesFbs = RequestShareSecrets.createEncryptedSharesVector(fbBuilder, add);
        byte[] signature = CipherClient.signTimeAndIter(dateTime, this.iteration);
        if (signature == null) {
            LOGGER.severe("[PairWiseMask] get signature is null!");
            return FLClientStatus.FAILED;
        }
        if (signature.length > 0) {
            int signed = RequestShareSecrets.createSignatureVector(fbBuilder, signature);
            RequestShareSecrets.startRequestShareSecrets(fbBuilder);
            RequestShareSecrets.addFlId(fbBuilder, id);
            RequestShareSecrets.addEncryptedShares(fbBuilder, encryptedSharesFbs);
            RequestShareSecrets.addIteration(fbBuilder, this.iteration);
            RequestShareSecrets.addTimestamp(fbBuilder, time);
            RequestShareSecrets.addSignature(fbBuilder, signed);
            requestShareSecretsRoot = RequestShareSecrets.endRequestShareSecrets(fbBuilder);
        } else {
            RequestShareSecrets.startRequestShareSecrets(fbBuilder);
            RequestShareSecrets.addFlId(fbBuilder, id);
            RequestShareSecrets.addEncryptedShares(fbBuilder, encryptedSharesFbs);
            RequestShareSecrets.addIteration(fbBuilder, this.iteration);
            RequestShareSecrets.addTimestamp(fbBuilder, time);
            requestShareSecretsRoot = RequestShareSecrets.endRequestShareSecrets(fbBuilder);
        }
        fbBuilder.finish(requestShareSecretsRoot);
        byte[] msg = fbBuilder.sizedByteArray();
        try {
            String url = Common.generateUrl(this.flParameter.isUseElb(), this.flParameter.getServerNum(), this.flParameter.getDomainName());
            byte[] responseData = this.flCommunication.syncRequest(url + "/shareSecrets", msg);
            if (!Common.isSeverReady(responseData)) {
                return this.serverNotReady("requestShareSecrets");
            }
            if (Common.isSeverJobFinished(responseData)) {
                return this.serverJobFinished("requestShareSecrets");
            }
            ByteBuffer buffer = ByteBuffer.wrap(responseData);
            ResponseShareSecrets responseShareSecrets = ResponseShareSecrets.getRootAsResponseShareSecrets(buffer);
            return this.judgeRequestShareSecrets(responseShareSecrets);
        }
        catch (IOException ex) {
            LOGGER.severe("[requestShareSecrets] catch IOException: " + ex.getMessage());
            return FLClientStatus.FAILED;
        }
    }

    private FLClientStatus judgeRequestShareSecrets(ResponseShareSecrets bufData) {
        this.retCode = bufData.retcode();
        LOGGER.info("[PairWiseMask] **************the response of RequestShareSecrets**************");
        LOGGER.info("[PairWiseMask] return code: " + this.retCode);
        LOGGER.info("[PairWiseMask] reason: " + bufData.reason());
        LOGGER.info("[PairWiseMask] current iteration in server: " + bufData.iteration());
        LOGGER.info("[PairWiseMask] next request time: " + bufData.nextReqTime());
        switch (this.retCode) {
            case 200: {
                LOGGER.info("[PairWiseMask] RequestShareSecrets success");
                return FLClientStatus.SUCCESS;
            }
            case 300: {
                LOGGER.info("[PairWiseMask] RequestShareSecrets out of time: need wait and request startFLJob again");
                this.setNextRequestTime(bufData.nextReqTime());
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.info("[PairWiseMask] catch SucNotMatch or SystemError in RequestShareSecrets");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[PairWiseMask] the return <retCode> from server in ResponseShareSecrets is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    private FLClientStatus getShareSecrets() {
        int getShareSecrets;
        FlatBufferBuilder fbBuilder = new FlatBufferBuilder();
        int id = fbBuilder.createString((CharSequence)this.localFLParameter.getFlID());
        Date date = new Date();
        long timestamp = date.getTime();
        String dateTime = String.valueOf(timestamp);
        int time = fbBuilder.createString((CharSequence)dateTime);
        byte[] signature = CipherClient.signTimeAndIter(dateTime, this.iteration);
        if (signature == null) {
            LOGGER.severe("[getShareSecrets] get signature is null!");
            return FLClientStatus.FAILED;
        }
        if (signature.length > 0) {
            int signed = GetShareSecrets.createSignatureVector(fbBuilder, signature);
            GetShareSecrets.startGetShareSecrets(fbBuilder);
            GetShareSecrets.addFlId(fbBuilder, id);
            GetShareSecrets.addIteration(fbBuilder, this.iteration);
            GetShareSecrets.addTimestamp(fbBuilder, time);
            GetShareSecrets.addSignature(fbBuilder, signed);
            getShareSecrets = GetShareSecrets.endGetShareSecrets(fbBuilder);
        } else {
            GetShareSecrets.startGetShareSecrets(fbBuilder);
            GetShareSecrets.addFlId(fbBuilder, id);
            GetShareSecrets.addIteration(fbBuilder, this.iteration);
            GetShareSecrets.addTimestamp(fbBuilder, time);
            getShareSecrets = GetShareSecrets.endGetShareSecrets(fbBuilder);
        }
        fbBuilder.finish(getShareSecrets);
        byte[] msg = fbBuilder.sizedByteArray();
        String url = Common.generateUrl(this.flParameter.isUseElb(), this.flParameter.getServerNum(), this.flParameter.getDomainName());
        try {
            byte[] responseData = this.flCommunication.syncRequest(url + "/getSecrets", msg);
            if (!Common.isSeverReady(responseData)) {
                return this.serverNotReady("getShareSecrets");
            }
            if (Common.isSeverJobFinished(responseData)) {
                return this.serverJobFinished("getShareSecrets");
            }
            ByteBuffer buffer = ByteBuffer.wrap(responseData);
            ReturnShareSecrets returnShareSecrets = ReturnShareSecrets.getRootAsReturnShareSecrets(buffer);
            return this.judgeGetShareSecrets(returnShareSecrets);
        }
        catch (IOException ex) {
            LOGGER.severe("[getShareSecrets] catch IOException: " + ex.getMessage());
            return FLClientStatus.FAILED;
        }
    }

    private FLClientStatus judgeGetShareSecrets(ReturnShareSecrets bufData) {
        this.retCode = bufData.retcode();
        LOGGER.info("[PairWiseMask] **************the response of GetShareSecrets**************");
        LOGGER.info("[PairWiseMask] return code: " + this.retCode);
        LOGGER.info("[PairWiseMask] current iteration in server: " + bufData.iteration());
        LOGGER.info("[PairWiseMask] next request time: " + bufData.nextReqTime());
        LOGGER.info("[PairWiseMask] the size of encrypted shares: " + bufData.encryptedSharesLength());
        switch (this.retCode) {
            case 200: {
                LOGGER.info("[PairWiseMask] GetShareSecrets success");
                this.returnShareList.clear();
                this.u2UClientList.clear();
                int length = bufData.encryptedSharesLength();
                for (int i = 0; i < length; ++i) {
                    EncryptShare shareSecret = new EncryptShare();
                    ClientShare clientShare = bufData.encryptedShares(i);
                    if (clientShare == null) {
                        LOGGER.severe("[PairWiseMask] the clientShare returned from server is null");
                        return FLClientStatus.FAILED;
                    }
                    shareSecret.setFlID(clientShare.flId());
                    ByteBuffer bufShare = clientShare.shareAsByteBuffer();
                    int sizeShare = clientShare.shareLength();
                    shareSecret.setShare(this.byteToArray(bufShare, sizeShare));
                    this.returnShareList.add(shareSecret);
                    this.u2UClientList.add(clientShare.flId());
                }
                return FLClientStatus.SUCCESS;
            }
            case 201: {
                LOGGER.info("[PairWiseMask] server is not ready now, need wait and request GetShareSecrets again!");
                return FLClientStatus.WAIT;
            }
            case 300: {
                LOGGER.info("[PairWiseMask] GetShareSecrets out of time: need wait and request startFLJob again");
                this.setNextRequestTime(bufData.nextReqTime());
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.info("[PairWiseMask] catch SucNotMatch or SystemError in GetShareSecrets");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[PairWiseMask] the return <retCode> from server in ReturnShareSecrets is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    public FLClientStatus exchangeKeys() {
        LOGGER.info("[PairWiseMask] ==================== round0: RequestExchangeKeys+GetExchangeKeys ======================");
        FLClientStatus curStatus = this.requestExchangeKeys();
        this.waitTryTime = 0;
        while (curStatus == FLClientStatus.WAIT) {
            ++this.waitTryTime;
            if (this.waitTryTimeExceedsLimit().booleanValue()) {
                curStatus = FLClientStatus.FAILED;
                break;
            }
            Common.sleep(10000L);
            curStatus = this.requestExchangeKeys();
        }
        if (curStatus != FLClientStatus.SUCCESS) {
            return curStatus;
        }
        curStatus = this.getExchangeKeys();
        this.waitTryTime = 0;
        while (curStatus == FLClientStatus.WAIT) {
            ++this.waitTryTime;
            if (this.waitTryTimeExceedsLimit().booleanValue()) {
                curStatus = FLClientStatus.FAILED;
                break;
            }
            Common.sleep(10000L);
            curStatus = this.getExchangeKeys();
        }
        return curStatus;
    }

    public FLClientStatus shareSecrets() {
        LOGGER.info("[PairWiseMask] ==================== round1: RequestShareSecrets+GetShareSecrets ======================");
        FLClientStatus curStatus = this.requestShareSecrets();
        this.waitTryTime = 0;
        while (curStatus == FLClientStatus.WAIT) {
            ++this.waitTryTime;
            if (this.waitTryTimeExceedsLimit().booleanValue()) {
                curStatus = FLClientStatus.FAILED;
                break;
            }
            Common.sleep(10000L);
            curStatus = this.requestShareSecrets();
        }
        if (curStatus != FLClientStatus.SUCCESS) {
            return curStatus;
        }
        curStatus = this.getShareSecrets();
        this.waitTryTime = 0;
        while (curStatus == FLClientStatus.WAIT) {
            ++this.waitTryTime;
            if (this.waitTryTimeExceedsLimit().booleanValue()) {
                curStatus = FLClientStatus.FAILED;
                break;
            }
            Common.sleep(10000L);
            curStatus = this.getShareSecrets();
        }
        return curStatus;
    }

    public FLClientStatus reconstructSecrets() {
        LOGGER.info("[PairWiseMask] =================== round3: GetClientList+SendReconstructSecret ========================");
        FLClientStatus curStatus = this.clientListReq.getClientList(this.iteration, this.u3ClientList, this.decryptShareSecretsList, this.returnShareList, this.cUVKeys);
        this.waitTryTime = 0;
        while (curStatus == FLClientStatus.WAIT) {
            ++this.waitTryTime;
            if (this.waitTryTimeExceedsLimit().booleanValue()) {
                curStatus = FLClientStatus.FAILED;
                break;
            }
            Common.sleep(10000L);
            curStatus = this.clientListReq.getClientList(this.iteration, this.u3ClientList, this.decryptShareSecretsList, this.returnShareList, this.cUVKeys);
        }
        if (curStatus == FLClientStatus.RESTART) {
            this.nextRequestTime = this.clientListReq.getNextRequestTime();
        }
        if (curStatus != FLClientStatus.SUCCESS) {
            return curStatus;
        }
        this.retCode = this.clientListReq.getRetCode();
        if (this.flParameter.isPkiVerify()) {
            LOGGER.info("[PairWiseMask] The mode is pkiVerify mode, start clientList check ...");
            curStatus = this.clientListCheck();
            this.waitTryTime = 0;
            while (curStatus == FLClientStatus.WAIT) {
                ++this.waitTryTime;
                if (this.waitTryTimeExceedsLimit().booleanValue()) {
                    curStatus = FLClientStatus.FAILED;
                    break;
                }
                Common.sleep(10000L);
                curStatus = this.clientListCheck();
            }
            if (curStatus != FLClientStatus.SUCCESS) {
                return curStatus;
            }
        }
        curStatus = this.reconstructSecretReq.sendReconstructSecret(this.decryptShareSecretsList, this.u3ClientList, this.iteration);
        this.waitTryTime = 0;
        while (curStatus == FLClientStatus.WAIT) {
            ++this.waitTryTime;
            if (this.waitTryTimeExceedsLimit().booleanValue()) {
                curStatus = FLClientStatus.FAILED;
                break;
            }
            Common.sleep(10000L);
            curStatus = this.reconstructSecretReq.sendReconstructSecret(this.decryptShareSecretsList, this.u3ClientList, this.iteration);
        }
        if (curStatus == FLClientStatus.RESTART) {
            this.nextRequestTime = this.reconstructSecretReq.getNextRequestTime();
        }
        this.retCode = this.reconstructSecretReq.getRetCode();
        return curStatus;
    }

    private byte[] signPkAndTime(String clientID, byte[] cPK, byte[] sPK, String time, int iterNum) {
        byte[] concatData = CipherClient.concatenateData(cPK, sPK, time, iterNum);
        LOGGER.info("concatenate data success!");
        return SignAndVerify.signData(clientID, concatData);
    }

    private static byte[] concatenateData(byte[] cPK, byte[] sPK, String time, int iterNum) {
        if (time == null) {
            LOGGER.severe("[concatenateData] input time is null, please check!");
            throw new IllegalArgumentException();
        }
        byte[] byteTime = time.getBytes(StandardCharsets.UTF_8);
        String iterString = String.valueOf(iterNum);
        byte[] byteIter = iterString.getBytes(StandardCharsets.UTF_8);
        int concatLength = cPK.length + sPK.length + byteTime.length + byteIter.length;
        byte[] concatData = new byte[concatLength];
        int offset = 0;
        System.arraycopy(cPK, 0, concatData, offset, cPK.length);
        System.arraycopy(sPK, 0, concatData, offset += cPK.length, sPK.length);
        System.arraycopy(byteTime, 0, concatData, offset += sPK.length, byteTime.length);
        System.arraycopy(byteIter, 0, concatData, offset += byteTime.length, byteIter.length);
        return concatData;
    }

    private static byte[] concatenateIterAndTime(String time, int iterNum) {
        byte[] byteTime = time.getBytes(StandardCharsets.UTF_8);
        String iterString = String.valueOf(iterNum);
        byte[] byteIter = iterString.getBytes(StandardCharsets.UTF_8);
        int concatLength = byteTime.length + byteIter.length;
        byte[] concatData = new byte[concatLength];
        int offset = 0;
        System.arraycopy(byteTime, 0, concatData, offset, byteTime.length);
        System.arraycopy(byteIter, 0, concatData, offset += byteTime.length, byteIter.length);
        return concatData;
    }

    private static boolean verifySignature(String clientID, X509Certificate[] x509Certificates, byte[] signature, byte[] cPK, byte[] sPK, String timestamp, int iteration) {
        byte[] concatData = CipherClient.concatenateData(cPK, sPK, timestamp, iteration);
        return SignAndVerify.verifySignatureByCert(clientID, x509Certificates, concatData, signature);
    }

    private FLClientStatus clientListCheck() {
        LOGGER.info("[PairWiseMask] ==================== ClientListCheck ======================");
        FLClientStatus curStatus = this.sendClientListSign();
        this.waitTryTime = 0;
        while (curStatus == FLClientStatus.WAIT) {
            ++this.waitTryTime;
            if (this.waitTryTimeExceedsLimit().booleanValue()) {
                curStatus = FLClientStatus.FAILED;
                break;
            }
            Common.sleep(10000L);
            curStatus = this.sendClientListSign();
        }
        if (curStatus != FLClientStatus.SUCCESS) {
            return curStatus;
        }
        curStatus = this.getAllClientListSign();
        this.waitTryTime = 0;
        while (curStatus == FLClientStatus.WAIT) {
            ++this.waitTryTime;
            if (this.waitTryTimeExceedsLimit().booleanValue()) {
                curStatus = FLClientStatus.FAILED;
                break;
            }
            Common.sleep(10000L);
            curStatus = this.getAllClientListSign();
        }
        return curStatus;
    }

    private FLClientStatus sendClientListSign() {
        int sendClientListRoot;
        LOGGER.info("[PairWiseMask] ==============request flID: " + this.localFLParameter.getFlID() + "==============");
        this.genDHKeyPairs();
        List<String> clientList = this.u3ClientList;
        int listSize = this.u3ClientList.size();
        if (listSize == 0) {
            LOGGER.severe("[Encrypt] u3List is empty, please check!");
            return FLClientStatus.FAILED;
        }
        byte[] clientListByte = this.transStringListToByte(clientList);
        byte[] listHash = SignAndVerify.getSHA256(clientListByte);
        String clientID = this.flParameter.getClientID();
        byte[] signature = SignAndVerify.signData(clientID, listHash);
        if (signature == null) {
            LOGGER.severe("[sendClientListSign] the returned signature is null");
            return FLClientStatus.FAILED;
        }
        FlatBufferBuilder fbBuilder = new FlatBufferBuilder();
        int signed = RequestExchangeKeys.createSignatureVector(fbBuilder, signature);
        Date date = new Date();
        long timestamp = date.getTime();
        String dateTime = String.valueOf(timestamp);
        byte[] reqSign = CipherClient.signTimeAndIter(dateTime, this.iteration);
        String flID = this.localFLParameter.getFlID();
        int id = fbBuilder.createString((CharSequence)flID);
        int time = fbBuilder.createString((CharSequence)dateTime);
        if (signature.length > 0) {
            int reqSigned = SendClientListSign.createSignatureVector(fbBuilder, reqSign);
            sendClientListRoot = SendClientListSign.createSendClientListSign(fbBuilder, id, this.iteration, time, signed, reqSigned);
        } else {
            sendClientListRoot = SendClientListSign.createSendClientListSign(fbBuilder, id, this.iteration, time, signed, 0);
        }
        fbBuilder.finish(sendClientListRoot);
        byte[] msg = fbBuilder.sizedByteArray();
        String url = Common.generateUrl(this.flParameter.isUseElb(), this.flParameter.getServerNum(), this.flParameter.getDomainName());
        try {
            byte[] responseData = this.flCommunication.syncRequest(url + "/pushListSign", msg);
            if (!Common.isSeverReady(responseData)) {
                return this.serverNotReady("sendClientListSign");
            }
            if (Common.isSeverJobFinished(responseData)) {
                return this.serverJobFinished("sendClientListSign");
            }
            ByteBuffer buffer = ByteBuffer.wrap(responseData);
            ResponseClientListSign responseClientListSign = ResponseClientListSign.getRootAsResponseClientListSign(buffer);
            return this.judgeRequestClientList(responseClientListSign);
        }
        catch (IOException e) {
            e.printStackTrace();
            return FLClientStatus.FAILED;
        }
    }

    private FLClientStatus judgeRequestClientList(ResponseClientListSign bufData) {
        this.retCode = bufData.retcode();
        LOGGER.info("[PairWiseMask] **************the response of RequestClientListSign**************");
        LOGGER.info("[PairWiseMask] return code: " + this.retCode);
        LOGGER.info("[PairWiseMask] reason: " + bufData.reason());
        LOGGER.info("[PairWiseMask] current iteration in server: " + bufData.iteration());
        LOGGER.info("[PairWiseMask] next request time: " + bufData.nextReqTime());
        switch (this.retCode) {
            case 200: {
                LOGGER.info("[PairWiseMask] RequestClientListSign success");
                return FLClientStatus.SUCCESS;
            }
            case 300: {
                LOGGER.info("[PairWiseMask] RequestClientListSign out of time: need wait and request startFLJob again");
                this.setNextRequestTime(bufData.nextReqTime());
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.info("[PairWiseMask] catch RequestError or SystemError in RequestClientListSign");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[PairWiseMask] the return <retCode> from server in RequestClientListSign is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    private FLClientStatus getAllClientListSign() {
        int requestAllClientListSign;
        FlatBufferBuilder fbBuilder = new FlatBufferBuilder();
        int id = fbBuilder.createString((CharSequence)this.localFLParameter.getFlID());
        Date date = new Date();
        long timestamp = date.getTime();
        String dateTime = String.valueOf(timestamp);
        int time = fbBuilder.createString((CharSequence)dateTime);
        byte[] signature = CipherClient.signTimeAndIter(dateTime, this.iteration);
        if (signature.length > 0) {
            int signed = RequestAllClientListSign.createSignatureVector(fbBuilder, signature);
            requestAllClientListSign = RequestAllClientListSign.createRequestAllClientListSign(fbBuilder, id, this.iteration, time, signed);
        } else {
            requestAllClientListSign = RequestAllClientListSign.createRequestAllClientListSign(fbBuilder, id, this.iteration, time, 0);
        }
        fbBuilder.finish(requestAllClientListSign);
        byte[] msg = fbBuilder.sizedByteArray();
        String url = Common.generateUrl(this.flParameter.isUseElb(), this.flParameter.getServerNum(), this.flParameter.getDomainName());
        try {
            byte[] responseData = this.flCommunication.syncRequest(url + "/getListSign", msg);
            if (!Common.isSeverReady(responseData)) {
                return this.serverNotReady("getAllClientListSign");
            }
            if (Common.isSeverJobFinished(responseData)) {
                return this.serverJobFinished("getAllClientListSign");
            }
            ByteBuffer buffer = ByteBuffer.wrap(responseData);
            ReturnAllClientListSign returnAllClientList = ReturnAllClientListSign.getRootAsReturnAllClientListSign(buffer);
            return this.judgeAllClientList(returnAllClientList);
        }
        catch (IOException e) {
            e.printStackTrace();
            return FLClientStatus.FAILED;
        }
    }

    private FLClientStatus judgeAllClientList(ReturnAllClientListSign bufData) {
        this.retCode = bufData.retcode();
        LOGGER.info("[PairWiseMask] **************the response of GetAllClientsList**************");
        LOGGER.info("[PairWiseMask] return code: " + this.retCode);
        LOGGER.info("[PairWiseMask] reason: " + bufData.reason());
        LOGGER.info("[PairWiseMask] current iteration in server: " + bufData.iteration());
        LOGGER.info("[PairWiseMask] next request time: " + bufData.nextReqTime());
        switch (this.retCode) {
            case 200: {
                LOGGER.info("[PairWiseMask] GetAllClientList success");
                int length = bufData.clientListSignLength();
                String clientID = this.flParameter.getClientID();
                String localFlID = this.localFLParameter.getFlID();
                byte[] localClientList = this.transStringListToByte(this.u3ClientList);
                byte[] localListHash = SignAndVerify.getSHA256(localClientList);
                for (int i = 0; i < length; ++i) {
                    ByteBuffer signature = bufData.clientListSign(i).signatureAsByteBuffer();
                    byte[] sigByte = new byte[signature.remaining()];
                    signature.get(sigByte);
                    if (bufData.clientListSign(i).flId() == null) {
                        LOGGER.severe("[PairWiseMask] get flID failed!");
                        return FLClientStatus.FAILED;
                    }
                    String srcFlId = bufData.clientListSign(i).flId();
                    X509Certificate[] remoteCertificates = this.certificateList.get(srcFlId);
                    if (localFlID.equals(srcFlId) || SignAndVerify.verifySignatureByCert(clientID, remoteCertificates, localListHash, sigByte)) continue;
                    LOGGER.info("[PairWiseMask] FlID: " + srcFlId + ", signature authentication failed");
                    return FLClientStatus.FAILED;
                }
                return FLClientStatus.SUCCESS;
            }
            case 201: {
                LOGGER.info("[PairWiseMask] server is not ready now, need wait and request GetAllClientsList again!");
                return FLClientStatus.WAIT;
            }
            case 300: {
                LOGGER.info("[PairWiseMask] GetAllClientsList out of time: need wait and request startFLJob again");
                this.setNextRequestTime(bufData.nextReqTime());
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.info("[PairWiseMask] catch SucNotMatch or SystemError in GetAllClientsList");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[PairWiseMask] the return <retCode> from server in ReturnAllClientList is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    private byte[] transStringListToByte(List<String> stringList) {
        int byteNum = 0;
        for (String value : stringList) {
            byte[] stringByte = value.getBytes(StandardCharsets.UTF_8);
            byteNum += stringByte.length;
        }
        byte[] concatData = new byte[byteNum];
        int offset = 0;
        for (String str : stringList) {
            byte[] stringByte = str.getBytes(StandardCharsets.UTF_8);
            System.arraycopy(stringByte, 0, concatData, offset, stringByte.length);
            offset += stringByte.length;
        }
        return concatData;
    }

    public static byte[] signTimeAndIter(String dateTime, int iteration) {
        FLParameter flParameter = FLParameter.getInstance();
        String clientID = flParameter.getClientID();
        boolean isPkiVerify = flParameter.isPkiVerify();
        byte[] signature = new byte[]{};
        if (isPkiVerify) {
            LOGGER.info("ClientID is:" + clientID);
            byte[] concatData = CipherClient.concatenateIterAndTime(dateTime, iteration);
            signature = SignAndVerify.signData(clientID, concatData);
        }
        return signature;
    }

    private static String transformX509ToPem(X509Certificate x509Certificate) {
        String pemCert;
        if (x509Certificate == null) {
            LOGGER.severe("[CertVerify] x509Certificate is null, please check!");
            return null;
        }
        try {
            byte[] derCert = x509Certificate.getEncoded();
            pemCert = new String(Base64.getEncoder().encode(derCert));
        }
        catch (CertificateEncodingException e) {
            LOGGER.severe("[CertVerify] catch Exception: " + e.getMessage());
            return null;
        }
        return pemCert;
    }

    private static String[] transformX509ArrayToPemArray(X509Certificate[] x509Certificates) {
        if (x509Certificates == null || x509Certificates.length == 0) {
            LOGGER.severe("[CertVerify] certificateChains is null or empty, please check!");
            throw new IllegalArgumentException();
        }
        int nSize = x509Certificates.length;
        String[] pemCerts = new String[nSize];
        for (int i = 0; i < nSize; ++i) {
            String pemCert;
            pemCerts[i] = pemCert = CipherClient.transformX509ToPem(x509Certificates[i]);
        }
        return pemCerts;
    }

    private Boolean waitTryTimeExceedsLimit() {
        if (this.waitTryTime > 18) {
            LOGGER.severe("[waitTryTimeExceedsLimit] the waitTryTime exceeds the limit, current waitTryTime is: " + this.waitTryTime + " the limited time is: 18");
            return true;
        }
        return false;
    }

    private FLClientStatus serverNotReady(String logTag) {
        LOGGER.info("[" + logTag + "] the server is not ready now, need wait some time and request again");
        this.nextRequestTime = Common.getNextReqTime();
        this.retCode = 300;
        return FLClientStatus.RESTART;
    }

    private FLClientStatus serverJobFinished(String logTag) {
        LOGGER.info("[" + logTag + "] The server's training job is disabled or finished. will stop the task and exist.");
        this.retCode = 500;
        return FLClientStatus.FAILED;
    }
}

