/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.cipher;

import com.mindspore.flclient.cipher.CertVerify;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;

public class SignAndVerify {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(SignAndVerify.class.toString());

    public static byte[] signData(String clientID, byte[] data) {
        if (clientID == null || clientID.isEmpty()) {
            LOGGER.severe("[SignAndVerify] the parameter clientID is null or empty, please check!");
            return null;
        }
        if (data == null || data.length == 0) {
            LOGGER.severe("[SignAndVerify] the parameter data is null or empty, please check!");
            return null;
        }
        byte[] signData = null;
        try {
            KeyStore ks = KeyStore.getInstance("HwKeyStore");
            ks.load(null);
            Key privateKey = ks.getKey(clientID, null);
            if (privateKey == null) {
                LOGGER.info("private key is null");
                return null;
            }
            Signature signature = Signature.getInstance("SHA256withRSA/PSS", "HwUniversalKeyStoreProvider");
            signature.initSign((PrivateKey)privateKey);
            signature.update(data);
            signData = signature.sign();
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException | CertificateException e) {
            LOGGER.severe("[SignAndVerify] catch Exception: " + e.getMessage());
        }
        return signData;
    }

    public static boolean verifySignatureByCert(String clientID, X509Certificate[] x509Certificates, byte[] data, byte[] signed) {
        boolean isValid;
        if (clientID == null || clientID.isEmpty()) {
            LOGGER.severe("[SignAndVerify] the parameter clientID is null or empty, please check!");
            return false;
        }
        if (x509Certificates == null || x509Certificates.length < 1) {
            LOGGER.severe("[SignAndVerify] the parameter x509Certificates is null or the length is not valid: < 1, please check!");
            return false;
        }
        if (data == null || data.length == 0) {
            LOGGER.severe("[SignAndVerify] the parameter data is null or empty, please check!");
            return false;
        }
        if (signed == null || signed.length == 0) {
            LOGGER.severe("[SignAndVerify] the parameter signed is null or empty, please check!");
            return false;
        }
        if (!CertVerify.verifyCertificateChain(clientID, x509Certificates)) {
            LOGGER.info("Verify chain failed!");
            return false;
        }
        LOGGER.info("Verify chain success!");
        try {
            if (x509Certificates[0].getPublicKey() == null) {
                LOGGER.severe("[SignAndVerify] get public key failed!");
                return false;
            }
            PublicKey publicKey = x509Certificates[0].getPublicKey();
            Signature signature = Signature.getInstance("SHA256withRSA/PSS");
            signature.initVerify(publicKey);
            signature.update(data);
            isValid = signature.verify(signed);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            LOGGER.severe("[SignAndVerify] catch Exception: " + e.getMessage());
            return false;
        }
        return isValid;
    }

    public static byte[] getSHA256(byte[] bytes) {
        byte[] hash = new byte[]{};
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            hash = messageDigest.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.severe("[PkiUtil] catch NoSuchAlgorithmException: " + e.getMessage());
        }
        return hash;
    }
}

