/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient;

import com.google.flatbuffers.FlatBufferBuilder;
import com.mindspore.flclient.FLClientStatus;
import com.mindspore.flclient.FLParameter;
import com.mindspore.flclient.LocalFLParameter;
import com.mindspore.flclient.ServerMod;
import com.mindspore.flclient.common.FLLoggerGenerater;
import com.mindspore.flclient.compression.DecodeExecutor;
import com.mindspore.flclient.model.Client;
import com.mindspore.flclient.model.ClientManager;
import com.mindspore.flclient.model.RunType;
import com.mindspore.flclient.model.Status;
import com.mindspore.flclient.pki.PkiBean;
import com.mindspore.flclient.pki.PkiUtil;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.logging.Logger;
import mindspore.fl.schema.CompressFeatureMap;
import mindspore.fl.schema.FLPlan;
import mindspore.fl.schema.FeatureMap;
import mindspore.fl.schema.RequestFLJob;
import mindspore.fl.schema.ResponseFLJob;

public class StartFLJob {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(StartFLJob.class.toString());
    private static volatile StartFLJob startFLJob;
    private FLParameter flParameter = FLParameter.getInstance();
    private LocalFLParameter localFLParameter = LocalFLParameter.getInstance();
    private int featureSize;
    private String nextRequestTime;
    private ArrayList<String> updateFeatureName = new ArrayList();
    private int retCode = 400;
    private float lr = 0.1f;
    private int batchSize;

    private StartFLJob() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StartFLJob getInstance() {
        StartFLJob localRef = startFLJob;
        if (localRef != null) return localRef;
        Class<StartFLJob> clazz = StartFLJob.class;
        synchronized (StartFLJob.class) {
            localRef = startFLJob;
            if (localRef != null) return localRef;
            startFLJob = localRef = new StartFLJob();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localRef;
        }
    }

    public String getNextRequestTime() {
        return this.nextRequestTime;
    }

    public int getRetCode() {
        return this.retCode;
    }

    public byte[] getRequestStartFLJob(int trainDataSize, int evaDataSize, int iteration, long time, PkiBean pkiBean) {
        RequestStartFLJobBuilder builder = new RequestStartFLJobBuilder();
        if (this.flParameter.isPkiVerify()) {
            if (pkiBean == null) {
                LOGGER.severe("[startFLJob] the parameter of <pkiBean> is null, please check!");
                throw new IllegalArgumentException();
            }
            return builder.flName(this.flParameter.getFlName()).time(time).id(this.localFLParameter.getFlID()).trainDataSize(trainDataSize).evaDataSize(evaDataSize).iteration(iteration).signData(pkiBean.getSignData()).certificateChain(pkiBean.getCertificates()).downloadCompressTypesBuilder(this.flParameter.getDownloadCompressTypes()).build();
        }
        return builder.flName(this.flParameter.getFlName()).time(time).id(this.localFLParameter.getFlID()).trainDataSize(trainDataSize).evaDataSize(evaDataSize).iteration(iteration).downloadCompressTypesBuilder(this.flParameter.getDownloadCompressTypes()).build();
    }

    public int getFeatureSize() {
        return this.featureSize;
    }

    public ArrayList<String> getUpdateFeatureName() {
        return this.updateFeatureName;
    }

    private FeatureGenerator FeatureGeneratorCtr(ResponseFLJob responseDataBuf) {
        byte compressType = responseDataBuf.downloadCompressType();
        switch (compressType) {
            case 0: {
                return new NormalFeatureGenerator(responseDataBuf);
            }
            case 2: {
                return new QuatFeatureGenerator(responseDataBuf);
            }
        }
        LOGGER.severe("[FeatureGeneratorCtr] Unsupported compress type:" + compressType);
        return null;
    }

    private FLClientStatus getUpdateFeatureForFederated(Client client, FeatureGenerator featureGenerator) {
        FLClientStatus result = FLClientStatus.SUCCESS;
        Status status = Status.SUCCESS;
        this.updateFeatureName.clear();
        this.featureSize = 0;
        LOGGER.info("[getUpdateFeatureForFederated] set <batch size> for client: " + this.batchSize);
        client.setBatchSize(this.batchSize);
        while (!featureGenerator.isEnd()) {
            FeatureMap featureMap = featureGenerator.next();
            this.featureSize += featureMap.dataLength();
            this.updateFeatureName.add(featureMap.weightFullname());
            status = client.updateFeature(featureMap, true);
            if (status == Status.SUCCESS) continue;
            LOGGER.severe("[getUpdateFeatureForFederated] Update feature failed.");
            break;
        }
        if (status == Status.SUCCESS && this.featureSize > 0) {
            return FLClientStatus.SUCCESS;
        }
        LOGGER.severe("[getUpdateFeatureForFederated] get update features for Federated failed, featureSize is: " + this.featureSize + " status:" + (Object)((Object)status));
        return FLClientStatus.FAILED;
    }

    private FLClientStatus getUpdateFeatureForHybrid(Client client, FeatureGenerator featureGenerator) {
        FLClientStatus result = FLClientStatus.SUCCESS;
        Status status = Status.SUCCESS;
        this.updateFeatureName.clear();
        this.featureSize = 0;
        LOGGER.info("[getUpdateFeatureForHybrid] set <batch size> for client: " + this.batchSize);
        client.setBatchSize(this.batchSize);
        while (!featureGenerator.isEnd()) {
            FeatureMap featureMap = featureGenerator.next();
            if (this.flParameter.getHybridWeightName(RunType.TRAINMODE).contains(featureMap.weightFullname())) {
                this.featureSize += featureMap.dataLength();
                this.updateFeatureName.add(featureMap.weightFullname());
                status = client.updateFeature(featureMap, true);
            }
            if (status != Status.SUCCESS) {
                LOGGER.severe("[getUpdateFeatureForHybrid] Update feature failed.");
                break;
            }
            if (this.flParameter.getHybridWeightName(RunType.INFERMODE).contains(featureMap.weightFullname())) {
                status = client.updateFeature(featureMap, false);
            }
            if (status == Status.SUCCESS) continue;
            LOGGER.severe("[getUpdateFeatureForHybrid] Update feature failed.");
            break;
        }
        if (status == Status.SUCCESS && this.featureSize > 0) {
            return FLClientStatus.SUCCESS;
        }
        LOGGER.severe("[getUpdateFeatureForHybrid] get update features for hybrid failed, featureSize is: " + this.featureSize + " status:" + (Object)((Object)status));
        return FLClientStatus.FAILED;
    }

    private FLClientStatus parseResponseFeatures(ResponseFLJob flJob) {
        FLClientStatus status = FLClientStatus.FAILED;
        Client client = ClientManager.getClient(this.flParameter.getFlName());
        FeatureGenerator featureGenerator = this.FeatureGeneratorCtr(flJob);
        if (this.localFLParameter.getServerMod().equals(ServerMod.HYBRID_TRAINING.toString())) {
            LOGGER.info("[startFLJob] parseResponseFeatures by for train and infer models");
            status = this.getUpdateFeatureForHybrid(client, featureGenerator);
        } else if (this.localFLParameter.getServerMod().equals(ServerMod.FEDERATED_LEARNING.toString())) {
            String trainModelPath = this.flParameter.getTrainModelPath();
            String inferModelPath = this.flParameter.getInferModelPath();
            if (!inferModelPath.equals("null") && !inferModelPath.equals(trainModelPath)) {
                LOGGER.info("[startFLJob] parseResponseFeatures for train and infer model");
                return this.getUpdateFeatureForHybrid(client, featureGenerator);
            }
            LOGGER.info("[startFLJob] parseResponseFeatures for train model");
            status = this.getUpdateFeatureForFederated(client, featureGenerator);
        }
        return status;
    }

    public FLClientStatus doResponse(ResponseFLJob flJob) {
        if (flJob == null) {
            LOGGER.severe("[startFLJob] the input parameter flJob is null");
            this.retCode = 500;
            return FLClientStatus.FAILED;
        }
        FLPlan flPlanConfig = flJob.flPlanConfig();
        if (flPlanConfig == null) {
            LOGGER.severe("[startFLJob] the flPlanConfig is null");
            this.retCode = 500;
            return FLClientStatus.FAILED;
        }
        if (flPlanConfig.cipher() == null || flPlanConfig.cipher().dsParams() == null) {
            LOGGER.severe("[startFLJob] the flPlanConfig cipher is null");
            this.retCode = 500;
            return FLClientStatus.FAILED;
        }
        this.retCode = flJob.retcode();
        LOGGER.info("[startFLJob] ==========the response message of startFLJob is:================");
        LOGGER.info("[startFLJob] return retCode: " + this.retCode);
        LOGGER.info("[startFLJob] reason: " + flJob.reason());
        LOGGER.info("[startFLJob] iteration: " + flJob.iteration());
        LOGGER.info("[startFLJob] is selected: " + flJob.isSelected());
        LOGGER.info("[startFLJob] next request time: " + flJob.nextReqTime());
        LOGGER.info("[startFLJob] signds rEst: " + flPlanConfig.cipher().dsParams().signdsREst());
        LOGGER.info("[startFLJob] signds isReached: " + flPlanConfig.cipher().dsParams().signdsIsReached());
        this.nextRequestTime = flJob.nextReqTime();
        LOGGER.info("[startFLJob] timestamp: " + flJob.timestamp());
        LOGGER.info("[startFLJob] privacy preserving unsupervised type: " + flJob.unsupervisedEvalFlg());
        int responseRetCode = flJob.retcode();
        switch (responseRetCode) {
            case 200: {
                if (flJob.downloadCompressType() == 0 && flJob.featureMapLength() <= 0) {
                    LOGGER.warning("[startFLJob] the feature size get from server is zero");
                    this.retCode = 500;
                    return FLClientStatus.FAILED;
                }
                this.localFLParameter.setServerMod(flPlanConfig.serverMode());
                this.localFLParameter.setREst(flPlanConfig.cipher().dsParams().signdsREst());
                this.localFLParameter.setRangeReached(flPlanConfig.cipher().dsParams().signdsIsReached());
                if (flPlanConfig.lr() != 0.0f) {
                    this.lr = flPlanConfig.lr();
                } else {
                    LOGGER.info("[startFLJob] the GlobalParameter <lr> from server: " + this.lr + " is not " + "valid, " + "will use the default value 0.1");
                }
                this.localFLParameter.setLr(this.lr);
                this.localFLParameter.setUnsupervisedEvalFlg(flJob.unsupervisedEvalFlg());
                this.batchSize = flPlanConfig.miniBatch();
                LOGGER.info("[startFLJob] into <parseResponseFeatures>");
                FLClientStatus status = this.parseResponseFeatures(flJob);
                return status;
            }
            case 300: {
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.info("[startFLJob] catch RequestError or SystemError");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[startFLJob] the return <retCode> from server is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    static {
        System.loadLibrary("mindspore-lite-jni");
    }

    class RequestStartFLJobBuilder {
        private RequestFLJob requestFLJob;
        private FlatBufferBuilder builder = new FlatBufferBuilder();
        private int nameOffset = 0;
        private int iteration = 0;
        private int trainDataSize = 0;
        private int evaDataSize = 0;
        private int timestampOffset = 0;
        private int idOffset = 0;
        private int signDataOffset = 0;
        private int keyAttestationOffset = 0;
        private int equipCertOffset = 0;
        private int equipCACertOffset = 0;
        private int rootCertOffset = 0;
        private int downloadCompressTypesOffset = 0;

        public RequestStartFLJobBuilder flName(String name) {
            if (name == null || name.isEmpty()) {
                LOGGER.severe("[startFLJob] the parameter of <name> is null or empty, please check!");
                throw new IllegalArgumentException();
            }
            this.nameOffset = this.builder.createString((CharSequence)name);
            return this;
        }

        public RequestStartFLJobBuilder id(String id) {
            if (id == null || id.isEmpty()) {
                LOGGER.severe("[startFLJob] the parameter of <id> is null or empty, please check!");
                throw new IllegalArgumentException();
            }
            this.idOffset = this.builder.createString((CharSequence)id);
            return this;
        }

        public RequestStartFLJobBuilder time(long timestamp) {
            this.timestampOffset = this.builder.createString((CharSequence)String.valueOf(timestamp));
            return this;
        }

        public RequestStartFLJobBuilder trainDataSize(int trainDataSize) {
            this.trainDataSize = trainDataSize;
            LOGGER.info("[startFLJob] the train data size: " + trainDataSize);
            return this;
        }

        public RequestStartFLJobBuilder evaDataSize(int evaDataSize) {
            this.evaDataSize = evaDataSize;
            LOGGER.info("[startFLJob] the evaluate data size: " + evaDataSize);
            return this;
        }

        public RequestStartFLJobBuilder iteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        public RequestStartFLJobBuilder signData(byte[] signData) {
            if (signData == null || signData.length == 0) {
                LOGGER.severe("[startFLJob] the parameter of <signData> is null or empty, please check!");
                throw new IllegalArgumentException();
            }
            this.signDataOffset = RequestFLJob.createSignDataVector(this.builder, signData);
            return this;
        }

        public RequestStartFLJobBuilder certificateChain(Certificate[] certificates) {
            if (certificates == null || certificates.length < 4) {
                LOGGER.severe("[startFLJob] the parameter of <certificates> is null or the length is not valid (should be >= 4), please check!");
                throw new IllegalArgumentException();
            }
            try {
                String keyAttestationPem = PkiUtil.getPemFormat(certificates[0]);
                String equipCertPem = PkiUtil.getPemFormat(certificates[1]);
                String equipCACertPem = PkiUtil.getPemFormat(certificates[2]);
                String rootCertPem = PkiUtil.getPemFormat(certificates[3]);
                this.keyAttestationOffset = this.builder.createString((CharSequence)keyAttestationPem);
                this.equipCertOffset = this.builder.createString((CharSequence)equipCertPem);
                this.equipCACertOffset = this.builder.createString((CharSequence)equipCACertPem);
                this.rootCertOffset = this.builder.createString((CharSequence)rootCertPem);
            }
            catch (IOException e) {
                LOGGER.severe("[StartFLJob] catch IOException in certificateChain: " + e.getMessage());
            }
            return this;
        }

        private RequestStartFLJobBuilder downloadCompressTypesBuilder(byte[] downloadCompressTypes) {
            if (downloadCompressTypes == null || downloadCompressTypes.length == 0) {
                LOGGER.severe("[StartFLJob] the parameter of <downloadCompressTypes> is null or empty, please check!");
                throw new IllegalArgumentException();
            }
            this.downloadCompressTypesOffset = RequestFLJob.createDownloadCompressTypesVector(this.builder, downloadCompressTypes);
            return this;
        }

        public byte[] build() {
            RequestFLJob.startRequestFLJob(this.builder);
            RequestFLJob.addFlName(this.builder, this.nameOffset);
            RequestFLJob.addFlId(this.builder, this.idOffset);
            RequestFLJob.addIteration(this.builder, this.iteration);
            RequestFLJob.addDataSize(this.builder, this.trainDataSize);
            RequestFLJob.addTimestamp(this.builder, this.timestampOffset);
            RequestFLJob.addSignData(this.builder, this.signDataOffset);
            RequestFLJob.addRootCert(this.builder, this.rootCertOffset);
            RequestFLJob.addEquipCaCert(this.builder, this.equipCACertOffset);
            RequestFLJob.addEquipCert(this.builder, this.equipCertOffset);
            RequestFLJob.addKeyAttestation(this.builder, this.keyAttestationOffset);
            RequestFLJob.addDownloadCompressTypes(this.builder, this.downloadCompressTypesOffset);
            RequestFLJob.addEvalDataSize(this.builder, this.evaDataSize);
            int root = RequestFLJob.endRequestFLJob(this.builder);
            this.builder.finish(root);
            return this.builder.sizedByteArray();
        }
    }

    class QuatFeatureGenerator
    extends FeatureGenerator {
        public QuatFeatureGenerator(ResponseFLJob responseDataBuf) {
            super(responseDataBuf);
            this.size = responseDataBuf.compressFeatureMapLength();
        }

        @Override
        public FeatureMap next() {
            if (this.curPos >= this.size) {
                return null;
            }
            int pre = this.curPos++;
            CompressFeatureMap cmpfeatureMap = this.responseDataBuf.compressFeatureMap(pre);
            return DecodeExecutor.quantDeCompress(cmpfeatureMap);
        }
    }

    class NormalFeatureGenerator
    extends FeatureGenerator {
        public NormalFeatureGenerator(ResponseFLJob responseDataBuf) {
            super(responseDataBuf);
            this.size = responseDataBuf.featureMapLength();
        }

        @Override
        public FeatureMap next() {
            if (this.curPos >= this.size) {
                return null;
            }
            int pre = this.curPos++;
            return this.responseDataBuf.featureMap(pre);
        }
    }

    abstract class FeatureGenerator {
        protected ResponseFLJob responseDataBuf;
        protected int curPos = 0;
        protected int size = 0;

        public FeatureGenerator(ResponseFLJob responseDataBuf) {
            this.responseDataBuf = responseDataBuf;
        }

        public abstract FeatureMap next();

        public boolean isEnd() {
            return this.curPos >= this.size;
        }
    }
}

