/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.common;

import com.mindspore.flclient.common.MsgAnonymous;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FLLoggerGenerater {
    private static Level level = Level.INFO;
    private static final AnonymousFilter filter = new AnonymousFilter();

    public static void setAnonymousFlg(boolean anonymousFlg) {
        AnonymousFilter.anonymousFlg = anonymousFlg;
    }

    public static Logger getModelLogger(String clsName) {
        Logger logger = Logger.getLogger(clsName);
        logger.setFilter(filter);
        return logger;
    }

    public static class AnonymousFilter
    implements Filter {
        private static boolean anonymousFlg = true;
        private final MsgAnonymous anonymous = new MsgAnonymous();

        @Override
        public boolean isLoggable(LogRecord record) {
            String originMsg = record.getMessage();
            String anoyedMsg = anonymousFlg ? this.anonymous.doAnonymous(originMsg) : originMsg;
            record.setMessage("<FLClient> " + anoyedMsg);
            return true;
        }
    }
}

