/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore;

import com.mindspore.config.MindsporeLite;
import java.nio.ByteBuffer;

public class MSTensor {
    private long tensorPtr;

    public MSTensor() {
        this.tensorPtr = 0L;
    }

    public MSTensor(long tensorPtr) {
        this.tensorPtr = tensorPtr;
    }

    public static MSTensor createTensor(String tensorName, int dataType, int[] tensorShape, ByteBuffer buffer) {
        if (tensorName == null || tensorShape == null || buffer == null) {
            return null;
        }
        long tensorPtr = MSTensor.createTensorByNative(tensorName, dataType, tensorShape, buffer);
        return new MSTensor(tensorPtr);
    }

    public int[] getShape() {
        return this.getShape(this.tensorPtr);
    }

    public int getDataType() {
        return this.getDataType(this.tensorPtr);
    }

    public byte[] getByteData() {
        return this.getByteData(this.tensorPtr);
    }

    public float[] getFloatData() {
        return this.getFloatData(this.tensorPtr);
    }

    public int[] getIntData() {
        return this.getIntData(this.tensorPtr);
    }

    public long[] getLongData() {
        return this.getLongData(this.tensorPtr);
    }

    public boolean setShape(int[] tensorShape) {
        if (tensorShape == null) {
            return false;
        }
        return this.setShape(this.tensorPtr, tensorShape);
    }

    public boolean setData(byte[] data) {
        if (data == null) {
            return false;
        }
        return this.setByteData(this.tensorPtr, data, data.length);
    }

    public boolean setData(float[] data) {
        if (data == null) {
            return false;
        }
        return this.setFloatData(this.tensorPtr, data, data.length);
    }

    public boolean setData(ByteBuffer data) {
        if (data == null) {
            return false;
        }
        return this.setByteBufferData(this.tensorPtr, data);
    }

    public long size() {
        return this.size(this.tensorPtr);
    }

    public int elementsNum() {
        return this.elementsNum(this.tensorPtr);
    }

    public void free() {
        this.free(this.tensorPtr);
        this.tensorPtr = 0L;
    }

    public String tensorName() {
        return this.tensorName(this.tensorPtr);
    }

    public long getMSTensorPtr() {
        return this.tensorPtr;
    }

    private static native long createTensorByNative(String var0, int var1, int[] var2, ByteBuffer var3);

    private native int[] getShape(long var1);

    private native int getDataType(long var1);

    private native byte[] getByteData(long var1);

    private native long[] getLongData(long var1);

    private native int[] getIntData(long var1);

    private native float[] getFloatData(long var1);

    private native boolean setByteData(long var1, byte[] var3, long var4);

    private native boolean setFloatData(long var1, float[] var3, long var4);

    private native boolean setShape(long var1, int[] var3);

    private native boolean setByteBufferData(long var1, ByteBuffer var3);

    private native long size(long var1);

    private native int elementsNum(long var1);

    private native void free(long var1);

    private native String tensorName(long var1);

    static {
        MindsporeLite.init();
    }
}

