/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.pki;

import com.mindspore.flclient.LocalFLParameter;
import com.mindspore.flclient.common.FLLoggerGenerater;
import com.mindspore.flclient.pki.PkiBean;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.logging.Logger;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class PkiUtil {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(PkiUtil.class.toString());

    public static PkiBean genPkiBean(String clientID, long time) {
        String sourceData = LocalFLParameter.getInstance().getFlID() + " " + time;
        byte[] signDataBytes = PkiUtil.signData(clientID, sourceData.getBytes(StandardCharsets.UTF_8));
        Certificate[] certificates = PkiUtil.getCertificateChain(clientID);
        return new PkiBean(signDataBytes, certificates);
    }

    public static byte[] getSHA256Str(String str) {
        byte[] hash = new byte[]{};
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            hash = messageDigest.digest(str.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.severe("[PkiUtil] catch NoSuchAlgorithmException: " + e.getMessage());
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPemFormat(Certificate certificate) throws IOException {
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        try {
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", certificate.getEncoded()));
        }
        catch (IOException | CertificateEncodingException e) {
            LOGGER.severe("[PkiUtil] catch IOException or CertificateEncodingException in getPermFormat: " + e.getMessage());
        }
        finally {
            pemWriter.flush();
            pemWriter.close();
        }
        return writer.toString();
    }

    private static byte[] signData(String clientID, byte[] data) {
        byte[] signData = null;
        try {
            KeyStore ks = KeyStore.getInstance("HwKeyStore");
            ks.load(null);
            Key privateKey = ks.getKey(clientID, null);
            if (privateKey == null) {
                return new byte[0];
            }
            Signature signature = Signature.getInstance("SHA256withRSA/PSS", "HwUniversalKeyStoreProvider");
            if (privateKey instanceof PrivateKey) {
                signature.initSign((PrivateKey)privateKey);
            }
            signature.update(data);
            signData = signature.sign();
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException | CertificateException e) {
            LOGGER.severe("[PkiUtil] catch Exception: " + e.getMessage());
        }
        return signData;
    }

    public static Certificate[] getCertificateChain(String clientID) {
        Certificate[] certificates = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("HwKeyStore");
            keyStore.load(null);
            KeyStore.Entry entry = keyStore.getEntry(clientID, null);
            if (entry == null) {
                return new Certificate[0];
            }
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
                return new Certificate[0];
            }
            certificates = ((KeyStore.PrivateKeyEntry)entry).getCertificateChain();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
            LOGGER.severe("[PkiUtil] catch Exception: " + e.getMessage());
        }
        return certificates;
    }

    public static String toHexFormat(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte byteData : data) {
            sb.append(String.format(Locale.ROOT, "%02x", byteData));
        }
        return sb.toString();
    }

    public static String genEquipCertHash(String clientID) {
        byte[] equipCertBytesHash = null;
        try {
            Certificate[] certificates = PkiUtil.getCertificateChain(clientID);
            if (certificates == null || certificates.length < 2) {
                return "";
            }
            String equipCert = PkiUtil.readPemFormat(certificates[1]);
            equipCertBytesHash = PkiUtil.getSHA256Str(equipCert);
        }
        catch (IOException e) {
            LOGGER.severe("[PkiUtil] catch Exception: " + e.getMessage());
        }
        return PkiUtil.toHexFormat(equipCertBytesHash);
    }

    public static String genHashFromCer(X509Certificate certificateGradeOne) {
        String equipCert = null;
        byte[] equipCertBytesHash = null;
        try {
            equipCert = PkiUtil.readPemFormat(certificateGradeOne);
            equipCertBytesHash = PkiUtil.getSHA256Str(equipCert);
        }
        catch (IOException e) {
            LOGGER.severe("[PkiUtil] catch Exception: " + e.getMessage());
        }
        if (equipCertBytesHash == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte byteData : equipCertBytesHash) {
            sb.append(String.format(Locale.ROOT, "%02x", byteData));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readPemFormat(Certificate certificate) throws IOException {
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        if (certificate == null) {
            LOGGER.severe("[PkiUtil] the input parameter certificate is null, please check");
            throw new IllegalArgumentException();
        }
        try {
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", certificate.getEncoded()));
        }
        catch (IOException | CertificateEncodingException e) {
            LOGGER.severe("[PkiUtil] catch IOException or CertificateEncodingException in getPermFormat: " + e.getMessage());
        }
        finally {
            pemWriter.flush();
            pemWriter.close();
        }
        return writer.toString();
    }
}

