/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.cipher;

import com.google.flatbuffers.FlatBufferBuilder;
import com.mindspore.flclient.CipherClient;
import com.mindspore.flclient.Common;
import com.mindspore.flclient.FLClientStatus;
import com.mindspore.flclient.FLCommunication;
import com.mindspore.flclient.FLParameter;
import com.mindspore.flclient.LocalFLParameter;
import com.mindspore.flclient.cipher.struct.DecryptShareSecrets;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import mindspore.fl.schema.ClientShare;
import mindspore.fl.schema.ReconstructSecret;
import mindspore.fl.schema.SendReconstructSecret;

public class ReconstructSecretReq {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(ReconstructSecretReq.class.toString());
    private FLCommunication flCommunication;
    private String nextRequestTime;
    private FLParameter flParameter = FLParameter.getInstance();
    private LocalFLParameter localFLParameter = LocalFLParameter.getInstance();
    private int retCode;

    public ReconstructSecretReq() {
        this.flCommunication = FLCommunication.getInstance();
    }

    public FLClientStatus sendReconstructSecret(List<DecryptShareSecrets> decryptShareSecretsList, List<String> u3ClientList, int iteration) {
        int reconstructSecretRoot;
        String url = Common.generateUrl(this.flParameter.isUseElb(), this.flParameter.getServerNum(), this.flParameter.getDomainName());
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int desFlId = builder.createString((CharSequence)this.localFLParameter.getFlID());
        Date date = new Date();
        long timestamp = date.getTime();
        String dateTime = String.valueOf(timestamp);
        int time = builder.createString((CharSequence)dateTime);
        int shareSecretsSize = decryptShareSecretsList.size();
        if (shareSecretsSize <= 0) {
            LOGGER.info("[PairWiseMask] request failed: the decryptShareSecretsList is null, please waite.");
            return FLClientStatus.FAILED;
        }
        int[] decryptShareList = new int[shareSecretsSize];
        for (int i = 0; i < shareSecretsSize; ++i) {
            int clientShare;
            int index;
            byte[] share;
            DecryptShareSecrets decryptShareSecrets = decryptShareSecretsList.get(i);
            if (decryptShareSecrets.getFlID() == null) {
                LOGGER.severe("[PairWiseMask] get remote flID failed!");
                return FLClientStatus.FAILED;
            }
            String srcFlId = decryptShareSecrets.getFlID();
            if (u3ClientList.contains(srcFlId)) {
                share = decryptShareSecrets.getBVu().getArray();
                index = decryptShareSecrets.getIndexB();
            } else {
                share = decryptShareSecrets.getSSkVu().getArray();
                index = decryptShareSecrets.getSIndex();
            }
            int fbsSrcFlId = builder.createString((CharSequence)srcFlId);
            int fbsShare = ClientShare.createShareVector(builder, share);
            decryptShareList[i] = clientShare = ClientShare.createClientShare(builder, fbsSrcFlId, fbsShare, index);
        }
        int reconstructShareSecrets = SendReconstructSecret.createReconstructSecretSharesVector(builder, decryptShareList);
        byte[] signature = CipherClient.signTimeAndIter(dateTime, iteration);
        if (signature.length > 0) {
            int signed = SendReconstructSecret.createSignatureVector(builder, signature);
            SendReconstructSecret.startSendReconstructSecret(builder);
            SendReconstructSecret.addFlId(builder, desFlId);
            SendReconstructSecret.addReconstructSecretShares(builder, reconstructShareSecrets);
            SendReconstructSecret.addIteration(builder, iteration);
            SendReconstructSecret.addTimestamp(builder, time);
            SendReconstructSecret.addSignature(builder, signed);
            reconstructSecretRoot = SendReconstructSecret.endSendReconstructSecret(builder);
        } else {
            SendReconstructSecret.startSendReconstructSecret(builder);
            SendReconstructSecret.addFlId(builder, desFlId);
            SendReconstructSecret.addReconstructSecretShares(builder, reconstructShareSecrets);
            SendReconstructSecret.addIteration(builder, iteration);
            SendReconstructSecret.addTimestamp(builder, time);
            SendReconstructSecret.addSignature(builder, 0);
            reconstructSecretRoot = SendReconstructSecret.endSendReconstructSecret(builder);
        }
        builder.finish(reconstructSecretRoot);
        byte[] msg = builder.sizedByteArray();
        try {
            byte[] responseData = this.flCommunication.syncRequest(url + "/reconstructSecrets", msg);
            if (!Common.isSeverReady(responseData)) {
                LOGGER.info("[sendReconstructSecret] the server is not ready now, need wait some time and request again");
                this.nextRequestTime = Common.getNextReqTime();
                this.retCode = 300;
                return FLClientStatus.RESTART;
            }
            if (Common.isSeverJobFinished(responseData)) {
                LOGGER.info("[sendReconstructSecret] The server's training job is disabled or finished. will stop the task and exist.");
                this.retCode = 500;
                return FLClientStatus.FAILED;
            }
            ByteBuffer buffer = ByteBuffer.wrap(responseData);
            ReconstructSecret reconstructSecretRsp = ReconstructSecret.getRootAsReconstructSecret(buffer);
            return this.judgeSendReconstructSecrets(reconstructSecretRsp);
        }
        catch (IOException ex) {
            LOGGER.severe("[PairWiseMask] un solved error code in reconstruct");
            ex.printStackTrace();
            return FLClientStatus.FAILED;
        }
    }

    private FLClientStatus judgeSendReconstructSecrets(ReconstructSecret bufData) {
        this.retCode = bufData.retcode();
        LOGGER.info("[PairWiseMask] **************the response of SendReconstructSecrets**************");
        LOGGER.info("[PairWiseMask] return code: " + this.retCode);
        LOGGER.info("[PairWiseMask] reason: " + bufData.reason());
        LOGGER.info("[PairWiseMask] current iteration in server: " + bufData.iteration());
        LOGGER.info("[PairWiseMask] next request time: " + bufData.nextReqTime());
        switch (this.retCode) {
            case 200: {
                LOGGER.info("[PairWiseMask] ReconstructSecrets success");
                return FLClientStatus.SUCCESS;
            }
            case 300: {
                LOGGER.info("[PairWiseMask] SendReconstructSecrets out of time: need wait and request startFLJob again");
                this.setNextRequestTime(bufData.nextReqTime());
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.info("[PairWiseMask] catch SucNotMatch or SystemError in SendReconstructSecrets");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[PairWiseMask] the return <retCode> from server in ReconstructSecret is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    public String getNextRequestTime() {
        return this.nextRequestTime;
    }

    public void setNextRequestTime(String nextRequestTime) {
        this.nextRequestTime = nextRequestTime;
    }

    public int getRetCode() {
        return this.retCode;
    }
}

